/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.enc;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.KeKiEnc;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.key.DkKeyMaker;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Cmac;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;

public abstract class KeKiCmacEnc
extends KeKiEnc {
    private DkKeyMaker km;
    private EncryptionType eType;

    public KeKiCmacEnc(EncryptProvider encProvider, EncryptionType eType, DkKeyMaker km) {
        super(encProvider, null);
        this.eType = eType;
        this.km = km;
    }

    @Override
    public int checksumSize() {
        return this.encProvider().blockSize();
    }

    @Override
    public byte[] prf(byte[] key, byte[] seed) throws KrbException {
        byte[] prfConst = "prf".getBytes(StandardCharsets.UTF_8);
        if (EncryptionHandler.getEncHandler(this.eType()).prfSize() != this.encProvider().blockSize()) {
            return null;
        }
        byte[] kp = this.km.dk(key, prfConst);
        return Cmac.cmac(this.encProvider(), kp, seed);
    }

    @Override
    protected byte[] makeChecksum(byte[] key, byte[] data, int hashSize) throws KrbException {
        byte[] hash = Cmac.cmac(this.encProvider(), key, data);
        byte[] output = new byte[hashSize];
        System.arraycopy(hash, 0, output, 0, hashSize);
        return output;
    }
}

