/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.session;

import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.SessionIdManager;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.util.log.Logger;

public abstract class AbstractSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final Logger LOG = Log.getLogger(AbstractSessionIdManager.class);
    private static final String __NEW_SESSION_ID = "org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.newSessionId";
    protected Random _random;
    protected boolean _weakRandom;
    protected String _workerName;
    protected String _workerAttr;
    protected long _reseed = 100000L;

    public AbstractSessionIdManager() {
    }

    public AbstractSessionIdManager(Random random) {
        this._random = random;
    }

    @Override
    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String workerName) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        if (workerName.contains(".")) {
            throw new IllegalArgumentException("Name cannot contain '.'");
        }
        this._workerName = workerName;
    }

    public Random getRandom() {
        return this._random;
    }

    public synchronized void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }

    public long getReseed() {
        return this._reseed;
    }

    public void setReseed(long reseed) {
        this._reseed = reseed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String newSessionId(HttpServletRequest request, long created) {
        AbstractSessionIdManager abstractSessionIdManager = this;
        synchronized (abstractSessionIdManager) {
            String cluster_id;
            if (request == null) {
                return this.newSessionId(created);
            }
            String requested_id = request.getRequestedSessionId();
            if (requested_id != null && this.idInUse(cluster_id = this.getClusterId(requested_id))) {
                return cluster_id;
            }
            String new_id = (String)request.getAttribute(__NEW_SESSION_ID);
            if (new_id != null && this.idInUse(new_id)) {
                return new_id;
            }
            String id = this.newSessionId(request.hashCode());
            request.setAttribute(__NEW_SESSION_ID, (Object)id);
            return id;
        }
    }

    public String newSessionId(long seedTerm) {
        String id = null;
        while (id == null || id.length() == 0 || this.idInUse(id)) {
            long r1;
            long r0;
            long l = r0 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ seedTerm << 32 : this._random.nextLong();
            if (r0 < 0L) {
                r0 = -r0;
            }
            if (this._reseed > 0L && r0 % this._reseed == 1L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reseeding {}", this);
                }
                if (this._random instanceof SecureRandom) {
                    SecureRandom secure = (SecureRandom)this._random;
                    secure.setSeed(secure.generateSeed(8));
                } else {
                    this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ seedTerm ^ Runtime.getRuntime().freeMemory());
                }
            }
            long l2 = r1 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ seedTerm << 32 : this._random.nextLong();
            if (r1 < 0L) {
                r1 = -r1;
            }
            id = Long.toString(r0, 36) + Long.toString(r1, 36);
            if (this._workerName == null) continue;
            id = this._workerName + id;
        }
        return id;
    }

    @Override
    public abstract void renewSessionId(String var1, String var2, HttpServletRequest var3);

    @Override
    protected void doStart() throws Exception {
        this.initRandom();
        this._workerAttr = this._workerName != null && this._workerName.startsWith("$") ? this._workerName.substring(1) : null;
    }

    @Override
    protected void doStop() throws Exception {
    }

    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = new SecureRandom();
            }
            catch (Exception e) {
                LOG.warn("Could not generate SecureRandom for session-id randomness", e);
                this._random = new Random();
                this._weakRandom = true;
            }
        } else {
            this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
        }
    }

    @Override
    public String getNodeId(String clusterId, HttpServletRequest request) {
        if (this._workerName != null) {
            if (this._workerAttr == null) {
                return clusterId + '.' + this._workerName;
            }
            String worker = (String)request.getAttribute(this._workerAttr);
            if (worker != null) {
                return clusterId + '.' + worker;
            }
        }
        return clusterId;
    }

    @Override
    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }
}

