/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FutureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FutureUtils.class);

    private FutureUtils() {
    }

    public static <T> void addListener(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action) {
        future.whenComplete((resp, error) -> {
            try {
                action.accept(resp, FutureUtils.unwrapCompletionException(error));
            }
            catch (Throwable t) {
                LOG.error("Unexpected error caught when processing CompletableFuture", t);
            }
        });
    }

    public static <T> void addListener(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        future.whenCompleteAsync((resp, error) -> {
            try {
                action.accept(resp, FutureUtils.unwrapCompletionException(error));
            }
            catch (Throwable t) {
                LOG.error("Unexpected error caught when processing CompletableFuture", t);
            }
        }, executor);
    }

    public static <T> CompletableFuture<T> wrapFuture(CompletableFuture<T> future, Executor executor) {
        CompletableFuture wrappedFuture = new CompletableFuture();
        FutureUtils.addListener(future, (r, e) -> {
            if (e != null) {
                wrappedFuture.completeExceptionally((Throwable)e);
            } else {
                wrappedFuture.complete(r);
            }
        }, executor);
        return wrappedFuture;
    }

    public static Throwable unwrapCompletionException(Throwable error) {
        Throwable cause;
        if (error instanceof CompletionException && (cause = error.getCause()) != null) {
            return cause;
        }
        return error;
    }

    public static <T> T get(Future<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible(cause, IOException.class);
            throw new IOException(cause);
        }
    }
}

