/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import ch.cern.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@Deprecated
public class RegionLoad
implements RegionMetrics {
    protected ClusterStatusProtos.RegionLoad regionLoadPB;
    private final RegionMetrics metrics;

    @SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public RegionLoad(ClusterStatusProtos.RegionLoad regionLoadPB) {
        this.regionLoadPB = regionLoadPB;
        this.metrics = RegionMetricsBuilder.toRegionMetrics(regionLoadPB);
    }

    RegionLoad(RegionMetrics metrics) {
        this.metrics = metrics;
        this.regionLoadPB = RegionMetricsBuilder.toRegionLoad(metrics);
    }

    @Deprecated
    public byte[] getName() {
        return this.metrics.getRegionName();
    }

    @Override
    public byte[] getRegionName() {
        return this.metrics.getRegionName();
    }

    @Override
    public int getStoreCount() {
        return this.metrics.getStoreCount();
    }

    @Override
    public int getStoreFileCount() {
        return this.metrics.getStoreFileCount();
    }

    @Override
    public Size getStoreFileSize() {
        return this.metrics.getStoreFileSize();
    }

    @Override
    public Size getMemStoreSize() {
        return this.metrics.getMemStoreSize();
    }

    @Override
    public long getReadRequestCount() {
        return this.metrics.getReadRequestCount();
    }

    @Override
    public long getFilteredReadRequestCount() {
        return this.metrics.getFilteredReadRequestCount();
    }

    @Override
    public Size getStoreFileIndexSize() {
        return this.metrics.getStoreFileIndexSize();
    }

    @Override
    public long getWriteRequestCount() {
        return this.metrics.getWriteRequestCount();
    }

    @Override
    public Size getStoreFileRootLevelIndexSize() {
        return this.metrics.getStoreFileRootLevelIndexSize();
    }

    @Override
    public Size getStoreFileUncompressedDataIndexSize() {
        return this.metrics.getStoreFileUncompressedDataIndexSize();
    }

    @Override
    public Size getBloomFilterSize() {
        return this.metrics.getBloomFilterSize();
    }

    @Override
    public long getCompactingCellCount() {
        return this.metrics.getCompactingCellCount();
    }

    @Override
    public long getCompactedCellCount() {
        return this.metrics.getCompactedCellCount();
    }

    @Override
    public long getCompletedSequenceId() {
        return this.metrics.getCompletedSequenceId();
    }

    @Override
    public Map<byte[], Long> getStoreSequenceId() {
        return this.metrics.getStoreSequenceId();
    }

    @Override
    public Size getUncompressedStoreFileSize() {
        return this.metrics.getUncompressedStoreFileSize();
    }

    @Deprecated
    public int getStores() {
        return this.metrics.getStoreCount();
    }

    @Deprecated
    public int getStorefiles() {
        return this.metrics.getStoreFileCount();
    }

    @Deprecated
    public int getStorefileSizeMB() {
        return (int)this.metrics.getStoreFileSize().get(Size.Unit.MEGABYTE);
    }

    @Deprecated
    public int getMemStoreSizeMB() {
        return (int)this.metrics.getMemStoreSize().get(Size.Unit.MEGABYTE);
    }

    @Deprecated
    public int getStorefileIndexSizeMB() {
        return this.getRootIndexSizeKB() >> 10;
    }

    @Deprecated
    public int getStorefileIndexSizeKB() {
        return this.getRootIndexSizeKB();
    }

    @Deprecated
    public long getRequestsCount() {
        return this.metrics.getRequestCount();
    }

    @Deprecated
    public long getReadRequestsCount() {
        return this.metrics.getReadRequestCount();
    }

    @Deprecated
    public long getFilteredReadRequestsCount() {
        return this.metrics.getFilteredReadRequestCount();
    }

    @Deprecated
    public long getWriteRequestsCount() {
        return this.metrics.getWriteRequestCount();
    }

    @Deprecated
    public int getRootIndexSizeKB() {
        return (int)this.metrics.getStoreFileRootLevelIndexSize().get(Size.Unit.KILOBYTE);
    }

    @Deprecated
    public int getTotalStaticIndexSizeKB() {
        return (int)this.metrics.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
    }

    @Deprecated
    public int getTotalStaticBloomSizeKB() {
        return (int)this.metrics.getBloomFilterSize().get(Size.Unit.KILOBYTE);
    }

    @Deprecated
    public long getTotalCompactingKVs() {
        return this.metrics.getCompactingCellCount();
    }

    @Deprecated
    public long getCurrentCompactedKVs() {
        return this.metrics.getCompactedCellCount();
    }

    @Deprecated
    public long getCompleteSequenceId() {
        return this.metrics.getCompletedSequenceId();
    }

    @Deprecated
    public List<ClusterStatusProtos.StoreSequenceId> getStoreCompleteSequenceId() {
        return this.metrics.getStoreSequenceId().entrySet().stream().map(s -> ClusterStatusProtos.StoreSequenceId.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])((byte[])s.getKey()))).setSequenceId((Long)s.getValue()).build()).collect(Collectors.toList());
    }

    @Deprecated
    public int getStoreUncompressedSizeMB() {
        return (int)this.metrics.getUncompressedStoreFileSize().get(Size.Unit.KILOBYTE);
    }

    @Override
    public float getDataLocality() {
        return this.metrics.getDataLocality();
    }

    @Override
    public long getLastMajorCompactionTimestamp() {
        return this.metrics.getLastMajorCompactionTimestamp();
    }

    @Deprecated
    public long getLastMajorCompactionTs() {
        return this.metrics.getLastMajorCompactionTimestamp();
    }

    public String toString() {
        StringBuilder sb = Strings.appendKeyValue(new StringBuilder(), "numberOfStores", this.getStores());
        Strings.appendKeyValue(sb, "numberOfStorefiles", this.getStorefiles());
        Strings.appendKeyValue(sb, "storefileUncompressedSizeMB", this.getStoreUncompressedSizeMB());
        Strings.appendKeyValue(sb, "lastMajorCompactionTimestamp", this.getLastMajorCompactionTs());
        Strings.appendKeyValue(sb, "storefileSizeMB", this.getStorefileSizeMB());
        if (this.getStoreUncompressedSizeMB() != 0) {
            Strings.appendKeyValue(sb, "compressionRatio", String.format("%.4f", Float.valueOf((float)this.getStorefileSizeMB() / (float)this.getStoreUncompressedSizeMB())));
        }
        Strings.appendKeyValue(sb, "memstoreSizeMB", this.getMemStoreSizeMB());
        Strings.appendKeyValue(sb, "readRequestsCount", this.getReadRequestsCount());
        Strings.appendKeyValue(sb, "writeRequestsCount", this.getWriteRequestsCount());
        Strings.appendKeyValue(sb, "rootIndexSizeKB", this.getRootIndexSizeKB());
        Strings.appendKeyValue(sb, "totalStaticIndexSizeKB", this.getTotalStaticIndexSizeKB());
        Strings.appendKeyValue(sb, "totalStaticBloomSizeKB", this.getTotalStaticBloomSizeKB());
        Strings.appendKeyValue(sb, "totalCompactingKVs", this.getTotalCompactingKVs());
        Strings.appendKeyValue(sb, "currentCompactedKVs", this.getCurrentCompactedKVs());
        float compactionProgressPct = Float.NaN;
        if (this.getTotalCompactingKVs() > 0L) {
            compactionProgressPct = (float)this.getCurrentCompactedKVs() / (float)this.getTotalCompactingKVs();
        }
        Strings.appendKeyValue(sb, "compactionProgressPct", Float.valueOf(compactionProgressPct));
        Strings.appendKeyValue(sb, "completeSequenceId", this.getCompleteSequenceId());
        Strings.appendKeyValue(sb, "dataLocality", Float.valueOf(this.getDataLocality()));
        return sb.toString();
    }
}

