/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RowMutations
implements Row {
    private final List<Mutation> mutations;
    private final byte[] row;

    public static RowMutations of(List<? extends Mutation> mutations) throws IOException {
        if (CollectionUtils.isEmpty(mutations)) {
            throw new IllegalArgumentException("Cannot instantiate a RowMutations by empty list");
        }
        return new RowMutations(mutations.get(0).getRow(), mutations.size()).add(mutations);
    }

    public RowMutations(byte[] row) {
        this(row, -1);
    }

    public RowMutations(byte[] row, int initialCapacity) {
        this.row = Bytes.copy(Mutation.checkRow(row));
        this.mutations = initialCapacity <= 0 ? new ArrayList<Mutation>() : new ArrayList<Mutation>(initialCapacity);
    }

    @Deprecated
    public void add(Put p) throws IOException {
        this.add((Mutation)p);
    }

    @Deprecated
    public void add(Delete d) throws IOException {
        this.add((Mutation)d);
    }

    public RowMutations add(Mutation mutation) throws IOException {
        return this.add(Collections.singletonList(mutation));
    }

    public RowMutations add(List<? extends Mutation> mutations) throws IOException {
        for (Mutation mutation : mutations) {
            if (Bytes.equals(this.row, mutation.getRow())) continue;
            throw new WrongRowIOException("The row in the recently added Put/Delete <" + Bytes.toStringBinary(mutation.getRow()) + "> doesn't match the original one <" + Bytes.toStringBinary(this.row) + ">");
        }
        this.mutations.addAll(mutations);
        return this;
    }

    @Override
    @Deprecated
    public int compareTo(Row i) {
        return Bytes.compareTo(this.getRow(), i.getRow());
    }

    @Deprecated
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RowMutations) {
            RowMutations other = (RowMutations)obj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        return Arrays.hashCode(this.row);
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public List<Mutation> getMutations() {
        return Collections.unmodifiableList(this.mutations);
    }

    public int getMaxPriority() {
        int maxPriority = Integer.MIN_VALUE;
        for (Mutation mutation : this.mutations) {
            maxPriority = Math.max(maxPriority, mutation.getPriority());
        }
        return maxPriority;
    }
}

