/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import ch.cern.hbase.thirdparty.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class TableDescriptorUtils {
    private TableDescriptorUtils() {
    }

    public static TableDescriptorDelta computeDelta(TableDescriptor oldTD, TableDescriptor newTD) {
        return new TableDescriptorDelta(oldTD, newTD);
    }

    public static final class TableDescriptorDelta {
        private final Set<byte[]> columnsAdded;
        private final Set<byte[]> columnsDeleted;
        private final Set<byte[]> columnsModified;

        private TableDescriptorDelta(TableDescriptor oldTD, TableDescriptor newTD) {
            Preconditions.checkNotNull((Object)oldTD);
            Preconditions.checkNotNull((Object)newTD);
            TreeMap<byte[], ColumnFamilyDescriptor> oldCFs = new TreeMap<byte[], ColumnFamilyDescriptor>(Bytes.BYTES_COMPARATOR);
            TreeSet<byte[]> newCFs = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (ColumnFamilyDescriptor cfd : oldTD.getColumnFamilies()) {
                oldCFs.put(cfd.getName(), cfd);
            }
            TreeSet<byte[]> added = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            TreeSet<byte[]> modified = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (ColumnFamilyDescriptor cfd : newTD.getColumnFamilies()) {
                byte[] cfName = cfd.getName();
                newCFs.add(cfName);
                if (!oldCFs.containsKey(cfName)) {
                    added.add(cfName);
                    continue;
                }
                if (cfd.equals(oldCFs.get(cfName))) continue;
                modified.add(cfName);
            }
            Set deleted = oldCFs.keySet();
            deleted.removeAll(newCFs);
            this.columnsAdded = Collections.unmodifiableSet(added);
            this.columnsDeleted = Collections.unmodifiableSet(deleted);
            this.columnsModified = Collections.unmodifiableSet(modified);
        }

        public Set<byte[]> getColumnsAdded() {
            return this.columnsAdded;
        }

        public Set<byte[]> getColumnsDeleted() {
            return this.columnsDeleted;
        }

        public Set<byte[]> getColumnsModified() {
            return this.columnsModified;
        }
    }
}

