/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ByteBufferPool {
    private static final Logger LOG = LoggerFactory.getLogger(ByteBufferPool.class);
    public static final String MAX_POOL_SIZE_KEY = "hbase.ipc.server.reservoir.initial.max";
    public static final String BUFFER_SIZE_KEY = "hbase.ipc.server.reservoir.initial.buffer.size";
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private final Queue<ByteBuffer> buffers = new ConcurrentLinkedQueue<ByteBuffer>();
    private final int bufferSize;
    private final int maxPoolSize;
    private AtomicInteger count;
    private final boolean directByteBuffer;
    private boolean maxPoolSizeInfoLevelLogged = false;

    public ByteBufferPool(int bufferSize, int maxPoolSize) {
        this(bufferSize, maxPoolSize, true);
    }

    public ByteBufferPool(int bufferSize, int maxPoolSize, boolean directByteBuffer) {
        this.bufferSize = bufferSize;
        this.maxPoolSize = maxPoolSize;
        this.directByteBuffer = directByteBuffer;
        LOG.info("Created with bufferSize={} and maxPoolSize={}", (Object)StringUtils.byteDesc((long)bufferSize), (Object)StringUtils.byteDesc((long)maxPoolSize));
        this.count = new AtomicInteger(0);
    }

    public ByteBuffer getBuffer() {
        int c;
        ByteBuffer bb = this.buffers.poll();
        if (bb != null) {
            bb.clear();
            return bb;
        }
        do {
            if ((c = this.count.intValue()) < this.maxPoolSize) continue;
            if (this.maxPoolSizeInfoLevelLogged) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Pool already reached its max capacity : " + this.maxPoolSize + " and no free buffers now. Consider increasing the value for '" + MAX_POOL_SIZE_KEY + "' ?");
                }
            } else {
                LOG.info("Pool already reached its max capacity : " + this.maxPoolSize + " and no free buffers now. Consider increasing the value for '" + MAX_POOL_SIZE_KEY + "' ?");
                this.maxPoolSizeInfoLevelLogged = true;
            }
            return null;
        } while (!this.count.compareAndSet(c, c + 1));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating a new offheap ByteBuffer of size: " + this.bufferSize);
        }
        return this.directByteBuffer ? ByteBuffer.allocateDirect(this.bufferSize) : ByteBuffer.allocate(this.bufferSize);
    }

    public void putbackBuffer(ByteBuffer buf) {
        if (buf.capacity() != this.bufferSize || this.directByteBuffer ^ buf.isDirect()) {
            LOG.warn("Trying to put a buffer, not created by this pool! Will be just ignored");
            return;
        }
        this.buffers.offer(buf);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @VisibleForTesting
    public int getQueueSize() {
        return this.buffers.size();
    }
}

