/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import ch.cern.hbase.thirdparty.com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LRUDictionary
implements Dictionary {
    BidirectionalLRUMap backingStore;

    @Override
    public byte[] getEntry(short idx) {
        return this.backingStore.get(idx);
    }

    @Override
    public void init(int initialSize) {
        this.backingStore = new BidirectionalLRUMap(initialSize);
    }

    @Override
    public short findEntry(byte[] data, int offset, int length) {
        short ret = this.backingStore.findIdx(data, offset, length);
        if (ret == -1) {
            this.addEntry(data, offset, length);
        }
        return ret;
    }

    @Override
    public short addEntry(byte[] data, int offset, int length) {
        return this.addEntryInternal(data, offset, length, true);
    }

    private short addEntryInternal(byte[] data, int offset, int length, boolean copy) {
        if (length <= 0) {
            return -1;
        }
        return this.backingStore.put(data, offset, length, copy);
    }

    @Override
    public void clear() {
        this.backingStore.clear();
    }

    @Override
    public short findEntry(ByteBuffer data, int offset, int length) {
        short ret = this.backingStore.findIdx(data, offset, length);
        if (ret == -1) {
            byte[] copy = new byte[length];
            ByteBufferUtils.copyFromBufferToArray(copy, data, offset, 0, length);
            this.addEntryInternal(copy, 0, length, false);
        }
        return ret;
    }

    static class BidirectionalLRUMap {
        private int currSize = 0;
        private Node head;
        private Node tail;
        private HashMap<Node, Short> nodeToIndex = new HashMap();
        private Node[] indexToNode;
        private int initSize = 0;

        public BidirectionalLRUMap(int initialSize) {
            this.initSize = initialSize;
            this.indexToNode = new Node[initialSize];
        }

        private short put(byte[] array, int offset, int length, boolean copy) {
            if (copy) {
                byte[] stored = new byte[length];
                Bytes.putBytes(stored, 0, array, offset, length);
                return this.putInternal(stored);
            }
            return this.putInternal(array);
        }

        private short putInternal(byte[] stored) {
            if (this.currSize < this.initSize) {
                if (this.indexToNode[this.currSize] == null) {
                    this.indexToNode[this.currSize] = new ByteArrayBackedNode();
                }
                this.indexToNode[this.currSize].setContents(stored, 0, stored.length);
                this.setHead(this.indexToNode[this.currSize]);
                short ret = (short)this.currSize++;
                this.nodeToIndex.put(this.indexToNode[ret], ret);
                return ret;
            }
            short s = this.nodeToIndex.remove(this.tail);
            this.tail.setContents(stored, 0, stored.length);
            this.nodeToIndex.put(this.tail, s);
            this.moveToHead(this.tail);
            return s;
        }

        private short findIdx(byte[] array, int offset, int length) {
            ByteArrayBackedNode comparisonNode = new ByteArrayBackedNode();
            ((Node)comparisonNode).setContents(array, offset, length);
            Short s = this.nodeToIndex.get(comparisonNode);
            if (s != null) {
                this.moveToHead(this.indexToNode[s]);
                return s;
            }
            return -1;
        }

        private short findIdx(ByteBuffer buf, int offset, int length) {
            ByteBufferBackedNode comparisonNode = new ByteBufferBackedNode();
            comparisonNode.setContents(buf, offset, length);
            Short s = this.nodeToIndex.get(comparisonNode);
            if (s != null) {
                this.moveToHead(this.indexToNode[s]);
                return s;
            }
            return -1;
        }

        private byte[] get(short idx) {
            Preconditions.checkElementIndex((int)idx, (int)this.currSize);
            this.moveToHead(this.indexToNode[idx]);
            return this.indexToNode[idx].getContents();
        }

        private void moveToHead(Node n) {
            if (this.head == n) {
                return;
            }
            assert (n.prev != null);
            n.prev.next = n.next;
            if (n.next != null) {
                n.next.prev = n.prev;
            } else {
                assert (n == this.tail);
                this.tail = n.prev;
            }
            this.setHead(n);
        }

        private void setHead(Node n) {
            n.prev = null;
            n.next = this.head;
            if (this.head != null) {
                assert (this.head.prev == null);
                this.head.prev = n;
            }
            this.head = n;
            if (this.tail == null) {
                this.tail = n;
            }
        }

        private void clear() {
            for (int i = 0; i < this.currSize; ++i) {
                this.indexToNode[i].next = null;
                this.indexToNode[i].prev = null;
                this.indexToNode[i].resetContents();
            }
            this.currSize = 0;
            this.nodeToIndex.clear();
            this.tail = null;
            this.head = null;
        }

        private static class ByteBufferBackedNode
        extends Node {
            private ByteBuffer container;

            @Override
            void setContents(byte[] container, int offset, int length) {
                this.container = ByteBuffer.wrap(container);
                this.offset = offset;
                this.length = length;
            }

            void setContents(ByteBuffer container, int offset, int length) {
                this.container = container;
                this.offset = offset;
                this.length = length;
            }

            @Override
            void resetContents() {
                this.container = null;
            }

            @Override
            byte[] getContents() {
                byte[] copy = new byte[this.length];
                ByteBufferUtils.copyFromBufferToArray(copy, this.container, this.offset, 0, this.length);
                return copy;
            }

            public int hashCode() {
                return ByteBufferUtils.hashCode(this.container, this.offset, this.length);
            }

            public boolean equals(Object other) {
                if (!(other instanceof Node)) {
                    return false;
                }
                Node casted = (Node)other;
                return ByteBufferUtils.equals(this.container, this.offset, this.length, casted.getContents(), casted.offset, casted.length);
            }
        }

        private static class ByteArrayBackedNode
        extends Node {
            private byte[] container;

            private ByteArrayBackedNode() {
            }

            @Override
            void setContents(byte[] container, int offset, int length) {
                this.container = container;
                this.offset = offset;
                this.length = length;
            }

            @Override
            byte[] getContents() {
                return this.container;
            }

            public int hashCode() {
                return Bytes.hashCode(this.container, this.offset, this.length);
            }

            @Override
            void resetContents() {
                this.container = null;
            }

            public boolean equals(Object other) {
                if (!(other instanceof Node)) {
                    return false;
                }
                Node casted = (Node)other;
                return Bytes.equals(this.container, this.offset, this.length, casted.getContents(), casted.offset, casted.length);
            }
        }

        private static abstract class Node {
            int offset;
            int length;
            Node next;
            Node prev;

            private Node() {
            }

            abstract void setContents(byte[] var1, int var2, int var3);

            abstract byte[] getContents();

            abstract void resetContents();
        }
    }
}

