/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import ch.cern.hbase.thirdparty.com.google.gson.GsonBuilder;
import ch.cern.hbase.thirdparty.com.google.gson.LongSerializationPolicy;
import ch.cern.hbase.thirdparty.com.google.gson.TypeAdapter;
import ch.cern.hbase.thirdparty.com.google.gson.stream.JsonReader;
import ch.cern.hbase.thirdparty.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class GsonUtil {
    private GsonUtil() {
    }

    public static GsonBuilder createGson() {
        return new GsonBuilder().setLongSerializationPolicy(LongSerializationPolicy.STRING).registerTypeAdapter(LongAdder.class, (Object)new TypeAdapter<LongAdder>(){

            public void write(JsonWriter out, LongAdder value) throws IOException {
                out.value(value.longValue());
            }

            public LongAdder read(JsonReader in) throws IOException {
                LongAdder value = new LongAdder();
                value.add(in.nextLong());
                return value;
            }
        });
    }
}

