/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import ch.cern.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import ch.cern.hbase.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class IdLock {
    private static final Logger LOG = LoggerFactory.getLogger(IdLock.class);
    private ConcurrentMap<Long, Entry> map = new ConcurrentHashMap<Long, Entry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getLockEntry(long id) throws IOException {
        Entry existing;
        Thread currentThread = Thread.currentThread();
        Entry entry = new Entry(id, currentThread);
        while ((existing = this.map.putIfAbsent(entry.id, entry)) != null) {
            Entry entry2 = existing;
            synchronized (entry2) {
                if (existing.locked) {
                    ++existing.numWaiters;
                    while (existing.locked) {
                        try {
                            existing.wait();
                        }
                        catch (InterruptedException e) {
                            --existing.numWaiters;
                            if (!existing.locked && existing.numWaiters == 0) {
                                this.map.remove(existing.id);
                            }
                            throw new InterruptedIOException("Interrupted waiting to acquire sparse lock");
                        }
                    }
                    --existing.numWaiters;
                    existing.locked = true;
                    existing.holder = currentThread;
                    return existing;
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry tryLockEntry(long id, long time) throws IOException {
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0);
        Thread currentThread = Thread.currentThread();
        Entry entry = new Entry(id, currentThread);
        long waitUtilTS = System.currentTimeMillis() + time;
        long remaining = time;
        Entry existing;
        while ((existing = this.map.putIfAbsent(entry.id, entry)) != null) {
            Entry entry2 = existing;
            synchronized (entry2) {
                if (existing.locked) {
                    ++existing.numWaiters;
                    try {
                        while (existing.locked) {
                            existing.wait(remaining);
                            if (!existing.locked) continue;
                            long currentTS = System.currentTimeMillis();
                            if (currentTS >= waitUtilTS) {
                                Entry entry3 = null;
                                return entry3;
                            }
                            remaining = waitUtilTS - currentTS;
                        }
                    }
                    catch (InterruptedException e) {
                        if (!existing.locked && existing.numWaiters == 1) {
                            this.map.remove(existing.id);
                        }
                        throw new InterruptedIOException("Interrupted waiting to acquire sparse lock");
                    }
                    finally {
                        --existing.numWaiters;
                    }
                    existing.locked = true;
                    existing.holder = currentThread;
                    return existing;
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLockEntry(Entry entry) {
        Thread currentThread = Thread.currentThread();
        Entry entry2 = entry;
        synchronized (entry2) {
            if (entry.holder != currentThread) {
                LOG.warn("{} is trying to release lock entry {}, but it is not the holder.", (Object)currentThread, (Object)entry);
            }
            entry.locked = false;
            if (entry.numWaiters > 0) {
                entry.notify();
            } else {
                this.map.remove(entry.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeldByCurrentThread(long id) {
        Thread currentThread = Thread.currentThread();
        Entry entry = (Entry)this.map.get(id);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            return currentThread.equals(entry.holder);
        }
    }

    @VisibleForTesting
    void assertMapEmpty() {
        assert (this.map.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void waitForWaiters(long id, int numWaiters) throws InterruptedException {
        while (true) {
            Entry entry;
            if ((entry = (Entry)this.map.get(id)) != null) {
                Entry entry2 = entry;
                synchronized (entry2) {
                    if (entry.numWaiters >= numWaiters) {
                        return;
                    }
                }
            }
            Thread.sleep(100L);
        }
    }

    public static final class Entry {
        private final long id;
        private int numWaiters;
        private boolean locked = true;
        private Thread holder;

        private Entry(long id, Thread holder) {
            this.id = id;
            this.holder = holder;
        }

        public String toString() {
            return "id=" + this.id + ", numWaiter=" + this.numWaiters + ", isLocked=" + this.locked + ", holder=" + this.holder;
        }
    }
}

