/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import ch.cern.hbase.thirdparty.com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Random64 {
    private static final long multiplier = 6364136223846793005L;
    private static final long addend = 1442695040888963407L;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private long seed;

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    public Random64() {
        this(Random64.seedUniquifier() ^ System.nanoTime());
    }

    public Random64(long seed) {
        this.seed = seed;
    }

    public long nextLong() {
        return this.next64(64);
    }

    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            long rnd = this.nextLong();
            long n = Math.min(len - i, 8);
            while (n-- > 0L) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
    }

    private long next64(int bits) {
        this.seed = this.seed * 6364136223846793005L + 1442695040888963407L;
        return this.seed >>> 64 - bits;
    }

    public static void main(String[] args) {
        long defaultTotalTestCnt = 1000000000000L;
        if (args.length == 1) {
            defaultTotalTestCnt = Long.parseLong(args[0]);
        }
        Preconditions.checkArgument((defaultTotalTestCnt > 0L ? 1 : 0) != 0, (Object)"totalTestCnt <= 0");
        int precision = 100000;
        long totalTestCnt = defaultTotalTestCnt + 100000L;
        int reportPeriod = 10000000;
        long startTime = System.currentTimeMillis();
        System.out.println("Do collision test, totalTestCnt=" + totalTestCnt);
        Random64 rand = new Random64();
        HashSet<Long> longSet = new HashSet<Long>();
        for (long cnt = 1L; cnt <= totalTestCnt; ++cnt) {
            long randLong = rand.nextLong();
            if (longSet.contains(randLong)) {
                System.err.println("Conflict! count=" + cnt);
                System.exit(1);
            }
            if (cnt % 100000L != 0L) continue;
            if (!longSet.add(randLong)) {
                System.err.println("Conflict! count=" + cnt);
                System.exit(1);
            }
            if (cnt % 10000000L != 0L) continue;
            long cost = System.currentTimeMillis() - startTime;
            long remainingMs = (long)(1.0 * (double)(totalTestCnt - cnt) * (double)cost / (double)cnt);
            System.out.println(String.format("Progress: %.3f%%, remaining %d minutes", 100.0 * (double)cnt / (double)totalTestCnt, remainingMs / 60000L));
        }
        System.out.println("No collision!");
    }
}

