/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.archetypes.exemplars.shaded_client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.archetypes.exemplars.shaded_client.HelloHBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHelloHBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHelloHBase.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testNamespaceExists() throws Exception {
        String NONEXISTENT_NAMESPACE = "xyzpdq_nonexistent";
        String EXISTING_NAMESPACE = "pdqxyz_myExistingNamespace";
        Admin admin = TEST_UTIL.getAdmin();
        boolean exists = HelloHBase.namespaceExists((Admin)admin, (String)"xyzpdq_nonexistent");
        Assert.assertEquals((String)"#namespaceExists failed: found nonexistent namespace.", (Object)false, (Object)exists);
        admin.createNamespace(NamespaceDescriptor.create((String)"pdqxyz_myExistingNamespace").build());
        exists = HelloHBase.namespaceExists((Admin)admin, (String)"pdqxyz_myExistingNamespace");
        Assert.assertEquals((String)"#namespaceExists failed: did NOT find existing namespace.", (Object)true, (Object)exists);
        admin.deleteNamespace("pdqxyz_myExistingNamespace");
    }

    @Test
    public void testCreateNamespaceAndTable() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        HelloHBase.createNamespaceAndTable((Admin)admin);
        boolean namespaceExists = HelloHBase.namespaceExists((Admin)admin, (String)"myTestNamespace");
        Assert.assertEquals((String)"#createNamespaceAndTable failed to create namespace.", (Object)true, (Object)namespaceExists);
        boolean tableExists = admin.tableExists(HelloHBase.MY_TABLE_NAME);
        Assert.assertEquals((String)"#createNamespaceAndTable failed to create table.", (Object)true, (Object)tableExists);
        admin.disableTable(HelloHBase.MY_TABLE_NAME);
        admin.deleteTable(HelloHBase.MY_TABLE_NAME);
        admin.deleteNamespace("myTestNamespace");
    }

    @Test
    public void testPutRowToTable() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        admin.createNamespace(NamespaceDescriptor.create((String)"myTestNamespace").build());
        Table table = TEST_UTIL.createTable(HelloHBase.MY_TABLE_NAME, HelloHBase.MY_COLUMN_FAMILY_NAME);
        HelloHBase.putRowToTable((Table)table);
        Result row = table.get(new Get(HelloHBase.MY_ROW_ID));
        Assert.assertEquals((String)"#putRowToTable failed to store row.", (Object)false, (Object)row.isEmpty());
        TEST_UTIL.deleteTable(HelloHBase.MY_TABLE_NAME);
        admin.deleteNamespace("myTestNamespace");
    }

    @Test
    public void testDeleteRow() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        admin.createNamespace(NamespaceDescriptor.create((String)"myTestNamespace").build());
        Table table = TEST_UTIL.createTable(HelloHBase.MY_TABLE_NAME, HelloHBase.MY_COLUMN_FAMILY_NAME);
        table.put(new Put(HelloHBase.MY_ROW_ID).addColumn(HelloHBase.MY_COLUMN_FAMILY_NAME, HelloHBase.MY_FIRST_COLUMN_QUALIFIER, Bytes.toBytes((String)"xyz")));
        HelloHBase.deleteRow((Table)table);
        Result row = table.get(new Get(HelloHBase.MY_ROW_ID));
        Assert.assertEquals((String)"#deleteRow failed to delete row.", (Object)true, (Object)row.isEmpty());
        TEST_UTIL.deleteTable(HelloHBase.MY_TABLE_NAME);
        admin.deleteNamespace("myTestNamespace");
    }
}

