/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.Config;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.ConfigKey;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.ConfigObject;

public class ConfigImpl
implements Config {
    private String resource;
    private Map<String, ConfigObject> properties;
    private List<Config> configs;

    protected ConfigImpl(String resource) {
        this.resource = resource;
        this.properties = new HashMap<String, ConfigObject>();
        this.configs = new ArrayList<Config>(0);
    }

    protected void reset() {
        this.properties.clear();
        this.configs.clear();
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public Set<String> getNames() {
        HashSet<String> propNames = new HashSet<String>(this.properties.keySet());
        for (Config config : this.configs) {
            propNames.addAll(config.getNames());
        }
        return propNames;
    }

    @Override
    public String getString(String name) {
        String result = null;
        ConfigObject co = this.properties.get(name);
        if (co != null) {
            result = co.getPropertyValue();
        } else {
            Config config;
            Iterator<Config> i$ = this.configs.iterator();
            while (i$.hasNext() && (result = (config = i$.next()).getString(name)) == null) {
            }
        }
        return result;
    }

    @Override
    public String getString(ConfigKey name, boolean useDefault) {
        if (useDefault) {
            return this.getString(name.getPropertyKey(), (String)name.getDefaultValue());
        }
        return this.getString(name.getPropertyKey());
    }

    @Override
    public String getString(String name, String defaultValue) {
        String result = this.getString(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public String getTrimmed(String name) {
        String result = this.getString(name);
        if (null != result) {
            result = result.trim();
        }
        return result;
    }

    @Override
    public String getTrimmed(ConfigKey name) {
        return this.getTrimmed(name.getPropertyKey());
    }

    @Override
    public Integer getInt(String name) {
        Integer result = null;
        String value = this.getTrimmed(name);
        if (value != null) {
            result = Integer.valueOf(value);
        }
        return result;
    }

    @Override
    public Integer getInt(ConfigKey name, boolean useDefault) {
        if (useDefault) {
            return this.getInt(name.getPropertyKey(), this.getDefaultValueAs(name, Integer.class));
        }
        return this.getInt(name.getPropertyKey());
    }

    private <T> T getDefaultValueAs(ConfigKey confKey, Class<T> cls) {
        Object defValue = confKey.getDefaultValue();
        if (defValue != null && cls != null) {
            return (T)defValue;
        }
        return null;
    }

    @Override
    public Integer getInt(String name, Integer defaultValue) {
        Integer result = this.getInt(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public void setInt(String name, Integer value) {
        this.set(name, String.valueOf(value));
    }

    @Override
    public void setInt(ConfigKey name, Integer value) {
        this.set(name.getPropertyKey(), String.valueOf(value));
    }

    @Override
    public Long getLong(String name) {
        Long result = null;
        String value = this.getTrimmed(name);
        if (value != null) {
            result = Long.valueOf(value);
        }
        return result;
    }

    @Override
    public Long getLong(ConfigKey name, boolean useDefault) {
        if (useDefault) {
            return this.getLong(name.getPropertyKey(), this.getDefaultValueAs(name, Long.class));
        }
        return this.getLong(name.getPropertyKey());
    }

    @Override
    public Long getLong(String name, Long defaultValue) {
        Long result = this.getLong(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public void setLong(String name, Long value) {
        this.set(name, String.valueOf(value));
    }

    @Override
    public void setLong(ConfigKey name, Long value) {
        this.set(name.getPropertyKey(), String.valueOf(value));
    }

    @Override
    public Float getFloat(String name) {
        Float result = null;
        String value = this.getTrimmed(name);
        if (value != null) {
            result = Float.valueOf(value);
        }
        return result;
    }

    @Override
    public Float getFloat(ConfigKey name, boolean useDefault) {
        if (useDefault) {
            return this.getFloat(name.getPropertyKey(), this.getDefaultValueAs(name, Float.class));
        }
        return this.getFloat(name.getPropertyKey());
    }

    @Override
    public Float getFloat(String name, Float defaultValue) {
        Float result = this.getFloat(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public void setFloat(String name, Float value) {
        this.set(name, String.valueOf(value));
    }

    @Override
    public void setFloat(ConfigKey name, Float value) {
        this.set(name.getPropertyKey(), String.valueOf(value));
    }

    @Override
    public Boolean getBoolean(String name) {
        Boolean result = null;
        String value = this.getTrimmed(name);
        if (value != null) {
            result = Boolean.valueOf(value);
        }
        return result;
    }

    @Override
    public Boolean getBoolean(ConfigKey name, boolean useDefault) {
        if (useDefault) {
            return this.getBoolean(name.getPropertyKey(), (Boolean)name.getDefaultValue());
        }
        return this.getBoolean(name.getPropertyKey());
    }

    @Override
    public Boolean getBoolean(String name, Boolean defaultValue) {
        Boolean result = this.getBoolean(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public void setBoolean(String name, Boolean value) {
        this.set(name, String.valueOf(value));
    }

    @Override
    public void setBoolean(ConfigKey name, Boolean value) {
        this.set(name.getPropertyKey(), String.valueOf(value));
    }

    @Override
    public List<String> getList(String name) {
        List<String> results = null;
        ConfigObject co = this.properties.get(name);
        if (co != null) {
            results = co.getListValues();
        } else {
            Config config;
            Iterator<Config> i$ = this.configs.iterator();
            while (i$.hasNext() && (results = (config = i$.next()).getList(name)) == null) {
            }
        }
        return results;
    }

    @Override
    public List<String> getList(String name, String[] defaultValue) {
        List<String> results = this.getList(name);
        if (results == null) {
            results = Arrays.asList(defaultValue);
        }
        return results;
    }

    @Override
    public List<String> getList(ConfigKey name) {
        if (name.getDefaultValue() != null) {
            return this.getList(name.getPropertyKey(), (String[])name.getDefaultValue());
        }
        return this.getList(name.getPropertyKey());
    }

    @Override
    public Config getConfig(String name) {
        Config result = null;
        ConfigObject co = this.properties.get(name);
        if (co != null) {
            result = co.getConfigValue();
        } else {
            Config config;
            Iterator<Config> i$ = this.configs.iterator();
            while (i$.hasNext() && (result = (config = i$.next()).getConfig(name)) == null) {
            }
        }
        return result;
    }

    @Override
    public Config getConfig(ConfigKey name) {
        return this.getConfig(name.getPropertyKey());
    }

    @Override
    public Class<?> getClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        String valueString = this.getString(name);
        if (valueString != null) {
            Class<?> cls;
            result = cls = Class.forName(name);
        }
        return result;
    }

    @Override
    public Class<?> getClass(String name, Class<?> defaultValue) throws ClassNotFoundException {
        Class<?> result = this.getClass(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public Class<?> getClass(ConfigKey name, boolean useDefault) throws ClassNotFoundException {
        if (useDefault) {
            return this.getClass(name.getPropertyKey(), (Class)name.getDefaultValue());
        }
        return this.getClass(name.getPropertyKey());
    }

    @Override
    public <T> T getInstance(String name) throws ClassNotFoundException {
        return this.getInstance(name, null);
    }

    @Override
    public <T> T getInstance(ConfigKey name) throws ClassNotFoundException {
        return this.getInstance(name.getPropertyKey());
    }

    @Override
    public <T> T getInstance(String name, Class<T> xface) throws ClassNotFoundException {
        T result = null;
        Class<?> cls = this.getClass(name, null);
        if (xface != null && !xface.isAssignableFrom(cls)) {
            throw new RuntimeException(cls + " does not implement " + xface);
        }
        try {
            result = (T)cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance with class " + cls.getName());
        }
        return result;
    }

    @Override
    public void setString(String name, String value) {
        this.set(name, value);
    }

    @Override
    public void setString(ConfigKey name, String value) {
        this.set(name.getPropertyKey(), value);
    }

    protected void set(String name, String value) {
        ConfigObject co = new ConfigObject(value);
        this.set(name, co);
    }

    protected void set(String name, Config value) {
        ConfigObject co = new ConfigObject(value);
        this.set(name, co);
    }

    protected void set(String name, ConfigObject value) {
        this.properties.put(name, value);
    }

    protected void add(Config config) {
        if (config != null) {
            if (this == config) {
                throw new IllegalArgumentException("You can not add a config to itself");
            }
            this.configs.add(config);
        }
    }
}

