/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public abstract class KrbInputStream
extends DataInputStream {
    public KrbInputStream(InputStream in) {
        super(in);
    }

    public KerberosTime readTime() throws IOException {
        long value = this.readInt();
        KerberosTime time = new KerberosTime(value * 1000L);
        return time;
    }

    public abstract PrincipalName readPrincipal(int var1) throws IOException;

    public EncryptionKey readKey() throws IOException {
        short eType = this.readShort();
        EncryptionType encType = EncryptionType.fromValue(Integer.valueOf(eType));
        byte[] keyData = this.readCountedOctets();
        if (encType == EncryptionType.NONE || keyData == null) {
            return null;
        }
        EncryptionKey key = new EncryptionKey(encType, keyData);
        return key;
    }

    public String readCountedString() throws IOException {
        byte[] countedOctets = this.readCountedOctets();
        if (countedOctets != null) {
            return new String(countedOctets, StandardCharsets.UTF_8);
        }
        return null;
    }

    public byte[] readCountedOctets() throws IOException {
        int len = this.readOctetsCount();
        if (len == 0) {
            return null;
        }
        if (len < 0 || len > this.available()) {
            throw new IOException("Unexpected octets len: " + len);
        }
        byte[] data = new byte[len];
        this.readFully(data);
        return data;
    }

    public abstract int readOctetsCount() throws IOException;
}

