/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.provider;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.provider.AbstractHashProvider;

public class MessageDigestHashProvider
extends AbstractHashProvider {
    private String algorithm;
    protected MessageDigest messageDigest;

    public MessageDigestHashProvider(int hashSize, int blockSize, String algorithm) {
        super(hashSize, blockSize);
        this.algorithm = algorithm;
        this.init();
    }

    @Override
    protected void init() {
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to init JCE provider", e);
        }
    }

    @Override
    public void hash(byte[] data, int start, int len) throws KrbException {
        this.messageDigest.update(data, start, len);
    }

    @Override
    public byte[] output() {
        return this.messageDigest.digest();
    }
}

