/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.handler.ContextHandler;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.session.AbstractSession;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.session.AbstractSessionManager;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.session.JDBCSessionIdManager;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.server.session.MemSession;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.hbase.shaded.org.eclipse.jetty.util.log.Logger;

public class JDBCSessionManager
extends AbstractSessionManager {
    private static final Logger LOG = Log.getLogger(JDBCSessionManager.class);
    private ConcurrentHashMap<String, Session> _sessions;
    protected JDBCSessionIdManager _jdbcSessionIdMgr = null;
    protected long _saveIntervalSec = 60L;
    protected JDBCSessionIdManager.SessionTableSchema _sessionTableSchema;

    public void setSaveInterval(long sec) {
        this._saveIntervalSec = sec;
    }

    public long getSaveInterval() {
        return this._saveIntervalSec;
    }

    public void cacheInvalidate(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(String idInCluster) {
        Session session = null;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            Session memSession = this._sessions.get(idInCluster);
            long now = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                if (memSession == null) {
                    LOG.debug("getSession(" + idInCluster + "): not in session map, now=" + now + " lastSaved=" + (memSession == null ? 0L : memSession._lastSaved) + " interval=" + this._saveIntervalSec * 1000L, new Object[0]);
                } else {
                    LOG.debug("getSession(" + idInCluster + "): in session map,  hashcode=" + memSession.hashCode() + " now=" + now + " lastSaved=" + (memSession == null ? 0L : memSession._lastSaved) + " interval=" + this._saveIntervalSec * 1000L + " lastNode=" + memSession._lastNode + " thisNode=" + this.getSessionIdManager().getWorkerName() + " difference=" + (now - memSession._lastSaved), new Object[0]);
                }
            }
            try {
                if (memSession == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession(" + idInCluster + "): no session in session map. Reloading session data from db.", new Object[0]);
                    }
                    session = this.loadSession(idInCluster, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context));
                } else if (now - memSession._lastSaved >= this._saveIntervalSec * 1000L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession(" + idInCluster + "): stale session. Reloading session data from db.", new Object[0]);
                    }
                    session = this.loadSession(idInCluster, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession(" + idInCluster + "): session in session map", new Object[0]);
                    }
                    session = memSession;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to load session " + idInCluster, e);
                return null;
            }
            if (session != null) {
                if (!session.getLastNode().equals(this.getSessionIdManager().getWorkerName()) || memSession == null) {
                    if (session._expiryTime <= 0L || session._expiryTime > now) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getSession(" + idInCluster + "): lastNode=" + session.getLastNode() + " thisNode=" + this.getSessionIdManager().getWorkerName(), new Object[0]);
                        }
                        session.setLastNode(this.getSessionIdManager().getWorkerName());
                        this._sessions.put(idInCluster, session);
                        try {
                            this.updateSessionNode(session);
                            session.didActivate();
                        }
                        catch (Exception e) {
                            LOG.warn("Unable to update freshly loaded session " + idInCluster, e);
                            return null;
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getSession ({}): Session has expired", idInCluster);
                        }
                        this._jdbcSessionIdMgr.removeSession(idInCluster);
                        session = null;
                    }
                } else {
                    session = memSession;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession({}): Session not stale {}", idInCluster, session);
                    }
                }
            } else {
                if (memSession != null) {
                    this.removeSession(memSession, true);
                }
                LOG.debug("getSession({}): No session in database matching id={}", idInCluster, idInCluster);
            }
            return session;
        }
    }

    @Override
    public int getSessions() {
        return this._sessions.size();
    }

    @Override
    public void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No session id manager defined");
        }
        this._jdbcSessionIdMgr = (JDBCSessionIdManager)this._sessionIdManager;
        this._sessionTableSchema = this._jdbcSessionIdMgr.getSessionTableSchema();
        this._sessions = new ConcurrentHashMap();
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this._sessions.clear();
        this._sessions = null;
    }

    @Override
    protected void shutdownSessions() {
        ArrayList<Object> sessions;
        long gracefulStopMs = this.getContextHandler().getServer().getStopTimeout();
        long stopTime = 0L;
        if (gracefulStopMs > 0L) {
            stopTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(gracefulStopMs, TimeUnit.MILLISECONDS);
        }
        ArrayList<Object> arrayList = sessions = this._sessions == null ? new ArrayList() : new ArrayList<Session>(this._sessions.values());
        while (sessions.size() > 0 && (stopTime > 0L && System.nanoTime() < stopTime || stopTime == 0L)) {
            for (Session session : sessions) {
                try {
                    session.save(false);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
                this._sessions.remove(session.getClusterId());
            }
            if (stopTime == 0L) break;
            sessions = new ArrayList<Session>(this._sessions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String oldClusterId, String oldNodeId, String newClusterId, String newNodeId) {
        block5: {
            Session session = null;
            try {
                session = this._sessions.remove(oldClusterId);
                if (session == null) break block5;
                Session session2 = session;
                synchronized (session2) {
                    session.setClusterId(newClusterId);
                    session.setNodeId(newNodeId);
                    this._sessions.put(newClusterId, session);
                    this.updateSession(session);
                }
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
        super.renewSessionId(oldClusterId, oldNodeId, newClusterId, newNodeId);
    }

    protected void invalidateSession(String idInCluster) {
        Session session = this._sessions.get(idInCluster);
        if (session != null) {
            session.invalidate();
        }
    }

    @Override
    protected boolean removeSession(String idInCluster) {
        Session session = this._sessions.remove(idInCluster);
        try {
            if (session != null) {
                this.deleteSession(session);
            }
        }
        catch (Exception e) {
            LOG.warn("Problem deleting session id=" + idInCluster, e);
        }
        return session != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSession(AbstractSession session) {
        if (session == null) {
            return;
        }
        this._sessions.put(session.getClusterId(), (Session)session);
        try {
            AbstractSession abstractSession = session;
            synchronized (abstractSession) {
                session.willPassivate();
                this.storeSession((Session)session);
                session.didActivate();
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to store new session id=" + session.getId(), e);
        }
    }

    @Override
    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(request);
    }

    protected AbstractSession newSession(String sessionId, String rowId, long created, long accessed, long maxInterval) {
        return new Session(sessionId, rowId, created, accessed, maxInterval);
    }

    @Override
    public boolean removeSession(AbstractSession session, boolean invalidate) {
        boolean removed = super.removeSession(session, invalidate);
        if (removed && !invalidate) {
            session.willPassivate();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> expire(Set<String> sessionIds) {
        if (this.isStopping() || this.isStopped()) {
            return null;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        HashSet<String> successfullyExpiredIds = new HashSet<String>();
        try {
            for (String sessionId : sessionIds) {
                Session session;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Expiring session id " + sessionId, new Object[0]);
                }
                if ((session = this._sessions.get(sessionId)) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Force loading session id " + sessionId, new Object[0]);
                    }
                    if ((session = this.loadSession(sessionId, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context))) != null) {
                        this._sessions.put(session.getClusterId(), session);
                    } else {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Unrecognized session id=" + sessionId, new Object[0]);
                        continue;
                    }
                }
                if (session == null) continue;
                session.timeout();
                successfullyExpiredIds.add(session.getClusterId());
            }
            HashSet<String> hashSet = successfullyExpiredIds;
            return hashSet;
        }
        catch (Throwable t) {
            LOG.warn("Problem expiring sessions", t);
            HashSet<String> hashSet = successfullyExpiredIds;
            return hashSet;
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    protected void expireCandidates(Set<String> candidateIds) {
        Iterator<String> itor = candidateIds.iterator();
        long now = System.currentTimeMillis();
        while (itor.hasNext()) {
            String id = itor.next();
            try {
                Session s;
                Session memSession = this._sessions.get(id);
                if (memSession == null || (s = this.loadSession(id, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context))) != null) continue;
                memSession.timeout();
            }
            catch (Exception e) {
                LOG.warn("Error checking db for expiry for session {}", id);
            }
        }
    }

    protected Set<String> getCandidateExpiredIds() {
        HashSet<String> expiredIds = new HashSet<String>();
        for (String id : this._sessions.keySet()) {
            Session session = this._sessions.get(id);
            if (session._expiryTime <= 0L || System.currentTimeMillis() <= session._expiryTime) continue;
            expiredIds.add(id);
        }
        return expiredIds;
    }

    protected Session loadSession(final String id, final String canonicalContextPath, final String vhost) throws Exception {
        final AtomicReference _reference = new AtomicReference();
        final AtomicReference _exception = new AtomicReference();
        Runnable load = new Runnable(){

            @Override
            public void run() {
                try (Connection connection = JDBCSessionManager.this.getConnection();
                     PreparedStatement statement = JDBCSessionManager.this._sessionTableSchema.getLoadStatement(connection, id, canonicalContextPath, vhost);
                     ResultSet result = statement.executeQuery();){
                    Session session = null;
                    if (result.next()) {
                        long maxInterval = result.getLong(JDBCSessionManager.this._sessionTableSchema.getMaxIntervalColumn());
                        if (maxInterval == -999L) {
                            maxInterval = JDBCSessionManager.this.getMaxInactiveInterval();
                        }
                        session = (Session)JDBCSessionManager.this.newSession(id, result.getString(JDBCSessionManager.this._sessionTableSchema.getRowIdColumn()), result.getLong(JDBCSessionManager.this._sessionTableSchema.getCreateTimeColumn()), result.getLong(JDBCSessionManager.this._sessionTableSchema.getAccessTimeColumn()), maxInterval);
                        session.setCookieSetTime(result.getLong(JDBCSessionManager.this._sessionTableSchema.getCookieTimeColumn()));
                        session.setLastAccessedTime(result.getLong(JDBCSessionManager.this._sessionTableSchema.getLastAccessTimeColumn()));
                        session.setLastNode(result.getString(JDBCSessionManager.this._sessionTableSchema.getLastNodeColumn()));
                        session.setLastSaved(result.getLong(JDBCSessionManager.this._sessionTableSchema.getLastSavedTimeColumn()));
                        session.setExpiryTime(result.getLong(JDBCSessionManager.this._sessionTableSchema.getExpiryTimeColumn()));
                        session.setCanonicalContext(result.getString(JDBCSessionManager.this._sessionTableSchema.getContextPathColumn()));
                        session.setVirtualHost(result.getString(JDBCSessionManager.this._sessionTableSchema.getVirtualHostColumn()));
                        try (InputStream is = ((JDBCSessionIdManager)JDBCSessionManager.this.getSessionIdManager())._dbAdaptor.getBlobInputStream(result, JDBCSessionManager.this._sessionTableSchema.getMapColumn());
                             ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(is);){
                            Object o = ois.readObject();
                            session.addAttributes((Map)o);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("LOADED session " + session, new Object[0]);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to load session " + id, new Object[0]);
                    }
                    _reference.set(session);
                }
                catch (Exception e) {
                    _exception.set(e);
                }
            }
        };
        if (this._context == null) {
            load.run();
        } else {
            this._context.getContextHandler().handle(null, load);
        }
        if (_exception.get() != null) {
            this._jdbcSessionIdMgr.removeSession(id);
            throw (Exception)_exception.get();
        }
        return (Session)_reference.get();
    }

    protected void storeSession(Session session) throws Exception {
        if (session == null) {
            return;
        }
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this._jdbcSessionIdMgr._insertSession);){
            String rowId = this.calculateRowId(session);
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement.setString(1, rowId);
            statement.setString(2, session.getClusterId());
            statement.setString(3, session.getCanonicalContext());
            statement.setString(4, session.getVirtualHost());
            statement.setString(5, this.getSessionIdManager().getWorkerName());
            statement.setLong(6, session.getAccessed());
            statement.setLong(7, session.getLastAccessedTime());
            statement.setLong(8, session.getCreationTime());
            statement.setLong(9, session.getCookieSetTime());
            statement.setLong(10, now);
            statement.setLong(11, session.getExpiryTime());
            statement.setLong(12, session.getMaxInactiveInterval());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(session.getAttributeMap());
            oos.flush();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(13, (InputStream)bais, bytes.length);
            statement.executeUpdate();
            session.setRowId(rowId);
            session.setLastSaved(now);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stored session " + session, new Object[0]);
        }
    }

    protected void updateSession(Session data) throws Exception {
        if (data == null) {
            return;
        }
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSession);){
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement.setString(1, data.getClusterId());
            statement.setString(2, this.getSessionIdManager().getWorkerName());
            statement.setLong(3, data.getAccessed());
            statement.setLong(4, data.getLastAccessedTime());
            statement.setLong(5, now);
            statement.setLong(6, data.getExpiryTime());
            statement.setLong(7, data.getMaxInactiveInterval());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data.getAttributeMap());
            oos.flush();
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(8, (InputStream)bais, bytes.length);
            statement.setString(9, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated session " + data, new Object[0]);
        }
    }

    protected void updateSessionNode(Session data) throws Exception {
        String nodeId = this.getSessionIdManager().getWorkerName();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionNode);){
            connection.setAutoCommit(true);
            statement.setString(1, nodeId);
            statement.setString(2, data.getRowId());
            statement.executeUpdate();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated last node for session id=" + data.getId() + ", lastNode = " + nodeId, new Object[0]);
        }
    }

    private void updateSessionAccessTime(Session data) throws Exception {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionAccessTime);){
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement.setString(1, this.getSessionIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessedTime());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            statement.setLong(6, data.getMaxInactiveInterval());
            statement.setString(7, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated access time session id=" + data.getId() + " with lastsaved=" + data.getLastSaved(), new Object[0]);
        }
    }

    protected void deleteSession(Session data) throws Exception {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this._jdbcSessionIdMgr._deleteSession);){
            connection.setAutoCommit(true);
            statement.setString(1, data.getRowId());
            statement.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted Session " + data, new Object[0]);
            }
        }
    }

    private Connection getConnection() throws SQLException {
        return ((JDBCSessionIdManager)this.getSessionIdManager()).getConnection();
    }

    private String calculateRowId(Session data) {
        String rowId = JDBCSessionManager.canonicalize(this._context.getContextPath());
        rowId = rowId + "_" + JDBCSessionManager.getVirtualHost(this._context);
        rowId = rowId + "_" + data.getId();
        return rowId;
    }

    private static String getVirtualHost(ContextHandler.Context context) {
        String vhost = "0.0.0.0";
        if (context == null) {
            return vhost;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return vhost;
        }
        return vhosts[0];
    }

    private static String canonicalize(String path) {
        if (path == null) {
            return "";
        }
        return path.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    public class Session
    extends MemSession {
        private static final long serialVersionUID = 5208464051134226143L;
        protected boolean _dirty;
        protected long _expiryTime;
        protected long _lastSaved;
        protected String _lastNode;
        protected String _virtualHost;
        protected String _rowId;
        protected String _canonicalContext;

        protected Session(HttpServletRequest request) {
            super(JDBCSessionManager.this, request);
            this._dirty = false;
            int maxInterval = this.getMaxInactiveInterval();
            this._expiryTime = maxInterval <= 0 ? 0L : System.currentTimeMillis() + (long)maxInterval * 1000L;
            this._virtualHost = JDBCSessionManager.getVirtualHost(JDBCSessionManager.this._context);
            this._canonicalContext = JDBCSessionManager.canonicalize(JDBCSessionManager.this._context.getContextPath());
            this._lastNode = JDBCSessionManager.this.getSessionIdManager().getWorkerName();
        }

        protected Session(String sessionId, String rowId, long created, long accessed, long maxInterval) {
            super(JDBCSessionManager.this, created, accessed, sessionId);
            this._dirty = false;
            this._rowId = rowId;
            super.setMaxInactiveInterval((int)maxInterval);
            this._expiryTime = maxInterval <= 0L ? 0L : System.currentTimeMillis() + maxInterval * 1000L;
        }

        protected synchronized String getRowId() {
            return this._rowId;
        }

        protected synchronized void setRowId(String rowId) {
            this._rowId = rowId;
        }

        public synchronized void setVirtualHost(String vhost) {
            this._virtualHost = vhost;
        }

        public synchronized String getVirtualHost() {
            return this._virtualHost;
        }

        public synchronized long getLastSaved() {
            return this._lastSaved;
        }

        public synchronized void setLastSaved(long time) {
            this._lastSaved = time;
        }

        public synchronized void setExpiryTime(long time) {
            this._expiryTime = time;
        }

        public synchronized long getExpiryTime() {
            return this._expiryTime;
        }

        public synchronized void setCanonicalContext(String str) {
            this._canonicalContext = str;
        }

        public synchronized String getCanonicalContext() {
            return this._canonicalContext;
        }

        public synchronized void setLastNode(String node) {
            this._lastNode = node;
        }

        public synchronized String getLastNode() {
            return this._lastNode;
        }

        @Override
        public void setAttribute(String name, Object value) {
            Object old = this.changeAttribute(name, value);
            if (value == null && old == null) {
                return;
            }
            this._dirty = true;
        }

        @Override
        public void removeAttribute(String name) {
            Object old = this.changeAttribute(name, null);
            if (old != null) {
                this._dirty = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean access(long time) {
            Session session = this;
            synchronized (session) {
                if (super.access(time)) {
                    int maxInterval = this.getMaxInactiveInterval();
                    this._expiryTime = maxInterval <= 0 ? 0L : time + (long)maxInterval * 1000L;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMaxInactiveInterval(int secs) {
            Session session = this;
            synchronized (session) {
                super.setMaxInactiveInterval(secs);
                int maxInterval = this.getMaxInactiveInterval();
                this._expiryTime = maxInterval <= 0 ? 0L : System.currentTimeMillis() + (long)maxInterval * 1000L;
                try {
                    JDBCSessionManager.this.updateSessionAccessTime(this);
                }
                catch (Exception e) {
                    LOG.warn("Problem saving changed max idle time for session " + this, e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void complete() {
            Session session = this;
            synchronized (session) {
                super.complete();
                try {
                    if (this.isValid()) {
                        if (this._dirty) {
                            this.save(true);
                        } else if (this.getAccessed() - this._lastSaved >= JDBCSessionManager.this.getSaveInterval() * 1000L) {
                            JDBCSessionManager.this.updateSessionAccessTime(this);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Problem persisting changed session data id=" + this.getId(), e);
                }
                finally {
                    this._dirty = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void save() throws Exception {
            Session session = this;
            synchronized (session) {
                try {
                    JDBCSessionManager.this.updateSession(this);
                }
                finally {
                    this._dirty = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void save(boolean reactivate) throws Exception {
            Session session = this;
            synchronized (session) {
                if (this._dirty) {
                    this.willPassivate();
                    JDBCSessionManager.this.updateSession(this);
                    if (reactivate) {
                        this.didActivate();
                    }
                }
            }
        }

        @Override
        protected void timeout() throws IllegalStateException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timing out session id=" + this.getClusterId(), new Object[0]);
            }
            super.timeout();
        }

        @Override
        public String toString() {
            return "Session rowId=" + this._rowId + ",id=" + this.getId() + ",lastNode=" + this._lastNode + ",created=" + this.getCreationTime() + ",accessed=" + this.getAccessed() + ",lastAccessed=" + this.getLastAccessedTime() + ",cookieSet=" + this.getCookieSetTime() + ",maxInterval=" + this.getMaxInactiveInterval() + ",lastSaved=" + this._lastSaved + ",expiry=" + this._expiryTime;
        }
    }
}

