/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(RegionStateStore.class);
    protected static final char META_REPLICA_ID_DELIMITER = '_';
    private final MasterServices master;

    public RegionStateStore(MasterServices master) {
        this.master = master;
    }

    public void visitMeta(final RegionStateVisitor visitor) throws IOException {
        MetaTableAccessor.fullScanRegions(this.master.getConnection(), new MetaTableAccessor.Visitor(){
            final boolean isDebugEnabled = RegionStateStore.access$000().isDebugEnabled();

            @Override
            public boolean visit(Result r) throws IOException {
                if (r != null && !r.isEmpty()) {
                    long st = 0L;
                    if (LOG.isTraceEnabled()) {
                        st = System.currentTimeMillis();
                    }
                    RegionStateStore.this.visitMetaEntry(visitor, r);
                    if (LOG.isTraceEnabled()) {
                        long et = System.currentTimeMillis();
                        LOG.trace("[T] LOAD META PERF " + StringUtils.humanTimeDiff(et - st));
                    }
                } else if (this.isDebugEnabled) {
                    LOG.debug("NULL result from meta - ignoring but this is strange.");
                }
                return true;
            }
        });
    }

    private void visitMetaEntry(RegionStateVisitor visitor, Result result) throws IOException {
        RegionLocations rl = MetaTableAccessor.getRegionLocations(result);
        if (rl == null) {
            return;
        }
        HRegionLocation[] locations = rl.getRegionLocations();
        if (locations == null) {
            return;
        }
        for (int i = 0; i < locations.length; ++i) {
            RegionInfo regionInfo;
            HRegionLocation hrl = locations[i];
            if (hrl == null || (regionInfo = hrl.getRegion()) == null) continue;
            int replicaId = regionInfo.getReplicaId();
            RegionState.State state = RegionStateStore.getRegionState(result, replicaId);
            ServerName lastHost = hrl.getServerName();
            ServerName regionLocation = RegionStateStore.getRegionServer(result, replicaId);
            long openSeqNum = hrl.getSeqNum();
            LOG.info("Load hbase:meta entry region={}, regionState={}, lastHost={}, regionLocation={}, openSeqNum={}", new Object[]{regionInfo.getEncodedName(), state, lastHost, regionLocation, openSeqNum});
            visitor.visitRegionState(result, regionInfo, state, regionLocation, lastHost, openSeqNum);
        }
    }

    public void updateRegionLocation(RegionStates.RegionStateNode regionStateNode) throws IOException {
        if (regionStateNode.getRegionInfo().isMetaRegion()) {
            this.updateMetaLocation(regionStateNode.getRegionInfo(), regionStateNode.getRegionLocation(), regionStateNode.getState());
        } else {
            long openSeqNum = regionStateNode.getState() == RegionState.State.OPEN ? regionStateNode.getOpenSeqNum() : -1L;
            this.updateUserRegionLocation(regionStateNode.getRegionInfo(), regionStateNode.getState(), regionStateNode.getRegionLocation(), openSeqNum, regionStateNode.getProcedure() != null ? regionStateNode.getProcedure().getProcId() : -1L);
        }
    }

    private void updateMetaLocation(RegionInfo regionInfo, ServerName serverName, RegionState.State state) throws IOException {
        try {
            MetaTableLocator.setMetaLocation(this.master.getZooKeeper(), serverName, regionInfo.getReplicaId(), state);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    private void updateUserRegionLocation(RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, long openSeqNum, long pid) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        int replicaId = regionInfo.getReplicaId();
        Put put = new Put(MetaTableAccessor.getMetaKeyForRegion(regionInfo), time);
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        StringBuilder info = new StringBuilder("pid=").append(pid).append(" updating hbase:meta row=").append(regionInfo.getEncodedName()).append(", regionState=").append((Object)state);
        if (openSeqNum >= 0L) {
            Preconditions.checkArgument(state == RegionState.State.OPEN && regionLocation != null, "Open region should be on a server");
            MetaTableAccessor.addLocation(put, regionLocation, openSeqNum, replicaId);
            if (regionInfo.getReplicaId() == 0 && this.hasGlobalReplicationScope(regionInfo.getTable())) {
                MetaTableAccessor.addReplicationBarrier(put, openSeqNum);
                info.append(", repBarrier=").append(openSeqNum);
            }
            info.append(", openSeqNum=").append(openSeqNum);
            info.append(", regionLocation=").append(regionLocation);
        } else if (regionLocation != null) {
            put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(RegionStateStore.getServerNameColumn(replicaId)).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(regionLocation.getServerName())).build());
            info.append(", regionLocation=").append(regionLocation);
        }
        put.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(RegionStateStore.getStateColumn(replicaId)).setTimestamp(put.getTimestamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes(state.name())).build());
        LOG.info(info.toString());
        this.updateRegionLocation(regionInfo, state, put);
    }

    private void updateRegionLocation(RegionInfo regionInfo, RegionState.State state, Put put) throws IOException {
        try (Table table = this.master.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
        catch (IOException e) {
            String msg = String.format("FAILED persisting region=%s state=%s", new Object[]{regionInfo.getShortNameToLog(), state});
            LOG.error(msg, (Throwable)e);
            this.master.abort(msg, e);
            throw e;
        }
    }

    private long getOpenSeqNumForParentRegion(RegionInfo region) throws IOException {
        FileSystem walFS = this.master.getMasterWalManager().getFileSystem();
        long maxSeqId = WALSplitter.getMaxRegionSequenceId(walFS, FSUtils.getWALRegionDir(this.master.getConfiguration(), region.getTable(), region.getEncodedName()));
        return maxSeqId > 0L ? maxSeqId + 1L : -1L;
    }

    public void splitRegion(RegionInfo parent, RegionInfo hriA, RegionInfo hriB, ServerName serverName) throws IOException {
        TableDescriptor htd = this.getTableDescriptor(parent.getTable());
        long parentOpenSeqNum = -1L;
        if (htd.hasGlobalReplicationScope()) {
            parentOpenSeqNum = this.getOpenSeqNumForParentRegion(parent);
        }
        MetaTableAccessor.splitRegion(this.master.getConnection(), parent, parentOpenSeqNum, hriA, hriB, serverName, this.getRegionReplication(htd));
    }

    public void mergeRegions(RegionInfo child, RegionInfo hriA, RegionInfo hriB, ServerName serverName) throws IOException {
        TableDescriptor htd = this.getTableDescriptor(child.getTable());
        long regionAOpenSeqNum = -1L;
        long regionBOpenSeqNum = -1L;
        if (htd.hasGlobalReplicationScope()) {
            regionAOpenSeqNum = this.getOpenSeqNumForParentRegion(hriA);
            regionBOpenSeqNum = this.getOpenSeqNumForParentRegion(hriB);
        }
        MetaTableAccessor.mergeRegions(this.master.getConnection(), child, hriA, regionAOpenSeqNum, hriB, regionBOpenSeqNum, serverName, this.getRegionReplication(htd));
    }

    public void deleteRegion(RegionInfo regionInfo) throws IOException {
        this.deleteRegions(Collections.singletonList(regionInfo));
    }

    public void deleteRegions(List<RegionInfo> regions) throws IOException {
        MetaTableAccessor.deleteRegions(this.master.getConnection(), regions);
    }

    private boolean hasGlobalReplicationScope(TableName tableName) throws IOException {
        return this.hasGlobalReplicationScope(this.getTableDescriptor(tableName));
    }

    private boolean hasGlobalReplicationScope(TableDescriptor htd) {
        return htd != null ? htd.hasGlobalReplicationScope() : false;
    }

    private int getRegionReplication(TableDescriptor htd) {
        return htd != null ? htd.getRegionReplication() : 1;
    }

    private TableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        return this.master.getTableDescriptors().get(tableName);
    }

    static ServerName getRegionServer(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, RegionStateStore.getServerNameColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            HRegionLocation location;
            RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
            if (locations != null && (location = locations.getRegionLocation(replicaId)) != null) {
                return location.getServerName();
            }
            return null;
        }
        return ServerName.parseServerName(Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
    }

    private static byte[] getServerNameColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVERNAME_QUALIFIER : Bytes.toBytes("sn_" + String.format("%04X", replicaId));
    }

    @VisibleForTesting
    public static RegionState.State getRegionState(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, RegionStateStore.getStateColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        return RegionState.State.valueOf(Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
    }

    private static byte[] getStateColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STATE_QUALIFIER : Bytes.toBytes("state_" + String.format("%04X", replicaId));
    }

    public static interface RegionStateVisitor {
        public void visitRegionState(Result var1, RegionInfo var2, RegionState.State var3, ServerName var4, ServerName var5, long var6);
    }
}

