/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.ShadedAccessControlUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class SnapshotDescriptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDescriptionUtils.class);
    public static final int SNAPSHOT_LAYOUT_VERSION = 2;
    public static final String SNAPSHOTINFO_FILE = ".snapshotinfo";
    public static final String SNAPSHOT_TMP_DIR_NAME = ".tmp";
    public static final long NO_SNAPSHOT_START_TIME_SPECIFIED = 0L;
    public static final String MASTER_SNAPSHOT_TIMEOUT_MILLIS = "hbase.snapshot.master.timeout.millis";
    public static final long DEFAULT_MAX_WAIT_TIME = 300000L;
    @Deprecated
    public static final int SNAPSHOT_TIMEOUT_MILLIS_DEFAULT = 300000;
    @Deprecated
    public static final String SNAPSHOT_TIMEOUT_MILLIS_KEY = "hbase.snapshot.master.timeoutMillis";

    private SnapshotDescriptionUtils() {
    }

    public static long getMaxMasterTimeout(Configuration conf, SnapshotProtos.SnapshotDescription.Type type, long defaultMaxWaitTime) {
        switch (type) {
            default: 
        }
        String confKey = MASTER_SNAPSHOT_TIMEOUT_MILLIS;
        return Math.max(conf.getLong(confKey, defaultMaxWaitTime), conf.getLong(SNAPSHOT_TIMEOUT_MILLIS_KEY, defaultMaxWaitTime));
    }

    public static Path getSnapshotRootDir(Path rootDir) {
        return new Path(rootDir, ".hbase-snapshot");
    }

    public static Path getCompletedSnapshotDir(SnapshotProtos.SnapshotDescription snapshot, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot.getName(), rootDir);
    }

    public static Path getCompletedSnapshotDir(String snapshotName, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(SnapshotDescriptionUtils.getSnapshotsDir(rootDir), snapshotName);
    }

    public static Path getWorkingSnapshotDir(Path rootDir) {
        return new Path(SnapshotDescriptionUtils.getSnapshotsDir(rootDir), SNAPSHOT_TMP_DIR_NAME);
    }

    public static Path getWorkingSnapshotDir(SnapshotProtos.SnapshotDescription snapshot, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(SnapshotDescriptionUtils.getWorkingSnapshotDir(rootDir), snapshot.getName());
    }

    public static Path getWorkingSnapshotDir(String snapshotName, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(SnapshotDescriptionUtils.getWorkingSnapshotDir(rootDir), snapshotName);
    }

    private static final Path getCompletedSnapshotDir(Path snapshotsDir, String snapshotName) {
        return new Path(snapshotsDir, snapshotName);
    }

    public static final Path getSnapshotsDir(Path rootDir) {
        return new Path(rootDir, ".hbase-snapshot");
    }

    public static SnapshotProtos.SnapshotDescription validate(SnapshotProtos.SnapshotDescription snapshot, Configuration conf) throws IllegalArgumentException, IOException {
        if (!snapshot.hasTable()) {
            throw new IllegalArgumentException("Descriptor doesn't apply to a table, so we can't build it.");
        }
        long time = snapshot.getCreationTime();
        if (time == 0L) {
            time = EnvironmentEdgeManager.currentTime();
            LOG.debug("Creation time not specified, setting to:" + time + " (current time:" + EnvironmentEdgeManager.currentTime() + ").");
            SnapshotProtos.SnapshotDescription.Builder builder = snapshot.toBuilder();
            builder.setCreationTime(time);
            snapshot = builder.build();
        }
        if (SnapshotDescriptionUtils.isSecurityAvailable(conf)) {
            snapshot = SnapshotDescriptionUtils.writeAclToSnapshotDescription(snapshot, conf);
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSnapshotInfo(SnapshotProtos.SnapshotDescription snapshot, Path workingDir, FileSystem fs) throws IOException {
        block5: {
            FsPermission perms = FSUtils.getFilePermissions(fs, fs.getConf(), "hbase.data.umask");
            Path snapshotInfo = new Path(workingDir, SNAPSHOTINFO_FILE);
            try (FSDataOutputStream out = FSUtils.create(fs, snapshotInfo, perms, true);){
                snapshot.writeTo((OutputStream)out);
            }
            catch (IOException e) {
                if (fs.delete(snapshotInfo, false)) break block5;
                String msg = "Couldn't delete snapshot info file: " + snapshotInfo;
                LOG.error(msg);
                throw new IOException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnapshotProtos.SnapshotDescription readSnapshotInfo(FileSystem fs, Path snapshotDir) throws CorruptedSnapshotException {
        SnapshotProtos.SnapshotDescription snapshotDescription;
        block6: {
            Path snapshotInfo = new Path(snapshotDir, SNAPSHOTINFO_FILE);
            FSDataInputStream in = null;
            try {
                SnapshotProtos.SnapshotDescription desc;
                in = fs.open(snapshotInfo);
                snapshotDescription = desc = SnapshotProtos.SnapshotDescription.parseFrom((InputStream)in);
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CorruptedSnapshotException("Couldn't read snapshot info from:" + snapshotInfo, e);
                }
            }
            in.close();
        }
        return snapshotDescription;
    }

    public static void completeSnapshot(SnapshotProtos.SnapshotDescription snapshot, Path rootdir, Path workingDir, FileSystem fs) throws SnapshotCreationException, IOException {
        Path finishedDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, rootdir);
        LOG.debug("Snapshot is done, just moving the snapshot from " + workingDir + " to " + finishedDir);
        if (!fs.rename(workingDir, finishedDir)) {
            throw new SnapshotCreationException("Failed to move working directory(" + workingDir + ") to completed directory(" + finishedDir + ").", ProtobufUtil.createSnapshotDesc(snapshot));
        }
    }

    public static boolean isSnapshotOwner(SnapshotDescription snapshot, User user) {
        if (user == null) {
            return false;
        }
        return user.getShortName().equals(snapshot.getOwner());
    }

    /*
     * Exception decompiling
     */
    public static boolean isSecurityAvailable(Configuration conf) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SnapshotProtos.SnapshotDescription writeAclToSnapshotDescription(final SnapshotProtos.SnapshotDescription snapshot, final Configuration conf) throws IOException {
        ListMultimap<String, TablePermission> perms = User.runAsLoginUser(new PrivilegedExceptionAction<ListMultimap<String, TablePermission>>(){

            @Override
            public ListMultimap<String, TablePermission> run() throws Exception {
                return AccessControlLists.getTablePermissions(conf, TableName.valueOf(snapshot.getTable()));
            }
        });
        return snapshot.toBuilder().setUsersAndPermissions(ShadedAccessControlUtil.toUserTablePermissions(perms)).build();
    }

    public static class CompletedSnaphotDirectoriesFilter
    extends FSUtils.BlackListDirFilter {
        public CompletedSnaphotDirectoriesFilter(FileSystem fs) {
            super(fs, Collections.singletonList(SnapshotDescriptionUtils.SNAPSHOT_TMP_DIR_NAME));
        }
    }
}

