/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.IdReadWriteLock;
import org.apache.hadoop.hbase.util.ZKDataMigrator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(TableStateManager.class);
    private static final String MIGRATE_TABLE_STATE_FROM_ZK_KEY = "hbase.migrate.table.state.from.zookeeper";
    private final IdReadWriteLock<TableName> tnLock = new IdReadWriteLock();
    protected final MasterServices master;
    private final ConcurrentMap<TableName, TableState.State> tableName2State = new ConcurrentHashMap<TableName, TableState.State>();

    public TableStateManager(MasterServices master) {
        this.master = master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableState(TableName tableName, TableState.State newState) throws IOException {
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.writeLock().lock();
        try {
            this.updateMetaState(tableName, newState);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableState setTableStateIfInStates(TableName tableName, TableState.State newState, TableState.State ... states) throws IOException {
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.writeLock().lock();
        try {
            TableState currentState = this.readMetaState(tableName);
            if (currentState == null) {
                throw new TableNotFoundException(tableName);
            }
            if (currentState.inStates(states)) {
                this.updateMetaState(tableName, newState);
                TableState tableState = null;
                return tableState;
            }
            TableState tableState = currentState;
            return tableState;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTableStateIfNotInStates(TableName tableName, TableState.State newState, TableState.State ... states) throws IOException {
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.writeLock().lock();
        try {
            TableState currentState = this.readMetaState(tableName);
            if (currentState == null) {
                throw new TableNotFoundException(tableName);
            }
            if (!currentState.inStates(states)) {
                this.updateMetaState(tableName, newState);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public boolean isTableState(TableName tableName, TableState.State ... states) {
        try {
            TableState tableState = this.getTableState(tableName);
            return tableState.isInStates(states);
        }
        catch (IOException e) {
            LOG.error("Unable to get table " + tableName + " state", (Throwable)e);
            return false;
        }
    }

    public void setDeletedTable(TableName tableName) throws IOException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return;
        }
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.writeLock().lock();
        try {
            MetaTableAccessor.deleteTableState(this.master.getConnection(), tableName);
            this.metaStateDeleted(tableName);
        }
        finally {
            this.tableName2State.remove(tableName);
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(TableName tableName) throws IOException {
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.readLock().lock();
        try {
            boolean bl = this.readMetaState(tableName) != null;
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public Set<TableName> getTablesInStates(final TableState.State ... states) throws IOException {
        final HashSet<TableName> rv = Sets.newHashSet();
        MetaTableAccessor.fullScanTables(this.master.getConnection(), new MetaTableAccessor.Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                TableState tableState = MetaTableAccessor.getTableState(r);
                if (tableState != null && tableState.inStates(states)) {
                    rv.add(tableState.getTableName());
                }
                return true;
            }
        });
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TableState getTableState(TableName tableName) throws IOException {
        ReentrantReadWriteLock lock = this.tnLock.getLock(tableName);
        lock.readLock().lock();
        try {
            TableState currentState = this.readMetaState(tableName);
            if (currentState == null) {
                throw new TableStateNotFoundException(tableName);
            }
            TableState tableState = currentState;
            return tableState;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetaState(TableName tableName, TableState.State newState) throws IOException {
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            if (TableState.State.DISABLING.equals((Object)newState) || TableState.State.DISABLED.equals((Object)newState)) {
                throw new IllegalArgumentIOException("Cannot disable the meta table; " + (Object)((Object)newState));
            }
            return;
        }
        boolean succ = false;
        try {
            MetaTableAccessor.updateTableState(this.master.getConnection(), tableName, newState);
            this.tableName2State.put(tableName, newState);
            succ = true;
        }
        finally {
            if (!succ) {
                this.tableName2State.remove(tableName);
            }
        }
        this.metaStateUpdated(tableName, newState);
    }

    protected void metaStateUpdated(TableName tableName, TableState.State newState) throws IOException {
    }

    protected void metaStateDeleted(TableName tableName) throws IOException {
    }

    @Nullable
    private TableState readMetaState(TableName tableName) throws IOException {
        TableState.State state = (TableState.State)((Object)this.tableName2State.get(tableName));
        if (state != null) {
            return new TableState(tableName, state);
        }
        TableState tableState = MetaTableAccessor.getTableState(this.master.getConnection(), tableName);
        if (tableState != null) {
            this.tableName2State.putIfAbsent(tableName, tableState.getState());
        }
        return tableState;
    }

    public void start() throws IOException {
        TableDescriptors tableDescriptors = this.master.getTableDescriptors();
        this.migrateZooKeeper();
        Connection connection = this.master.getConnection();
        this.fixTableStates(tableDescriptors, connection);
    }

    private void fixTableStates(TableDescriptors tableDescriptors, Connection connection) throws IOException {
        final HashMap states = new HashMap();
        MetaTableAccessor.fullScanTables(connection, new MetaTableAccessor.Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                TableState state = MetaTableAccessor.getTableState(r);
                states.put(state.getTableName().getNameAsString(), state);
                return true;
            }
        });
        for (TableDescriptor tableDesc : tableDescriptors.getAll().values()) {
            TableName tableName = tableDesc.getTableName();
            if (TableName.isMetaTableName(tableName)) {
                this.fixTableState(new TableState(tableName, TableState.State.ENABLED));
                continue;
            }
            TableState tableState = (TableState)states.get(tableName.getNameAsString());
            if (tableState == null) {
                LOG.warn(tableName + " has no table state in hbase:meta, assuming ENABLED");
                MetaTableAccessor.updateTableState(connection, tableName, TableState.State.ENABLED);
                this.fixTableState(new TableState(tableName, TableState.State.ENABLED));
                this.tableName2State.put(tableName, TableState.State.ENABLED);
                continue;
            }
            this.fixTableState(tableState);
            this.tableName2State.put(tableName, tableState.getState());
        }
    }

    protected void fixTableState(TableState tableState) throws IOException {
    }

    @Deprecated
    private void migrateZooKeeper() throws IOException {
        if (!this.master.getConfiguration().getBoolean(MIGRATE_TABLE_STATE_FROM_ZK_KEY, true)) {
            return;
        }
        try {
            for (Map.Entry<TableName, TableState.State> entry : ZKDataMigrator.queryForTableStates(this.master.getZooKeeper()).entrySet()) {
                if (this.master.getTableDescriptors().get(entry.getKey()) == null) {
                    this.deleteZooKeeper(entry.getKey());
                    LOG.info("Purged table state entry from zookeepr for table not in hbase:meta: " + entry.getKey());
                    continue;
                }
                TableState ts = null;
                try {
                    ts = this.getTableState(entry.getKey());
                }
                catch (TableStateNotFoundException tableStateNotFoundException) {
                    // empty catch block
                }
                if (ts != null) continue;
                TableState.State zkstate = entry.getValue();
                if (zkstate.equals((Object)TableState.State.ENABLED) || zkstate.equals((Object)TableState.State.DISABLED)) {
                    LOG.info("Migrating table state from zookeeper to hbase:meta; tableName=" + entry.getKey() + ", state=" + (Object)((Object)entry.getValue()));
                    this.updateMetaState(entry.getKey(), entry.getValue());
                    continue;
                }
                LOG.warn("Table={} has no state and zookeeper state is in-between={} (neither ENABLED or DISABLED); NOT MIGRATING table state", (Object)entry.getKey(), (Object)zkstate);
            }
        }
        catch (InterruptedException | KeeperException e) {
            LOG.warn("Failed reading table state from zookeeper", (Throwable)e);
        }
    }

    @Deprecated
    protected void deleteZooKeeper(TableName tableName) {
        try {
            String znode = ZNodePaths.joinZNode(this.master.getZooKeeper().getZNodePaths().tableZNode, tableName.getNameAsString());
            ZKUtil.deleteNodeFailSilent(this.master.getZooKeeper(), znode);
        }
        catch (KeeperException e) {
            LOG.warn("Failed deleting table state from zookeeper", (Throwable)e);
        }
    }

    public static class TableStateNotFoundException
    extends TableNotFoundException {
        TableStateNotFoundException(TableName tableName) {
            super(tableName.getNameAsString());
        }
    }
}

