/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.BulkLoadCellFilter;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NamespaceTableCfWALEntryFilter
implements WALEntryFilter,
WALCellFilter {
    private final ReplicationPeer peer;
    private BulkLoadCellFilter bulkLoadFilter = new BulkLoadCellFilter();

    public NamespaceTableCfWALEntryFilter(ReplicationPeer peer) {
        this.peer = peer;
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        if (this.peer.getPeerConfig().needToReplicate(entry.getKey().getTableName())) {
            return entry;
        }
        return null;
    }

    @Override
    public Cell filterCell(WAL.Entry entry, Cell cell) {
        ReplicationPeerConfig peerConfig = this.peer.getPeerConfig();
        if (peerConfig.replicateAllUserTables()) {
            Map<TableName, List<String>> excludeTableCfs = peerConfig.getExcludeTableCFsMap();
            if (excludeTableCfs == null) {
                return cell;
            }
            if (CellUtil.matchingColumn(cell, WALEdit.METAFAMILY, WALEdit.BULK_LOAD)) {
                cell = this.bulkLoadFilter.filterCell(cell, fam -> this.filterByExcludeTableCfs(entry.getKey().getTableName(), Bytes.toString(fam), excludeTableCfs));
            } else if (this.filterByExcludeTableCfs(entry.getKey().getTableName(), Bytes.toString(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()), excludeTableCfs)) {
                return null;
            }
            return cell;
        }
        Map<TableName, List<String>> tableCfs = peerConfig.getTableCFsMap();
        if (tableCfs == null) {
            return cell;
        }
        if (CellUtil.matchingColumn(cell, WALEdit.METAFAMILY, WALEdit.BULK_LOAD)) {
            cell = this.bulkLoadFilter.filterCell(cell, fam -> this.filterByTableCfs(entry.getKey().getTableName(), Bytes.toString(fam), tableCfs));
        } else if (this.filterByTableCfs(entry.getKey().getTableName(), Bytes.toString(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()), tableCfs)) {
            return null;
        }
        return cell;
    }

    private boolean filterByExcludeTableCfs(TableName tableName, String family, Map<TableName, List<String>> excludeTableCfs) {
        List<String> excludeCfs = excludeTableCfs.get(tableName);
        if (excludeCfs != null) {
            if (excludeCfs.isEmpty()) {
                return true;
            }
            if (excludeCfs.contains(family)) {
                return true;
            }
        }
        return false;
    }

    private boolean filterByTableCfs(TableName tableName, String family, Map<TableName, List<String>> tableCfs) {
        List<String> cfs = tableCfs.get(tableName);
        return cfs != null && !cfs.contains(family);
    }
}

