/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.rsgroup;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestShellRSGroups {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestShellRSGroups.class);
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final ScriptingContainer jruby = new ScriptingContainer();
    private static String basePath;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        basePath = System.getProperty("basedir");
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.coprocessor.abortonerror", false);
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        SecureTestUtil.enableSecurity((Configuration)TEST_UTIL.getConfiguration());
        VisibilityTestUtil.enableVisiblityLabels((Configuration)TEST_UTIL.getConfiguration());
        TEST_UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
        TEST_UTIL.startMiniCluster(4);
        ArrayList<String> loadPaths = new ArrayList<String>(2);
        loadPaths.add(basePath + "/src/main/ruby");
        loadPaths.add(basePath + "/src/test/ruby");
        jruby.setLoadPaths(loadPaths);
        jruby.put("$TEST_CLUSTER", (Object)TEST_UTIL);
        System.setProperty("jruby.jit.logging.verbose", "true");
        System.setProperty("jruby.jit.logging", "true");
        System.setProperty("jruby.native.verbose", "true");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRunShellTests() throws IOException {
        try {
            System.setProperty("shell.test", "Hbase::RSGroupShellTest");
            jruby.runScriptlet(PathType.ABSOLUTE, basePath + "/src/test/ruby/tests_runner.rb");
        }
        finally {
            System.clearProperty("shell.test");
        }
    }
}

