/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.jruby.embed.ScriptingContainer;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractTestShell {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final ScriptingContainer jruby = new ScriptingContainer();

    protected static void setUpConfig() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setInt("hbase.client.pause", 250);
        conf.setBoolean("hbase.quota.enabled", true);
        conf.setInt("hbase.client.retries.number", 6);
        conf.setBoolean("hbase.coprocessor.abortonerror", false);
        conf.setInt("hfile.format.version", 3);
        conf.setInt("hbase.master.info.port", 0);
        conf.setInt("hbase.regionserver.info.port", 0);
        conf.setBoolean("hbase.regionserver.info.port.auto", true);
        SecureTestUtil.enableSecurity((Configuration)conf);
        VisibilityTestUtil.enableVisiblityLabels((Configuration)conf);
    }

    protected static void setUpJRubyRuntime() {
        ArrayList<String> loadPaths = new ArrayList<String>(2);
        loadPaths.add("src/main/ruby");
        loadPaths.add("src/test/ruby");
        jruby.setLoadPaths(loadPaths);
        jruby.put("$TEST_CLUSTER", (Object)TEST_UTIL);
        System.setProperty("jruby.jit.logging.verbose", "true");
        System.setProperty("jruby.jit.logging", "true");
        System.setProperty("jruby.native.verbose", "true");
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        AbstractTestShell.setUpConfig();
        TEST_UTIL.startMiniCluster(1);
        AbstractTestShell.setUpJRubyRuntime();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

