/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TCompareOp;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TMutation;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestThriftHBaseServiceHandlerWithReadOnly {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftHBaseServiceHandlerWithReadOnly.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] tableAname = Bytes.toBytes((String)"tableA");
    private static byte[] familyAname = Bytes.toBytes((String)"familyA");
    private static byte[] familyBname = Bytes.toBytes((String)"familyB");
    private static byte[] qualifierAname = Bytes.toBytes((String)"qualifierA");
    private static byte[] qualifierBname = Bytes.toBytes((String)"qualifierB");
    private static byte[] valueAname = Bytes.toBytes((String)"valueA");
    private static byte[] valueBname = Bytes.toBytes((String)"valueB");
    private static HColumnDescriptor[] families = new HColumnDescriptor[]{new HColumnDescriptor(familyAname).setMaxVersions(3), new HColumnDescriptor(familyBname).setMaxVersions(2)};

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.thrift.readonly", true);
        UTIL.getConfiguration().set("hbase.client.retries.number", "3");
        UTIL.startMiniCluster();
        Admin admin = UTIL.getAdmin();
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((byte[])tableAname));
        for (HColumnDescriptor family : families) {
            tableDescriptor.addFamily(family);
        }
        admin.createTable((TableDescriptor)tableDescriptor);
        admin.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
    }

    private ThriftHBaseServiceHandler createHandler() throws TException {
        try {
            Configuration conf = UTIL.getConfiguration();
            return new ThriftHBaseServiceHandler(conf, UserProvider.instantiate((Configuration)conf));
        }
        catch (IOException ie) {
            throw new TException((Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistsWithReadOnly() throws TException {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testExists");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        boolean exceptionCaught = false;
        try {
            handler.exists(table, get);
        }
        catch (TIOError e) {
            exceptionCaught = true;
        }
        finally {
            Assert.assertFalse((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistsAllWithReadOnly() throws TException {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName1 = Bytes.toBytes((String)"testExistsAll1");
        byte[] rowName2 = Bytes.toBytes((String)"testExistsAll2");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TGet> gets = new ArrayList<TGet>();
        gets.add(new TGet(ByteBuffer.wrap(rowName1)));
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        boolean exceptionCaught = false;
        try {
            handler.existsAll(table, gets);
        }
        catch (TIOError e) {
            exceptionCaught = true;
        }
        finally {
            Assert.assertFalse((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testGet");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        boolean exceptionCaught = false;
        try {
            handler.get(table, get);
        }
        catch (TIOError e) {
            exceptionCaught = true;
        }
        finally {
            Assert.assertFalse((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMultipleWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = Bytes.toBytes((String)"testGetMultiple1");
        byte[] rowName2 = Bytes.toBytes((String)"testGetMultiple2");
        ArrayList<TGet> gets = new ArrayList<TGet>(2);
        gets.add(new TGet(ByteBuffer.wrap(rowName1)));
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        boolean exceptionCaught = false;
        try {
            handler.getMultiple(table, gets);
        }
        catch (TIOError e) {
            exceptionCaught = true;
        }
        finally {
            Assert.assertFalse((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName = Bytes.toBytes((String)"testPut");
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        boolean exceptionCaught = false;
        try {
            handler.put(table, put);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndPutWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testCheckAndPut");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        boolean exceptionCaught = false;
        try {
            handler.checkAndPut(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), putB);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutMultipleWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = Bytes.toBytes((String)"testPutMultiple1");
        byte[] rowName2 = Bytes.toBytes((String)"testPutMultiple2");
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>(2);
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        boolean exceptionCaught = false;
        try {
            handler.putMultiple(table, puts);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testDelete");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        boolean exceptionCaught = false;
        try {
            handler.deleteSingle(table, delete);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMultipleWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = Bytes.toBytes((String)"testDeleteMultiple1");
        byte[] rowName2 = Bytes.toBytes((String)"testDeleteMultiple2");
        ArrayList<TDelete> deletes = new ArrayList<TDelete>(2);
        deletes.add(new TDelete(ByteBuffer.wrap(rowName1)));
        deletes.add(new TDelete(ByteBuffer.wrap(rowName2)));
        boolean exceptionCaught = false;
        try {
            handler.deleteMultiple(table, deletes);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndMutateWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ByteBuffer row = ByteBuffer.wrap(Bytes.toBytes((String)"row"));
        ByteBuffer family = ByteBuffer.wrap(familyAname);
        ByteBuffer qualifier = ByteBuffer.wrap(qualifierAname);
        ByteBuffer value = ByteBuffer.wrap(valueAname);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueB = new TColumnValue(family, ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(row, columnValuesB);
        putB.setColumnValues(columnValuesB);
        TRowMutations tRowMutations = new TRowMutations(row, Arrays.asList(TMutation.put((TPut)putB)));
        boolean exceptionCaught = false;
        try {
            handler.checkAndMutate(table, row, family, qualifier, TCompareOp.EQUAL, value, tRowMutations);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndDeleteWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testCheckAndDelete");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        boolean exceptionCaught = false;
        try {
            handler.checkAndDelete(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), delete);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testIncrement");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>(1);
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TIncrement increment = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        boolean exceptionCaught = false;
        try {
            handler.increment(table, increment);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testAppend");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] v1 = Bytes.toBytes((String)"42");
        ArrayList<TColumnValue> appendColumns = new ArrayList<TColumnValue>(1);
        appendColumns.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(v1)));
        TAppend append = new TAppend(ByteBuffer.wrap(rowName), appendColumns);
        boolean exceptionCaught = false;
        try {
            handler.append(table, append);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMutateRowWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testMutateRow");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TMutation> mutations = new ArrayList<TMutation>(2);
        TMutation mutationA = TMutation.put((TPut)putA);
        mutations.add(mutationA);
        TMutation mutationB = TMutation.deleteSingle((TDelete)delete);
        mutations.add(mutationB);
        TRowMutations tRowMutations = new TRowMutations(ByteBuffer.wrap(rowName), mutations);
        boolean exceptionCaught = false;
        try {
            handler.mutateRow(table, tRowMutations);
        }
        catch (TIOError e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
            Assert.assertEquals((Object)"Thrift Server is in Read-only mode.", (Object)e.getMessage());
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanWithReadOnly() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TScan scan = new TScan();
        boolean exceptionCaught = false;
        try {
            int scanId = handler.openScanner(table, scan);
            handler.getScannerRows(scanId, 10);
            handler.closeScanner(scanId);
        }
        catch (TIOError e) {
            exceptionCaught = true;
        }
        finally {
            Assert.assertFalse((boolean)exceptionCaught);
        }
    }
}

