/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestThriftHttpServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftHttpServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftHttpServer.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Thread httpServerThread;
    private volatile Exception httpServerException;
    private Exception clientSideException;
    private ThriftServer thriftServer;
    int port;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    static volatile boolean tableCreated = false;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.thrift.http", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TEST_UTIL.startMiniCluster();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testExceptionThrownWhenMisConfigured() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.thrift.security.qop", "privacy");
        conf.setBoolean("hbase.thrift.ssl.enabled", false);
        ThriftServerRunner runner = null;
        ExpectedException thrown = ExpectedException.none();
        try {
            thrown.expect(IllegalArgumentException.class);
            thrown.expectMessage("Thrift HTTP Server's QoP is privacy, but hbase.thrift.ssl.enabled is false");
            runner = new ThriftServerRunner(conf);
            Assert.fail((String)"Thrift HTTP Server starts up even with wrong security configurations.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull(runner);
    }

    private void startHttpServerThread(String[] args) {
        LOG.info("Starting HBase Thrift server with HTTP server: " + Joiner.on((String)" ").join((Object[])args));
        this.httpServerException = null;
        this.httpServerThread = new Thread(() -> {
            try {
                this.thriftServer.doMain(args);
            }
            catch (Exception e) {
                this.httpServerException = e;
            }
        });
        this.httpServerThread.setName(ThriftServer.class.getSimpleName() + "-httpServer");
        this.httpServerThread.start();
    }

    @Test
    public void testRunThriftServerWithHeaderBufferLength() throws Exception {
        try {
            this.runThriftServer(64512);
        }
        catch (TTransportException tex) {
            Assert.assertFalse((boolean)tex.getMessage().equals("HTTP Response code: 431"));
        }
        this.exception.expect(TTransportException.class);
        this.exception.expectMessage("HTTP Response code: 431");
        this.runThriftServer(65536);
    }

    @Test
    public void testRunThriftServer() throws Exception {
        this.runThriftServer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runThriftServer(int customHeaderSize) throws Exception {
        ArrayList<String> args = new ArrayList<String>(3);
        this.port = HBaseTestingUtility.randomFreePort();
        args.add("-port");
        args.add(String.valueOf(this.port));
        args.add("-infoport");
        int infoPort = HBaseTestingUtility.randomFreePort();
        args.add(String.valueOf(infoPort));
        args.add("start");
        this.thriftServer = new ThriftServer(TEST_UTIL.getConfiguration());
        this.startHttpServerThread(args.toArray(new String[args.size()]));
        HBaseTestingUtility.waitForHostPort((String)"localhost", (int)this.port);
        String url = "http://localhost:" + this.port;
        try {
            this.checkHttpMethods(url);
            this.talkToThriftServer(url, customHeaderSize);
        }
        catch (Exception ex) {
            this.clientSideException = ex;
        }
        finally {
            this.stopHttpServerThread();
        }
        if (this.clientSideException != null) {
            LOG.error("Thrift client threw an exception " + this.clientSideException);
            if (this.clientSideException instanceof TTransportException) {
                throw this.clientSideException;
            }
            throw new Exception(this.clientSideException);
        }
    }

    private void checkHttpMethods(String url) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod("TRACE");
        conn.connect();
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void talkToThriftServer(String url, int customHeaderSize) throws Exception {
        THttpClient httpClient = new THttpClient(url);
        httpClient.open();
        if (customHeaderSize > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < customHeaderSize; ++i) {
                sb.append("a");
            }
            httpClient.setCustomHeader("User-Agent", sb.toString());
        }
        try {
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            if (!tableCreated) {
                TestThriftServer.createTestTables((Hbase.Iface)client);
                tableCreated = true;
            }
            TestThriftServer.checkTableList((Hbase.Iface)client);
        }
        finally {
            httpClient.close();
        }
    }

    private void stopHttpServerThread() throws Exception {
        LOG.debug("Stopping  Thrift HTTP server");
        this.thriftServer.stop();
        this.httpServerThread.join();
        if (this.httpServerException != null) {
            LOG.error("Command-line invocation of HBase Thrift server threw an exception", (Throwable)this.httpServerException);
            throw new Exception(this.httpServerException);
        }
    }
}

