/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.ImplType;
import org.apache.hadoop.hbase.thrift.TBoundedThreadPoolServer;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestThriftServerCmdLine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftServerCmdLine.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftServerCmdLine.class);
    protected final ImplType implType;
    protected boolean specifyFramed;
    protected boolean specifyBindIP;
    protected boolean specifyCompact;
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Thread cmdLineThread;
    private volatile Exception cmdLineException;
    private Exception clientSideException;
    private volatile ThriftServer thriftServer;
    protected int port;
    protected static volatile boolean tableCreated = false;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (ImplType implType : ImplType.values()) {
            for (boolean specifyFramed : new boolean[]{false, true}) {
                for (boolean specifyBindIP : new boolean[]{false, true}) {
                    if (specifyBindIP && !implType.canSpecifyBindIP) continue;
                    for (boolean specifyCompact : new boolean[]{false, true}) {
                        parameters.add(new Object[]{implType, specifyFramed, specifyBindIP, specifyCompact});
                    }
                }
            }
        }
        return parameters;
    }

    public TestThriftServerCmdLine(ImplType implType, boolean specifyFramed, boolean specifyBindIP, boolean specifyCompact) {
        this.implType = implType;
        this.specifyFramed = specifyFramed;
        this.specifyBindIP = specifyBindIP;
        this.specifyCompact = specifyCompact;
        LOG.debug(this.getParametersString());
    }

    private String getParametersString() {
        return "implType=" + this.implType + ", specifyFramed=" + this.specifyFramed + ", specifyBindIP=" + this.specifyBindIP + ", specifyCompact=" + this.specifyCompact;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TEST_UTIL.startMiniCluster();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    private void startCmdLineThread(final String[] args) {
        LOG.info("Starting HBase Thrift server with command line: " + Joiner.on((String)" ").join((Object[])args));
        this.cmdLineException = null;
        this.cmdLineThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestThriftServerCmdLine.this.thriftServer.run(args);
                }
                catch (Exception e) {
                    LOG.error("Error when start thrift server", (Throwable)e);
                    TestThriftServerCmdLine.this.cmdLineException = e;
                }
            }
        });
        this.cmdLineThread.setName(ThriftServer.class.getSimpleName() + "-cmdline");
        this.cmdLineThread.start();
    }

    protected ThriftServer createThriftServer() {
        return new ThriftServer(TEST_UTIL.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunThriftServer() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (this.implType != null) {
            String serverTypeOption = this.implType.toString();
            Assert.assertTrue((boolean)serverTypeOption.startsWith("-"));
            args.add(serverTypeOption);
        }
        this.port = HBaseTestingUtility.randomFreePort();
        args.add("-port");
        args.add(String.valueOf(this.port));
        args.add("-infoport");
        int infoPort = HBaseTestingUtility.randomFreePort();
        args.add(String.valueOf(infoPort));
        if (this.specifyFramed) {
            args.add("-framed");
        }
        if (this.specifyBindIP) {
            args.add("-bind");
            args.add(InetAddress.getLocalHost().getHostName());
        }
        if (this.specifyCompact) {
            args.add("-compact");
        }
        args.add("start");
        this.thriftServer = this.createThriftServer();
        this.startCmdLineThread(args.toArray(new String[args.size()]));
        for (int i = 0; i < 100 && this.thriftServer.tserver == null; ++i) {
            Thread.sleep(100L);
        }
        Class expectedClass = this.implType != null ? this.implType.serverClass : TBoundedThreadPoolServer.class;
        Assert.assertEquals((Object)expectedClass, this.thriftServer.tserver.getClass());
        try {
            this.talkToThriftServer();
        }
        catch (Exception ex) {
            this.clientSideException = ex;
        }
        finally {
            this.stopCmdLineThread();
        }
        if (this.clientSideException != null) {
            LOG.error("Thrift client threw an exception. Parameters:" + this.getParametersString(), (Throwable)this.clientSideException);
            throw new Exception(this.clientSideException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void talkToThriftServer() throws Exception {
        TSocket sock;
        TSocket transport = sock = new TSocket(InetAddress.getLocalHost().getHostName(), this.port);
        if (this.specifyFramed || this.implType.isAlwaysFramed) {
            transport = new TFramedTransport((TTransport)transport);
        }
        sock.open();
        try {
            Object prot = this.specifyCompact ? new TCompactProtocol((TTransport)transport) : new TBinaryProtocol((TTransport)transport);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            if (!tableCreated) {
                TestThriftServer.createTestTables((Hbase.Iface)client);
                tableCreated = true;
            }
            TestThriftServer.checkTableList((Hbase.Iface)client);
        }
        finally {
            sock.close();
        }
    }

    private void stopCmdLineThread() throws Exception {
        LOG.debug("Stopping " + this.implType.simpleClassName() + " Thrift server");
        this.thriftServer.stop();
        this.cmdLineThread.join();
        if (this.cmdLineException != null) {
            LOG.error("Command-line invocation of HBase Thrift server threw an exception", (Throwable)this.cmdLineException);
            throw new Exception(this.cmdLineException);
        }
    }
}

