/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.thrift.TestThriftHttpServer;
import org.apache.hadoop.hbase.thrift2.ThriftServer;
import org.apache.hadoop.hbase.thrift2.generated.TColumnFamilyDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TTableDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TTableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestThrift2HttpServer
extends TestThriftHttpServer {
    private static final String TABLENAME = "TestThrift2HttpServerTable";
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThrift2HttpServer.class);

    protected ThriftServer createThriftServer() {
        return new ThriftServer(TEST_UTIL.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void talkToThriftServer(String url, int customHeaderSize) throws Exception {
        THttpClient httpClient = new THttpClient(url);
        httpClient.open();
        if (customHeaderSize > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < customHeaderSize; ++i) {
                sb.append("a");
            }
            httpClient.setCustomHeader("User-Agent", sb.toString());
        }
        try {
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
            THBaseService.Client client = new THBaseService.Client((TProtocol)prot);
            TTableName tTableName = new TTableName();
            tTableName.setNs(Bytes.toBytes((String)""));
            tTableName.setQualifier(Bytes.toBytes((String)TABLENAME));
            if (!tableCreated) {
                Assert.assertTrue((!client.tableExists(tTableName) ? 1 : 0) != 0);
                TTableDescriptor tTableDescriptor = new TTableDescriptor();
                tTableDescriptor.setTableName(tTableName);
                TColumnFamilyDescriptor columnFamilyDescriptor = new TColumnFamilyDescriptor();
                columnFamilyDescriptor.setName(Bytes.toBytes((String)TABLENAME));
                tTableDescriptor.addToColumns(columnFamilyDescriptor);
                client.createTable(tTableDescriptor, new ArrayList());
                tableCreated = true;
            }
            Assert.assertTrue((boolean)client.tableExists(tTableName));
        }
        finally {
            httpClient.close();
        }
    }
}

