/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TAuthorization;
import org.apache.hadoop.hbase.thrift2.generated.TCellVisibility;
import org.apache.hadoop.hbase.thrift2.generated.TColumn;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.TIllegalArgument;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, MediumTests.class})
public class TestThriftHBaseServiceHandlerWithLabels {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftHBaseServiceHandlerWithLabels.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftHBaseServiceHandlerWithLabels.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] tableAname = Bytes.toBytes((String)"tableA");
    private static byte[] familyAname = Bytes.toBytes((String)"familyA");
    private static byte[] familyBname = Bytes.toBytes((String)"familyB");
    private static byte[] qualifierAname = Bytes.toBytes((String)"qualifierA");
    private static byte[] qualifierBname = Bytes.toBytes((String)"qualifierB");
    private static byte[] valueAname = Bytes.toBytes((String)"valueA");
    private static byte[] valueBname = Bytes.toBytes((String)"valueB");
    private static HColumnDescriptor[] families = new HColumnDescriptor[]{new HColumnDescriptor(familyAname).setMaxVersions(3), new HColumnDescriptor(familyBname).setMaxVersions(2)};
    private static final String TOPSECRET = "topsecret";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    private static User SUPERUSER;
    private static Configuration conf;

    public void assertTColumnValuesEqual(List<TColumnValue> columnValuesA, List<TColumnValue> columnValuesB) {
        Assert.assertEquals((long)columnValuesA.size(), (long)columnValuesB.size());
        Comparator<TColumnValue> comparator = new Comparator<TColumnValue>(){

            @Override
            public int compare(TColumnValue o1, TColumnValue o2) {
                return Bytes.compareTo((byte[])Bytes.add((byte[])o1.getFamily(), (byte[])o1.getQualifier()), (byte[])Bytes.add((byte[])o2.getFamily(), (byte[])o2.getQualifier()));
            }
        };
        Collections.sort(columnValuesA, comparator);
        Collections.sort(columnValuesB, comparator);
        for (int i = 0; i < columnValuesA.size(); ++i) {
            TColumnValue a = columnValuesA.get(i);
            TColumnValue b = columnValuesB.get(i);
            Assert.assertArrayEquals((byte[])a.getFamily(), (byte[])b.getFamily());
            Assert.assertArrayEquals((byte[])a.getQualifier(), (byte[])b.getQualifier());
            Assert.assertArrayEquals((byte[])a.getValue(), (byte[])b.getValue());
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        conf = UTIL.getConfiguration();
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", SUPERUSER.getShortName());
        VisibilityTestUtil.enableVisiblityLabels((Configuration)conf);
        UTIL.startMiniCluster(1);
        UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestThriftHBaseServiceHandlerWithLabels.createLabels();
        Admin admin = UTIL.getAdmin();
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((byte[])tableAname));
        for (HColumnDescriptor family : families) {
            tableDescriptor.addFamily(family);
        }
        admin.createTable((TableDescriptor)tableDescriptor);
        admin.close();
        TestThriftHBaseServiceHandlerWithLabels.setAuths();
    }

    private static void createLabels() throws IOException, InterruptedException {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestThriftHBaseServiceHandlerWithLabels.SECRET, TestThriftHBaseServiceHandlerWithLabels.CONFIDENTIAL, TestThriftHBaseServiceHandlerWithLabels.PRIVATE, TestThriftHBaseServiceHandlerWithLabels.PUBLIC, TestThriftHBaseServiceHandlerWithLabels.TOPSECRET};
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.addLabels((Connection)conn, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    private static void setAuths() throws IOException {
        String[] labels = new String[]{SECRET, CONFIDENTIAL, PRIVATE, PUBLIC, TOPSECRET};
        try {
            VisibilityClient.setAuths((Connection)UTIL.getConnection(), (String[])labels, (String)User.getCurrent().getShortName());
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
    }

    private ThriftHBaseServiceHandler createHandler() throws IOException {
        return new ThriftHBaseServiceHandler(conf, UserProvider.instantiate((Configuration)conf));
    }

    @Test
    public void testScanWithVisibilityLabels() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testScan" + i))), columnValues);
            if (i == 5) {
                put.setCellVisibility(new TCellVisibility().setExpression(PUBLIC));
            } else {
                put.setCellVisibility(new TCellVisibility().setExpression("(secret|confidential)&!topsecret"));
            }
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>(1);
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow(Bytes.toBytes((String)"testScan"));
        scan.setStopRow(Bytes.toBytes((String)"testScan\uffff"));
        TAuthorization tauth = new TAuthorization();
        ArrayList<String> labels = new ArrayList<String>(2);
        labels.add(SECRET);
        labels.add(PRIVATE);
        tauth.setLabels(labels);
        scan.setAuthorizations(tauth);
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)9L, (long)results.size());
        Assert.assertFalse((boolean)Bytes.equals((byte[])((TResult)results.get(5)).getRow(), (byte[])Bytes.toBytes((String)"testScan5")));
        for (int i = 0; i < 9; ++i) {
            if (i < 5) {
                Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testScan" + i)), (byte[])((TResult)results.get(i)).getRow());
                continue;
            }
            if (i == 5) continue;
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testScan" + (i + 1))), (byte[])((TResult)results.get(i)).getRow());
        }
        results = handler.getScannerRows(scanId, 9);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 9);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testGetScannerResultsWithAuthorizations() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(columnValue);
        for (int i = 0; i < 20; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testGetScannerResults" + this.pad(i, (byte)2)))), columnValues);
            if (i == 3) {
                put.setCellVisibility(new TCellVisibility().setExpression(PUBLIC));
            } else {
                put.setCellVisibility(new TCellVisibility().setExpression("(secret|confidential)&!topsecret"));
            }
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>(1);
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow(Bytes.toBytes((String)"testGetScannerResults"));
        scan.setStopRow(Bytes.toBytes((String)"testGetScannerResults05"));
        TAuthorization tauth = new TAuthorization();
        ArrayList<String> labels = new ArrayList<String>(2);
        labels.add(SECRET);
        labels.add(PRIVATE);
        tauth.setLabels(labels);
        scan.setAuthorizations(tauth);
        List results = handler.getScannerResults(table, scan, 5);
        Assert.assertEquals((long)4L, (long)results.size());
        for (int i = 0; i < 4; ++i) {
            if (i < 3) {
                Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testGetScannerResults" + this.pad(i, (byte)2))), (byte[])((TResult)results.get(i)).getRow());
                continue;
            }
            if (i == 3) continue;
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testGetScannerResults" + this.pad(i + 1, (byte)2))), (byte[])((TResult)results.get(i)).getRow());
        }
    }

    @Test
    public void testGetsWithLabels() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testPutGet");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        put.setCellVisibility(new TCellVisibility().setExpression("(secret|confidential)&!topsecret"));
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TAuthorization tauth = new TAuthorization();
        ArrayList<String> labels = new ArrayList<String>(2);
        labels.add(SECRET);
        labels.add(PRIVATE);
        tauth.setLabels(labels);
        get.setAuthorizations(tauth);
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        this.assertTColumnValuesEqual(columnValues, returnedColumnValues);
    }

    @Test
    public void testIncrementWithTags() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testIncrementWithTags");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(Bytes.toBytes((long)1L))));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        put.setCellVisibility(new TCellVisibility().setExpression(PRIVATE));
        handler.put(table, put);
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>(1);
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TIncrement increment = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        increment.setCellVisibility(new TCellVisibility().setExpression(SECRET));
        handler.increment(table, increment);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TAuthorization tauth = new TAuthorization();
        ArrayList<String> labels = new ArrayList<String>(1);
        labels.add(SECRET);
        tauth.setLabels(labels);
        get.setAuthorizations(tauth);
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        TColumnValue columnValue = (TColumnValue)result.getColumnValues().get(0);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((long)2L), (byte[])columnValue.getValue());
    }

    @Test
    public void testIncrementWithTagsWithNotMatchLabels() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testIncrementWithTagsWithNotMatchLabels");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(Bytes.toBytes((long)1L))));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        put.setCellVisibility(new TCellVisibility().setExpression(PRIVATE));
        handler.put(table, put);
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>(1);
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TIncrement increment = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        increment.setCellVisibility(new TCellVisibility().setExpression(SECRET));
        handler.increment(table, increment);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TAuthorization tauth = new TAuthorization();
        ArrayList<String> labels = new ArrayList<String>(1);
        labels.add(PUBLIC);
        tauth.setLabels(labels);
        get.setAuthorizations(tauth);
        TResult result = handler.get(table, get);
        Assert.assertNull((Object)result.getRow());
    }

    @Test
    public void testAppend() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testAppend");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] v1 = Bytes.toBytes((long)1L);
        byte[] v2 = Bytes.toBytes((long)5L);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(Bytes.toBytes((long)1L))));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        put.setCellVisibility(new TCellVisibility().setExpression(PRIVATE));
        handler.put(table, put);
        ArrayList<TColumnValue> appendColumns = new ArrayList<TColumnValue>(1);
        appendColumns.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(v2)));
        TAppend append = new TAppend(ByteBuffer.wrap(rowName), appendColumns);
        append.setCellVisibility(new TCellVisibility().setExpression(SECRET));
        handler.append(table, append);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TAuthorization tauth = new TAuthorization();
        ArrayList<String> labels = new ArrayList<String>(1);
        labels.add(SECRET);
        tauth.setLabels(labels);
        get.setAuthorizations(tauth);
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        TColumnValue columnValue = (TColumnValue)result.getColumnValues().get(0);
        Assert.assertArrayEquals((byte[])Bytes.add((byte[])v1, (byte[])v2), (byte[])columnValue.getValue());
    }

    private String pad(int n, byte pad) {
        String res = Integer.toString(n);
        while (res.length() < pad) {
            res = "0" + res;
        }
        return res;
    }
}

