/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import ch.cern.hbase.thirdparty.com.google.common.collect.Lists;
import ch.cern.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.thrift.ErrorThrowingGetObserver;
import org.apache.hadoop.hbase.thrift.HbaseHandlerMetricsProxy;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.ThriftServer;
import org.apache.hadoop.hbase.thrift2.ThriftUtilities;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TColumn;
import org.apache.hadoop.hbase.thrift2.generated.TColumnFamilyDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TCompareOp;
import org.apache.hadoop.hbase.thrift2.generated.TConsistency;
import org.apache.hadoop.hbase.thrift2.generated.TDataBlockEncoding;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TDeleteType;
import org.apache.hadoop.hbase.thrift2.generated.TDurability;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;
import org.apache.hadoop.hbase.thrift2.generated.TIllegalArgument;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TMutation;
import org.apache.hadoop.hbase.thrift2.generated.TNamespaceDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TReadType;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.thrift2.generated.TTableDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TTableName;
import org.apache.hadoop.hbase.thrift2.generated.TTimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, MediumTests.class})
public class TestThriftHBaseServiceHandler {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftHBaseServiceHandler.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftHBaseServiceHandler.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] tableAname = Bytes.toBytes((String)"tableA");
    private static byte[] familyAname = Bytes.toBytes((String)"familyA");
    private static byte[] familyBname = Bytes.toBytes((String)"familyB");
    private static byte[] qualifierAname = Bytes.toBytes((String)"qualifierA");
    private static byte[] qualifierBname = Bytes.toBytes((String)"qualifierB");
    private static byte[] valueAname = Bytes.toBytes((String)"valueA");
    private static byte[] valueBname = Bytes.toBytes((String)"valueB");
    private static HColumnDescriptor[] families = new HColumnDescriptor[]{new HColumnDescriptor(familyAname).setMaxVersions(3), new HColumnDescriptor(familyBname).setMaxVersions(2)};
    private static final MetricsAssertHelper metricsHelper = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    @Rule
    public TestName name = new TestName();

    public void assertTColumnValuesEqual(List<TColumnValue> columnValuesA, List<TColumnValue> columnValuesB) {
        Assert.assertEquals((long)columnValuesA.size(), (long)columnValuesB.size());
        Comparator<TColumnValue> comparator = new Comparator<TColumnValue>(){

            @Override
            public int compare(TColumnValue o1, TColumnValue o2) {
                return Bytes.compareTo((byte[])Bytes.add((byte[])o1.getFamily(), (byte[])o1.getQualifier()), (byte[])Bytes.add((byte[])o2.getFamily(), (byte[])o2.getQualifier()));
            }
        };
        Collections.sort(columnValuesA, comparator);
        Collections.sort(columnValuesB, comparator);
        for (int i = 0; i < columnValuesA.size(); ++i) {
            TColumnValue a = columnValuesA.get(i);
            TColumnValue b = columnValuesB.get(i);
            this.assertTColumnValueEqual(a, b);
        }
    }

    public void assertTColumnValueEqual(TColumnValue a, TColumnValue b) {
        Assert.assertArrayEquals((byte[])a.getFamily(), (byte[])b.getFamily());
        Assert.assertArrayEquals((byte[])a.getQualifier(), (byte[])b.getQualifier());
        Assert.assertArrayEquals((byte[])a.getValue(), (byte[])b.getValue());
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().set("hbase.client.retries.number", "3");
        UTIL.startMiniCluster();
        Admin admin = UTIL.getAdmin();
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((byte[])tableAname));
        for (HColumnDescriptor family : families) {
            tableDescriptor.addFamily(family);
        }
        admin.createTable((TableDescriptor)tableDescriptor);
        admin.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
    }

    private ThriftHBaseServiceHandler createHandler() throws TException {
        try {
            Configuration conf = UTIL.getConfiguration();
            return new ThriftHBaseServiceHandler(conf, UserProvider.instantiate((Configuration)conf));
        }
        catch (IOException ie) {
            throw new TException((Throwable)ie);
        }
    }

    @Test
    public void testExists() throws TIOError, TException {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testExists");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.exists(table, get));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        Assert.assertTrue((boolean)handler.exists(table, get));
    }

    @Test
    public void testExistsAll() throws TIOError, TException {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName1 = Bytes.toBytes((String)"testExistsAll1");
        byte[] rowName2 = Bytes.toBytes((String)"testExistsAll2");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TGet> gets = new ArrayList<TGet>();
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        List existsResult1 = handler.existsAll(table, gets);
        Assert.assertFalse((boolean)((Boolean)existsResult1.get(0)));
        Assert.assertFalse((boolean)((Boolean)existsResult1.get(1)));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>();
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        handler.putMultiple(table, puts);
        List existsResult2 = handler.existsAll(table, gets);
        Assert.assertTrue((boolean)((Boolean)existsResult2.get(0)));
        Assert.assertTrue((boolean)((Boolean)existsResult2.get(1)));
    }

    @Test
    public void testPutGet() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testPutGet");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        this.assertTColumnValuesEqual(columnValues, returnedColumnValues);
    }

    @Test
    public void testPutGetMultiple() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = Bytes.toBytes((String)"testPutGetMultiple1");
        byte[] rowName2 = Bytes.toBytes((String)"testPutGetMultiple2");
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>(2);
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        handler.putMultiple(table, puts);
        ArrayList<TGet> gets = new ArrayList<TGet>(2);
        gets.add(new TGet(ByteBuffer.wrap(rowName1)));
        gets.add(new TGet(ByteBuffer.wrap(rowName2)));
        List results = handler.getMultiple(table, gets);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertArrayEquals((byte[])rowName1, (byte[])((TResult)results.get(0)).getRow());
        this.assertTColumnValuesEqual(columnValues, ((TResult)results.get(0)).getColumnValues());
        Assert.assertArrayEquals((byte[])rowName2, (byte[])((TResult)results.get(1)).getRow());
        this.assertTColumnValuesEqual(columnValues, ((TResult)results.get(1)).getColumnValues());
    }

    @Test
    public void testDeleteMultiple() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] rowName1 = Bytes.toBytes((String)"testDeleteMultiple1");
        byte[] rowName2 = Bytes.toBytes((String)"testDeleteMultiple2");
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        ArrayList<TPut> puts = new ArrayList<TPut>(2);
        puts.add(new TPut(ByteBuffer.wrap(rowName1), columnValues));
        puts.add(new TPut(ByteBuffer.wrap(rowName2), columnValues));
        handler.putMultiple(table, puts);
        ArrayList<TDelete> deletes = new ArrayList<TDelete>(2);
        deletes.add(new TDelete(ByteBuffer.wrap(rowName1)));
        deletes.add(new TDelete(ByteBuffer.wrap(rowName2)));
        List deleteResults = handler.deleteMultiple(table, deletes);
        Assert.assertEquals((long)0L, (long)deleteResults.size());
        Assert.assertFalse((boolean)handler.exists(table, new TGet(ByteBuffer.wrap(rowName1))));
        Assert.assertFalse((boolean)handler.exists(table, new TGet(ByteBuffer.wrap(rowName2))));
    }

    @Test
    public void testDelete() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testDelete");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValues.add(columnValueA);
        columnValues.add(columnValueB);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>(1);
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        handler.deleteSingle(table, delete);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        ArrayList<TColumnValue> expectedColumnValues = new ArrayList<TColumnValue>(1);
        expectedColumnValues.add(columnValueB);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
    }

    @Test
    public void testDeleteAllTimestamps() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testDeleteAllTimestamps");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValueA.setTimestamp(System.currentTimeMillis() - 10L);
        columnValues.add(columnValueA);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        columnValueA.setTimestamp(System.currentTimeMillis());
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        get.setMaxVersions(2);
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>(1);
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        delete.setDeleteType(TDeleteType.DELETE_COLUMNS);
        handler.deleteSingle(table, delete);
        get = new TGet(ByteBuffer.wrap(rowName));
        result = handler.get(table, get);
        Assert.assertNull((Object)result.getRow());
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
    }

    @Test
    public void testDeleteSingleTimestamp() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testDeleteSingleTimestamp");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        long timestamp1 = System.currentTimeMillis() - 10L;
        long timestamp2 = System.currentTimeMillis();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValueA.setTimestamp(timestamp1);
        columnValues.add(columnValueA);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        columnValueA.setTimestamp(timestamp2);
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        get.setMaxVersions(2);
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>(1);
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        delete.setDeleteType(TDeleteType.DELETE_COLUMN);
        handler.deleteSingle(table, delete);
        get = new TGet(ByteBuffer.wrap(rowName));
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        Assert.assertEquals((long)timestamp1, (long)((TColumnValue)result.getColumnValues().get(0)).getTimestamp());
    }

    @Test
    public void testDeleteFamily() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testDeleteFamily");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        long timestamp1 = System.currentTimeMillis() - 10L;
        long timestamp2 = System.currentTimeMillis();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValueA.setTimestamp(timestamp1);
        columnValues.add(columnValueA);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        columnValueA.setTimestamp(timestamp2);
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        get.setMaxVersions(2);
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        delete.setDeleteType(TDeleteType.DELETE_FAMILY);
        handler.deleteSingle(table, delete);
        get = new TGet(ByteBuffer.wrap(rowName));
        result = handler.get(table, get);
        Assert.assertArrayEquals(null, (byte[])result.getRow());
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
    }

    @Test
    public void testDeleteFamilyVersion() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testDeleteFamilyVersion");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        long timestamp1 = System.currentTimeMillis() - 10L;
        long timestamp2 = System.currentTimeMillis();
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValueA.setTimestamp(timestamp1);
        columnValues.add(columnValueA);
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        columnValueA.setTimestamp(timestamp2);
        handler.put(table, put);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        get.setMaxVersions(2);
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>();
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setTimestamp(timestamp1);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        delete.setDeleteType(TDeleteType.DELETE_FAMILY_VERSION);
        handler.deleteSingle(table, delete);
        get = new TGet(ByteBuffer.wrap(rowName));
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        Assert.assertEquals((long)timestamp2, (long)((TColumnValue)result.getColumnValues().get(0)).getTimestamp());
    }

    @Test
    public void testIncrement() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testIncrement");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(Bytes.toBytes((long)1L))));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>(1);
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TIncrement increment = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        handler.increment(table, increment);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        TColumnValue columnValue = (TColumnValue)result.getColumnValues().get(0);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((long)2L), (byte[])columnValue.getValue());
    }

    @Test
    public void testAppend() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testAppend");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        byte[] v1 = Bytes.toBytes((String)"42");
        byte[] v2 = Bytes.toBytes((String)"23");
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(v1)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        ArrayList<TColumnValue> appendColumns = new ArrayList<TColumnValue>(1);
        appendColumns.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(v2)));
        TAppend append = new TAppend(ByteBuffer.wrap(rowName), appendColumns);
        handler.append(table, append);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        TColumnValue columnValue = (TColumnValue)result.getColumnValues().get(0);
        Assert.assertArrayEquals((byte[])Bytes.add((byte[])v1, (byte[])v2), (byte[])columnValue.getValue());
    }

    @Test
    public void testCheckAndPut() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testCheckAndPut");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        Assert.assertFalse((boolean)handler.checkAndPut(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), putB));
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
        handler.put(table, putA);
        Assert.assertTrue((boolean)handler.checkAndPut(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), putB));
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        ArrayList<TColumnValue> expectedColumnValues = new ArrayList<TColumnValue>(2);
        expectedColumnValues.add(columnValueA);
        expectedColumnValues.add(columnValueB);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
    }

    @Test
    public void testCheckAndDelete() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testCheckAndDelete");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        handler.put(table, putB);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.checkAndDelete(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), delete));
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        this.assertTColumnValuesEqual(columnValuesB, result.getColumnValues());
        handler.put(table, putA);
        Assert.assertTrue((boolean)handler.checkAndDelete(table, ByteBuffer.wrap(rowName), ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname), delete));
        result = handler.get(table, get);
        Assert.assertFalse((boolean)result.isSetRow());
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
    }

    @Test
    public void testScan() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testScan" + i))), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>(1);
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow(Bytes.toBytes((String)"testScan"));
        scan.setStopRow(Bytes.toBytes((String)"testScan\uffff"));
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testScan" + i)), (byte[])((TResult)results.get(i)).getRow());
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testLongLivedScan() throws Exception {
        int numTrials = 6;
        int trialPause = 1000;
        int cleanUpInterval = 100;
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setInt("hbase.thrift.connection.max-idletime", numTrials / 2 * trialPause);
        conf.setInt("hbase.thrift.connection.cleanup-interval", cleanUpInterval);
        ThriftHBaseServiceHandler handler = new ThriftHBaseServiceHandler(conf, UserProvider.instantiate((Configuration)conf));
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(columnValue);
        for (int i = 0; i < numTrials; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testScan" + i))), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>(1);
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow(Bytes.toBytes((String)"testScan"));
        scan.setStopRow(Bytes.toBytes((String)"testScan\uffff"));
        scan.setCaching(1);
        int scanId = handler.openScanner(table, scan);
        for (int i = 0; i < numTrials; ++i) {
            List results = handler.getScannerRows(scanId, 1);
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testScan" + i)), (byte[])((TResult)results.get(0)).getRow());
            Thread.sleep(trialPause);
        }
    }

    @Test
    public void testReverseScan() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testReverseScan" + i))), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        scan.setReversed(true);
        ArrayList<TColumn> columns = new ArrayList<TColumn>(1);
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow(Bytes.toBytes((String)"testReverseScan\uffff"));
        scan.setStopRow(Bytes.toBytes((String)"testReverseScan"));
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testReverseScan" + (9 - i))), (byte[])((TResult)results.get(i)).getRow());
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testScanWithFilter() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testScanWithFilter" + i))), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>(1);
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow(Bytes.toBytes((String)"testScanWithFilter"));
        scan.setStopRow(Bytes.toBytes((String)"testScanWithFilter\uffff"));
        scan.setFilterString(ByteBuffer.wrap(Bytes.toBytes((String)"KeyOnlyFilter()")));
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testScanWithFilter" + i)), (byte[])((TResult)results.get(i)).getRow());
            Assert.assertEquals((long)0L, (long)((TColumnValue)((TResult)results.get(i)).getColumnValues().get(0)).getValue().length);
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testScanWithColumnFamilyTimeRange() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue familyAColumnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        TColumnValue familyBColumnValue = new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        long minTimestamp = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            familyAColumnValue.setTimestamp(minTimestamp + (long)i);
            familyBColumnValue.setTimestamp(minTimestamp + (long)i);
            ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
            columnValues.add(familyAColumnValue);
            columnValues.add(familyBColumnValue);
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testScanWithColumnFamilyTimeRange" + i))), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        HashMap<ByteBuffer, TTimeRange> colFamTimeRangeMap = new HashMap<ByteBuffer, TTimeRange>(2);
        colFamTimeRangeMap.put(ByteBuffer.wrap(familyAname), new TTimeRange(minTimestamp + 3L, minTimestamp + 5L));
        colFamTimeRangeMap.put(ByteBuffer.wrap(familyBname), new TTimeRange(minTimestamp + 6L, minTimestamp + 9L));
        scan.setColFamTimeRangeMap(colFamTimeRangeMap);
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 5);
        Assert.assertEquals((long)5L, (long)results.size());
        int familyACount = 0;
        int familyBCount = 0;
        for (TResult result : results) {
            List columnValues = result.getColumnValues();
            if (!CollectionUtils.isNotEmpty((Collection)columnValues)) continue;
            if (Bytes.equals((byte[])familyAname, (byte[])((TColumnValue)columnValues.get(0)).getFamily())) {
                ++familyACount;
                continue;
            }
            if (!Bytes.equals((byte[])familyBname, (byte[])((TColumnValue)columnValues.get(0)).getFamily())) continue;
            ++familyBCount;
        }
        Assert.assertEquals((long)2L, (long)familyACount);
        Assert.assertEquals((long)3L, (long)familyBCount);
        results = handler.getScannerRows(scanId, 1);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 1);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testSmallScan() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        columnValues.add(columnValue);
        for (int i = 0; i < 10; ++i) {
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testSmallScan" + i))), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        scan.setStartRow(Bytes.toBytes((String)"testSmallScan"));
        scan.setStopRow(Bytes.toBytes((String)"testSmallScan\uffff"));
        scan.setReadType(TReadType.PREAD);
        scan.setCaching(2);
        int scanId = handler.openScanner(table, scan);
        List results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testSmallScan" + i)), (byte[])((TResult)results.get(i)).getRow());
        }
        results = handler.getScannerRows(scanId, 10);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 10);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testPutTTL() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testPutTTL");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(Bytes.toBytes((long)1L))));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        HashMap<ByteBuffer, ByteBuffer> attributes = new HashMap<ByteBuffer, ByteBuffer>();
        long ttlTimeMs = 2000L;
        attributes.put(ByteBuffer.wrap(Bytes.toBytes((String)"_ttl")), ByteBuffer.wrap(Bytes.toBytes((long)ttlTimeMs)));
        put.setAttributes(attributes);
        handler.put(table, put);
        TGet getOne = new TGet(ByteBuffer.wrap(rowName));
        TResult resultOne = handler.get(table, getOne);
        Assert.assertArrayEquals((byte[])rowName, (byte[])resultOne.getRow());
        Assert.assertEquals((long)1L, (long)resultOne.getColumnValuesSize());
        Thread.sleep(ttlTimeMs * 15L);
        TGet getTwo = new TGet(ByteBuffer.wrap(rowName));
        TResult resultTwo = handler.get(table, getTwo);
        Assert.assertNull((Object)resultTwo.getRow());
        Assert.assertEquals((long)0L, (long)resultTwo.getColumnValuesSize());
    }

    private String pad(int n, byte pad) {
        String res = Integer.toString(n);
        while (res.length() < pad) {
            res = "0" + res;
        }
        return res;
    }

    @Test
    public void testScanWithBatchSize() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(100);
        for (int i = 0; i < 100; ++i) {
            String colNum = this.pad(i, (byte)3);
            TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(Bytes.toBytes((String)("col" + colNum))), ByteBuffer.wrap(Bytes.toBytes((String)("val" + colNum))));
            columnValues.add(columnValue);
        }
        TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)"testScanWithBatchSize")), columnValues);
        handler.put(table, put);
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>(1);
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow(Bytes.toBytes((String)"testScanWithBatchSize"));
        scan.setStopRow(Bytes.toBytes((String)"testScanWithBatchSize\uffff"));
        scan.setBatchSize(10);
        int scanId = handler.openScanner(table, scan);
        List results = null;
        for (int i = 0; i < 10; ++i) {
            results = handler.getScannerRows(scanId, 1);
            Assert.assertEquals((long)1L, (long)results.size());
            List cols = ((TResult)results.get(0)).getColumnValues();
            Assert.assertEquals((long)10L, (long)cols.size());
            for (int y = 0; y < 10; ++y) {
                int colNum = y + 10 * i;
                String colNumPad = this.pad(colNum, (byte)3);
                Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("col" + colNumPad)), (byte[])((TColumnValue)cols.get(y)).getQualifier());
            }
        }
        results = handler.getScannerRows(scanId, 1);
        Assert.assertEquals((long)0L, (long)results.size());
        handler.closeScanner(scanId);
        try {
            handler.getScannerRows(scanId, 1);
            Assert.fail((String)"Scanner id should be invalid");
        }
        catch (TIllegalArgument tIllegalArgument) {
            // empty catch block
        }
    }

    @Test
    public void testGetScannerResults() throws Exception {
        int i;
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TColumnValue columnValue = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(columnValue);
        for (int i2 = 0; i2 < 20; ++i2) {
            TPut put = new TPut(ByteBuffer.wrap(Bytes.toBytes((String)("testGetScannerResults" + this.pad(i2, (byte)2)))), columnValues);
            handler.put(table, put);
        }
        TScan scan = new TScan();
        ArrayList<TColumn> columns = new ArrayList<TColumn>(1);
        TColumn column = new TColumn();
        column.setFamily(familyAname);
        column.setQualifier(qualifierAname);
        columns.add(column);
        scan.setColumns(columns);
        scan.setStartRow(Bytes.toBytes((String)"testGetScannerResults"));
        scan.setStopRow(Bytes.toBytes((String)"testGetScannerResults05"));
        List results = handler.getScannerResults(table, scan, 5);
        Assert.assertEquals((long)5L, (long)results.size());
        for (i = 0; i < 5; ++i) {
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testGetScannerResults" + this.pad(i, (byte)2))), (byte[])((TResult)results.get(i)).getRow());
        }
        scan.setStopRow(Bytes.toBytes((String)"testGetScannerResults10"));
        results = handler.getScannerResults(table, scan, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testGetScannerResults" + this.pad(i, (byte)2))), (byte[])((TResult)results.get(i)).getRow());
        }
        scan.setStopRow(Bytes.toBytes((String)"testGetScannerResults20"));
        results = handler.getScannerResults(table, scan, 20);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testGetScannerResults" + this.pad(i, (byte)2))), (byte[])((TResult)results.get(i)).getRow());
        }
        scan = new TScan();
        scan.setColumns(columns);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"testGetScannerResults20"));
        scan.setStopRow(Bytes.toBytes((String)"testGetScannerResults"));
        results = handler.getScannerResults(table, scan, 20);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)("testGetScannerResults" + this.pad(19 - i, (byte)2))), (byte[])((TResult)results.get(i)).getRow());
        }
    }

    @Test
    public void testFilterRegistration() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.thrift.filters", "MyFilter:filterclass");
        ThriftServer.registerFilters((Configuration)conf);
        Map registeredFilters = ParseFilter.getAllFilters();
        Assert.assertEquals((Object)"filterclass", registeredFilters.get("MyFilter"));
    }

    @Test
    public void testMetrics() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        ThriftMetrics metrics = TestThriftHBaseServiceHandler.getMetrics(conf);
        ThriftHBaseServiceHandler hbaseHandler = this.createHandler();
        THBaseService.Iface handler = HbaseHandlerMetricsProxy.newInstance((THBaseService.Iface)hbaseHandler, (ThriftMetrics)metrics, (Configuration)conf);
        byte[] rowName = Bytes.toBytes((String)"testMetrics");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        Assert.assertFalse((boolean)handler.exists(table, get));
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(2);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyBname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname)));
        TPut put = new TPut(ByteBuffer.wrap(rowName), columnValues);
        put.setColumnValues(columnValues);
        handler.put(table, put);
        Assert.assertTrue((boolean)handler.exists(table, get));
        metricsHelper.assertCounter("put_num_ops", 1L, (BaseSource)metrics.getSource());
        metricsHelper.assertCounter("exists_num_ops", 2L, (BaseSource)metrics.getSource());
    }

    private static ThriftMetrics getMetrics(Configuration conf) throws Exception {
        ThriftMetrics m = new ThriftMetrics(conf, ThriftMetrics.ThriftServerType.TWO);
        m.getSource().init();
        return m;
    }

    @Test
    public void testMetricsWithException() throws Exception {
        byte[] rowkey = Bytes.toBytes((String)"row1");
        byte[] family = Bytes.toBytes((String)"f");
        byte[] col = Bytes.toBytes((String)"c");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        tableDesc.addCoprocessor(ErrorThrowingGetObserver.class.getName());
        tableDesc.addFamily(new HColumnDescriptor(family));
        Table table = UTIL.createTable((TableDescriptor)tableDesc, (byte[][])null);
        table.put(new Put(rowkey).addColumn(family, col, Bytes.toBytes((String)"val1")));
        ThriftHBaseServiceHandler hbaseHandler = this.createHandler();
        ThriftMetrics metrics = TestThriftHBaseServiceHandler.getMetrics(UTIL.getConfiguration());
        THBaseService.Iface handler = HbaseHandlerMetricsProxy.newInstance((THBaseService.Iface)hbaseHandler, (ThriftMetrics)metrics, null);
        ByteBuffer tTableName = ByteBuffer.wrap(tableName.getName());
        long preGetCounter = metricsHelper.checkCounterExists("get_num_ops", (BaseSource)metrics.getSource()) ? metricsHelper.getCounter("get_num_ops", (BaseSource)metrics.getSource()) : 0L;
        TGet tGet = new TGet(ByteBuffer.wrap(rowkey));
        TResult tResult = handler.get(tTableName, tGet);
        ArrayList expectedColumnValues = Lists.newArrayList((Object[])new TColumnValue[]{new TColumnValue(ByteBuffer.wrap(family), ByteBuffer.wrap(col), ByteBuffer.wrap(Bytes.toBytes((String)"val1")))});
        Assert.assertArrayEquals((byte[])rowkey, (byte[])tResult.getRow());
        List returnedColumnValues = tResult.getColumnValues();
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
        metricsHelper.assertCounter("get_num_ops", preGetCounter + 1L, (BaseSource)metrics.getSource());
        for (ErrorThrowingGetObserver.ErrorType type : ErrorThrowingGetObserver.ErrorType.values()) {
            this.testExceptionType(handler, metrics, tTableName, rowkey, type);
        }
    }

    private void testExceptionType(THBaseService.Iface handler, ThriftMetrics metrics, ByteBuffer tTableName, byte[] rowkey, ErrorThrowingGetObserver.ErrorType errorType) {
        long preGetCounter = metricsHelper.getCounter("get_num_ops", (BaseSource)metrics.getSource());
        String exceptionKey = errorType.getMetricName();
        long preExceptionCounter = metricsHelper.checkCounterExists(exceptionKey, (BaseSource)metrics.getSource()) ? metricsHelper.getCounter(exceptionKey, (BaseSource)metrics.getSource()) : 0L;
        TGet tGet = new TGet(ByteBuffer.wrap(rowkey));
        HashMap<ByteBuffer, ByteBuffer> attributes = new HashMap<ByteBuffer, ByteBuffer>();
        attributes.put(ByteBuffer.wrap(Bytes.toBytes((String)"error")), ByteBuffer.wrap(Bytes.toBytes((String)errorType.name())));
        tGet.setAttributes(attributes);
        try {
            TResult tResult = handler.get(tTableName, tGet);
            Assert.fail((String)"Get with error attribute should have thrown an exception");
        }
        catch (TException e) {
            LOG.info("Received exception: ", (Throwable)e);
            metricsHelper.assertCounter("get_num_ops", preGetCounter + 1L, (BaseSource)metrics.getSource());
            metricsHelper.assertCounter(exceptionKey, preExceptionCounter + 1L, (BaseSource)metrics.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsPrecision() throws Exception {
        byte[] rowkey = Bytes.toBytes((String)"row1");
        byte[] family = Bytes.toBytes((String)"f");
        byte[] col = Bytes.toBytes((String)"c");
        TableName tableName = TableName.valueOf((String)"testMetricsPrecision");
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        tableDesc.addCoprocessor(DelayingRegionObserver.class.getName());
        tableDesc.addFamily(new HColumnDescriptor(family));
        Table table = null;
        try {
            table = UTIL.createTable((TableDescriptor)tableDesc, (byte[][])null);
            table.put(new Put(rowkey).addColumn(family, col, Bytes.toBytes((String)"val1")));
            ThriftHBaseServiceHandler hbaseHandler = this.createHandler();
            ThriftMetrics metrics = TestThriftHBaseServiceHandler.getMetrics(UTIL.getConfiguration());
            THBaseService.Iface handler = HbaseHandlerMetricsProxy.newInstance((THBaseService.Iface)hbaseHandler, (ThriftMetrics)metrics, null);
            ByteBuffer tTableName = ByteBuffer.wrap(tableName.getName());
            TGet tGet = new TGet(ByteBuffer.wrap(rowkey));
            TResult tResult = handler.get(tTableName, tGet);
            ArrayList expectedColumnValues = Lists.newArrayList((Object[])new TColumnValue[]{new TColumnValue(ByteBuffer.wrap(family), ByteBuffer.wrap(col), ByteBuffer.wrap(Bytes.toBytes((String)"val1")))});
            Assert.assertArrayEquals((byte[])rowkey, (byte[])tResult.getRow());
            List returnedColumnValues = tResult.getColumnValues();
            this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
            metricsHelper.assertGaugeGt("get_max", 3000L, (BaseSource)metrics.getSource());
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
                UTIL.deleteTable(tableName);
            }
        }
    }

    @Test
    public void testAttribute() throws Exception {
        byte[] rowName = Bytes.toBytes((String)"testAttribute");
        byte[] attributeKey = Bytes.toBytes((String)"attribute1");
        byte[] attributeValue = Bytes.toBytes((String)"value1");
        HashMap<ByteBuffer, ByteBuffer> attributes = new HashMap<ByteBuffer, ByteBuffer>();
        attributes.put(ByteBuffer.wrap(attributeKey), ByteBuffer.wrap(attributeValue));
        TGet tGet = new TGet(ByteBuffer.wrap(rowName));
        tGet.setAttributes(attributes);
        Get get = ThriftUtilities.getFromThrift((TGet)tGet);
        Assert.assertArrayEquals((byte[])get.getAttribute("attribute1"), (byte[])attributeValue);
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        TPut tPut = new TPut(ByteBuffer.wrap(rowName), columnValues);
        tPut.setAttributes(attributes);
        Put put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertArrayEquals((byte[])put.getAttribute("attribute1"), (byte[])attributeValue);
        TScan tScan = new TScan();
        tScan.setAttributes(attributes);
        Scan scan = ThriftUtilities.scanFromThrift((TScan)tScan);
        Assert.assertArrayEquals((byte[])scan.getAttribute("attribute1"), (byte[])attributeValue);
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>(1);
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TIncrement tIncrement = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        tIncrement.setAttributes(attributes);
        Increment increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertArrayEquals((byte[])increment.getAttribute("attribute1"), (byte[])attributeValue);
        TDelete tDelete = new TDelete(ByteBuffer.wrap(rowName));
        tDelete.setAttributes(attributes);
        Delete delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertArrayEquals((byte[])delete.getAttribute("attribute1"), (byte[])attributeValue);
    }

    @Test
    public void testMutateRow() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        byte[] rowName = Bytes.toBytes((String)"testMutateRow");
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueA = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname));
        columnValuesA.add(columnValueA);
        TPut putA = new TPut(ByteBuffer.wrap(rowName), columnValuesA);
        putA.setColumnValues(columnValuesA);
        handler.put(table, putA);
        TGet get = new TGet(ByteBuffer.wrap(rowName));
        TResult result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        List returnedColumnValues = result.getColumnValues();
        ArrayList<Object> expectedColumnValues = new ArrayList<TColumnValue>(1);
        expectedColumnValues.add(columnValueA);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueB = new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(ByteBuffer.wrap(rowName), columnValuesB);
        putB.setColumnValues(columnValuesB);
        TDelete delete = new TDelete(ByteBuffer.wrap(rowName));
        ArrayList<TColumn> deleteColumns = new ArrayList<TColumn>(1);
        TColumn deleteColumn = new TColumn(ByteBuffer.wrap(familyAname));
        deleteColumn.setQualifier(qualifierAname);
        deleteColumns.add(deleteColumn);
        delete.setColumns(deleteColumns);
        ArrayList<TMutation> mutations = new ArrayList<TMutation>(2);
        TMutation mutationA = TMutation.put((TPut)putB);
        mutations.add(mutationA);
        TMutation mutationB = TMutation.deleteSingle((TDelete)delete);
        mutations.add(mutationB);
        TRowMutations tRowMutations = new TRowMutations(ByteBuffer.wrap(rowName), mutations);
        handler.mutateRow(table, tRowMutations);
        result = handler.get(table, get);
        Assert.assertArrayEquals((byte[])rowName, (byte[])result.getRow());
        returnedColumnValues = result.getColumnValues();
        expectedColumnValues = new ArrayList(1);
        expectedColumnValues.add(columnValueB);
        this.assertTColumnValuesEqual(expectedColumnValues, returnedColumnValues);
    }

    @Test
    public void testDurability() throws Exception {
        byte[] rowName = Bytes.toBytes((String)"testDurability");
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(1);
        columnValues.add(new TColumnValue(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname), ByteBuffer.wrap(valueAname)));
        ArrayList<TColumnIncrement> incrementColumns = new ArrayList<TColumnIncrement>(1);
        incrementColumns.add(new TColumnIncrement(ByteBuffer.wrap(familyAname), ByteBuffer.wrap(qualifierAname)));
        TDelete tDelete = new TDelete(ByteBuffer.wrap(rowName));
        tDelete.setDurability(TDurability.SKIP_WAL);
        Delete delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertEquals((Object)Durability.SKIP_WAL, (Object)delete.getDurability());
        tDelete.setDurability(TDurability.ASYNC_WAL);
        delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertEquals((Object)Durability.ASYNC_WAL, (Object)delete.getDurability());
        tDelete.setDurability(TDurability.SYNC_WAL);
        delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertEquals((Object)Durability.SYNC_WAL, (Object)delete.getDurability());
        tDelete.setDurability(TDurability.FSYNC_WAL);
        delete = ThriftUtilities.deleteFromThrift((TDelete)tDelete);
        Assert.assertEquals((Object)Durability.FSYNC_WAL, (Object)delete.getDurability());
        TPut tPut = new TPut(ByteBuffer.wrap(rowName), columnValues);
        tPut.setDurability(TDurability.SKIP_WAL);
        Put put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertEquals((Object)Durability.SKIP_WAL, (Object)put.getDurability());
        tPut.setDurability(TDurability.ASYNC_WAL);
        put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertEquals((Object)Durability.ASYNC_WAL, (Object)put.getDurability());
        tPut.setDurability(TDurability.SYNC_WAL);
        put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertEquals((Object)Durability.SYNC_WAL, (Object)put.getDurability());
        tPut.setDurability(TDurability.FSYNC_WAL);
        put = ThriftUtilities.putFromThrift((TPut)tPut);
        Assert.assertEquals((Object)Durability.FSYNC_WAL, (Object)put.getDurability());
        TIncrement tIncrement = new TIncrement(ByteBuffer.wrap(rowName), incrementColumns);
        tIncrement.setDurability(TDurability.SKIP_WAL);
        Increment increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertEquals((Object)Durability.SKIP_WAL, (Object)increment.getDurability());
        tIncrement.setDurability(TDurability.ASYNC_WAL);
        increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertEquals((Object)Durability.ASYNC_WAL, (Object)increment.getDurability());
        tIncrement.setDurability(TDurability.SYNC_WAL);
        increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertEquals((Object)Durability.SYNC_WAL, (Object)increment.getDurability());
        tIncrement.setDurability(TDurability.FSYNC_WAL);
        increment = ThriftUtilities.incrementFromThrift((TIncrement)tIncrement);
        Assert.assertEquals((Object)Durability.FSYNC_WAL, (Object)increment.getDurability());
    }

    @Test
    public void testCheckAndMutate() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        ByteBuffer table = ByteBuffer.wrap(tableAname);
        ByteBuffer row = ByteBuffer.wrap(Bytes.toBytes((String)"row"));
        ByteBuffer family = ByteBuffer.wrap(familyAname);
        ByteBuffer qualifier = ByteBuffer.wrap(qualifierAname);
        ByteBuffer value = ByteBuffer.wrap(valueAname);
        ArrayList<TColumnValue> columnValuesB = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueB = new TColumnValue(family, ByteBuffer.wrap(qualifierBname), ByteBuffer.wrap(valueBname));
        columnValuesB.add(columnValueB);
        TPut putB = new TPut(row, columnValuesB);
        putB.setColumnValues(columnValuesB);
        TRowMutations tRowMutations = new TRowMutations(row, Arrays.asList(TMutation.put((TPut)putB)));
        TResult result = handler.get(table, new TGet(row));
        Assert.assertEquals((long)0L, (long)result.getColumnValuesSize());
        Assert.assertFalse((String)"Expected condition to not pass", (boolean)handler.checkAndMutate(table, row, family, qualifier, TCompareOp.EQUAL, value, tRowMutations));
        ArrayList<TColumnValue> columnValuesA = new ArrayList<TColumnValue>(1);
        TColumnValue columnValueA = new TColumnValue(family, qualifier, value);
        columnValuesA.add(columnValueA);
        handler.put(table, new TPut(row, columnValuesA));
        result = handler.get(table, new TGet(row));
        Assert.assertEquals((long)1L, (long)result.getColumnValuesSize());
        this.assertTColumnValueEqual(columnValueA, (TColumnValue)result.getColumnValues().get(0));
        Assert.assertTrue((String)"Expected condition to pass", (boolean)handler.checkAndMutate(table, row, family, qualifier, TCompareOp.EQUAL, value, tRowMutations));
        result = handler.get(table, new TGet(row));
        Assert.assertEquals((long)2L, (long)result.getColumnValuesSize());
        this.assertTColumnValueEqual(columnValueA, (TColumnValue)result.getColumnValues().get(0));
        this.assertTColumnValueEqual(columnValueB, (TColumnValue)result.getColumnValues().get(1));
    }

    @Test
    public void testConsistency() throws Exception {
        byte[] rowName = Bytes.toBytes((String)"testConsistency");
        TGet tGet = new TGet(ByteBuffer.wrap(rowName));
        tGet.setConsistency(TConsistency.STRONG);
        Get get = ThriftUtilities.getFromThrift((TGet)tGet);
        Assert.assertEquals((Object)Consistency.STRONG, (Object)get.getConsistency());
        tGet.setConsistency(TConsistency.TIMELINE);
        tGet.setTargetReplicaId(1);
        get = ThriftUtilities.getFromThrift((TGet)tGet);
        Assert.assertEquals((Object)Consistency.TIMELINE, (Object)get.getConsistency());
        Assert.assertEquals((long)1L, (long)get.getReplicaId());
        TScan tScan = new TScan();
        tScan.setConsistency(TConsistency.STRONG);
        Scan scan = ThriftUtilities.scanFromThrift((TScan)tScan);
        Assert.assertEquals((Object)Consistency.STRONG, (Object)scan.getConsistency());
        tScan.setConsistency(TConsistency.TIMELINE);
        tScan.setTargetReplicaId(1);
        scan = ThriftUtilities.scanFromThrift((TScan)tScan);
        Assert.assertEquals((Object)Consistency.TIMELINE, (Object)scan.getConsistency());
        Assert.assertEquals((long)1L, (long)scan.getReplicaId());
        TResult tResult = new TResult();
        Assert.assertFalse((boolean)tResult.isSetStale());
        tResult.setStale(true);
        Assert.assertTrue((boolean)tResult.isSetStale());
    }

    @Test
    public void testDDLOpertions() throws Exception {
        String namespace = "testDDLOpertionsNamespace";
        String table = "testDDLOpertionsTable";
        TTableName tTableName = new TTableName();
        tTableName.setNs(Bytes.toBytes((String)namespace));
        tTableName.setQualifier(Bytes.toBytes((String)table));
        ThriftHBaseServiceHandler handler = this.createHandler();
        TNamespaceDescriptor namespaceDescriptor = new TNamespaceDescriptor();
        namespaceDescriptor.setName(namespace);
        namespaceDescriptor.putToConfiguration("key1", "value1");
        namespaceDescriptor.putToConfiguration("key2", "value2");
        handler.createNamespace(namespaceDescriptor);
        List namespaceDescriptors = handler.listNamespaceDescriptors();
        Assert.assertTrue((namespaceDescriptors.size() == 3 ? 1 : 0) != 0);
        namespaceDescriptor.putToConfiguration("kye3", "value3");
        handler.modifyNamespace(namespaceDescriptor);
        TNamespaceDescriptor namespaceDescriptorReturned = handler.getNamespaceDescriptor(namespace);
        Assert.assertTrue((namespaceDescriptorReturned.getConfiguration().size() == 3 ? 1 : 0) != 0);
        TTableDescriptor tableDescriptor = new TTableDescriptor();
        tableDescriptor.setTableName(tTableName);
        TColumnFamilyDescriptor columnFamilyDescriptor1 = new TColumnFamilyDescriptor();
        columnFamilyDescriptor1.setName(familyAname);
        columnFamilyDescriptor1.setDataBlockEncoding(TDataBlockEncoding.DIFF);
        tableDescriptor.addToColumns(columnFamilyDescriptor1);
        ArrayList<ByteBuffer> splitKeys = new ArrayList<ByteBuffer>();
        splitKeys.add(ByteBuffer.wrap(Bytes.toBytes((int)5)));
        handler.createTable(tableDescriptor, splitKeys);
        tableDescriptor.setDurability(TDurability.ASYNC_WAL);
        handler.modifyTable(tableDescriptor);
        columnFamilyDescriptor1.setInMemory(true);
        handler.modifyColumnFamily(tTableName, columnFamilyDescriptor1);
        TColumnFamilyDescriptor columnFamilyDescriptor2 = new TColumnFamilyDescriptor();
        columnFamilyDescriptor2.setName(familyBname);
        columnFamilyDescriptor2.setDataBlockEncoding(TDataBlockEncoding.PREFIX);
        handler.addColumnFamily(tTableName, columnFamilyDescriptor2);
        TTableDescriptor tableDescriptorReturned = handler.getTableDescriptor(tTableName);
        Assert.assertTrue((tableDescriptorReturned.getColumns().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((tableDescriptorReturned.getDurability() == TDurability.ASYNC_WAL ? 1 : 0) != 0);
        TColumnFamilyDescriptor columnFamilyDescriptor1Returned = tableDescriptorReturned.getColumns().stream().filter(desc -> Bytes.equals((byte[])desc.getName(), (byte[])familyAname)).findFirst().get();
        Assert.assertTrue((columnFamilyDescriptor1Returned.isInMemory() ? 1 : 0) != 0);
        handler.deleteColumnFamily(tTableName, ByteBuffer.wrap(familyBname));
        tableDescriptorReturned = handler.getTableDescriptor(tTableName);
        Assert.assertTrue((tableDescriptorReturned.getColumns().size() == 1 ? 1 : 0) != 0);
        handler.disableTable(tTableName);
        Assert.assertTrue((boolean)handler.isTableDisabled(tTableName));
        handler.enableTable(tTableName);
        Assert.assertTrue((boolean)handler.isTableEnabled(tTableName));
        Assert.assertTrue((boolean)handler.isTableAvailable(tTableName));
        handler.disableTable(tTableName);
        handler.truncateTable(tTableName, true);
        Assert.assertTrue((boolean)handler.isTableAvailable(tTableName));
        handler.disableTable(tTableName);
        handler.deleteTable(tTableName);
        Assert.assertFalse((boolean)handler.tableExists(tTableName));
        handler.deleteNamespace(namespace);
        namespaceDescriptors = handler.listNamespaceDescriptors();
        Assert.assertTrue((namespaceDescriptors.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTableDescriptor() throws Exception {
        ThriftHBaseServiceHandler handler = this.createHandler();
        TTableDescriptor tableDescriptor = handler.getTableDescriptor(ThriftUtilities.tableNameFromHBase((TableName)TableName.valueOf((byte[])tableAname)));
        TableDescriptor table = ThriftUtilities.tableDescriptorFromThrift((TTableDescriptor)tableDescriptor);
        Assert.assertTrue((boolean)table.getTableName().equals((Object)TableName.valueOf((byte[])tableAname)));
        Assert.assertTrue((table.getColumnFamilies().length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((table.getColumnFamily(familyAname).getMaxVersions() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((table.getColumnFamily(familyBname).getMaxVersions() == 2 ? 1 : 0) != 0);
    }

    public static class DelayingRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        private static final Logger LOG = LoggerFactory.getLogger(DelayingRegionObserver.class);
        private long delayMillis;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void start(CoprocessorEnvironment e) throws IOException {
            this.delayMillis = e.getConfiguration().getLong("delayingregionobserver.delay", 3000L);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            try {
                long start = System.currentTimeMillis();
                TimeUnit.MILLISECONDS.sleep(this.delayMillis);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Slept for " + (System.currentTimeMillis() - start) + " msec");
                }
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted while sleeping");
            }
        }
    }
}

