/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import ch.cern.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import ch.cern.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import ch.cern.hbase.thirdparty.org.apache.commons.cli.Options;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.thrift.HBaseServiceHandler;
import org.apache.hadoop.hbase.thrift.HbaseHandlerMetricsProxy;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.thrift.TProcessor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@SuppressWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Change the name will be an incompatible change, will do it later")
public class ThriftServer
extends org.apache.hadoop.hbase.thrift.ThriftServer {
    private static final Logger log = LoggerFactory.getLogger(ThriftServer.class);

    public ThriftServer(Configuration conf) {
        super(conf);
    }

    @Override
    protected void printUsageAndExit(Options options, int exitCode) throws Shell.ExitCodeException {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Thrift", null, options, "To start the Thrift server run 'hbase-daemon.sh start thrift2' or 'hbase thrift2'\nTo shutdown the thrift server run 'hbase-daemon.sh stop thrift2' or send a kill signal to the thrift server pid", true);
        throw new Shell.ExitCodeException(exitCode, "");
    }

    @Override
    protected HBaseServiceHandler createHandler(Configuration conf, UserProvider userProvider) throws IOException {
        return new ThriftHBaseServiceHandler(conf, userProvider);
    }

    @Override
    protected ThriftMetrics createThriftMetrics(Configuration conf) {
        return new ThriftMetrics(conf, ThriftMetrics.ThriftServerType.TWO);
    }

    @Override
    protected TProcessor createProcessor() {
        return new THBaseService.Processor<THBaseService.Iface>(HbaseHandlerMetricsProxy.newInstance((THBaseService.Iface)((Object)this.hbaseServiceHandler), this.metrics, this.conf));
    }

    @Override
    protected void addOptions(Options options) {
        super.addOptions(options);
        options.addOption("ro", "readonly", false, "Respond only to read method requests [default: false]");
    }

    @Override
    protected void parseCommandLine(CommandLine cmd, Options options) throws Shell.ExitCodeException {
        super.parseCommandLine(cmd, options);
        boolean readOnly = false;
        if (cmd.hasOption("readonly")) {
            readOnly = true;
        }
        this.conf.setBoolean("hbase.thrift.readonly", readOnly);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int status = ToolRunner.run((Configuration)conf, (Tool)new ThriftServer(conf), (String[])args);
        System.exit(status);
    }
}

