/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import ch.cern.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionNormalizerProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionNormalizerTracker
extends ZKNodeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(RegionNormalizerTracker.class);

    public RegionNormalizerTracker(ZKWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getZNodePaths().regionNormalizerZNode, abortable);
    }

    public boolean isNormalizerOn() {
        byte[] upData = super.getData(false);
        try {
            return upData == null || this.parseFrom(upData).getNormalizerOn();
        }
        catch (DeserializationException dex) {
            LOG.error("ZK state for RegionNormalizer could not be parsed " + Bytes.toStringBinary((byte[])upData));
            return false;
        }
    }

    public void setNormalizerOn(boolean normalizerOn) throws KeeperException {
        byte[] upData = this.toByteArray(normalizerOn);
        try {
            ZKUtil.setData(this.watcher, this.watcher.getZNodePaths().regionNormalizerZNode, upData);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createAndWatch(this.watcher, this.watcher.getZNodePaths().regionNormalizerZNode, upData);
        }
        super.nodeDataChanged(this.watcher.getZNodePaths().regionNormalizerZNode);
    }

    private byte[] toByteArray(boolean isNormalizerOn) {
        RegionNormalizerProtos.RegionNormalizerState.Builder builder = RegionNormalizerProtos.RegionNormalizerState.newBuilder();
        builder.setNormalizerOn(isNormalizerOn);
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    private RegionNormalizerProtos.RegionNormalizerState parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix((byte[])pbBytes);
        RegionNormalizerProtos.RegionNormalizerState.Builder builder = RegionNormalizerProtos.RegionNormalizerState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])pbBytes, (int)magicLen, (int)(pbBytes.length - magicLen));
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
        return builder.build();
    }
}

