/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.immutable.WrappedString;
import scala.runtime.BoxesRunTime;

public final class CSVExprUtils$ {
    public static CSVExprUtils$ MODULE$;

    static {
        new CSVExprUtils$();
    }

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        Iterator iterator;
        if (options.isCommentSet()) {
            String commentPrefix = ((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString();
            iterator = iter.filter((Function1 & java.io.Serializable & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$filterCommentAndEmpty$1(commentPrefix, line)));
        } else {
            iterator = iter.filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$filterCommentAndEmpty$2(x$1)));
        }
        return iterator;
    }

    public Iterator<String> skipComments(Iterator<String> iter, CSVOptions options) {
        Iterator iterator;
        if (options.isCommentSet()) {
            String commentPrefix = ((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString();
            iterator = iter.dropWhile((Function1 & java.io.Serializable & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$skipComments$1(commentPrefix, line)));
        } else {
            iterator = iter.dropWhile((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$skipComments$2(x$2)));
        }
        return iterator;
    }

    public Option<String> extractHeader(Iterator<String> iter, CSVOptions options) {
        Iterator<String> nonEmptyLines = this.skipComments(iter, options);
        return nonEmptyLines.hasNext() ? new Some(nonEmptyLines.next()) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char toChar(String str) throws IllegalArgumentException {
        Some some;
        Some some2;
        Some some3;
        Some some4;
        Some some5;
        Some some6;
        char c;
        WrappedString wrappedString = Predef$.MODULE$.wrapString(str);
        Some some7 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some7.isEmpty() && some7.get() != null && ((SeqLike)some7.get()).lengthCompare(0) == 0) {
            throw new IllegalArgumentException("Delimiter cannot be empty string");
        }
        Some some8 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some8.isEmpty() && some8.get() != null && ((SeqLike)some8.get()).lengthCompare(1) == 0 && '\\' == (c = BoxesRunTime.unboxToChar((Object)((SeqLike)some8.get()).apply(0)))) {
            throw new IllegalArgumentException("Single backslash is prohibited. It has special meaning as beginning of an escape sequence. To get the backslash character, pass a string with two backslashes as the delimiter.");
        }
        Some some9 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some9.isEmpty() && some9.get() != null && ((SeqLike)some9.get()).lengthCompare(1) == 0) {
            int c2 = BoxesRunTime.unboxToChar((Object)((SeqLike)some9.get()).apply(0));
            return (char)c2;
        }
        Some some10 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some10.isEmpty() && some10.get() != null && ((SeqLike)some10.get()).lengthCompare(2) == 0) {
            char c3 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(0));
            char c4 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(1));
            if ('\\' == c3 && 't' == c4) {
                return (char)9;
            }
        }
        if (!(some6 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some6.get() != null && ((SeqLike)some6.get()).lengthCompare(2) == 0) {
            char c5 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(0));
            char c6 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(1));
            if ('\\' == c5 && 'r' == c6) {
                return (char)13;
            }
        }
        if (!(some5 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some5.get() != null && ((SeqLike)some5.get()).lengthCompare(2) == 0) {
            char c7 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(0));
            char c8 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(1));
            if ('\\' == c7 && 'b' == c8) {
                return (char)8;
            }
        }
        if (!(some4 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some4.get() != null && ((SeqLike)some4.get()).lengthCompare(2) == 0) {
            char c9 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(0));
            char c10 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(1));
            if ('\\' == c9 && 'f' == c10) {
                return (char)12;
            }
        }
        if (!(some3 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(2) == 0) {
            char c11 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(0));
            char c12 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(1));
            if ('\\' == c11 && '\"' == c12) {
                return (char)34;
            }
        }
        if (!(some2 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
            char c13 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(0));
            char c14 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(1));
            if ('\\' == c13 && '\'' == c14) {
                return (char)39;
            }
        }
        if (!(some = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            char c15 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(0));
            char c16 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(1));
            if ('\\' == c15 && '\\' == c16) {
                return (char)92;
            }
        }
        String string = str;
        String string2 = "\u0000";
        if (string == null) {
            if (string2 == null) return (char)0;
        } else if (string.equals(string2)) {
            return (char)0;
        }
        Some some11 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (some11.isEmpty()) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        if (some11.get() == null) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        if (((SeqLike)some11.get()).lengthCompare(2) != 0) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        char c17 = BoxesRunTime.unboxToChar((Object)((SeqLike)some11.get()).apply(0));
        if ('\\' != c17) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        throw new IllegalArgumentException(new StringBuilder(45).append("Unsupported special character for delimiter: ").append(str).toString());
    }

    public String toDelimiterStr(String str) {
        String chunk;
        String delimiter = "";
        for (int idx = 0; idx < str.length(); idx += chunk.length()) {
            int readAhead = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx) == '\\' ? 2 : 1;
            chunk = StringUtils.substring((String)str, (int)idx, (int)(idx + readAhead));
            delimiter = new StringBuilder(0).append(delimiter).append(this.toChar(chunk)).toString();
        }
        return new StringOps(Predef$.MODULE$.augmentString(delimiter)).mkString("");
    }

    public static final /* synthetic */ boolean $anonfun$filterCommentAndEmpty$1(String commentPrefix$1, String line) {
        return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() && !line.startsWith(commentPrefix$1);
    }

    public static final /* synthetic */ boolean $anonfun$filterCommentAndEmpty$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$skipComments$1(String commentPrefix$2, String line) {
        return line.trim().isEmpty() || line.startsWith(commentPrefix$2);
    }

    public static final /* synthetic */ boolean $anonfun$skipComments$2(String x$2) {
        return x$2.trim().isEmpty();
    }

    private CSVExprUtils$() {
        MODULE$ = this;
    }
}

