/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(a1, a2) - Returns true if a1 contains at least a non-null element present also in a2. If the arrays have no common element and they are both non-empty and either of them contains a null element null is returned, false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(3, 4, 5));\n       true\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0012%\u0001FB\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005J\u0001\tE\t\u0015!\u0003E\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011!9\u0006\u0001#b\u0001\n\u0013A\u0006\u0002\u00037\u0001\u0011\u000b\u0007I\u0011B7\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005\"CAG\u0001\u0005\u0005I\u0011AAH\u0011%\t)\nAI\u0001\n\u0003\t9\nC\u0005\u0002.\u0002\t\n\u0011\"\u0001\u0002\u0018\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0017\u0005\n\u0003\u0003\u0004\u0011\u0011!C\u0001\u0003\u0007D\u0011\"a3\u0001\u0003\u0003%\t!!4\t\u0013\u0005M\u0007!!A\u0005B\u0005U\u0007\"CAr\u0001\u0005\u0005I\u0011AAs\u0011%\tI\u000fAA\u0001\n\u0003\nYoB\u0005\u0003\u0010\u0011\n\t\u0011#\u0001\u0003\u0012\u0019A1\u0005JA\u0001\u0012\u0003\u0011\u0019\u0002\u0003\u0004K;\u0011\u0005!\u0011\u0005\u0005\n\u0005Gi\u0012\u0011!C#\u0005KA\u0011Ba\n\u001e\u0003\u0003%\tI!\u000b\t\u0013\t=R$!A\u0005\u0002\nE\u0002\"\u0003B\";\u0005\u0005I\u0011\u0002B#\u00055\t%O]1zg>3XM\u001d7ba*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001eYJt\b\u0005\u00024i5\tA%\u0003\u00026I\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003g]J!\u0001\u000f\u0013\u0003K\tKg.\u0019:z\u0003J\u0014\u0018-_#yaJ,7o]5p]^KG\u000f[%na2L7-\u001b;DCN$\bC\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$a\u0002)s_\u0012,8\r\u001e\t\u0003u\u0001K!!Q\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002\tB\u00111'R\u0005\u0003\r\u0012\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2\u0001T'O!\t\u0019\u0004\u0001C\u0003C\u000b\u0001\u0007A\tC\u0003I\u000b\u0001\u0007A)A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001R!\t\u0011V+D\u0001T\u0015\t!f%\u0001\u0005b]\u0006d\u0017p]5t\u0013\t16KA\bUsB,7\t[3dWJ+7/\u001e7u\u0003!y'\u000fZ3sS:<W#A-\u0011\u0007i\u0013WM\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011a\fM\u0001\u0007yI|w\u000e\u001e \n\u0003qJ!!Y\u001e\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\t\u001fJ$WM]5oO*\u0011\u0011m\u000f\t\u0003u\u0019L!aZ\u001e\u0003\u0007\u0005s\u0017\u0010\u000b\u0002\bSB\u0011!H[\u0005\u0003Wn\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0019\u0011|WI^1mk\u0006$\u0018n\u001c8\u0016\u00039\u0004RAO8rc\u0016L!\u0001]\u001e\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001:v\u001b\u0005\u0019(B\u0001;'\u0003\u0011)H/\u001b7\n\u0005Y\u001c(!C!se\u0006LH)\u0019;bQ\tA\u0011.\u0001\u0005eCR\fG+\u001f9f+\u0005Q\bCA>\u007f\u001b\u0005a(BA?)\u0003\u0015!\u0018\u0010]3t\u0013\tyHP\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,WCAA\u0003!\rQ\u0014qA\u0005\u0004\u0003\u0013Y$a\u0002\"p_2,\u0017M\\\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0006K\u0006=\u00111\u0003\u0005\u0007\u0003#Y\u0001\u0019A3\u0002\u0005\u0005\f\u0004BBA\u000b\u0017\u0001\u0007Q-\u0001\u0002be\u0005Aa-Y:u\u000bZ\fG\u000eF\u0003f\u00037\ty\u0002\u0003\u0004\u0002\u001e1\u0001\r!]\u0001\u0005CJ\u0014\u0018\u0007\u0003\u0004\u0002\"1\u0001\r!]\u0001\u0005CJ\u0014('\u0001\bceV$XMR8sG\u0016,e/\u00197\u0015\u000b\u0015\f9#!\u000b\t\r\u0005uQ\u00021\u0001r\u0011\u0019\t\t#\u0004a\u0001c\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003_\tY$!\u0012\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e%\u0003\u001d\u0019w\u000eZ3hK:LA!!\u000f\u00024\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002>9\u0001\r!a\u0010\u0002\u0007\r$\b\u0010\u0005\u0003\u00022\u0005\u0005\u0013\u0002BA\"\u0003g\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002H9\u0001\r!a\f\u0002\u0005\u00154\u0018a\u00034bgR\u001cu\u000eZ3hK:$\"\"!\u0014\u0002^\u0005}\u0013\u0011MA3!\u0011\ty%a\u0016\u000f\t\u0005E\u00131\u000b\t\u00039nJ1!!\u0016<\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011LA.\u0005\u0019\u0019FO]5oO*\u0019\u0011QK\u001e\t\u000f\u0005ur\u00021\u0001\u0002@!9\u0011qI\bA\u0002\u0005=\u0002bBA2\u001f\u0001\u0007\u0011QJ\u0001\bg6\fG\u000e\\3s\u0011\u001d\t9g\u0004a\u0001\u0003\u001b\naAY5hO\u0016\u0014\u0018!\u00052skR,gi\u001c:dK\u000e{G-Z4f]RQ\u0011QJA7\u0003_\n\t(a\u001d\t\u000f\u0005u\u0002\u00031\u0001\u0002@!9\u0011q\t\tA\u0002\u0005=\u0002bBA2!\u0001\u0007\u0011Q\n\u0005\b\u0003O\u0002\u0002\u0019AA'\u0003YqW\u000f\u001c7TC\u001a,W\t\\3nK:$8i\u001c3fO\u0016tGCCA'\u0003s\ni(!!\u0002\u0006\"9\u00111P\tA\u0002\u00055\u0013\u0001C1se\u0006Lh+\u0019:\t\u000f\u0005}\u0014\u00031\u0001\u0002N\u0005)\u0011N\u001c3fq\"9\u00111Q\tA\u0002\u00055\u0013\u0001B2pI\u0016Dq!a\"\u0012\u0001\u0004\ti%\u0001\u0006jg:+H\u000e\\\"pI\u0016\f!\u0002\u001d:fiRLh*Y7f+\t\ti%\u0001\u0003d_BLH#\u0002'\u0002\u0012\u0006M\u0005b\u0002\"\u0014!\u0003\u0005\r\u0001\u0012\u0005\b\u0011N\u0001\n\u00111\u0001E\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!'+\u0007\u0011\u000bYj\u000b\u0002\u0002\u001eB!\u0011qTAU\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016!C;oG\",7m[3e\u0015\r\t9kO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAV\u0003C\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000bA\u0001\\1oO*\u0011\u0011QX\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002Z\u0005]\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAAc!\rQ\u0014qY\u0005\u0004\u0003\u0013\\$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA3\u0002P\"I\u0011\u0011\u001b\r\u0002\u0002\u0003\u0007\u0011QY\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0007#BAm\u0003?,WBAAn\u0015\r\tinO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAq\u00037\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QAAt\u0011!\t\tNGA\u0001\u0002\u0004)\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0006\u00055\b\u0002CAi7\u0005\u0005\t\u0019A3)'\u0001\t\t0a>\u0002z\u0006u\u0018q B\u0002\u0005\u000b\u0011IAa\u0003\u0011\u0007M\n\u00190C\u0002\u0002v\u0012\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002|\u0006\t9n\u0018$V\u001d\u000e{\u0006&Y\u0019-A\u0005\u0014\u0014\u0006I\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\n\u0017\u0007I2p]R\f\u0017N\\:!CR\u0004C.Z1ti\u0002\n\u0007E\\8o[9,H\u000e\u001c\u0011fY\u0016lWM\u001c;!aJ,7/\u001a8uA\u0005d7o\u001c\u0011j]\u0002\n'G\f\u0011JM\u0002\"\b.\u001a\u0011beJ\f\u0017p\u001d\u0011iCZ,\u0007E\\8!G>lWn\u001c8!K2,W.\u001a8uA\u0005tG\r\t;iKf\u0004\u0013M]3!E>$\b\u000e\t8p]6*W\u000e\u001d;zA\u0005tG\rI3ji\",'\u000fI8gAQDW-\u001c\u0011d_:$\u0018-\u001b8tA\u0005\u0004c.\u001e7mA\u0015dW-\\3oi\u0002rW\u000f\u001c7!SN\u0004#/\u001a;ve:,G\r\f\u0011gC2\u001cX\rI8uQ\u0016\u0014x/[:f]\u0005AQ\r_1na2,7/\t\u0002\u0003\u0002\u0005!&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023'\u000b\u0017!CJ\u0014\u0018-\u001f\u00154Y\u0001\"D\u0006I\u001b*SmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B\u0004\u0003-\t'O]1z?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t5\u0011!\u0002\u001a/i9\u0002\u0014!D!se\u0006L8o\u0014<fe2\f\u0007\u000f\u0005\u00024;M!QD!\u0006@!\u001d\u00119B!\bE\t2k!A!\u0007\u000b\u0007\tm1(A\u0004sk:$\u0018.\\3\n\t\t}!\u0011\u0004\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B\t\u0003!!xn\u0015;sS:<GCAAZ\u0003\u0015\t\u0007\u000f\u001d7z)\u0015a%1\u0006B\u0017\u0011\u0015\u0011\u0005\u00051\u0001E\u0011\u0015A\u0005\u00051\u0001E\u0003\u001d)h.\u00199qYf$BAa\r\u0003@A)!H!\u000e\u0003:%\u0019!qG\u001e\u0003\r=\u0003H/[8o!\u0015Q$1\b#E\u0013\r\u0011id\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t\u0005\u0013%!AA\u00021\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0003\u0003BA[\u0005\u0013JAAa\u0013\u00028\n1qJ\u00196fGR\u0004")
public class ArraysOverlap
extends BinaryExpression
implements BinaryArrayExpressionWithImplicitCast,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private transient Function2<ArrayData, ArrayData, Object> doEvaluation;
    private final Expression left;
    private final Expression right;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraysOverlap arraysOverlap) {
        return ArraysOverlap$.MODULE$.unapply(arraysOverlap);
    }

    public static Function1<Tuple2<Expression, Expression>, ArraysOverlap> tupled() {
        return ArraysOverlap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArraysOverlap>> curried() {
        return ArraysOverlap$.MODULE$.curried();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private DataType elementType$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.elementType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString()) : typeCheckResult;
        return typeCheckResult2;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.doEvaluation = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.fastEval((ArrayData)arr1, (ArrayData)arr2) : (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.bruteForceEval((ArrayData)arr1, (ArrayData)arr2);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doEvaluation;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.doEvaluation$lzycompute() : this.doEvaluation;
    }

    @Override
    public DataType dataType() {
        return BooleanType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.left().nullable() || this.right().nullable() || ((ArrayType)this.left().dataType()).containsNull() || ((ArrayType)this.right().dataType()).containsNull();
    }

    @Override
    public Object nullSafeEval(Object a1, Object a2) {
        return this.doEvaluation().apply((Object)((ArrayData)a1), (Object)((ArrayData)a2));
    }

    private Object fastEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            Tuple2 tuple2;
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            Tuple2 tuple22 = tuple2 = arr1.numElements() > arr2.numElements() ? new Tuple2((Object)arr1, (Object)arr2) : new Tuple2((Object)arr2, (Object)arr1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayData bigger = (ArrayData)tuple2._1();
            ArrayData smaller = (ArrayData)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bigger, (Object)smaller);
            Tuple2 tuple24 = tuple23;
            ArrayData bigger2 = (ArrayData)tuple24._1();
            ArrayData smaller2 = (ArrayData)tuple24._2();
            if (smaller2.numElements() > 0) {
                HashSet smallestSet = new HashSet();
                smaller2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$28, v) -> {
                    ArraysOverlap.$anonfun$fastEval$1(hasNull, smallestSet, BoxesRunTime.unboxToInt((Object)x$28), v);
                    return BoxedUnit.UNIT;
                });
                bigger2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$29, v1) -> {
                    ArraysOverlap.$anonfun$fastEval$2(hasNull, smallestSet, object2, BoxesRunTime.unboxToInt((Object)x$29), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object bruteForceEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            if (arr1.numElements() > 0 && arr2.numElements() > 0) {
                arr1.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$30, v1) -> {
                    ArraysOverlap.$anonfun$bruteForceEval$1(this, hasNull, arr2, object2, BoxesRunTime.unboxToInt((Object)x$30), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(a1, a2) -> {
            String smaller = ctx.freshName("smallerArray");
            String bigger = ctx.freshName("biggerArray");
            String comparisonCode = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? this.fastCodegen(ctx, ev, smaller, bigger) : this.bruteForceCodegen(ctx, ev, smaller, bigger);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(261).append("\n         |ArrayData ").append(smaller).append(";\n         |ArrayData ").append(bigger).append(";\n         |if (").append((String)a1).append(".numElements() > ").append((String)a2).append(".numElements()) {\n         |  ").append(bigger).append(" = ").append((String)a1).append(";\n         |  ").append(smaller).append(" = ").append((String)a2).append(";\n         |} else {\n         |  ").append(smaller).append(" = ").append((String)a1).append(";\n         |  ").append(bigger).append(" = ").append((String)a2).append(";\n         |}\n         |if (").append(smaller).append(".numElements() > 0) {\n         |  ").append(comparisonCode).append("\n         |}\n       ").toString())).stripMargin();
        });
    }

    private String fastCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), i);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String javaElementClass = CodeGenerator$.MODULE$.boxedType(this.elementType());
        String javaSet = java.util.HashSet.class.getName();
        String set = ctx.freshName("set");
        String addToSetFromSmallerCode = this.nullSafeElementCodegen(smaller, i, new StringBuilder(7).append(set).append(".add(").append(getFromSmaller).append(");").toString(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String elementIsInSetCode = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(set).append(".contains(").append(getFromBigger).append(")) {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |  break;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n       |").append(javaSet).append("<").append(javaElementClass).append("> ").append(set).append(" = new ").append(javaSet).append("<").append(javaElementClass).append(">();\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(smaller).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(addToSetFromSmallerCode).append("\n       |}\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(elementIsInSetCode).append("\n       |}\n     ").toString())).stripMargin();
    }

    private String bruteForceCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), j);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String compareValues = this.nullSafeElementCodegen(smaller, j, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n         |if (").append(ctx.genEqual(this.elementType(), getFromSmaller, getFromBigger)).append(") {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String isInSmaller = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |for (int ").append(j).append(" = 0; ").append(j).append(" < ").append(smaller).append(".numElements() && !").append(ev.value()).append("; ").append(j).append(" ++) {\n         |  ").append(compareValues).append("\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements() && !").append(ev.value()).append("; ").append(i).append(" ++) {\n       |  ").append(isInSmaller).append("\n       |}\n     ").toString())).stripMargin();
    }

    public String nullSafeElementCodegen(String arrayVar, String index, String code, String isNullCode) {
        return this.inputTypes().exists((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)ArraysOverlap.$anonfun$nullSafeElementCodegen$1(x$32))) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n         |if (").append(arrayVar).append(".isNullAt(").append(index).append(")) {\n         |  ").append(isNullCode).append("\n         |} else {\n         |  ").append(code).append("\n         |}\n       ").toString())).stripMargin() : code;
    }

    @Override
    public String prettyName() {
        return "arrays_overlap";
    }

    public ArraysOverlap copy(Expression left, Expression right) {
        return new ArraysOverlap(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArraysOverlap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysOverlap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysOverlap)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysOverlap arraysOverlap = (ArraysOverlap)x$1;
        Expression expression = this.left();
        Expression expression2 = arraysOverlap.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arraysOverlap.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraysOverlap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$fastEval$1(BooleanRef hasNull$2, HashSet smallestSet$1, int x$28, Object v) {
        if (v == null) {
            hasNull$2.elem = true;
        } else {
            smallestSet$1.$plus$eq(v);
        }
    }

    public static final /* synthetic */ void $anonfun$fastEval$2(BooleanRef hasNull$2, HashSet smallestSet$1, Object nonLocalReturnKey2$1, int x$29, Object v1) {
        if (v1 == null) {
            hasNull$2.elem = true;
        } else if (smallestSet$1.contains(v1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$2(ArraysOverlap $this, BooleanRef hasNull$3, Object v1$1, Object nonLocalReturnKey3$1, int x$31, Object v2) {
        if (v2 == null) {
            hasNull$3.elem = true;
        } else if ($this.ordering().equiv(v1$1, v2)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$1(ArraysOverlap $this, BooleanRef hasNull$3, ArrayData arr2$1, Object nonLocalReturnKey3$1, int x$30, Object v1) {
        if (v1 == null) {
            hasNull$3.elem = true;
        } else {
            arr2$1.foreach($this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$31, v2) -> {
                ArraysOverlap.$anonfun$bruteForceEval$2($this, hasNull$3, v1, nonLocalReturnKey3$1, BoxesRunTime.unboxToInt((Object)x$31), v2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeElementCodegen$1(AbstractDataType x$32) {
        return ((ArrayType)x$32).containsNull();
    }

    public ArraysOverlap(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
    }
}

