/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Atan2$;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(exprY, exprX) - Returns the angle in radians between the positive x-axis of a plane\n      and the point given by the coordinates (`exprX`, `exprY`), as if computed by\n      `java.lang.Math._FUNC_`.\n  ", arguments="\n    Arguments:\n      * exprY - coordinate on y-axis\n      * exprX - coordinate on x-axis\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 0);\n       0.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\r\u001a\u0001\u001aB\u0001\u0002\u000e\u0001\u0003\u0016\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0012)A\u0005m!A!\b\u0001BK\u0002\u0013\u0005Q\u0007\u0003\u0005<\u0001\tE\t\u0015!\u00037\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\t\u0005\u0001\"\u0015C\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u001dI\u0006!!A\u0005\u0002iCq!\u0018\u0001\u0012\u0002\u0013\u0005a\fC\u0004j\u0001E\u0005I\u0011\u00010\t\u000f)\u0004\u0011\u0011!C!W\"9A\u000fAA\u0001\n\u0003)\bbB=\u0001\u0003\u0003%\tA\u001f\u0005\b{\u0002\t\t\u0011\"\u0011\u007f\u0011%\tY\u0001AA\u0001\n\u0003\ti\u0001C\u0005\u0002\u0018\u0001\t\t\u0011\"\u0011\u0002\u001a\u001dI\u0011qG\r\u0002\u0002#\u0005\u0011\u0011\b\u0004\t1e\t\t\u0011#\u0001\u0002<!1AH\u0005C\u0001\u0003\u0013B\u0011\"a\u0013\u0013\u0003\u0003%)%!\u0014\t\u0013\u0005=##!A\u0005\u0002\u0006E\u0003\"CA,%\u0005\u0005I\u0011QA-\u0011%\tYGEA\u0001\n\u0013\tiGA\u0003Bi\u0006t'G\u0003\u0002\u001b7\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taR$\u0001\u0005dCR\fG._:u\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\u0011\u0001qeK\u0019\u0011\u0005!JS\"A\r\n\u0005)J\"\u0001\u0006\"j]\u0006\u0014\u00180T1uQ\u0016C\bO]3tg&|g\u000e\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0004Qe>$Wo\u0019;\u0011\u00051\u0012\u0014BA\u001a.\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003Y\u0002\"\u0001K\u001c\n\u0005aJ\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDc\u0001 @\u0001B\u0011\u0001\u0006\u0001\u0005\u0006i\u0015\u0001\rA\u000e\u0005\u0006u\u0015\u0001\rAN\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004\u0007\u001aC\u0005C\u0001\u0017E\u0013\t)UFA\u0002B]fDQa\u0012\u0004A\u0002\r\u000ba!\u001b8qkR\f\u0004\"B%\u0007\u0001\u0004\u0019\u0015AB5oaV$('A\u0005e_\u001e+gnQ8eKR\u0019AJU,\u0011\u00055\u0003V\"\u0001(\u000b\u0005=K\u0012aB2pI\u0016<WM\\\u0005\u0003#:\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006'\u001e\u0001\r\u0001V\u0001\u0004GRD\bCA'V\u0013\t1fJ\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000ba;\u0001\u0019\u0001'\u0002\u0005\u00154\u0018\u0001B2paf$2AP.]\u0011\u001d!\u0004\u0002%AA\u0002YBqA\u000f\u0005\u0011\u0002\u0003\u0007a'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003}S#A\u000e1,\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u0013Ut7\r[3dW\u0016$'B\u00014.\u0003)\tgN\\8uCRLwN\\\u0005\u0003Q\u000e\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001\u00027b]\u001eT\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002t]\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\u001e\t\u0003Y]L!\u0001_\u0017\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005\r[\bb\u0002?\u000e\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003}\u0004R!!\u0001\u0002\b\rk!!a\u0001\u000b\u0007\u0005\u0015Q&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0003\u0002\u0004\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty!!\u0006\u0011\u00071\n\t\"C\u0002\u0002\u00145\u0012qAQ8pY\u0016\fg\u000eC\u0004}\u001f\u0005\u0005\t\u0019A\"\u0002\r\u0015\fX/\u00197t)\u0011\ty!a\u0007\t\u000fq\u0004\u0012\u0011!a\u0001\u0007\"z\u0001!a\b\u0002&\u0005\u001d\u00121FA\u0017\u0003c\t\u0019\u0004E\u0002)\u0003CI1!a\t\u001a\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u000b\u0002\u0003SS\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(/\u0017\u0017!Kb\u0004(\u000fW\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!C:<G.\u001a\u0011j]\u0002\u0012\u0018\rZ5b]N\u0004#-\u001a;xK\u0016t\u0007\u0005\u001e5fAA|7/\u001b;jm\u0016\u0004\u00030L1ySN\u0004sN\u001a\u0011bAAd\u0017M\\3\u000bA\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004C\u000f[3!a>Lg\u000e\u001e\u0011hSZ,g\u000e\t2zAQDW\rI2p_J$\u0017N\\1uKN\u0004\u0003\u0006Y3yaJD\u0006\r\f\u0011aKb\u0004(/\u00171*Y\u0001\n7\u000fI5gA\r|W\u000e];uK\u0012\u0004#-\u001f\u0006!A\u0001\u0002\u0003\u0005\t1kCZ\fg\u0006\\1oO:j\u0015\r\u001e5/?\u001a+fjQ0a])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011qF\u0001]\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9s3\u0002j\u0003eY8pe\u0012Lg.\u0019;fA=t\u0007%_\u0017bq&\u001c(\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJD\u0006%\f\u0011d_>\u0014H-\u001b8bi\u0016\u0004sN\u001c\u0011y[\u0005D\u0018n\u001d\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u00026\u0005I$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u0019-AAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019/a)\u0001\u0003%A\u0003Bi\u0006t'\u0007\u0005\u0002)%M!!#!\u00102!\u001d\ty$!\u00127myj!!!\u0011\u000b\u0007\u0005\rS&A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0013\u0011\t\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA\u001d\u0003!!xn\u0015;sS:<G#\u00017\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000by\n\u0019&!\u0016\t\u000bQ*\u0002\u0019\u0001\u001c\t\u000bi*\u0002\u0019\u0001\u001c\u0002\u000fUt\u0017\r\u001d9msR!\u00111LA4!\u0015a\u0013QLA1\u0013\r\ty&\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b1\n\u0019G\u000e\u001c\n\u0007\u0005\u0015TF\u0001\u0004UkBdWM\r\u0005\t\u0003S2\u0012\u0011!a\u0001}\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003_\u00022!\\A9\u0013\r\t\u0019H\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class Atan2
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Atan2 atan2) {
        return Atan2$.MODULE$.unapply(atan2);
    }

    public static Function1<Tuple2<Expression, Expression>, Atan2> tupled() {
        return Atan2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Atan2>> curried() {
        return Atan2$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(BoxesRunTime.unboxToDouble((Object)input1) + 0.0, BoxesRunTime.unboxToDouble((Object)input2) + 0.0));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & java.io.Serializable & Serializable)(c1, c2) -> new StringBuilder(36).append("java.lang.Math.atan2(").append((String)c1).append(" + 0.0, ").append((String)c2).append(" + 0.0)").toString());
    }

    public Atan2 copy(Expression left, Expression right) {
        return new Atan2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Atan2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Atan2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Atan2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Atan2 atan2 = (Atan2)x$1;
        Expression expression = this.left();
        Expression expression2 = atan2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = atan2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!atan2.canEqual(this)) return false;
        return true;
    }

    public Atan2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double y, double x) {
                return this.apply$mcDDD$sp(y, x);
            }

            public double apply$mcDDD$sp(double y, double x) {
                return package$.MODULE$.atan2(y, x);
            }
        }, "ATAN2");
    }
}

