/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.DatePart$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(field, source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted, and supported string values are as same as the fields of the equivalent function `EXTRACT`.\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_('week', timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_('doy', DATE'2019-08-12');\n       224\n      > SELECT _FUNC_('SECONDS', timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_('days', interval 1 year 10 months 5 days);\n       5\n      > SELECT _FUNC_('seconds', interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n  ", note="\n    The _FUNC_ function is equivalent to the SQL-standard function `EXTRACT(field FROM source)`\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015w!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003a\u0004\"B,\u0002\t\u0003A\u0006b\u0002/\u0002\u0003\u0003%\t)\u0018\u0005\n\u0003O\u000b\u0011\u0011!CA\u0003SC\u0011\"a/\u0002\u0003\u0003%I!!0\u0007\t9z\u0002i\u0018\u0005\t5\"\u0011)\u001a!C\u0001S\"A!\u000e\u0003B\tB\u0003%Q\b\u0003\u0005O\u0011\tU\r\u0011\"\u0001j\u0011!Y\u0007B!E!\u0002\u0013i\u0004\u0002\u00037\t\u0005+\u0007I\u0011A5\t\u00115D!\u0011#Q\u0001\nuBQ!\u000f\u0005\u0005\u00029DQ!\u000f\u0005\u0005\u0002IDQ!\u001e\u0005\u0005BYDa\u0001\n\u0005\u0005B\u0005\u001d\u0001bBA\u0005\u0011\u0011\u0005\u0013q\u0001\u0005\n\u0003\u0017A\u0011\u0011!C\u0001\u0003\u001bA\u0011\"!\u0006\t#\u0003%\t!a\u0006\t\u0013\u00055\u0002\"%A\u0005\u0002\u0005]\u0001\"CA\u0018\u0011E\u0005I\u0011AA\f\u0011%\t\t\u0004CA\u0001\n\u0003\n\u0019\u0004C\u0005\u0002D!\t\t\u0011\"\u0001\u0002F!I\u0011Q\n\u0005\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003+B\u0011\u0011!C!\u0003/B\u0011\"a\u0019\t\u0003\u0003%\t!!\u001a\t\u0013\u0005=\u0004\"!A\u0005B\u0005E\u0014\u0001\u0003#bi\u0016\u0004\u0016M\u001d;\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0001\"!L\u0001\u000e\u0003}\u0011\u0001\u0002R1uKB\u000b'\u000f^\n\u0004\u0003A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g\r\u0005\u00022o%\u0011\u0001H\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\n\u0011\u0003]1sg\u0016,\u0005\u0010\u001e:bGR4\u0015.\u001a7e)\u0011i\u0004)T(\u0011\u00055r\u0014BA  \u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006\u0003\u000e\u0001\rAQ\u0001\rKb$(/Y2u\r&,G\u000e\u001a\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015\u0013T\"\u0001$\u000b\u0005\u001d[\u0013A\u0002\u001fs_>$h(\u0003\u0002Je\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tI%\u0007C\u0003O\u0007\u0001\u0007Q(\u0001\u0004t_V\u00148-\u001a\u0005\u0007!\u000e!\t\u0019A)\u0002\u001f\u0015\u0014(o\u001c:IC:$G.\u001a$v]\u000e\u00042!\r*U\u0013\t\u0019&G\u0001\u0005=Eft\u0017-\\3?!\t\tT+\u0003\u0002We\t9aj\u001c;iS:<\u0017\u0001\u0005;p\u000bF,\u0018N^1mK:$X\t\u001f9s)\ri\u0014l\u0017\u0005\u00065\u0012\u0001\r!P\u0001\u0006M&,G\u000e\u001a\u0005\u0006\u001d\u0012\u0001\r!P\u0001\u0006CB\u0004H.\u001f\u000b\b=\u0006\u0005\u00161UAS!\ti\u0003bE\u0003\tA\u000e4g\u0007\u0005\u0002.C&\u0011!m\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011Q\u0006Z\u0005\u0003K~\u0011!CU;oi&lWMU3qY\u0006\u001cW-\u00192mKB\u0011\u0011gZ\u0005\u0003QJ\u0012q\u0001\u0015:pIV\u001cG/F\u0001>\u0003\u00191\u0017.\u001a7eA\u000591o\\;sG\u0016\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007\u0005\u0006\u0003__B\f\b\"\u0002.\u0010\u0001\u0004i\u0004\"\u0002(\u0010\u0001\u0004i\u0004\"\u00027\u0010\u0001\u0004iDc\u00010ti\")!\f\u0005a\u0001{!)a\n\u0005a\u0001{\u0005ia\r\\1u\u0003J<W/\\3oiN,\u0012a\u001e\t\u0005qv\f\tA\u0004\u0002zw:\u0011QI_\u0005\u0002g%\u0011APM\u0001\ba\u0006\u001c7.Y4f\u0013\tqxP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\ta(\u0007E\u00022\u0003\u0007I1!!\u00023\u0005\r\te._\u000b\u0002\u0005\u0006Q\u0001O]3uift\u0015-\\3\u0002\t\r|\u0007/\u001f\u000b\b=\u0006=\u0011\u0011CA\n\u0011\u001dQF\u0003%AA\u0002uBqA\u0014\u000b\u0011\u0002\u0003\u0007Q\bC\u0004m)A\u0005\t\u0019A\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0004\u0016\u0004{\u0005m1FAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\"'\u0001\u0006b]:|G/\u0019;j_:LA!a\u000b\u0002\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012\u0001\u00027b]\u001eT!!a\u0010\u0002\t)\fg/Y\u0005\u0004\u0017\u0006e\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA$!\r\t\u0014\u0011J\u0005\u0004\u0003\u0017\u0012$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0001\u0003#B\u0011\"a\u0015\u001b\u0003\u0003\u0005\r!a\u0012\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0006\u0005\u0004\u0002\\\u0005\u0005\u0014\u0011A\u0007\u0003\u0003;R1!a\u00183\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004}\u0006u\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004c\u0005%\u0014bAA6e\t9!i\\8mK\u0006t\u0007\"CA*9\u0005\u0005\t\u0019AA\u0001\u0003\u0019)\u0017/^1mgR!\u0011qMA:\u0011%\t\u0019&HA\u0001\u0002\u0004\t\t\u0001K\u000e\t\u0003o\ni(a \u0002\u0004\u0006\u0015\u0015\u0011RAF\u0003\u001f\u000b\t*!&\u0002\u0018\u0006m\u0015Q\u0014\t\u0004[\u0005e\u0014bAA>?\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAA\u0003E{f)\u0016(D?\"2\u0017.\u001a7eY\u0001\u001ax.\u001e:dK&\u0002S\u0006I#yiJ\f7\r^:!C\u0002\u0002\u0018M\u001d;!_\u001a\u0004C\u000f[3!I\u0006$Xm\f;j[\u0016\u001cH/Y7qA=\u0014\b%\u001b8uKJ4\u0018\r\u001c\u0011t_V\u00148-\u001a\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAD\u0003\t\u0005\"\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011gS\u0016dG\rI\u0017!g\u0016dWm\u0019;tA]D\u0017n\u00195!a\u0006\u0014H\u000fI8gAQDW\rI:pkJ\u001cW\rI:i_VdG\r\t2fA\u0015DHO]1di\u0016$G\u0006I1oI\u0002\u001aX\u000f\u001d9peR,G\rI:ue&tw\r\t<bYV,7\u000fI1sK\u0002\n7\u000fI:b[\u0016\u0004\u0013m\u001d\u0011uQ\u0016\u0004c-[3mIN\u0004sN\u001a\u0011uQ\u0016\u0004S-];jm\u0006dWM\u001c;!MVt7\r^5p]\u0002\u0002W\t\u0017+S\u0003\u000e#\u0006M\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!g>,(oY3![\u0001\n\u0007\u0005Z1uK>\"\u0018.\\3ti\u0006l\u0007\u000fI8sA%tG/\u001a:wC2\u00043m\u001c7v[:\u0004cM]8nA]DWM]3!A\u001aLW\r\u001c3aAMDw.\u001e7eA\t,\u0007%\u001a=ue\u0006\u001cG/\u001a3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u001b\u000bA\u0011\u0001\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oe+\u0015IU\u0014-AQKU*R*U\u00036\u0003\u0006e\n\u001a1cej\u0003\u0007O\u00172e\u0001\u0002\u0014G\u000f\u00191uA\u0002d&\r\u001a4iU2t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\n\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(o\u0016,7n\n\u0017!i&lWm\u001d;b[B<#\u0007M\u0019:[ABT&\r\u001a!aER\u0004\u0007\r\u001e1a9\n$g\r\u001b6m\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a4\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":Cm\\=(Y\u0001\"\u0015\tV#(eA\n\u0014(\f\u00199[E\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eI\"$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014T\u000b\u000e{e\nR*(Y\u0001\"\u0018.\\3ti\u0006l\u0007o\n\u001a1cej\u0013\u0007M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\nd\u0006\r\u00191aA\nt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c9\u0002\u0004\u0007\r\u00191c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005Z1zg\u001eb\u0003%\u001b8uKJ4\u0018\r\u001c\u00112Ae,\u0017M\u001d\u00112a\u0001jwN\u001c;ig\u0002*\u0004\u0005Z1zg&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM,7m\u001c8eg\u001eb\u0003%\u001b8uKJ4\u0018\r\u001c\u00116A!|WO]:!gA\u00023/Z2p]\u0012\u001c\b%\r\u0011nS2d\u0017n]3d_:$7\u000fI\u0019![&\u001c'o\\:fG>tGm]\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0002d\u0006\r\u00192aA\n$\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003'\u000b1M\u0003\u0011!A\u0001\"\u0006.\u001a\u0011`\rVs5i\u0018\u0011gk:\u001cG/[8oA%\u001c\b%Z9vSZ\fG.\u001a8uAQ|\u0007\u0005\u001e5fAM\u000bF*L:uC:$\u0017M\u001d3!MVt7\r^5p]\u0002\u0002W\t\u0017+S\u0003\u000e#\u0006FZ5fY\u0012\u0004cIU(NAM|WO]2fS\u0001T\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u00033\u000ba\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002 \u0006)1G\f\u0019/a!)!,\u0002a\u0001{!)a*\u0002a\u0001{!)A.\u0002a\u0001{\u00059QO\\1qa2LH\u0003BAV\u0003o\u0003R!MAW\u0003cK1!a,3\u0005\u0019y\u0005\u000f^5p]B1\u0011'a->{uJ1!!.3\u0005\u0019!V\u000f\u001d7fg!A\u0011\u0011\u0018\u0004\u0002\u0002\u0003\u0007a,A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0018\t\u0005\u0003o\t\t-\u0003\u0003\u0002D\u0006e\"AB(cU\u0016\u001cG\u000f")
public class DatePart
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(DatePart datePart) {
        return DatePart$.MODULE$.unapply(datePart);
    }

    public static Expression toEquivalentExpr(Expression expression, Expression expression2) {
        return DatePart$.MODULE$.toEquivalentExpr(expression, expression2);
    }

    public static Expression parseExtractField(String string, Expression expression, Function0<Nothing$> function0) {
        return DatePart$.MODULE$.parseExtractField(string, expression, function0);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        DatePart datePart = this;
        synchronized (datePart) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName()).append("(").append(this.field().sql()).append(", ").append(this.source().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "date_part";
    }

    public DatePart copy(Expression field, Expression source, Expression child) {
        return new DatePart(field, source, child);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "DatePart";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.field();
                break;
            }
            case 1: {
                expression = this.source();
                break;
            }
            case 2: {
                expression = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatePart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DatePart)) return false;
        boolean bl = true;
        if (!bl) return false;
        DatePart datePart = (DatePart)x$1;
        Expression expression = this.field();
        Expression expression2 = datePart.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = datePart.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.child();
        Expression expression6 = datePart.child();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!datePart.canEqual(this)) return false;
        return true;
    }

    public DatePart(Expression field, Expression source, Expression child) {
        this.field = field;
        this.source = source;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public DatePart(Expression field, Expression source) {
        this(field, source, DatePart$.MODULE$.toEquivalentExpr(field, source));
    }
}

