/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(keys, values) - Creates a map with a pair of the given key/value arrays. All elements\n      in keys should not be null", examples="\n    Examples:\n      > SELECT _FUNC_(array(1.0, 3.0), array('2', '4'));\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015)\u0007\u0001\"\u0011g\u0011!Q\u0007\u0001#b\u0001\n\u0013Y\u0007\"\u0002:\u0001\t\u0003\u001a\b\"B>\u0001\t\u0003b\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\n\u0003S\u0001\u0011\u0011!C\u0001\u0003WA\u0011\"!\r\u0001#\u0003%\t!a\r\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005M\u0002\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\ti\u0006AA\u0001\n\u0003\ty\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0001\u0002j!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000f\u0005\n\u0003\u007f\u0002\u0011\u0011!C\u0001\u0003\u0003C\u0011\"a#\u0001\u0003\u0003%\t%!$\b\u0013\u0005-f$!A\t\u0002\u00055f\u0001C\u000f\u001f\u0003\u0003E\t!a,\t\r\u0011;B\u0011AA_\u0011%\tylFA\u0001\n\u000b\n\t\rC\u0005\u0002D^\t\t\u0011\"!\u0002F\"I\u00111Z\f\u0002\u0002\u0013\u0005\u0015Q\u001a\u0005\n\u0003?<\u0012\u0011!C\u0005\u0003C\u0014Q\"T1q\rJ|W.\u0011:sCf\u001c(BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001a\u0003gM\u001d\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0013'\u0003\u00023=\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011AGO\u0005\u0003wU\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\ta\b\u0005\u0002.\u007f%\u0011\u0001I\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\r\u001eC\u0005CA\u0017\u0001\u0011\u0015aT\u00011\u0001?\u0011\u0015\u0011U\u00011\u0001?\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002\u0017B\u0019A\nV,\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001)+\u0003\u0019a$o\\8u}%\ta'\u0003\u0002Tk\u00059\u0001/Y2lC\u001e,\u0017BA+W\u0005\r\u0019V-\u001d\u0006\u0003'V\u0002\"\u0001W.\u000e\u0003eS!A\u0017\u0012\u0002\u000bQL\b/Z:\n\u0005qK&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012!\u0003!\tg.\u00197zg&\u001c\u0018B\u00013b\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u001d\u0004\"\u0001\u00175\n\u0005%L&aB'baRK\b/Z\u0001\u000b[\u0006\u0004()^5mI\u0016\u0014X#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=\u0004\u0013\u0001B;uS2L!!\u001d8\u0003)\u0005\u0013(/Y=CCN,G-T1q\u0005VLG\u000eZ3s\u00031qW\u000f\u001c7TC\u001a,WI^1m)\r!x/\u001f\t\u0003iUL!A^\u001b\u0003\u0007\u0005s\u0017\u0010C\u0003y\u0015\u0001\u0007A/\u0001\u0005lKf\f%O]1z\u0011\u0015Q(\u00021\u0001u\u0003)1\u0018\r\\;f\u0003J\u0014\u0018-_\u0001\nI><UM\\\"pI\u0016$R!`A\u0004\u0003#\u00012A`A\u0002\u001b\u0005y(bAA\u0001=\u000591m\u001c3fO\u0016t\u0017bAA\u0003\u007f\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\n-\u0001\r!a\u0003\u0002\u0007\r$\b\u0010E\u0002\u007f\u0003\u001bI1!a\u0004\u0000\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0005\f\u0001\u0004i\u0018AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00033\u0001B!a\u0007\u0002$9!\u0011QDA\u0010!\tqU'C\u0002\u0002\"U\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011k\u0005!1m\u001c9z)\u00151\u0015QFA\u0018\u0011\u001daT\u0002%AA\u0002yBqAQ\u0007\u0011\u0002\u0003\u0007a(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U\"f\u0001 \u00028-\u0012\u0011\u0011\b\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003%)hn\u00195fG.,GMC\u0002\u0002DU\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9%!\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0005\u0005\u0003\u0002R\u0005mSBAA*\u0015\u0011\t)&a\u0016\u0002\t1\fgn\u001a\u0006\u0003\u00033\nAA[1wC&!\u0011QEA*\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0007E\u00025\u0003GJ1!!\u001a6\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r!\u00181\u000e\u0005\n\u0003[\u0012\u0012\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA:!\u0015\t)(a\u001fu\u001b\t\t9HC\u0002\u0002zU\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti(a\u001e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0007\u000bI\tE\u00025\u0003\u000bK1!a\"6\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u001c\u0015\u0003\u0003\u0005\r\u0001^\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0015q\u0012\u0005\t\u0003[*\u0012\u0011!a\u0001i\"z\u0001!a%\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9\u000bE\u0002.\u0003+K1!a&\u001f\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!(\u0002\u0003\u000bQ\u0001\u0005\t\u0011!?\u001a+fjQ0)W\u0016L8\u000f\f\u0011wC2,Xm]\u0015![\u0001\u001a%/Z1uKN\u0004\u0013\rI7ba\u0002:\u0018\u000e\u001e5!C\u0002\u0002\u0018-\u001b:!_\u001a\u0004C\u000f[3!O&4XM\u001c\u0011lKf|c/\u00197vK\u0002\n'O]1zg:\u0002\u0013\t\u001c7!K2,W.\u001a8ug*\u0001\u0003\u0005\t\u0011!A%t\u0007e[3zg\u0002\u001a\bn\\;mI\u0002rw\u000e\u001e\u0011cK\u0002rW\u000f\u001c7\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a)\u0002G*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nd\u0006\r\u0017!g9\u0002\u0014\u0006\f\u0011beJ\f\u0017\u0010K\u00143O1\u0002s\u0005N\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u000230\r\u00181u\t\u0012$\u0005L\u001a/ai\u0012CGI?\u000bA\u0001\nQa]5oG\u0016\f#!!+\u0002\u000bIrCG\f\u0019\u0002\u001b5\u000b\u0007O\u0012:p[\u0006\u0013(/Y=t!\tisc\u0005\u0003\u0018\u0003cK\u0004cBAZ\u0003ssdHR\u0007\u0003\u0003kS1!a.6\u0003\u001d\u0011XO\u001c;j[\u0016LA!a/\u00026\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u00055\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005=\u0013!B1qa2LH#\u0002$\u0002H\u0006%\u0007\"\u0002\u001f\u001b\u0001\u0004q\u0004\"\u0002\"\u001b\u0001\u0004q\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001f\fY\u000eE\u00035\u0003#\f).C\u0002\u0002TV\u0012aa\u00149uS>t\u0007#\u0002\u001b\u0002Xzr\u0014bAAmk\t1A+\u001e9mKJB\u0001\"!8\u001c\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a9\u0011\t\u0005E\u0013Q]\u0005\u0005\u0003O\f\u0019F\u0001\u0004PE*,7\r\u001e")
public class MapFromArrays
extends BinaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(MapFromArrays mapFromArrays) {
        return MapFromArrays$.MODULE$.unapply(mapFromArrays);
    }

    public static Function1<Tuple2<Expression, Expression>, MapFromArrays> tupled() {
        return MapFromArrays$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MapFromArrays>> curried() {
        return MapFromArrays$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$, ArrayType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            typeCheckResult = defaultCheck;
        } else {
            DataType keyType = ((ArrayType)this.left().dataType()).elementType();
            typeCheckResult = TypeUtils$.MODULE$.checkForMapKeyType(keyType);
        }
        return typeCheckResult;
    }

    @Override
    public MapType dataType() {
        return new MapType(((ArrayType)this.left().dataType()).elementType(), ((ArrayType)this.right().dataType()).elementType(), ((ArrayType)this.right().dataType()).containsNull());
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        MapFromArrays mapFromArrays = this;
        synchronized (mapFromArrays) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object keyArray, Object valueArray) {
        ArrayData keyArrayData = (ArrayData)keyArray;
        ArrayData valueArrayData = (ArrayData)valueArray;
        return this.mapBuilder().from(keyArrayData.copy(), valueArrayData.copy());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(keyArrayData, valueArrayData) -> {
            String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
            return new StringBuilder(27).append(ev.value()).append(" = ").append(builderTerm).append(".from(").append((String)keyArrayData).append(".copy(), ").append((String)valueArrayData).append(".copy());").toString();
        });
    }

    @Override
    public String prettyName() {
        return "map_from_arrays";
    }

    public MapFromArrays copy(Expression left, Expression right) {
        return new MapFromArrays(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "MapFromArrays";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapFromArrays;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapFromArrays)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapFromArrays mapFromArrays = (MapFromArrays)x$1;
        Expression expression = this.left();
        Expression expression2 = mapFromArrays.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapFromArrays.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!mapFromArrays.canEqual(this)) return false;
        return true;
    }

    public MapFromArrays(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

