/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Reverse$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a reversed string or an array with reverse order of elements.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       LQS krapS\n      > SELECT _FUNC_(array(2, 1, 4, 3));\n       [3,4,1,2]\n  ", group="array_funcs", since="1.5.0", note="\n    Reverse logic for arrays is available since 2.4.0.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!)\u0001\t\u0001C\u0001\u0003\")A\t\u0001C!\u000b\")\u0001\f\u0001C!3\")Q\f\u0001C!=\"AA\r\u0001EC\u0002\u0013%Q\rC\u0003n\u0001\u0011\u0005c\u000eC\u0003}\u0001\u0011%Q\u0010C\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003SA\u0011\"a\u0010\u0001\u0003\u0003%\t%!\u0011\t\u0013\u0005E\u0003!!A\u0005\u0002\u0005M\u0003\"CA.\u0001\u0005\u0005I\u0011AA/\u0011%\t\u0019\u0007AA\u0001\n\u0003\n)\u0007C\u0005\u0002t\u0001\t\t\u0011\"\u0001\u0002v!I\u0011q\u0010\u0001\u0002\u0002\u0013\u0005\u0013\u0011Q\u0004\n\u0003Wc\u0012\u0011!E\u0001\u0003[3\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011q\u0016\u0005\u0007\u0001V!\t!!0\t\u0013\u0005}V#!A\u0005F\u0005\u0005\u0007\"CAb+\u0005\u0005I\u0011QAc\u0011%\tI-FA\u0001\n\u0003\u000bY\rC\u0005\u0002XV\t\t\u0011\"\u0003\u0002Z\n9!+\u001a<feN,'BA\u000f\u001f\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005}\u0001\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Qc&M\u001c\u0011\u0005-bS\"\u0001\u000f\n\u00055b\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005-z\u0013B\u0001\u0019\u001d\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$a\u0002)s_\u0012,8\r\u001e\t\u0003eaJ!!O\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003q\u0002\"aK\u001f\n\u0005yb\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDC\u0001\"D!\tY\u0003\u0001C\u0003;\u0007\u0001\u0007A(\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0012\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0005&\u0001\u0004=e>|GOP\u0005\u0002i%\u0011ajM\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!AT\u001a\u0011\u0005M3V\"\u0001+\u000b\u0005U\u0003\u0013!\u0002;za\u0016\u001c\u0018BA,U\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005Q\u0006CA*\\\u0013\taFK\u0001\u0005ECR\fG+\u001f9f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\ty&\r\u0005\u00023A&\u0011\u0011m\r\u0002\u0004\u0003:L\b\"B2\u0007\u0001\u0004y\u0016!B5oaV$\u0018!\u00033p%\u00164XM]:f+\u00051\u0007\u0003\u0002\u001ah?~K!\u0001[\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004FA\u0004k!\t\u00114.\u0003\u0002mg\tIAO]1og&,g\u000e^\u0001\nI><UM\\\"pI\u0016$2a\\;{!\t\u00018/D\u0001r\u0015\t\u0011H$A\u0004d_\u0012,w-\u001a8\n\u0005Q\f(\u0001C#yaJ\u001cu\u000eZ3\t\u000bYD\u0001\u0019A<\u0002\u0007\r$\b\u0010\u0005\u0002qq&\u0011\u00110\u001d\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015Y\b\u00021\u0001p\u0003\t)g/A\u0007tiJLgnZ\"pI\u0016<UM\u001c\u000b\u0006}\u00065\u0011q\u0002\t\u0004\u007f\u0006\u001da\u0002BA\u0001\u0003\u0007\u0001\"!S\u001a\n\u0007\u0005\u00151'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000b\u0019\u0004\"B>\n\u0001\u0004y\u0007BBA\t\u0013\u0001\u0007a0A\u0005dQ&dGMT1nK\u0006a\u0011M\u001d:bs\u000e{G-Z$f]R9a0a\u0006\u0002\u001a\u0005m\u0001\"\u0002<\u000b\u0001\u00049\b\"B>\u000b\u0001\u0004y\u0007BBA\t\u0015\u0001\u0007a0\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A`\u0001\u0005G>\u0004\u0018\u0010F\u0002C\u0003KAqA\u000f\u0007\u0011\u0002\u0003\u0007A(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-\"f\u0001\u001f\u0002.-\u0012\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003%)hn\u00195fG.,GMC\u0002\u0002:M\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti$a\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0003mC:<'BAA'\u0003\u0011Q\u0017M^1\n\t\u0005%\u0011qI\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00022AMA,\u0013\r\tIf\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004?\u0006}\u0003\"CA1!\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\r\t\u0006\u0003S\nygX\u0007\u0003\u0003WR1!!\u001c4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\nYG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA<\u0003{\u00022AMA=\u0013\r\tYh\r\u0002\b\u0005>|G.Z1o\u0011!\t\tGEA\u0001\u0002\u0004y\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002x\u0005\r\u0005\u0002CA1'\u0005\u0005\t\u0019A0)/\u0001\t9)!$\u0002\u0010\u0006M\u0015QSAM\u00037\u000by*!)\u0002&\u0006\u001d\u0006cA\u0016\u0002\n&\u0019\u00111\u0012\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011S\u0001V?\u001a+fjQ0)CJ\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t:fm\u0016\u00148/\u001a3!gR\u0014\u0018N\\4!_J\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I<ji\"\u0004#/\u001a<feN,\u0007e\u001c:eKJ\u0004sN\u001a\u0011fY\u0016lWM\u001c;t]\u0005AQ\r_1na2,7/\t\u0002\u0002\u0018\u0006\t\u0019A\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011M#N\u00033N]1q'*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\u0012D\u0006I\u0019-AQb\u0003eM\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6\u0007\f\u001b-c1\u0012TL\u0003\u0011!\u0003\u00159'o\\;qC\t\ti*A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAR\u0003\u0015\td&\u000e\u00181\u0003\u0011qw\u000e^3\"\u0005\u0005%\u0016A\u000f\u0006!A\u0001\u0002#+\u001a<feN,\u0007\u0005\\8hS\u000e\u0004cm\u001c:!CJ\u0014\u0018-_:!SN\u0004\u0013M^1jY\u0006\u0014G.\u001a\u0011tS:\u001cW\r\t\u001a/i9\u0002dF\u0003\u0011!\u0003\u001d\u0011VM^3sg\u0016\u0004\"aK\u000b\u0014\tU\t\tl\u000e\t\u0007\u0003g\u000bI\f\u0010\"\u000e\u0005\u0005U&bAA\\g\u00059!/\u001e8uS6,\u0017\u0002BA^\u0003k\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\ti+\u0001\u0005u_N#(/\u001b8h)\t\t\u0019%A\u0003baBd\u0017\u0010F\u0002C\u0003\u000fDQA\u000f\rA\u0002q\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002N\u0006M\u0007\u0003\u0002\u001a\u0002PrJ1!!54\u0005\u0019y\u0005\u000f^5p]\"A\u0011Q[\r\u0002\u0002\u0003\u0007!)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001c\t\u0005\u0003\u000b\ni.\u0003\u0003\u0002`\u0006\u001d#AB(cU\u0016\u001cG\u000f")
public class Reverse
extends UnaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient Function1<Object, Object> doReverse;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(Reverse reverse) {
        return Reverse$.MODULE$.unapply(reverse);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Reverse, A> function1) {
        return Reverse$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Reverse> compose(Function1<A, Expression> function1) {
        return Reverse$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, ArrayType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.doReverse().apply(input);
    }

    private Function1<Object, Object> doReverse$lzycompute() {
        Reverse reverse = this;
        synchronized (reverse) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        ArrayData arrayData = (ArrayData)input;
                        return new GenericArrayData(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(arrayData.toObjectArray(elementType))).reverse());
                    };
                } else if (StringType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$26 -> ((UTF8String)x$26).reverse();
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doReverse = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.doReverse;
    }

    private Function1<Object, Object> doReverse() {
        return !this.bitmap$trans$0 ? this.doReverse$lzycompute() : this.doReverse;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String string;
            DataType dataType = this.dataType();
            if (dataType instanceof StringType) {
                string = this.stringCodeGen(ev, (String)c);
            } else if (dataType instanceof ArrayType) {
                string = this.arrayCodeGen(ctx, ev, (String)c);
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    private String stringCodeGen(ExprCode ev, String childName) {
        return new StringBuilder(16).append(ev.value()).append(" = (").append(childName).append(").reverse();").toString();
    }

    private String arrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        DataType elementType = ((ArrayType)this.dataType()).elementType();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, childName, i, j, ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n       |final int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  int ").append(j).append(" = ").append(numElements).append(" - ").append(i).append(" - 1;\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "reverse";
    }

    public Reverse copy(Expression child) {
        return new Reverse(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Reverse";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Reverse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Reverse)) return false;
        boolean bl = true;
        if (!bl) return false;
        Reverse reverse = (Reverse)x$1;
        Expression expression = this.child();
        Expression expression2 = reverse.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!reverse.canEqual(this)) return false;
        return true;
    }

    public Reverse(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

