/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityGenerator;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToCsv$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a CSV string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       1,2\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       26/08/2015\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\tuc\u0001\u0002\u0015*\u0001ZB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\tA\u0002\u0011\t\u0012)A\u0005%\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003A\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B5\t\u000b5\u0004A\u0011\u00018\t\u000bM\u0004A\u0011\t;\t\u000b5\u0004A\u0011\u0001=\t\u000b5\u0004A\u0011A>\t\u000b5\u0004A\u0011A?\t\u0015\u0005\u0005\u0001\u0001#b\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\u001e\u0001A)\u0019!C\u0001\u0003?A!\"a\f\u0001\u0011\u000b\u0007I\u0011AA\u0019\u0011)\t\t\u0005\u0001EC\u0002\u0013\u0005\u00111\t\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\tY\u0007\u0001C!\u0003[Bq!!\u001d\u0001\t\u0003\n\u0019\bC\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003G\u0003\u0011\u0013!C\u0001\u0003KC\u0011\"a/\u0001#\u0003%\t!!0\t\u0013\u0005\u0005\u0007!%A\u0005\u0002\u0005\r\u0007\"CAd\u0001\u0005\u0005I\u0011IAe\u0011%\t)\u000eAA\u0001\n\u0003\t9\u000eC\u0005\u0002`\u0002\t\t\u0011\"\u0001\u0002b\"I\u0011q\u001d\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001e\u0005\n\u0003o\u0004\u0011\u0011!C\u0001\u0003sD\u0011\"!@\u0001\u0003\u0003%\t%a@\b\u0013\tu\u0011&!A\t\u0002\t}a\u0001\u0003\u0015*\u0003\u0003E\tA!\t\t\r5\u0004C\u0011\u0001B\u0018\u0011%\u0011\t\u0004IA\u0001\n\u000b\u0012\u0019\u0004C\u0005\u00036\u0001\n\t\u0011\"!\u00038!I!q\b\u0011\u0012\u0002\u0013\u0005\u00111\u0019\u0005\n\u0005\u0003\u0002\u0013\u0011!CA\u0005\u0007B\u0011B!\u0015!#\u0003%\t!a1\t\u0013\tM\u0003%!A\u0005\n\tU#\u0001D*ueV\u001cGo\u001d+p\u0007N4(B\u0001\u0016,\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00051j\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u000194H\u0010#H\u001bB\u0011\u0001(O\u0007\u0002S%\u0011!(\u000b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0001\bP\u0005\u0003{%\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005K\u0013aB2pI\u0016<WM\\\u0005\u0003\u0007\u0002\u0013qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003q\u0015K!AR\u0015\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0004Qe>$Wo\u0019;\u0011\u0005!s\u0015BA(J\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001dy\u0007\u000f^5p]N,\u0012A\u0015\t\u0005'jkVL\u0004\u0002U1B\u0011Q+S\u0007\u0002-*\u0011q+N\u0001\u0007yI|w\u000e\u001e \n\u0005eK\u0015A\u0002)sK\u0012,g-\u0003\u0002\\9\n\u0019Q*\u00199\u000b\u0005eK\u0005CA*_\u0013\tyFL\u0001\u0004TiJLgnZ\u0001\t_B$\u0018n\u001c8tA\u0005)1\r[5mIV\t1\r\u0005\u00029I&\u0011Q-\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012!\u001b\t\u0004\u0011*l\u0016BA6J\u0005\u0019y\u0005\u000f^5p]\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}Q!q\u000e]9s!\tA\u0004\u0001C\u0003Q\u000f\u0001\u0007!\u000bC\u0003b\u000f\u0001\u00071\rC\u0004h\u000fA\u0005\t\u0019A5\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u001e\t\u0003\u0011ZL!a^%\u0003\u000f\t{w\u000e\\3b]R\u0019q.\u001f>\t\u000bAK\u0001\u0019\u0001*\t\u000b\u0005L\u0001\u0019A2\u0015\u0005=d\b\"B1\u000b\u0001\u0004\u0019GcA8\u007f\u007f\")\u0011m\u0003a\u0001G\")\u0001k\u0003a\u0001G\u00061qO]5uKJ,\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0005\u0005=\u0019\u0005.\u0019:BeJ\f\u0017p\u0016:ji\u0016\u0014\bf\u0001\u0007\u0002\u0018A\u0019\u0001*!\u0007\n\u0007\u0005m\u0011JA\u0005ue\u0006t7/[3oi\u0006Y\u0011N\u001c9viN\u001b\u0007.Z7b+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9#L\u0001\u0006if\u0004Xm]\u0005\u0005\u0003W\t)C\u0001\u0006TiJ,8\r\u001e+za\u0016D3!DA\f\u0003\r9WM\\\u000b\u0003\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sY\u0013aA2tm&!\u0011QHA\u001c\u0005I)f.\u001b<pG&$\u0018pR3oKJ\fGo\u001c:)\u00079\t9\"A\u0005d_:4XM\u001d;feV\u0011\u0011Q\t\t\b\u0011\u0006\u001d\u00131JA)\u0013\r\tI%\u0013\u0002\n\rVt7\r^5p]F\u00022\u0001SA'\u0013\r\ty%\u0013\u0002\u0004\u0003:L\b\u0003BA*\u00037j!!!\u0016\u000b\t\u0005\u001d\u0012q\u000b\u0006\u0004\u00033z\u0013AB;og\u00064W-\u0003\u0003\u0002^\u0005U#AC+U\rb\u001aFO]5oO\"\u001aq\"a\u0006\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u001a\u0011\t\u0005\r\u0012qM\u0005\u0005\u0003S\n)C\u0001\u0005ECR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\rY\u0014q\u000e\u0005\u0006OF\u0001\r!X\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u0003\u0017\n)\bC\u0004\u0002xI\u0001\r!a\u0013\u0002\u000bY\fG.^3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002~A1\u0011qPAE\u0003\u001fsA!!!\u0002\u0006:\u0019Q+a!\n\u0003)K1!a\"J\u0003\u001d\u0001\u0018mY6bO\u0016LA!a#\u0002\u000e\n\u00191+Z9\u000b\u0007\u0005\u001d\u0015\n\u0005\u0003\u0002$\u0005E\u0015\u0002BAJ\u0003K\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001^\u0003\u0011\u0019w\u000e]=\u0015\u000f=\fi*a(\u0002\"\"9\u0001+\u0006I\u0001\u0002\u0004\u0011\u0006bB1\u0016!\u0003\u0005\ra\u0019\u0005\bOV\u0001\n\u00111\u0001j\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a*+\u0007I\u000bIk\u000b\u0002\u0002,B!\u0011QVA\\\u001b\t\tyK\u0003\u0003\u00022\u0006M\u0016!C;oG\",7m[3e\u0015\r\t),S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA]\u0003_\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a0+\u0007\r\fI+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015'fA5\u0002*\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a3\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fTA!!5\u0002\u000e\u0005!A.\u00198h\u0013\ry\u0016qZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\u00042\u0001SAn\u0013\r\ti.\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\n\u0019\u000fC\u0005\u0002fn\t\t\u00111\u0001\u0002Z\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a;\u0011\r\u00055\u00181_A&\u001b\t\tyOC\u0002\u0002r&\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)0a<\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004k\u0006m\b\"CAs;\u0005\u0005\t\u0019AA&\u0003\u0019)\u0017/^1mgR\u0019QO!\u0001\t\u0013\u0005\u0015h$!AA\u0002\u0005-\u0003f\u0004\u0001\u0003\u0006\t-!Q\u0002B\t\u0005'\u00119B!\u0007\u0011\u0007a\u00129!C\u0002\u0003\n%\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0010\u0005AuLR+O\u0007~CS\r\u001f9s72\u0002s\u000e\u001d;j_:\u001cX,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007eQ*WAM$(/\u001b8hA]LG\u000f\u001b\u0011bA\u001dLg/\u001a8!gR\u0014Xo\u0019;!m\u0006dW/Z\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QC\u0001\u0002B*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc.Y7fI~\u001bHO];di\":\u0013m\n\u0017!c1\u0002sEY\u0014-AIJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112YIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\\1nK\u0012|6\u000f\u001e:vGRDs\u0005^5nK\u001eb\u0003\u0005^8`i&lWm\u001d;b[BDsE\r\u00192k5\u0002\u0004(\f\u001a7O1\u0002s%_=zs6jU*\f3eO%JC\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012dg\f\u00199_I\u0002\u0014'\u000e\u0006!A\u0005)1/\u001b8dK\u0006\u0012!1D\u0001\u0006g9\u0002d\u0006M\u0001\r'R\u0014Xo\u0019;t)>\u001c5O\u001e\t\u0003q\u0001\u001aB\u0001\tB\u0012\u001bBA!Q\u0005B\u0016%\u000eLw.\u0004\u0002\u0003()\u0019!\u0011F%\u0002\u000fI,h\u000e^5nK&!!Q\u0006B\u0014\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005?\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0017\fQ!\u00199qYf$ra\u001cB\u001d\u0005w\u0011i\u0004C\u0003QG\u0001\u0007!\u000bC\u0003bG\u0001\u00071\rC\u0004hGA\u0005\t\u0019A5\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003F\t5\u0003\u0003\u0002%k\u0005\u000f\u0002b\u0001\u0013B%%\u000eL\u0017b\u0001B&\u0013\n1A+\u001e9mKNB\u0001Ba\u0014&\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B,!\u0011\tiM!\u0017\n\t\tm\u0013q\u001a\u0002\u0007\u001f\nTWm\u0019;")
public class StructsToCsv
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private transient CharArrayWriter writer;
    private transient StructType inputSchema;
    private transient UnivocityGenerator gen;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToCsv$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToCsv structsToCsv) {
        return StructsToCsv$.MODULE$.unapply(structsToCsv);
    }

    public static Option<String> apply$default$3() {
        return StructsToCsv$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToCsv> tupled() {
        return StructsToCsv$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToCsv>>> curried() {
        return StructsToCsv$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private StructType inputSchema$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                StructType structType;
                DataType dataType = this.child().dataType();
                if (!(dataType instanceof StructType)) {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unsupported input type ").append(dataType.catalogString()).toString());
                }
                StructType structType2 = structType = (StructType)dataType;
                this.inputSchema = structType2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputSchema;
    }

    public StructType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private UnivocityGenerator gen$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.gen = new UnivocityGenerator(this.inputSchema(), this.writer(), new CSVOptions(this.options(), true, (String)this.timeZoneId().get()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.gen;
    }

    public UnivocityGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.converter = (Function1 & Serializable & scala.Serializable)row -> UTF8String.fromString((String)this.gen().writeToString((InternalRow)row));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StructType$ structType$ = StructType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)structType$);
    }

    @Override
    public String prettyName() {
        return "to_csv";
    }

    public StructsToCsv copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToCsv(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToCsv";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToCsv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToCsv structsToCsv = (StructsToCsv)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToCsv.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToCsv.canEqual(this)) return false;
        return true;
    }

    public StructsToCsv(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StructsToCsv(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

