/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.GraphOps;
import org.apache.spark.graphx.LocalSparkContext;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.rdd.RDD;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0002\u0004\u0001\u001f!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00059!)\u0001\u0007\u0001C\u0005c!)A\u0007\u0001C\u0005k\tiqI]1qQ>\u00038oU;ji\u0016T!a\u0002\u0005\u0002\r\u001d\u0014\u0018\r\u001d5y\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011QCF\u0007\u0002\r%\u0011qC\u0002\u0002\u0012\u0019>\u001c\u0017\r\\*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001\u001b!\t)\u0002!A\u0007hKR\u001c\u0015p\u00197f\u000fJ\f\u0007\u000f\u001b\u000b\u0004;%r\u0003\u0003B\u000b\u001fA\u0019J!a\b\u0004\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0011{WO\u00197f!\t\ts%\u0003\u0002)E\t\u0019\u0011J\u001c;\t\u000b)\u0012\u0001\u0019A\u0016\u0002\u0005M\u001c\u0007CA\t-\u0013\ti\u0003B\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u00030\u0005\u0001\u0007a%A\u0006ok64VM\u001d;jG\u0016\u001c\u0018!D4fi\u000eC\u0017-\u001b8He\u0006\u0004\b\u000eF\u0002\u001eeMBQAK\u0002A\u0002-BQaL\u0002A\u0002\u0019\nqbZ3u\u000fJ\f\u0007\u000f\u001b$s_6\u001cV-\u001d\u000b\u0004;Y:\u0004\"\u0002\u0016\u0005\u0001\u0004Y\u0003\"\u0002\u001d\u0005\u0001\u0004I\u0014aA:fcB\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u000f\u0003\u0019a$o\\8u}%\t1%\u0003\u0002BE\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0006\u0003\u0003\n\u0002B!\t$'M%\u0011qI\t\u0002\u0007)V\u0004H.\u001a\u001a")
public class GraphOpsSuite
extends SparkFunSuite
implements LocalSparkContext {
    @Override
    public <T> T withSpark(Function1<SparkContext, T> f) {
        return (T)LocalSparkContext.withSpark$(this, f);
    }

    private Graph<Object, Object> getCycleGraph(SparkContext sc, int numVertices) {
        scala.collection.immutable.IndexedSeq cycle = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numVertices).map((Function1 & Serializable & scala.Serializable)x -> GraphOpsSuite.$anonfun$getCycleGraph$1(numVertices, BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        return this.getGraphFromSeq(sc, (IndexedSeq<Tuple2<Object, Object>>)cycle);
    }

    private Graph<Object, Object> getChainGraph(SparkContext sc, int numVertices) {
        scala.collection.immutable.IndexedSeq chain = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numVertices - 1).map((Function1 & Serializable & scala.Serializable)x -> GraphOpsSuite.$anonfun$getChainGraph$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        return this.getGraphFromSeq(sc, (IndexedSeq<Tuple2<Object, Object>>)chain);
    }

    private Graph<Object, Object> getGraphFromSeq(SparkContext sc, IndexedSeq<Tuple2<Object, Object>> seq) {
        RDD rawEdges = sc.parallelize(seq, 3, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int s = tuple2._1$mcI$sp();
            int d = tuple2._2$mcI$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)s, (long)d);
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Double()).cache();
    }

    public static final /* synthetic */ String $anonfun$new$3(long vid, String attr, int u) {
        return new StringBuilder(0).append(attr).append(u).toString();
    }

    public static final /* synthetic */ void $anonfun$new$5(GraphOpsSuite $this, SparkContext sc) {
        Graph<Object, Object> graph = $this.getCycleGraph(sc, 100);
        VertexRDD nbrs = (VertexRDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).collectNeighborIds(EdgeDirection$.MODULE$.Either()).cache();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)nbrs.count()));
        int $org_scalatest_assert_macro_right = 100;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).numVertices()));
        long $org_scalatest_assert_macro_right2 = nbrs.count();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nbrs.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long[] nbrs = (long[])tuple2._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(nbrs)).size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            return assertion;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nbrs.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Set s;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long vid = tuple2._1$mcJ$sp();
            long[] nbrs = (long[])tuple2._2();
            Set $org_scalatest_assert_macro_left = s = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(nbrs)).toSet();
            long $org_scalatest_assert_macro_right = (vid + 1L) % 100L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            Set $org_scalatest_assert_macro_left2 = s;
            long $org_scalatest_assert_macro_right2 = vid > 0L ? vid - 1L : 99L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            return assertion;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$11(Tuple2 x0$4) {
        long b;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long a = tuple2._1$mcJ$sp();
        boolean bl = a != (b = tuple2._2$mcJ$sp());
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$15(int x) {
        return new Tuple2.mcJI.sp((long)x, x);
    }

    public static final /* synthetic */ Edge $anonfun$new$16(int x) {
        return new Edge.mcI.sp(0L, (long)x, x);
    }

    public static final /* synthetic */ int $anonfun$new$18(long vid, int data, Option deg) {
        return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ void $anonfun$new$25(GraphOpsSuite $this, SparkContext sc) {
        Graph<Object, Object> graph = $this.getCycleGraph(sc, 100);
        VertexRDD edges = (VertexRDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).collectEdges(EdgeDirection$.MODULE$.Out()).cache();
        long $org_scalatest_assert_macro_left = edges.count();
        int $org_scalatest_assert_macro_right = 100;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Edge[] edges = (Edge[])tuple2._2();
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])edges);
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            return assertion;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Set edgeDstIds;
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long vid = tuple2._1$mcJ$sp();
            Edge[] edges = (Edge[])tuple2._2();
            Set s = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges)).toSet();
            Set $org_scalatest_assert_macro_left = edgeDstIds = (Set)s.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToLong((long)e.dstId()), Set$.MODULE$.canBuildFrom());
            long $org_scalatest_assert_macro_right = (vid + 1L) % 100L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            return assertion;
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(GraphOpsSuite $this, SparkContext sc) {
        Graph<Object, Object> graph = $this.getCycleGraph(sc, 100);
        VertexRDD edges = (VertexRDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).collectEdges(EdgeDirection$.MODULE$.In()).cache();
        long $org_scalatest_assert_macro_left = edges.count();
        int $org_scalatest_assert_macro_right = 100;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Edge[] edges = (Edge[])tuple2._2();
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])edges);
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            return assertion;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Set edgeSrcIds;
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long vid = tuple2._1$mcJ$sp();
            Edge[] edges = (Edge[])tuple2._2();
            Set s = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges)).toSet();
            Set $org_scalatest_assert_macro_left = edgeSrcIds = (Set)s.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToLong((long)e.srcId()), Set$.MODULE$.canBuildFrom());
            long $org_scalatest_assert_macro_right = vid > 0L ? vid - 1L : 99L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            return assertion;
        });
    }

    public static final /* synthetic */ long $anonfun$new$38(long vid$1, Edge e) {
        return vid$1 != e.srcId() ? e.srcId() : e.dstId();
    }

    public static final /* synthetic */ void $anonfun$new$35(GraphOpsSuite $this, SparkContext sc) {
        Graph<Object, Object> graph = $this.getCycleGraph(sc, 100);
        VertexRDD edges = (VertexRDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).collectEdges(EdgeDirection$.MODULE$.Either()).cache();
        long $org_scalatest_assert_macro_left = edges.count();
        int $org_scalatest_assert_macro_right = 100;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Edge[] edges = (Edge[])tuple2._2();
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])edges);
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            return assertion;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Set edgeIds;
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long vid = tuple2._1$mcJ$sp();
            Edge[] edges = (Edge[])tuple2._2();
            Set s = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges)).toSet();
            Set $org_scalatest_assert_macro_left = edgeIds = (Set)s.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToLong((long)GraphOpsSuite.$anonfun$new$38(vid, e)), Set$.MODULE$.canBuildFrom());
            long $org_scalatest_assert_macro_right = (vid + 1L) % 100L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Set $org_scalatest_assert_macro_left2 = edgeIds;
            long $org_scalatest_assert_macro_right2 = vid > 0L ? vid - 1L : 99L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            return assertion;
        });
    }

    public static final /* synthetic */ void $anonfun$new$40(GraphOpsSuite $this, SparkContext sc) {
        Graph<Object, Object> graph = $this.getChainGraph(sc, 50);
        VertexRDD edges = (VertexRDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).collectEdges(EdgeDirection$.MODULE$.Out()).cache();
        long $org_scalatest_assert_macro_left = edges.count();
        int $org_scalatest_assert_macro_right = 49;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
            Tuple2 tuple2 = x0$11;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Edge[] edges = (Edge[])tuple2._2();
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])edges);
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            return assertion;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Set edgeDstIds;
            Tuple2 tuple2 = x0$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long vid = tuple2._1$mcJ$sp();
            Edge[] edges = (Edge[])tuple2._2();
            Set s = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges)).toSet();
            Set $org_scalatest_assert_macro_left = edgeDstIds = (Set)s.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToLong((long)e.dstId()), Set$.MODULE$.canBuildFrom());
            long $org_scalatest_assert_macro_right = vid + 1L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            return assertion;
        });
    }

    public static final /* synthetic */ void $anonfun$new$45(GraphOpsSuite $this, SparkContext sc) {
        Graph<Object, Object> graph = $this.getChainGraph(sc, 50);
        VertexRDD edges = (VertexRDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).collectEdges(EdgeDirection$.MODULE$.In()).cache();
        long $org_scalatest_assert_macro_left = edges.count();
        int $org_scalatest_assert_macro_right = 49;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$13 -> {
            Tuple2 tuple2 = x0$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Edge[] edges = (Edge[])tuple2._2();
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])edges);
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            return assertion;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$14 -> {
            Set edgeDstIds;
            Tuple2 tuple2 = x0$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long vid = tuple2._1$mcJ$sp();
            Edge[] edges = (Edge[])tuple2._2();
            Set s = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges)).toSet();
            Set $org_scalatest_assert_macro_left = edgeDstIds = (Set)s.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToLong((long)e.srcId()), Set$.MODULE$.canBuildFrom());
            long $org_scalatest_assert_macro_right = (vid - 1L) % 100L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            return assertion;
        });
    }

    public static final /* synthetic */ long $anonfun$new$53(long vid$2, Edge e) {
        return vid$2 != e.srcId() ? e.srcId() : e.dstId();
    }

    public static final /* synthetic */ void $anonfun$new$50(GraphOpsSuite $this, SparkContext sc) {
        Graph<Object, Object> graph = $this.getChainGraph(sc, 50);
        VertexRDD edges = (VertexRDD)Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).collectEdges(EdgeDirection$.MODULE$.Either()).cache();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)edges.count()));
        int $org_scalatest_assert_macro_right = 50;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$15 -> {
            Assertion assertion;
            Tuple2 tuple2 = x0$15;
            if (tuple2 != null) {
                long vid = tuple2._1$mcJ$sp();
                Edge[] edges = (Edge[])tuple2._2();
                if (vid > 0L && vid < 49L) {
                    Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])edges);
                    int $org_scalatest_assert_macro_right = 2;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
                } else {
                    Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])edges);
                    int $org_scalatest_assert_macro_right = 1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Assertion assertion2 = assertion;
            return assertion2;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).foreach((Function1 & Serializable & scala.Serializable)x0$16 -> {
            Assertion assertion;
            Tuple2 tuple2 = x0$16;
            if (tuple2 != null) {
                long vid = tuple2._1$mcJ$sp();
                Edge[] edges = (Edge[])tuple2._2();
                Set s = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges)).toSet();
                Set edgeIds = (Set)s.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToLong((long)GraphOpsSuite.$anonfun$new$53(vid, e)), Set$.MODULE$.canBuildFrom());
                if (vid == 0L) {
                    Set $org_scalatest_assert_macro_left = edgeIds;
                    long $org_scalatest_assert_macro_right = 1L;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
                } else if (vid == 49L) {
                    Set $org_scalatest_assert_macro_left = edgeIds;
                    long $org_scalatest_assert_macro_right = 48L;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
                } else {
                    Set $org_scalatest_assert_macro_left = edgeIds;
                    long $org_scalatest_assert_macro_right = vid + 1L;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
                    Set $org_scalatest_assert_macro_left2 = edgeIds;
                    long $org_scalatest_assert_macro_right2 = vid - 1L;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                    assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Assertion assertion2 = assertion;
            return assertion2;
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$getCycleGraph$1(int numVertices$1, int x) {
        return new Tuple2.mcII.sp(x, (x + 1) % numVertices$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getChainGraph$1(int x) {
        return new Tuple2.mcII.sp(x, x + 1);
    }

    public GraphOpsSuite() {
        LocalSparkContext.$init$(this);
        this.test("joinVertices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            RDD vertices = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"one"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"two"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"three")})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD edges = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge(1L, 2L, (Object)"onetwo")})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class));
            Graph g = Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class));
            RDD tbl = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJI.sp(1L, 10), new Tuple2.mcJI.sp(2L, 20)})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Graph g1 = Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class)).joinVertices(tbl, (Function3 & Serializable & scala.Serializable)(vid, attr, u) -> GraphOpsSuite.$anonfun$new$3(BoxesRunTime.unboxToLong((Object)vid), attr, BoxesRunTime.unboxToInt((Object)u)), ClassTag$.MODULE$.Int());
            Set v = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])g1.vertices().collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(v);
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"one10"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"two20"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"three")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("collectNeighborIds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            GraphOpsSuite.$anonfun$new$5(this, sc);
            return BoxedUnit.UNIT;
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("removeSelfEdges", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            Tuple2[] edgeArray = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1))})).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int a = tuple2._1$mcI$sp();
                int b = tuple2._2$mcI$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)a, (long)b);
                return sp2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Set correctEdges = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edgeArray)).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)GraphOpsSuite.$anonfun$new$11(x0$4))))).toSet();
            Graph graph = Graph$.MODULE$.fromEdgeTuples(sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])edgeArray), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Int());
            Tuple2[] canonicalizedEdges = (Tuple2[])Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).removeSelfEdges().edges().map((Function1 & Serializable & scala.Serializable)e -> new Tuple2.mcJJ.sp(e.srcId(), e.dstId()), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])canonicalizedEdges)).toSet().size()));
            int $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])canonicalizedEdges)).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])canonicalizedEdges)).toSet());
            Set $org_scalatest_assert_macro_right2 = correctEdges;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            Set e2;
            int n = 5;
            RDD vertices = sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable & scala.Serializable)x -> GraphOpsSuite.$anonfun$new$15(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            RDD edges = sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).map((Function1 & Serializable & scala.Serializable)x -> GraphOpsSuite.$anonfun$new$16(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class));
            Graph graph2 = Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).cache();
            GraphOps qual$1 = Graph$.MODULE$.graphToGraphOps(graph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)graph -> {
                VertexRDD degrees = Graph$.MODULE$.graphToGraphOps(graph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).outDegrees();
                return graph.outerJoinVertices((RDD)degrees, (Function3 & Serializable & scala.Serializable)(vid, data, deg) -> BoxesRunTime.boxToInteger((int)GraphOpsSuite.$anonfun$new$18(BoxesRunTime.unboxToLong((Object)vid), BoxesRunTime.unboxToInt((Object)data), deg)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
            };
            JFunction2.mcZJI.sp & Serializable & scala.Serializable x$2 = (JFunction2.mcZJI.sp & Serializable & scala.Serializable)(vid, deg) -> deg > 0;
            Function1 x$3 = qual$1.filter$default$2();
            Graph filteredGraph = qual$1.filter((Function1)x$1, x$3, (Function2)x$2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).cache();
            Set v = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredGraph.vertices().collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(v);
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(0, 0)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Set $org_scalatest_assert_macro_left2 = e2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredGraph.edges().map((Function1 & Serializable & scala.Serializable)e -> new Edge.mcI.sp(e.srcId(), e.dstId(), e.attr$mcI$sp()), ClassTag$.MODULE$.apply(Edge.class)).collect())).toSet();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("convertToCanonicalEdges", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            RDD vertices = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"one"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"two"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"three")})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            RDD edges = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge.mcI.sp(1L, 2L, 1), new Edge.mcI.sp(2L, 1L, 1), new Edge.mcI.sp(3L, 2L, 2)})), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class));
            Graph g = Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
            GraphOps qual$2 = Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
            Function2 x$4 = qual$2.convertToCanonicalEdges$default$1();
            Graph g1 = qual$2.convertToCanonicalEdges(x$4);
            Set e = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])g1.edges().collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e);
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge.mcI.sp(1L, 2L, 1), new Edge.mcI.sp(2L, 3L, 2)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("collectEdgesCycleDirectionOut", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            GraphOpsSuite.$anonfun$new$25(this, sc);
            return BoxedUnit.UNIT;
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("collectEdgesCycleDirectionIn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            GraphOpsSuite.$anonfun$new$30(this, sc);
            return BoxedUnit.UNIT;
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("collectEdgesCycleDirectionEither", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            GraphOpsSuite.$anonfun$new$35(this, sc);
            return BoxedUnit.UNIT;
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("collectEdgesChainDirectionOut", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            GraphOpsSuite.$anonfun$new$40(this, sc);
            return BoxedUnit.UNIT;
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("collectEdgesChainDirectionIn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            GraphOpsSuite.$anonfun$new$45(this, sc);
            return BoxedUnit.UNIT;
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("collectEdgesChainDirectionEither", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            GraphOpsSuite.$anonfun$new$50(this, sc);
            return BoxedUnit.UNIT;
        }), new Position("GraphOpsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
    }
}

