/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.hive.test.HiveTestJars$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.test.ProcessTestUtils;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001\u0002\n\u0014\u0001\u0001BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004@\u0001\u0001\u0006Ia\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u00017\u0011\u0019\t\u0005\u0001)A\u0005o!9!\t\u0001b\u0001\n\u00031\u0004BB\"\u0001A\u0003%q\u0007C\u0004E\u0001\t\u0007I\u0011\u0001\u001c\t\r\u0015\u0003\u0001\u0015!\u00038\u0011\u00151\u0005\u0001\"\u0011H\u0011\u0015q\u0005\u0001\"\u0011H\u0011\u0015y\u0005\u0001\"\u0001Q\u0011%\t\t\u0002AI\u0001\n\u0003\t\u0019\u0002C\u0005\u0002*\u0001\t\n\u0011\"\u0001\u0002\u0014!I\u00111\u0006\u0001\u0012\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u0003gA\u0011\"a\u000e\u0001#\u0003%\t!!\u000f\u0003\u0011\rc\u0017nU;ji\u0016T!\u0001F\u000b\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005Y9\u0012\u0001\u00025jm\u0016T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0011&WA\u0011!eI\u0007\u00023%\u0011A%\u0007\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!j\u0012!C:dC2\fG/Z:u\u0013\tQsEA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\u0004\"\u0001L\u0018\u000e\u00035R!AL\r\u0002\u0011%tG/\u001a:oC2L!\u0001M\u0017\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\r\t\u0003i\u0001i\u0011aE\u0001\u000eo\u0006\u0014X\r[8vg\u0016\u0004\u0016\r\u001e5\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u0005%|'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012AAR5mK\u0006qq/\u0019:fQ>,8/\u001a)bi\"\u0004\u0013!D7fi\u0006\u001cHo\u001c:f!\u0006$\b.\u0001\bnKR\f7\u000f^8sKB\u000bG\u000f\u001b\u0011\u0002\u001dM\u001c'/\u0019;dQ\u0012K'\u000fU1uQ\u0006y1o\u0019:bi\u000eDG)\u001b:QCRD\u0007%A\tta\u0006\u00148nV1sK\"{Wo]3ESJ\f!c\u001d9be.<\u0016M]3I_V\u001cX\rR5sA\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n!QK\\5u\u0003!\tg\r^3s\u00032d\u0017\u0001\u0004:v]\u000ec\u0017nV5uQ&tG#C)f_jd\u00181AA\u0007)\tA%\u000bC\u0003T\u0019\u0001\u0007A+A\rrk\u0016\u0014\u0018.Z:B]\u0012,\u0005\u0010]3di\u0016$\u0017I\\:xKJ\u001c\bcA%V/&\u0011aK\u0013\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003B%Y5jK!!\u0017&\u0003\rQ+\b\u000f\\33!\tY&M\u0004\u0002]AB\u0011QLS\u0007\u0002=*\u0011qlH\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005T\u0015A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!\u0019&\t\u000b\u0019d\u0001\u0019A4\u0002\u000fQLW.Z8viB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\tIV\u0014\u0018\r^5p]*\u0011ANS\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00018j\u000591\u0015N\\5uK\u0012+(/\u0019;j_:Dq\u0001\u001d\u0007\u0011\u0002\u0003\u0007\u0011/A\u0005fqR\u0014\u0018-\u0011:hgB\u0019!o\u001e.\u000f\u0005M,hBA/u\u0013\u0005Y\u0015B\u0001<K\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001_=\u0003\u0007M+\u0017O\u0003\u0002w\u0015\"91\u0010\u0004I\u0001\u0002\u0004\t\u0018AD3se>\u0014(+Z:q_:\u001cXm\u001d\u0005\b{2\u0001\n\u00111\u0001\u007f\u00039i\u0017-\u001f2f/\u0006\u0014X\r[8vg\u0016\u00042!S@8\u0013\r\t\tA\u0013\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\u0015A\u0002%AA\u0002\u0005\u001d\u0011aE;tK\u0016CH/\u001a:oC2D\u0015N^3GS2,\u0007cA%\u0002\n%\u0019\u00111\u0002&\u0003\u000f\t{w\u000e\\3b]\"A\u0011q\u0002\u0007\u0011\u0002\u0003\u0007q'A\u0005nKR\f7\u000f^8sK\u00061\"/\u001e8DY&<\u0016\u000e\u001e5j]\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0016)\u001a\u0011/a\u0006,\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\tK\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\tiBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faC];o\u00072Lw+\u001b;iS:$C-\u001a4bk2$HeM\u0001\u0017eVt7\t\\5XSRD\u0017N\u001c\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0006\u0016\u0004}\u0006]\u0011A\u0006:v]\u000ec\u0017nV5uQ&tG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005U\"\u0006BA\u0004\u0003/\taC];o\u00072Lw+\u001b;iS:$C-\u001a4bk2$HEN\u000b\u0003\u0003wQ3aNA\f\u0001")
public class CliSuite
extends SparkFunSuite {
    private final File warehousePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
    private final File metastorePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
    private final File scratchDirPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
    private final File sparkWareHouseDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());

    public File warehousePath() {
        return this.warehousePath;
    }

    public File metastorePath() {
        return this.metastorePath;
    }

    public File scratchDirPath() {
        return this.scratchDirPath;
    }

    public File sparkWareHouseDir() {
        return this.sparkWareHouseDir;
    }

    public void beforeAll() {
        super.beforeAll();
        this.warehousePath().delete();
        this.metastorePath().delete();
        this.scratchDirPath().delete();
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.warehousePath());
            Utils$.MODULE$.deleteRecursively(this.metastorePath());
            Utils$.MODULE$.deleteRecursively(this.scratchDirPath());
        }
        finally {
            super.afterAll();
        }
    }

    public void runCliWithin(FiniteDuration timeout, Seq<String> extraArgs, Seq<String> errorResponses, Option<File> maybeWarehouse, boolean useExternalHiveFile, File metastore, Seq<Tuple2<String, String>> queriesAndExpectedAnswers) {
        String queriesString = ((TraversableOnce)queriesAndExpectedAnswers.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1._1()).append("\n").toString(), Seq$.MODULE$.canBuildFrom())).mkString();
        Seq expectedAnswers = (Seq)queriesAndExpectedAnswers.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String query = (String)tuple2._1();
                String answer = (String)tuple2._2();
                String string = query;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{answer}));
                } else {
                    List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.split("\n"))).toList();
                    if (!(list instanceof .colon.colon)) {
                        throw new MatchError((Object)list);
                    }
                    .colon.colon colon2 = (.colon.colon)list;
                    String firstLine = (String)colon2.head();
                    List tail = colon2.tl$access$1();
                    String string3 = new StringBuilder(11).append("spark-sql> ").append(firstLine).toString();
                    List list2 = ((List)tail.map((Function1 & Serializable & scala.Serializable)l -> new StringBuilder(11).append("         > ").append((String)l).toString(), List$.MODULE$.canBuildFrom())).$colon$colon((Object)string3);
                    List queryEcho = list2;
                    seq = (Seq)((SeqLike)queryEcho.map((Function1 & Serializable & scala.Serializable)x$3 -> (String)new StringOps(Predef$.MODULE$.augmentString(x$3)).take(60), List$.MODULE$.canBuildFrom())).$colon$plus((Object)answer, List$.MODULE$.canBuildFrom());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Seq seq2 = seq;
            return seq2;
        }, Seq$.MODULE$.canBuildFrom());
        String extraHive = useExternalHiveFile ? new StringBuilder(41).append("--driver-class-path ").append(System.getProperty("user.dir")).append("/src/test/noclasspath").toString() : "";
        String warehouseConf = (String)maybeWarehouse.map((Function1 & Serializable & scala.Serializable)dir -> new StringBuilder(12).append("--hiveconf ").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(dir).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String cliScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../../bin/spark-sql".split("/"))).mkString(File.separator);
        String jdbcUrl = new StringBuilder(37).append("jdbc:derby:;databaseName=").append(metastore).append(";create=true").toString();
        Seq command = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(287).append(cliScript).append("\n         |  --master local\n         |  --driver-java-options -Dderby.system.durability=test\n         |  ").append(extraHive).append("\n         |  --conf spark.ui.enabled=false\n         |  --hiveconf ").append(HiveConf.ConfVars.METASTORECONNECTURLKEY).append("=").append(jdbcUrl).append("\n         |  --hiveconf ").append(HiveConf.ConfVars.SCRATCHDIR).append("=").append(this.scratchDirPath()).append("\n         |  --hiveconf conf1=conftest\n         |  --hiveconf conf2=1\n         |  ").append(warehouseConf).append("\n       ").toString())).stripMargin().split("\\s+"))).toSeq().$plus$plus(extraArgs, Seq$.MODULE$.canBuildFrom());
        IntRef next = IntRef.create((int)0);
        Promise foundAllExpectedAnswers = Promise$.MODULE$.apply();
        ArrayBuffer buffer = new ArrayBuffer();
        Object lock = new Object();
        Process process = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).start();
        OutputStreamWriter stdinWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
        stdinWriter.write(queriesString);
        stdinWriter.flush();
        stdinWriter.close();
        new ProcessTestUtils.ProcessOutputCapturer(process.getInputStream(), (Function1 & Serializable & scala.Serializable)line -> {
            this.captureOutput$1("stdout", line, lock, buffer, next, expectedAnswers, foundAllExpectedAnswers, errorResponses);
            return BoxedUnit.UNIT;
        }).start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getErrorStream(), (Function1 & Serializable & scala.Serializable)line -> {
            this.captureOutput$1("stderr", line, lock, buffer, next, expectedAnswers, foundAllExpectedAnswers, errorResponses);
            return BoxedUnit.UNIT;
        }).start();
        try {
            try {
                ThreadUtils$.MODULE$.awaitResult((Awaitable)foundAllExpectedAnswers.future(), (Duration)timeout);
                this.log().info("Found all expected output.");
            }
            catch (Throwable cause) {
                String message = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(392).append("\n           |=======================\n           |CliSuite failure output\n           |=======================\n           |Spark SQL CLI command line: ").append(command.mkString(" ")).append("\n           |Exception: ").append(cause).append("\n           |Failed to capture next expected output \"").append(expectedAnswers.apply(next.elem)).append("\" within ").append(timeout).append(".\n           |\n           |").append(buffer.mkString("\n")).append("\n           |===========================\n           |End CliSuite failure output\n           |===========================\n         ").toString())).stripMargin();
                this.logError((Function0 & Serializable & scala.Serializable)() -> message, cause);
                throw this.fail(message, cause, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            }
        }
        finally {
            if (!process.waitFor(1L, TimeUnit.MINUTES)) {
                try {
                    throw this.fail("spark-sql did not exit gracefully.", new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
                }
                catch (Throwable throwable) {
                    process.destroy();
                    throw throwable;
                }
            }
        }
    }

    public Seq<String> runCliWithin$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Seq<String> runCliWithin$default$3() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:"}));
    }

    public Option<File> runCliWithin$default$4() {
        return new Some((Object)this.warehousePath());
    }

    public boolean runCliWithin$default$5() {
        return false;
    }

    public File runCliWithin$default$6() {
        return this.metastorePath();
    }

    private final void captureOutput$1(String source, String line, Object lock$1, ArrayBuffer buffer$1, IntRef next$1, Seq expectedAnswers$1, Promise foundAllExpectedAnswers$1, Seq errorResponses$1) {
        Object object = lock$1;
        synchronized (object) {
            Object object2;
            String newLine = new StringBuilder(5).append(new Timestamp(new Date().getTime())).append(" - ").append(source).append("> ").append(line).toString();
            this.log().info(newLine);
            buffer$1.$plus$eq((Object)newLine);
            if (next$1.elem < expectedAnswers$1.size() && line.contains((CharSequence)expectedAnswers$1.apply(next$1.elem))) {
                this.log().info(new StringBuilder(33).append(source).append("> found expected output line ").append(next$1.elem).append(": '").append(expectedAnswers$1.apply(next$1.elem)).append("'").toString());
                ++next$1.elem;
                object2 = next$1.elem == expectedAnswers$1.size() ? BoxesRunTime.boxToBoolean((boolean)foundAllExpectedAnswers$1.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
            } else {
                errorResponses$1.foreach((Function1 & Serializable & scala.Serializable)r -> line.contains((CharSequence)r) ? BoxesRunTime.boxToBoolean((boolean)foundAllExpectedAnswers$1.tryFailure((Throwable)new RuntimeException(new StringBuilder(25).append("Failed with error line '").append(line).append("'").toString()))) : BoxedUnit.UNIT);
                object2 = BoxedUnit.UNIT;
            }
        }
    }

    public CliSuite() {
        this.test("load warehouse dir from hive-site.xml", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File metastore = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            metastore.delete();
            try {
                FiniteDuration x$1 = new package.DurationInt(package$.MODULE$.DurationInt(1)).minute();
                None$ x$2 = None$.MODULE$;
                boolean x$3 = true;
                File x$4 = metastore;
                Seq<String> x$5 = this.runCliWithin$default$2();
                Seq<String> x$6 = this.runCliWithin$default$3();
                Tuple2 x$7 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)"hive_one");
                Tuple2 x$8 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set spark.sql.warehouse.dir;"), (Object)"hive_one");
                this.runCliWithin(x$1, x$5, x$6, (Option<File>)x$2, x$3, x$4, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$7, x$8}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(metastore);
            }
            return boxedUnit;
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        this.test("load warehouse dir from --hiveconf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FiniteDuration x$9 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
            boolean x$10 = true;
            Seq<String> x$11 = this.runCliWithin$default$2();
            Seq<String> x$12 = this.runCliWithin$default$3();
            Option<File> x$13 = this.runCliWithin$default$4();
            File x$14 = this.runCliWithin$default$6();
            Tuple2 x$15 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)this.warehousePath().getAbsolutePath());
            Tuple2 x$16 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create database cliTestDb;"), (Object)"");
            Tuple2 x$17 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database cliTestDb;"), (Object)this.warehousePath().getAbsolutePath());
            Tuple2 x$18 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set spark.sql.warehouse.dir;"), (Object)this.warehousePath().getAbsolutePath());
            this.runCliWithin(x$9, x$11, x$12, x$13, x$10, x$14, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$15, x$16, x$17, x$18}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("load warehouse dir from --conf spark(.hadoop).hive.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File metastore = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            metastore.delete();
            try {
                FiniteDuration x$19 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
                Seq x$20 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--conf", new StringBuilder(14).append("spark.hadoop.").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.sparkWareHouseDir()).toString()}));
                None$ x$21 = None$.MODULE$;
                boolean x$22 = true;
                File x$23 = metastore;
                Seq<String> x$24 = this.runCliWithin$default$3();
                Tuple2 x$25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                Tuple2 x$26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create database cliTestDb;"), (Object)"");
                Tuple2 x$27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database cliTestDb;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                Tuple2 x$28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set spark.sql.warehouse.dir;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                this.runCliWithin(x$19, (Seq<String>)x$20, x$24, (Option<File>)x$21, x$22, x$23, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$25, x$26, x$27, x$28}));
                FiniteDuration x$29 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
                Seq x$30 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--conf", new StringBuilder(7).append("spark.").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.sparkWareHouseDir()).toString()}));
                File x$31 = metastore;
                Seq<String> x$32 = this.runCliWithin$default$3();
                Option<File> x$33 = this.runCliWithin$default$4();
                boolean x$34 = this.runCliWithin$default$5();
                Tuple2 x$35 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                Tuple2 x$36 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create database cliTestDb;"), (Object)"");
                Tuple2 x$37 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database cliTestDb;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                Tuple2 x$38 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"set spark.sql.warehouse.dir;"), (Object)this.sparkWareHouseDir().getAbsolutePath());
                this.runCliWithin(x$29, (Seq<String>)x$30, x$32, x$33, x$34, x$31, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x$35, x$36, x$37, x$38}));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(metastore);
            }
            return boxedUnit;
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("load warehouse dir from spark.sql.warehouse.dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            File metastore = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            metastore.delete();
            try {
                FiniteDuration x$39 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
                Seq x$40 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--conf", new StringBuilder(2).append(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()).append("=").append(this.sparkWareHouseDir()).append("1").toString(), "--conf", new StringBuilder(15).append("spark.hadoop.").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.sparkWareHouseDir()).append("2").toString()}));
                File x$41 = metastore;
                Seq<String> x$42 = this.runCliWithin$default$3();
                Option<File> x$43 = this.runCliWithin$default$4();
                boolean x$44 = this.runCliWithin$default$5();
                Seq x$45 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"desc database default;"), (Object)this.sparkWareHouseDir().getAbsolutePath().concat("1"))}));
                this.runCliWithin(x$39, (Seq<String>)x$40, x$42, x$43, x$44, x$41, (Seq<Tuple2<String, String>>)x$45);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(metastore);
            }
            return boxedUnit;
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        this.test("Simple commands", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE hive_test(key INT, val STRING) USING hive;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SHOW TABLES;"), (Object)"hive_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("LOAD DATA LOCAL INPATH '").append(dataFilePath).append("'\n         |OVERWRITE INTO TABLE hive_test;").toString())).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CACHE TABLE hive_test;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT COUNT(*) FROM hive_test;"), (Object)"5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE hive_test;"), (Object)"")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("Single command with -e", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-e", "SHOW DATABASES;"}))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        this.test("Single command with --database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE DATABASE hive_db_test;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"USE hive_db_test;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE hive_table_test(key INT, val STRING);"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SHOW TABLES;"), (Object)"hive_table_test")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--database", "hive_db_test", "-e", "SHOW TABLES;"}))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"hive_table_test")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        this.test("Commands using SerDe provided in --jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarFile = HiveTestJars$.MODULE$.getHiveHcatalogCoreJar(HiveTestJars$.MODULE$.getHiveHcatalogCoreJar$default$1()).getCanonicalPath();
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--jars", String.valueOf(jarFile)}))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE t1(key string, val string)\n        |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe';")).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE sourceTable (key INT, val STRING) USING hive;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("LOAD DATA LOCAL INPATH '").append(dataFilePath).append("'\n         |OVERWRITE INTO TABLE sourceTable;").toString())).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INSERT INTO TABLE t1 SELECT key, val FROM sourceTable;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT collect_list(array(val)) FROM t1;"), (Object)"[[\"val_238\"],[\"val_86\"],[\"val_311\"],[\"val_27\"],[\"val_165\"]]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE t1;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE sourceTable;"), (Object)"")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        this.test("SPARK-29022: Commands using SerDe provided in --hive.aux.jars.path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            String hiveContribJar = HiveTestJars$.MODULE$.getHiveHcatalogCoreJar(HiveTestJars$.MODULE$.getHiveHcatalogCoreJar$default$1()).getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--conf", new StringBuilder(14).append("spark.hadoop.").append(HiveConf.ConfVars.HIVEAUXJARS).append("=").append(hiveContribJar).toString()}))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE addJarWithHiveAux(key string, val string)\n        |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe';")).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE sourceTableForWithHiveAux (key INT, val STRING) USING hive;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(83).append("LOAD DATA LOCAL INPATH '").append(dataFilePath).append("'\n         |OVERWRITE INTO TABLE sourceTableForWithHiveAux;").toString())).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INSERT INTO TABLE addJarWithHiveAux SELECT key, val FROM sourceTableForWithHiveAux;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT collect_list(array(val)) FROM addJarWithHiveAux;"), (Object)"[[\"val_238\"],[\"val_86\"],[\"val_311\"],[\"val_27\"],[\"val_165\"]]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE addJarWithHiveAux;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE sourceTableForWithHiveAux;"), (Object)"")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("SPARK-11188 Analysis error reporting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FiniteDuration x$46 = new package.DurationInt(package$.MODULE$.DurationInt(2)).minute();
            Seq x$47 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AnalysisException"}));
            Seq<String> x$48 = this.runCliWithin$default$2();
            Option<File> x$49 = this.runCliWithin$default$4();
            boolean x$50 = this.runCliWithin$default$5();
            File x$51 = this.runCliWithin$default$6();
            Seq x$52 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select * from nonexistent_table;"), (Object)"Error in query: Table or view not found: nonexistent_table;")}));
            this.runCliWithin(x$46, x$48, (Seq<String>)x$47, x$49, x$50, x$51, (Seq<Tuple2<String, String>>)x$52);
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("SPARK-11624 Spark SQL CLI should set sessionState only once", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-e", "!echo \"This is a test for Spark-11624\";"}))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"This is a test for Spark-11624")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("list jars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL jarFile = Thread.currentThread().getContextClassLoader().getResource("TestUDTF.jar");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("ADD JAR ").append(jarFile).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LIST JARS;"), (Object)"TestUDTF.jar")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        this.test("list jar <jarfile>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL jarFile = Thread.currentThread().getContextClassLoader().getResource("TestUDTF.jar");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("ADD JAR ").append(jarFile).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(10).append("List JAR ").append(jarFile).append(";").toString()), (Object)"TestUDTF.jar")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        this.test("list files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(10).append("ADD FILE ").append(dataFilePath).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LIST FILES;"), (Object)"small_kv.txt")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        this.test("list file <filepath>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(10).append("ADD FILE ").append(dataFilePath).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(11).append("LIST FILE ").append(dataFilePath).append(";").toString()), (Object)"small_kv.txt")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        this.test("apply hiveconf from cli command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET conf1;"), (Object)"conftest"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET conf2;"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET conf3=${hiveconf:conf1};"), (Object)"conftest"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SET conf3;"), (Object)"conftest")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        this.test("Support hive.aux.jars.path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String hiveContribJar = HiveTestJars$.MODULE$.getHiveContribJar(HiveTestJars$.MODULE$.getHiveContribJar$default$1()).getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--conf", new StringBuilder(14).append("spark.hadoop.").append(HiveConf.ConfVars.HIVEAUXJARS).append("=").append(hiveContribJar).toString()}))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY FUNCTION example_format AS 'org.apache.hadoop.hive.contrib.udf.example.UDFExampleFormat';"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT example_format('%o', 93);"), (Object)"135")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        this.test("SPARK-28840 test --jars command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarFile = new File("../../sql/hive/src/test/resources/SPARK-21101-1.0.jar").getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--jars", String.valueOf(jarFile)}))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY FUNCTION testjar AS 'org.apache.spark.sql.hive.execution.UDTFStack';"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT testjar(1,'TEST-SPARK-TEST-jar', 28840);"), (Object)"TEST-SPARK-TEST-jar\t28840")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        this.test("SPARK-28840 test --jars and hive.aux.jars.path command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String jarFile = new File("../../sql/hive/src/test/resources/SPARK-21101-1.0.jar").getCanonicalPath();
            String hiveContribJar = HiveTestJars$.MODULE$.getHiveContribJar(HiveTestJars$.MODULE$.getHiveContribJar$default$1()).getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--jars", String.valueOf(jarFile), "--conf", new StringBuilder(14).append("spark.hadoop.").append(HiveConf.ConfVars.HIVEAUXJARS).append("=").append(hiveContribJar).toString()}))), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY FUNCTION testjar AS 'org.apache.spark.sql.hive.execution.UDTFStack';"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT testjar(1,'TEST-SPARK-TEST-jar', 28840);"), (Object)"TEST-SPARK-TEST-jar\t28840"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TEMPORARY FUNCTION example_max AS 'org.apache.hadoop.hive.contrib.udaf.example.UDAFExampleMax';"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT concat_ws(',', 'First', example_max(1234321), 'Third');"), (Object)"First,1234321,Third")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
        this.test("SPARK-29022 Commands using SerDe provided in ADD JAR sql", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL dataFilePath = Thread.currentThread().getContextClassLoader().getResource("data/files/small_kv.txt");
            String hiveContribJar = HiveTestJars$.MODULE$.getHiveHcatalogCoreJar(HiveTestJars$.MODULE$.getHiveHcatalogCoreJar$default$1()).getCanonicalPath();
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append("ADD JAR ").append(hiveContribJar).append(";").toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE addJarWithSQL(key string, val string)\n        |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe';")).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CREATE TABLE sourceTableForWithSQL(key INT, val STRING) USING hive;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("LOAD DATA LOCAL INPATH '").append(dataFilePath).append("'\n         |OVERWRITE INTO TABLE sourceTableForWithSQL;").toString())).stripMargin()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INSERT INTO TABLE addJarWithSQL SELECT key, val FROM sourceTableForWithSQL;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT collect_list(array(val)) FROM addJarWithSQL;"), (Object)"[[\"val_238\"],[\"val_86\"],[\"val_311\"],[\"val_27\"],[\"val_165\"]]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE addJarWithSQL;"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DROP TABLE sourceTableForWithSQL;"), (Object)"")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        this.test("SPARK-26321 Should not split semicolon within quoted string literals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(3)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select 'Test1', \"^;^\";"), (Object)"Test1\t^;^"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select 'Test2', \"\\\";\";"), (Object)"Test2\t\";"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select 'Test3', \"\\';\";"), (Object)"Test3\t';"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"select concat('Test4', ';');"), (Object)"Test4;")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        this.test("Pad Decimal numbers with trailing zeros to the scale of the column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SELECT CAST(1 AS DECIMAL(38, 18));"), (Object)"1.000000000000000000")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        this.test("SPARK-30049 Should not complain for quotes in commented lines", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT concat('test', 'comment') -- someone's comment here\n        |;")).stripMargin()), (Object)"testcomment")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        this.test("SPARK-31102 spark-sql fails to parse when contains comment", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT concat('test', 'comment'),\n        |    -- someone's comment here\n        | 2;")).stripMargin()), (Object)"testcomment")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
        this.test("SPARK-30049 Should not complain for quotes in commented with multi-lines", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT concat('test', 'comment') -- someone's comment here \\\n        | comment continues here with single ' quote \\\n        | extra ' \\\n        |;")).stripMargin()), (Object)"testcomment")})), new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        this.test("SPARK-31595 Should allow unescaped quote mark in quoted string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT '\"legal string a';select 1 + 234;")).stripMargin()), (Object)"235")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), this.runCliWithin$default$2(), this.runCliWithin$default$3(), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("SELECT \"legal 'string b\";select 22222 + 1;")).stripMargin()), (Object)"22223")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
        this.test("AnalysisException with root cause will be printStacktrace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--hiveconf", "hive.session.silent=false", "-e", "select date_sub(date'2011-11-11', '1.2');"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NumberFormatException"}))), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)"Error in query: The second argument of 'date_sub' function needs to be an integer."), new Tuple2((Object)"", (Object)"NumberFormatException: invalid input syntax for type numeric: 1.2")}));
            this.runCliWithin(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--conf", "spark.hive.session.silent=true", "-e", "select date_sub(date'2011-11-11', '1.2');"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AnalysisException"}))), this.runCliWithin$default$4(), this.runCliWithin$default$5(), this.runCliWithin$default$6(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)"Error in query: The second argument of 'date_sub' function needs to be an integer.")}));
        }, new Position("CliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
    }
}

