/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.spark.SparkException;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.test.HiveTestJars$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftJdbcTest;
import org.apache.spark.sql.hive.thriftserver.ServerMode$;
import org.apache.spark.sql.hive.thriftserver.TestData$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q2A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C!7!)a\u0005\u0001C\u0005O\tY\u0002*\u001b<f)\"\u0014\u0018N\u001a;CS:\f'/_*feZ,'oU;ji\u0016T!AB\u0004\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005!I\u0011\u0001\u00025jm\u0016T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0003\n\u0005Y)!A\u0005%jm\u0016$\u0006N]5gi*#'m\u0019+fgR\fa\u0001P5oSRtD#A\r\u0011\u0005Q\u0001\u0011\u0001B7pI\u0016,\u0012\u0001\b\t\u0003;\u0001r!\u0001\u0006\u0010\n\u0005})\u0011AC*feZ,'/T8eK&\u0011\u0011E\t\u0002\u0006-\u0006dW/Z\u0005\u0003G\u0011\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]*\tQ%A\u0003tG\u0006d\u0017-\u0001\u000bxSRD7\tT%TKJ4\u0018nY3DY&,g\u000e\u001e\u000b\u0003Q1\u0002\"!\u000b\u0016\u000e\u0003\u0011J!a\u000b\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006[\r\u0001\rAL\u0001\u0002MB!\u0011fL\u0019)\u0013\t\u0001DEA\u0005Gk:\u001cG/[8ocA\u0011!GO\u0007\u0002g)\u0011A'N\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\u0005Y:\u0014aA2mS*\u0011\u0001(O\u0001\bg\u0016\u0014h/[2f\u0015\tAQ\"\u0003\u0002<g\t1B\u000b\u001b:jMR\u001cE*S*feZL7-Z\"mS\u0016tG\u000f")
public class HiveThriftBinaryServerSuite
extends HiveThriftJdbcTest {
    @Override
    public Enumeration.Value mode() {
        return ServerMode$.MODULE$.binary();
    }

    private void withCLIServiceClient(Function1<ThriftCLIServiceClient, BoxedUnit> f) {
        TSocket rawTransport = new TSocket("localhost", this.serverPort());
        String user = System.getProperty("user.name");
        TTransport transport = PlainSaslHelper.getPlainTransport((String)user, (String)"anonymous", (TTransport)rawTransport);
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        ThriftCLIServiceClient client = new ThriftCLIServiceClient((TCLIService.Iface)new TCLIService.Client((TProtocol)protocol));
        transport.open();
        try {
            f.apply((Object)client);
        }
        finally {
            transport.close();
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(HiveThriftBinaryServerSuite $this, ThriftCLIServiceClient client) {
        String user = System.getProperty("user.name");
        SessionHandle sessionHandle = client.openSession(user, "");
        $this.assertResult("Spark SQL", "Wrong GetInfo(CLI_DBMS_NAME) result", client.getInfo(sessionHandle, GetInfoType.CLI_DBMS_NAME).getStringValue(), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        $this.assertResult("Spark SQL", "Wrong GetInfo(CLI_SERVER_NAME) result", client.getInfo(sessionHandle, GetInfoType.CLI_SERVER_NAME).getStringValue(), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
        String version = client.getInfo(sessionHandle, GetInfoType.CLI_DBMS_VER).getStringValue();
        $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Spark version: ").append(version).toString());
        String string = version;
        String string2 = "Unknown";
        $this.assertResult(bl, "Spark version shouldn't be \"Unknown\"", BoxesRunTime.boxToBoolean(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
    }

    public static final /* synthetic */ void $anonfun$new$6(HiveThriftBinaryServerSuite $this, ThriftCLIServiceClient client$1, SessionHandle sessionHandle$1, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_16563(key INT, val STRING) USING hive", new StringBuilder(57).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE test_16563").toString()}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        HashMap confOverlay = new HashMap();
        OperationHandle operationHandle = client$1.executeStatement(sessionHandle$1, "SELECT * FROM test_16563", confOverlay);
        RowSet rows_next = client$1.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 1000L, FetchType.QUERY_OUTPUT);
        $this.assertResult(BoxesRunTime.boxToInteger((int)5), "Fetching result first time from next row", BoxesRunTime.boxToInteger((int)rows_next.numRows()), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        RowSet rows_first = client$1.fetchResults(operationHandle, FetchOrientation.FETCH_FIRST, 1000L, FetchType.QUERY_OUTPUT);
        $this.assertResult(BoxesRunTime.boxToInteger((int)5), "Repeat fetching result from first row", BoxesRunTime.boxToInteger((int)rows_first.numRows()), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }

    public static final /* synthetic */ void $anonfun$new$5(HiveThriftBinaryServerSuite $this, ThriftCLIServiceClient client) {
        String user = System.getProperty("user.name");
        SessionHandle sessionHandle = client.openSession(user, "");
        $this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_16563"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$6($this, client, sessionHandle, statement);
            return BoxedUnit.UNIT;
        });
    }

    private final void executeTest$1(String hiveList, Statement statement$2) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hiveList.split(";"))).foreach((Function1 & Serializable & scala.Serializable)m -> {
            String[] kv = m.split("=");
            String k = kv[0];
            String v = kv[1];
            String modValue = new StringBuilder(10).append(v).append("_MOD_VALUE").toString();
            ResultSet resultSet = statement$2.executeQuery(new StringBuilder(12).append("select '${").append(k).append("}'").toString());
            resultSet.next();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(resultSet.getString(1));
            String $org_scalatest_assert_macro_right = v;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            statement$2.executeQuery(new StringBuilder(5).append("set ").append(k).append("=").append(modValue).toString());
            ResultSet modResultSet = statement$2.executeQuery(new StringBuilder(12).append("select '${").append(k).append("}'").toString());
            modResultSet.next();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(modResultSet.getString(1));
            String $org_scalatest_assert_macro_right2 = String.valueOf(modValue);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        });
    }

    public static final /* synthetic */ void $anonfun$new$9(HiveThriftBinaryServerSuite $this, Statement statement) {
        $this.executeTest$1($this.hiveConfList(), statement);
        $this.executeTest$1($this.hiveVarList(), statement);
    }

    public static final /* synthetic */ void $anonfun$new$12(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET spark.sql.shuffle.partitions=3", "CREATE TABLE test(key INT, val STRING) USING hive", new StringBuilder(51).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE test").toString(), "CACHE TABLE test"}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        Integer n = BoxesRunTime.boxToInteger((int)5);
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM test");
        resultSet.next();
        $this.assertResult(n, "Row count mismatch", BoxesRunTime.boxToInteger((int)resultSet.getInt(1)), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
    }

    public static final /* synthetic */ void $anonfun$new$15(HiveThriftBinaryServerSuite $this, Statement statement) {
        ResultSet resultSet = statement.executeQuery("SET spark.sql.hive.version");
        resultSet.next();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(resultSet.getString(1));
        String $org_scalatest_assert_macro_right = "spark.sql.hive.version";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(resultSet.getString(2));
        String $org_scalatest_assert_macro_right2 = HiveUtils$.MODULE$.builtinHiveVersion();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
    }

    public static final /* synthetic */ Assertion $anonfun$new$19(HiveThriftBinaryServerSuite $this, ResultSet resultSet$1, int x$1) {
        resultSet$1.next();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)resultSet$1.getInt(1)));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(resultSet$1.wasNull(), "resultSet.wasNull()", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
    }

    public static final /* synthetic */ void $anonfun$new$17(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_null(key INT, val STRING) USING hive", new StringBuilder(56).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKvWithNull()).append("' OVERWRITE INTO TABLE test_null").toString()}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        ResultSet resultSet = statement.executeQuery("SELECT * FROM test_null WHERE key IS NULL");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)x$1 -> HiveThriftBinaryServerSuite.$anonfun$new$19($this, resultSet, BoxesRunTime.unboxToInt((Object)x$1)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(resultSet.next(), "resultSet.next()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
    }

    public static final /* synthetic */ Assertion $anonfun$new$23(HiveThriftBinaryServerSuite $this, ResultSet resultSet$2, int key) {
        resultSet$2.next();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)resultSet$2.getInt(1)));
        int $org_scalatest_assert_macro_right = key;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }

    public static final /* synthetic */ void $anonfun$new$21(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_4292(key INT, val STRING) USING hive", new StringBuilder(56).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE test_4292").toString()}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        ResultSet resultSet = statement.executeQuery("SELECT key FROM test_4292");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{238, 86, 311, 27, 165}))).foreach((Function1 & Serializable & scala.Serializable)key -> HiveThriftBinaryServerSuite.$anonfun$new$23($this, resultSet, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static final /* synthetic */ void $anonfun$new$25(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_date(key INT, value STRING) USING hive", new StringBuilder(56).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE test_date").toString()}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        Date date = Date.valueOf("2011-01-01");
        ResultSet resultSet = statement.executeQuery("SELECT CAST('2011-01-01' as date) FROM test_date LIMIT 1");
        resultSet.next();
        $this.assertResult(date, resultSet.getDate(1), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
    }

    public static final /* synthetic */ void $anonfun$new$28(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_map(key INT, value STRING) USING hive", new StringBuilder(55).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE test_map").toString()}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        ResultSet resultSet = statement.executeQuery("SELECT MAP(key, value) FROM test_map LIMIT 1");
        resultSet.next();
        $this.assertResult("{238:\"val_238\"}", resultSet.getString(1), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        ResultSet resultSet2 = statement.executeQuery("SELECT ARRAY(CAST(key AS STRING), value) FROM test_map LIMIT 1");
        resultSet2.next();
        $this.assertResult("[\"238\",\"val_238\"]", resultSet2.getString(1), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
    }

    public static final /* synthetic */ void $anonfun$new$31(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_binary(key INT, value STRING) USING hive", new StringBuilder(58).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE test_binary").toString()}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        byte[] expected = "val_238".getBytes();
        ResultSet resultSet = statement.executeQuery("SELECT CAST(value as BINARY) FROM test_binary LIMIT 1");
        resultSet.next();
        $this.assertResult(expected, resultSet.getObject(1), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
    }

    public static final /* synthetic */ void $anonfun$new$34(HiveThriftBinaryServerSuite $this, ObjectRef data$1, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_map(key INT, value STRING) USING hive", new StringBuilder(55).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE test_map").toString(), "CACHE TABLE test_table AS SELECT key FROM test_map ORDER BY key DESC", "CREATE DATABASE db1"}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        ResultSet plan = statement.executeQuery("explain select * from test_table");
        plan.next();
        plan.next();
        String $org_scalatest_assert_macro_left = plan.getString(1);
        String $org_scalatest_assert_macro_right = "Scan In-memory table `test_table`";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        ResultSet rs1 = statement.executeQuery("SELECT key FROM test_table ORDER BY KEY DESC");
        ArrayBuffer buf1 = new ArrayBuffer();
        while (rs1.next()) {
            buf1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rs1.getInt(1)));
        }
        rs1.close();
        ResultSet rs2 = statement.executeQuery("SELECT key FROM test_map ORDER BY KEY DESC");
        ArrayBuffer buf2 = new ArrayBuffer();
        while (rs2.next()) {
            buf2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rs2.getInt(1)));
        }
        rs2.close();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(buf1);
        ArrayBuffer $org_scalatest_assert_macro_right2 = buf2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        data$1.elem = buf1;
    }

    public static final /* synthetic */ void $anonfun$new$36(HiveThriftBinaryServerSuite $this, ObjectRef defaultV1$1, ObjectRef defaultV2$1, Statement statement) {
        ResultSet rs1 = statement.executeQuery(new StringBuilder(4).append("SET ").append(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()).toString());
        rs1.next();
        defaultV1$1.elem = rs1.getString(1);
        String $org_scalatest_assert_macro_left = (String)defaultV1$1.elem;
        String $org_scalatest_assert_macro_right = "200";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        rs1.close();
        ResultSet rs2 = statement.executeQuery("SET hive.cli.print.header");
        rs2.next();
        defaultV2$1.elem = rs2.getString(1);
        String $org_scalatest_assert_macro_left2 = (String)defaultV1$1.elem;
        String $org_scalatest_assert_macro_right2 = "true";
        String string3 = $org_scalatest_assert_macro_left2;
        String string4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, string3 == null ? string4 != null : !string3.equals(string4), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        rs2.close();
    }

    public static final /* synthetic */ void $anonfun$new$37(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("SET ").append(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()).append("=291").toString(), "SET hive.cli.print.header=true"}));
        queries.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)), Seq$.MODULE$.canBuildFrom());
        ResultSet rs1 = statement.executeQuery(new StringBuilder(4).append("SET ").append(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()).toString());
        rs1.next();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("spark.sql.shuffle.partitions");
        String $org_scalatest_assert_macro_right = rs1.getString(1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer("291");
        String $org_scalatest_assert_macro_right2 = rs1.getString(2);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        rs1.close();
        ResultSet rs2 = statement.executeQuery("SET hive.cli.print.header");
        rs2.next();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer("hive.cli.print.header");
        String $org_scalatest_assert_macro_right3 = rs2.getString(1);
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer("true");
        String $org_scalatest_assert_macro_right4 = rs2.getString(2);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        rs2.close();
    }

    public static final /* synthetic */ void $anonfun$new$39(HiveThriftBinaryServerSuite $this, ObjectRef defaultV1$1, ObjectRef defaultV2$1, Statement statement) {
        ResultSet rs1 = statement.executeQuery(new StringBuilder(4).append("SET ").append(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()).toString());
        rs1.next();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer((String)defaultV1$1.elem);
        String $org_scalatest_assert_macro_right = rs1.getString(1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        rs1.close();
        ResultSet rs2 = statement.executeQuery("SET hive.cli.print.header");
        rs2.next();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer((String)defaultV2$1.elem);
        String $org_scalatest_assert_macro_right2 = rs2.getString(1);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        rs2.close();
    }

    public static final /* synthetic */ void $anonfun$new$40(HiveThriftBinaryServerSuite $this, ObjectRef data$1, Statement statement) {
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> statement.executeQuery("SELECT key FROM test_table ORDER BY KEY DESC"), ClassTag$.MODULE$.apply(SQLException.class), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        ResultSet plan = statement.executeQuery("explain select key from test_map ORDER BY key DESC");
        plan.next();
        plan.next();
        String $org_scalatest_assert_macro_left = plan.getString(1);
        String $org_scalatest_assert_macro_right = "Scan In-memory table `test_table`";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        ResultSet rs = statement.executeQuery("SELECT key FROM test_map ORDER BY KEY DESC");
        ArrayBuffer buf = new ArrayBuffer();
        while (rs.next()) {
            buf.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rs.getInt(1)));
        }
        rs.close();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(buf);
        ArrayBuffer $org_scalatest_assert_macro_right2 = (ArrayBuffer)data$1.elem;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
    }

    public static final /* synthetic */ void $anonfun$new$42(HiveThriftBinaryServerSuite $this, Statement statement) {
        statement.execute("USE db1");
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> statement.executeQuery("SELECT key FROM test_map ORDER BY KEY DESC"), ClassTag$.MODULE$.apply(SQLException.class), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        statement.execute("CREATE TABLE test_map2(key INT, value STRING)");
    }

    public static final /* synthetic */ void $anonfun$new$44(HiveThriftBinaryServerSuite $this, Statement statement) {
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> statement.executeQuery("SELECT key FROM test_map2"), ClassTag$.MODULE$.apply(SQLException.class), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        statement.execute("USE db1");
        statement.executeQuery("SELECT key from test_map2");
    }

    public static final /* synthetic */ void $anonfun$new$47(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_map(key INT, value STRING)", new StringBuilder(55).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE test_map").toString()}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        ExecutionContextExecutorService ec = ExecutionContext$.MODULE$.fromExecutorService(ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("test-jdbc-cancel"));
        try {
            Throwable e;
            Future f = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> statement.executeQuery(new StringBuilder(30).append("SELECT COUNT(*) FROM test_map ").append(((TraversableOnce)List$.MODULE$.fill(10, (Function0 & Serializable & scala.Serializable)() -> "join test_map")).mkString(" ")).toString()), (ExecutionContext)ec);
            Thread.sleep(1000L);
            statement.cancel();
            Throwable $org_scalatest_assert_macro_left = e = ((Throwable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (ResultSet)ThreadUtils$.MODULE$.awaitResult((Awaitable)f, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).minute()), ClassTag$.MODULE$.apply(SparkException.class), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455))).getCause();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.sql.SQLException", $org_scalatest_assert_macro_left instanceof SQLException, Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right = "cancelled";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
            statement.executeQuery("SET spark.sql.hive.thriftServer.async=false");
            try {
                Future sf = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> statement.executeQuery(new StringBuilder(30).append("SELECT COUNT(*) FROM test_map ").append(((TraversableOnce)List$.MODULE$.fill(4, (Function0 & Serializable & scala.Serializable)() -> "join test_map")).mkString(" ")).toString()), (ExecutionContext)ec);
                Thread.sleep(1000L);
                statement.cancel();
                ResultSet rs1 = (ResultSet)ThreadUtils$.MODULE$.awaitResult((Awaitable)sf, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).minute());
                rs1.next();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rs1.getInt(1)));
                double $org_scalatest_assert_macro_right2 = package$.MODULE$.pow(5.0, 5.0);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
                rs1.close();
                ResultSet rs2 = statement.executeQuery("SELECT COUNT(*) FROM test_map");
                rs2.next();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rs2.getInt(1)));
                int $org_scalatest_assert_macro_right3 = 5;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
                rs2.close();
            }
            finally {
                statement.executeQuery("SET spark.sql.hive.thriftServer.async=true");
            }
        }
        finally {
            ec.shutdownNow();
        }
    }

    public static final /* synthetic */ void $anonfun$new$55(Statement statement) {
        String jarFile = HiveTestJars$.MODULE$.getHiveHcatalogCoreJar(HiveTestJars$.MODULE$.getHiveHcatalogCoreJar$default$1()).getCanonicalPath();
        statement.executeQuery(new StringBuilder(8).append("ADD JAR ").append(jarFile).toString());
    }

    public static final /* synthetic */ void $anonfun$new$56(HiveThriftBinaryServerSuite $this, Statement statement) {
        Seq queries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE smallKV(key INT, val STRING) USING hive", new StringBuilder(54).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE smallKV").toString(), new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE addJar(key string)\n              |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe'\n            ")).stripMargin()}));
        queries.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        statement.executeQuery(new StringOps(Predef$.MODULE$.augmentString("\n              |INSERT INTO TABLE addJar SELECT 'k1' as key FROM smallKV limit 1\n            ")).stripMargin());
        ResultSet actualResult = statement.executeQuery("SELECT key FROM addJar");
        ArrayBuffer actualResultBuffer = new ArrayBuffer();
        while (actualResult.next()) {
            actualResultBuffer.$plus$eq((Object)actualResult.getString(1));
        }
        actualResult.close();
        ResultSet expectedResult = statement.executeQuery("SELECT 'k1'");
        ArrayBuffer expectedResultBuffer = new ArrayBuffer();
        while (expectedResult.next()) {
            expectedResultBuffer.$plus$eq((Object)expectedResult.getString(1));
        }
        expectedResult.close();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(expectedResultBuffer);
        ArrayBuffer $org_scalatest_assert_macro_right = actualResultBuffer;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
    }

    public static final /* synthetic */ void $anonfun$new$59(HiveThriftBinaryServerSuite $this, Statement statement) {
        ResultSet resultSet = statement.executeQuery("SET -v");
        scala.collection.mutable.Map conf = Map$.MODULE$.empty();
        while (resultSet.next()) {
            conf.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resultSet.getString(1)), (Object)resultSet.getString(2)));
        }
        if (HiveUtils$.MODULE$.isHive23()) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(conf.get((Object)HiveUtils$.MODULE$.FAKE_HIVE_VERSION().key()));
            Some $org_scalatest_assert_macro_right = new Some((Object)"2.3.7");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
        } else {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(conf.get((Object)HiveUtils$.MODULE$.FAKE_HIVE_VERSION().key()));
            Some $org_scalatest_assert_macro_right = new Some((Object)"1.2.1");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        }
    }

    public static final /* synthetic */ void $anonfun$new$61(HiveThriftBinaryServerSuite $this, Statement statement) {
        ResultSet resultSet = statement.executeQuery("SET");
        scala.collection.mutable.Map conf = Map$.MODULE$.empty();
        while (resultSet.next()) {
            conf.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resultSet.getString(1)), (Object)resultSet.getString(2)));
        }
        if (HiveUtils$.MODULE$.isHive23()) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(conf.get((Object)HiveUtils$.MODULE$.FAKE_HIVE_VERSION().key()));
            Some $org_scalatest_assert_macro_right = new Some((Object)"2.3.7");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        } else {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(conf.get((Object)HiveUtils$.MODULE$.FAKE_HIVE_VERSION().key()));
            Some $org_scalatest_assert_macro_right = new Some((Object)"1.2.1");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        }
    }

    public static final /* synthetic */ void $anonfun$new$63(HiveThriftBinaryServerSuite $this, Statement statement) {
        try {
            String jarPath = "../hive/src/test/resources/TestUDTF.jar";
            String jarURL = new StringBuilder(8).append("file://").append(System.getProperty("user.dir")).append("/").append(jarPath).toString();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("ADD JAR ").append(jarURL).toString(), new StringOps(Predef$.MODULE$.augmentString("CREATE TEMPORARY FUNCTION udtf_count2\n             |AS 'org.apache.spark.sql.hive.execution.GenericUDTFCount2'\n           ")).stripMargin()}))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
            ResultSet rs1 = statement.executeQuery("DESCRIBE FUNCTION udtf_count2");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs1.next(), "rs1.next()", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs1.getString(1));
            String $org_scalatest_assert_macro_right = "Function: udtf_count2";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(rs1.next(), "rs1.next()", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
            $this.assertResult("Class: org.apache.spark.sql.hive.execution.GenericUDTFCount2", rs1.getString(1), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(rs1.next(), "rs1.next()", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(rs1.getString(1));
            String $org_scalatest_assert_macro_right2 = "Usage: N/A.";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
            String dataPath = "../hive/src/test/resources/data/files/kv1.txt";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE test_udtf(key INT, value STRING) USING hive", new StringBuilder(56).append("LOAD DATA LOCAL INPATH '").append(dataPath).append("' OVERWRITE INTO TABLE test_udtf").toString()}))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
            ResultSet rs2 = statement.executeQuery("SELECT key, cc FROM test_udtf LATERAL VIEW udtf_count2(value) dd AS cc");
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(rs2.next(), "rs2.next()", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rs2.getInt(1)));
            int $org_scalatest_assert_macro_right3 = 97;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rs2.getInt(2)));
            int $org_scalatest_assert_macro_right4 = 500;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(rs2.next(), "rs2.next()", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rs2.getInt(1)));
            int $org_scalatest_assert_macro_right5 = 97;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rs2.getInt(2)));
            int $org_scalatest_assert_macro_right6 = 500;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        }
        finally {
            statement.executeQuery("DROP TEMPORARY FUNCTION udtf_count2");
        }
    }

    private final File[] pipeoutFileList$1(UUID sessionID) {
        return this.lScratchDir().listFiles(new FilenameFilter(null, sessionID){
            private final UUID sessionID$1;

            public boolean accept(File dir, String name) {
                return name.startsWith(this.sessionID$1.toString()) && name.endsWith(".pipeout");
            }
            {
                this.sessionID$1 = sessionID$1;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$new$71(HiveThriftBinaryServerSuite $this, ThriftCLIServiceClient client) {
        Assertion assertion;
        String user = System.getProperty("user.name");
        SessionHandle sessionHandle = client.openSession(user, "");
        UUID sessionID = sessionHandle.getSessionId();
        if (HiveUtils$.MODULE$.isHive23()) {
            File[] $org_scalatest_assert_macro_left = $this.pipeoutFileList$1(sessionID);
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        } else {
            File[] $org_scalatest_assert_macro_left = $this.pipeoutFileList$1(sessionID);
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
        }
        client.closeSession(sessionHandle);
        File[] $org_scalatest_assert_macro_left = $this.pipeoutFileList$1(sessionID);
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
    }

    public static final /* synthetic */ void $anonfun$new$73(HiveThriftBinaryServerSuite $this, Statement statement) {
        ResultSet resultSet = statement.executeQuery("SELECT CAST('4.56' AS FLOAT)");
        resultSet.next();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(resultSet.getString(1));
        String $org_scalatest_assert_macro_right = "4.56";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
    }

    public static final /* synthetic */ void $anonfun$new$75(HiveThriftBinaryServerSuite $this, Statement statement) {
        ResultSet rs = statement.executeQuery("SELECT CAST(1 AS decimal(38, 18))");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getBigDecimal(1));
        BigDecimal $org_scalatest_assert_macro_right = new BigDecimal("1.000000000000000000");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
    }

    public static final /* synthetic */ void $anonfun$new$77(HiveThriftBinaryServerSuite $this, Statement statement) {
        ResultSet rs = statement.executeQuery("SELECT interval 3 months 1 hours");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "3 months 1 hours";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
    }

    public static final /* synthetic */ void $anonfun$new$78(HiveThriftBinaryServerSuite $this, Statement statement) {
        SQLException e = (SQLException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> statement.executeQuery("SELECT interval 3 months 1 hou"), ClassTag$.MODULE$.apply(SQLException.class), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "org.apache.spark.sql.catalyst.parser.ParseException";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
    }

    private final void checkResult$1(RowSet rows, long start, long end) {
        long $org_scalatest_assert_macro_left = rows.getStartOffset();
        long $org_scalatest_assert_macro_right = start;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
        int $org_scalatest_assert_macro_left2 = rows.numRows();
        long $org_scalatest_assert_macro_right2 = end - start;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), (long)$org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(rows.iterator()).asScala()).zip(new RichLong(Predef$.MODULE$.longWrapper(start)).until((Object)BoxesRunTime.boxToLong((long)end)).iterator()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object[] row = (Object[])tuple2._1();
            long v = tuple2._2$mcJ$sp();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)row[0])));
            long $org_scalatest_assert_macro_right = v;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
            return assertion;
        });
    }

    public static final /* synthetic */ void $anonfun$new$82(HiveThriftBinaryServerSuite $this, ThriftCLIServiceClient client) {
        String user = System.getProperty("user.name");
        SessionHandle sessionHandle = client.openSession(user, "");
        HashMap confOverlay = new HashMap();
        OperationHandle operationHandle = client.executeStatement(sessionHandle, "SELECT * FROM range(10)", confOverlay);
        RowSet rows = null;
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 5L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 0L, 5L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 2L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 5L, 7L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_PRIOR, 3L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 2L, 5L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_PRIOR, 3L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 0L, 3L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_PRIOR, 4L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 0L, 4L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 10L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 4L, 10L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 5L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 10L, 10L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 2L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 10L, 10L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_PRIOR, 1L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 9L, 10L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 5L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 10L, 10L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_FIRST, 3L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 0L, 3L);
        rows = client.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 1000L, FetchType.QUERY_OUTPUT);
        $this.checkResult$1(rows, 3L, 10L);
        client.closeOperation(operationHandle);
        client.closeSession(sessionHandle);
    }

    public static final /* synthetic */ void $anonfun$new$85(HiveThriftBinaryServerSuite $this, ThriftCLIServiceClient client$2, SessionHandle sessionHandle$2, Statement statement) {
        HashMap confOverlay = new HashMap();
        String jarFile = HiveTestJars$.MODULE$.getHiveHcatalogCoreJar(HiveTestJars$.MODULE$.getHiveHcatalogCoreJar$default$1()).getCanonicalPath();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("ADD JAR ").append(jarFile).toString(), "CREATE TABLE smallKV(key INT, val STRING) USING hive", new StringBuilder(54).append("LOAD DATA LOCAL INPATH '").append(TestData$.MODULE$.smallKv()).append("' OVERWRITE INTO TABLE smallKV").toString()}))).foreach((Function1 & Serializable & scala.Serializable)query -> client$2.executeStatement(sessionHandle$2, query, (Map)confOverlay));
        client$2.executeStatement(sessionHandle$2, new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE addJar(key string)\n            |ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe'\n          ")).stripMargin(), confOverlay);
        client$2.executeStatement(sessionHandle$2, "INSERT INTO TABLE addJar SELECT 'k1' as key FROM smallKV limit 1", confOverlay);
        OperationHandle operationHandle = client$2.executeStatement(sessionHandle$2, "SELECT key FROM addJar", confOverlay);
        RowSet rows_next = client$2.fetchResults(operationHandle, FetchOrientation.FETCH_NEXT, 1000L, FetchType.QUERY_OUTPUT);
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), "Fetching result first time from next row", BoxesRunTime.boxToInteger((int)rows_next.numRows()), Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
    }

    public static final /* synthetic */ void $anonfun$new$84(HiveThriftBinaryServerSuite $this, ThriftCLIServiceClient client) {
        String user = System.getProperty("user.name");
        SessionHandle sessionHandle = client.openSession(user, "");
        $this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"smallKV", "addJar"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$85($this, client, sessionHandle, statement);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$88(HiveThriftBinaryServerSuite $this, Statement st) {
        st.execute("set spark.sql.datetime.java8API.enabled=true");
        ResultSet rs = st.executeQuery("select date '2020-05-28', timestamp '2020-05-28 00:00:00'");
        rs.next();
        String $org_scalatest_assert_macro_left = rs.getDate(1).toString();
        String $org_scalatest_assert_macro_right = "2020-05-28";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
        String $org_scalatest_assert_macro_left2 = rs.getTimestamp(2).toString();
        String $org_scalatest_assert_macro_right2 = "2020-05-28 00:00:00.0";
        String string3 = $org_scalatest_assert_macro_left2;
        String string4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 821));
    }

    public static final /* synthetic */ void $anonfun$new$90(HiveThriftBinaryServerSuite $this, Statement st) {
        st.execute("set spark.sql.session.timeZone=+03:15");
        ResultSet rs = st.executeQuery("select timestamp '2020-05-28 10:00:00'");
        rs.next();
        String $org_scalatest_assert_macro_left = rs.getString(1);
        String $org_scalatest_assert_macro_right = "2020-05-28 10:00:00.0";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
        String $org_scalatest_assert_macro_left2 = rs.getTimestamp(1).toString();
        String $org_scalatest_assert_macro_right2 = "2020-05-28 10:00:00.0";
        String string3 = $org_scalatest_assert_macro_left2;
        String string4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
    }

    public static final /* synthetic */ Assertion $anonfun$new$93(HiveThriftBinaryServerSuite $this, Statement statement$18, int _) {
        statement$18.execute("SET spark.sql.session.timeZone=GMT-12");
        ResultSet firstResult = statement$18.executeQuery("SELECT date 'now'");
        firstResult.next();
        Date beyondDateLineWest = firstResult.getDate(1);
        statement$18.execute("SET spark.sql.session.timeZone=GMT+13");
        ResultSet secondResult = statement$18.executeQuery("SELECT date 'now'");
        secondResult.next();
        Date dateLineEast = secondResult.getDate(1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(dateLineEast.after(beyondDateLineWest), "dateLineEast.after(beyondDateLineWest)", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"SQLConf changes should persist across execution threads", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
    }

    public static final /* synthetic */ void $anonfun$new$92(HiveThriftBinaryServerSuite $this, int iter$1, Statement statement) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), iter$1).foreach((Function1 & Serializable & scala.Serializable)_ -> HiveThriftBinaryServerSuite.$anonfun$new$93($this, statement, BoxesRunTime.unboxToInt((Object)_)));
    }

    public HiveThriftBinaryServerSuite() {
        this.test("GetInfo Thrift API", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCLIServiceClient((Function1<ThriftCLIServiceClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            HiveThriftBinaryServerSuite.$anonfun$new$2(this, client);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("SPARK-16563 ThriftCLIService FetchResults repeat fetching result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCLIServiceClient((Function1<ThriftCLIServiceClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            HiveThriftBinaryServerSuite.$anonfun$new$5(this, client);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("Support beeline --hiveconf and --hivevar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$9(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("JDBC query execution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$12(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("Checks Hive version", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$15(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("SPARK-3004 regression: result set containing NULL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_null"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$17(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("SPARK-4292 regression: result set iterator issue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_4292"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$21(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("SPARK-4309 regression: Date type support", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_date"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$25(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("SPARK-4407 regression: Complex type support", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_map"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$28(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        this.test("SPARK-12143 regression: Binary type support", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_binary"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$31(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("test multiple session", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef defaultV1 = ObjectRef.create(null);
            ObjectRef defaultV2 = ObjectRef.create(null);
            ObjectRef data = ObjectRef.create(null);
            this.withMultipleConnectionJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_map", "db1.test_map2"}), (Seq<Function1<Statement, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$34(this, data, statement);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$36(this, defaultV1, defaultV2, statement);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$37(this, statement);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$39(this, defaultV1, defaultV2, statement);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$40(this, data, statement);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$42(this, statement);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$44(this, statement);
                return BoxedUnit.UNIT;
            }}));
        }, new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.ignore("test jdbc cancel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_map"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$47(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        this.test("test add jar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withMultipleConnectionJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"smallKV", "addJar"}), (Seq<Function1<Statement, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$55(statement);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$56(this, statement);
            return BoxedUnit.UNIT;
        }})), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        this.test("Checks Hive version via SET -v", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$59(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        this.test("Checks Hive version via SET", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$61(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
        this.test("SPARK-11595 ADD JAR with input path having URL scheme", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_udtf"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$63(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
        this.test("SPARK-11043 check operation log root directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String expectedLine = new StringBuilder(41).append("Operation log root directory is created: ").append(this.operationLogPath().getAbsoluteFile()).toString();
            BufferedSource bufferSrc = Source$.MODULE$.fromFile(this.logPath(), Codec$.MODULE$.fallbackSystemCodec());
            return (Assertion)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bufferSrc.getLines().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(expectedLine))), "bufferSrc.getLines().exists(((x$2: String) => x$2.contains(expectedLine)))", Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bufferSrc.close());
        }, new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        this.test("SPARK-23547 Cleanup the .pipeout file when the Hive Session closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCLIServiceClient((Function1<ThriftCLIServiceClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            HiveThriftBinaryServerSuite.$anonfun$new$71(this, client);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
        this.test("SPARK-24829 Checks cast as float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$73(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
        this.test("SPARK-28463: Thriftserver throws BigDecimal incompatible with HiveDecimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            HiveThriftBinaryServerSuite.$anonfun$new$75(this, statement);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
        this.test("Support interval type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$77(this, statement);
                return BoxedUnit.UNIT;
            });
            this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$78(this, statement);
                return BoxedUnit.UNIT;
            });
        }, new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
        this.test("ThriftCLIService FetchResults FETCH_FIRST, FETCH_NEXT, FETCH_PRIOR", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCLIServiceClient((Function1<ThriftCLIServiceClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            HiveThriftBinaryServerSuite.$anonfun$new$82(this, client);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        this.test("SPARK-29492: use add jar in sync mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCLIServiceClient((Function1<ThriftCLIServiceClient, BoxedUnit>)(Function1 & Serializable & scala.Serializable)client -> {
            HiveThriftBinaryServerSuite.$anonfun$new$84(this, client);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        this.test("SPARK-31859 Thriftserver works with spark.sql.datetime.java8API.enabled=true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)st -> {
            HiveThriftBinaryServerSuite.$anonfun$new$88(this, st);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
        this.test("SPARK-31861 Thriftserver respects spark.sql.session.timeZone", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)st -> {
            HiveThriftBinaryServerSuite.$anonfun$new$90(this, st);
            return BoxedUnit.UNIT;
        }), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
        this.test("SPARK-31863 Session conf should persist between Thriftserver worker threads", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int iter = 20;
            this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
                HiveThriftBinaryServerSuite.$anonfun$new$92(this, iter, statement);
                return BoxedUnit.UNIT;
            });
        }, new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
    }
}

