/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.ServerMode$;
import org.apache.spark.sql.test.ProcessTestUtils;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005mh!B\u001d;\u0003\u00039\u0005\"\u0002-\u0001\t\u0003I\u0006\"\u0002/\u0001\r\u0003i\u0006b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007e\u0002\u0001\u000b\u0011\u00026\t\u000fM\u0004!\u0019!C\u0005i\"1q\u0010\u0001Q\u0001\nUD\u0001\"!\u0001\u0001\u0005\u0004%\t\u0002\u001e\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003v\u0011!\t)\u0001\u0001b\u0001\n#!\bbBA\u0004\u0001\u0001\u0006I!\u001e\u0005\f\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0001C\u0006\u0002\u0016\u0001\u0001\r\u00111A\u0005\n\u0005]\u0001bCA\u0012\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001bAq!!\n\u0001\t#\tY\u0001\u0003\u0005\u0002(\u0001\u0011\r\u0011\"\u0005j\u0011\u001d\tI\u0003\u0001Q\u0001\n)D\u0001\"a\u000b\u0001\u0005\u0004%\t\"\u001b\u0005\b\u0003[\u0001\u0001\u0015!\u0003k\u0011\u0019\ty\u0003\u0001C\tS\"Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011CA\u001a\u0011-\t\t\u0005\u0001a\u0001\u0002\u0004%\t\"a\u0011\t\u0017\u0005\u001d\u0003\u00011A\u0001B\u0003&\u0011Q\u0007\u0005\f\u0003\u0013\u0002\u0001\u0019!a\u0001\n#\t\u0019\u0004C\u0006\u0002L\u0001\u0001\r\u00111A\u0005\u0012\u00055\u0003bCA)\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kAa!a\u0015\u0001\t#!\b\"CA+\u0001\t\u0007I\u0011BA\u001a\u0011!\t9\u0006\u0001Q\u0001\n\u0005U\u0002bCA-\u0001\u0001\u0007\t\u0019!C\t\u0003gA1\"a\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002^!Y\u0011\u0011\r\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001b\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0004%\t\"a\r\t\u0017\u0005\u0015\u0004\u00011AA\u0002\u0013E\u0011q\r\u0005\f\u0003W\u0002\u0001\u0019!A!B\u0013\t)\u0004C\u0006\u0002n\u0001\u0001\r\u00111A\u0005\u0012\u0005M\u0002bCA8\u0001\u0001\u0007\t\u0019!C\t\u0003cB1\"!\u001e\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00026!Y\u0011q\u000f\u0001A\u0002\u0003\u0007I\u0011BA=\u0011-\t\t\t\u0001a\u0001\u0002\u0004%I!a!\t\u0017\u0005\u001d\u0005\u00011A\u0001B\u0003&\u00111\u0010\u0005\n\u0003\u0013\u0003\u0001\u0019!C\u0005\u0003\u0017C\u0011\"!(\u0001\u0001\u0004%I!a(\t\u0011\u0005\r\u0006\u0001)Q\u0005\u0003\u001bCq!!*\u0001\t#\t9\u000bC\u0004\u0002<\u0002!\t\"!0\t\u0011\u0005%\u0007A1A\u0005\u0002%Dq!a3\u0001A\u0003%!\u000e\u0003\u0005\u0002N\u0002\u0011\r\u0011\"\u0001j\u0011\u001d\ty\r\u0001Q\u0001\n)D\u0011\"!5\u0001\u0005\u0004%\t!a5\t\u0011\u0005\u0015\b\u0001)A\u0005\u0003+Dq!a:\u0001\t\u0013\tI\u000fC\u0004\u0002r\u0002!I!a=\t\u000f\u0005U\b\u0001\"\u0003\u0002t\"9\u0011q\u001f\u0001\u0005R\u0005M\bbBA}\u0001\u0011E\u00131\u001f\u0002\u0016\u0011&4X\r\u00165sS\u001a$8+\u001a:wKJ\u0014D+Z:u\u0015\tYD(\u0001\u0007uQJLg\r^:feZ,'O\u0003\u0002>}\u0005!\u0001.\u001b<f\u0015\ty\u0004)A\u0002tc2T!!\u0011\"\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\n\u0014*\u0011\u0005%SU\"\u0001!\n\u0005-\u0003%!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002N!6\taJ\u0003\u0002P\t\u0006I1oY1mCR,7\u000f^\u0005\u0003#:\u0013\u0011CQ3g_J,\u0017I\u001c3BMR,'/\u00117m!\t\u0019f+D\u0001U\u0015\t)\u0006)\u0001\u0005j]R,'O\\1m\u0013\t9FKA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Q\u0006CA.\u0001\u001b\u0005Q\u0014\u0001B7pI\u0016,\u0012A\u0018\t\u0003?\nt!a\u00171\n\u0005\u0005T\u0014AC*feZ,'/T8eK&\u00111\r\u001a\u0002\u0006-\u0006dW/Z\u0005\u0003K\u001a\u00141\"\u00128v[\u0016\u0014\u0018\r^5p]*\tq-A\u0003tG\u0006d\u0017-\u0001\u0006D\u0019\u0006\u001b6k\u0018(B\u001b\u0016+\u0012A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fA\u0001\\1oO*\tq.\u0001\u0003kCZ\f\u0017BA9m\u0005\u0019\u0019FO]5oO\u0006Y1\tT!T'~s\u0015)T#!\u00035aujR0G\u00132+u,T!S\u0017V\tQ\u000f\u0005\u0002w{:\u0011qo\u001f\t\u0003q\u001al\u0011!\u001f\u0006\u0003u\u001a\u000ba\u0001\u0010:p_Rt\u0014B\u0001?g\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O \u0006\u0003y\u001a\fa\u0002T(H?\u001aKE*R0N\u0003J[\u0005%A\u0006ti\u0006\u0014HoU2sSB$\u0018\u0001D:uCJ$8k\u0019:jaR\u0004\u0013AC:u_B\u001c6M]5qi\u0006Y1\u000f^8q'\u000e\u0014\u0018\u000e\u001d;!\u00035a\u0017n\u001d;f]&tw\rU8siV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t\t\"D\u0001g\u0013\r\t\u0019B\u001a\u0002\u0004\u0013:$\u0018!\u00057jgR,g.\u001b8h!>\u0014Ho\u0018\u0013fcR!\u0011\u0011DA\u0010!\u0011\ty!a\u0007\n\u0007\u0005uaM\u0001\u0003V]&$\b\"CA\u0011\u0019\u0005\u0005\t\u0019AA\u0007\u0003\rAH%M\u0001\u000fY&\u001cH/\u001a8j]\u001e\u0004vN\u001d;!\u0003)\u0019XM\u001d<feB{'\u000f^\u0001\rQ&4XmQ8oM2K7\u000f^\u0001\u000eQ&4XmQ8oM2K7\u000f\u001e\u0011\u0002\u0017!Lg/\u001a,be2K7\u000f^\u0001\rQ&4XMV1s\u0019&\u001cH\u000fI\u0001\u0005kN,'/A\u0007xCJ,\u0007n\\;tKB\u000bG\u000f[\u000b\u0003\u0003k\u0001B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wq\u0017AA5p\u0013\u0011\ty$!\u000f\u0003\t\u0019KG.Z\u0001\u0012o\u0006\u0014X\r[8vg\u0016\u0004\u0016\r\u001e5`I\u0015\fH\u0003BA\r\u0003\u000bB\u0011\"!\t\u0016\u0003\u0003\u0005\r!!\u000e\u0002\u001d]\f'/\u001a5pkN,\u0007+\u0019;iA\u0005iQ.\u001a;bgR|'/\u001a)bi\"\f\u0011#\\3uCN$xN]3QCRDw\fJ3r)\u0011\tI\"a\u0014\t\u0013\u0005\u0005\u0002$!AA\u0002\u0005U\u0012AD7fi\u0006\u001cHo\u001c:f!\u0006$\b\u000eI\u0001\u0011[\u0016$\u0018m\u001d;pe\u0016TEMY2Ve&\fa\u0001]5e\t&\u0014\u0018a\u00029jI\u0012K'\u000fI\u0001\bY><\u0007+\u0019;i\u0003-awn\u001a)bi\"|F%Z9\u0015\t\u0005e\u0011q\f\u0005\n\u0003Cq\u0012\u0011!a\u0001\u0003k\t\u0001\u0002\\8h!\u0006$\b\u000eI\u0001\u0011_B,'/\u0019;j_:dun\u001a)bi\"\fAc\u001c9fe\u0006$\u0018n\u001c8M_\u001e\u0004\u0016\r\u001e5`I\u0015\fH\u0003BA\r\u0003SB\u0011\"!\t\"\u0003\u0003\u0005\r!!\u000e\u0002#=\u0004XM]1uS>tGj\\4QCRD\u0007%A\u0006m'\u000e\u0014\u0018\r^2i\t&\u0014\u0018a\u00047TGJ\fGo\u00195ESJ|F%Z9\u0015\t\u0005e\u00111\u000f\u0005\n\u0003C!\u0013\u0011!a\u0001\u0003k\tA\u0002\\*de\u0006$8\r\u001b#je\u0002\n\u0011\u0003\\8h)\u0006LG.\u001b8h!J|7-Z:t+\t\tY\bE\u0002l\u0003{J1!a m\u0005\u001d\u0001&o\\2fgN\fQ\u0003\\8h)\u0006LG.\u001b8h!J|7-Z:t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0005\u0015\u0005\"CA\u0011O\u0005\u0005\t\u0019AA>\u0003Iawn\u001a+bS2Lgn\u001a)s_\u000e,7o\u001d\u0011\u0002\u001f\u0011L\u0017m\u001a8pg&\u001c()\u001e4gKJ,\"!!$\u0011\u000b\u0005=\u0015\u0011T;\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000bq!\\;uC\ndWMC\u0002\u0002\u0018\u001a\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY*!%\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001\u0014I&\fwM\\8tSN\u0014UO\u001a4fe~#S-\u001d\u000b\u0005\u00033\t\t\u000bC\u0005\u0002\")\n\t\u00111\u0001\u0002\u000e\u0006\u0001B-[1h]>\u001c\u0018n\u001d\"vM\u001a,'\u000fI\u0001\nKb$(/Y\"p]\u001a,\"!!+\u0011\u000b\u0005-\u0016QW;\u000f\t\u00055\u0016\u0011\u0017\b\u0004q\u0006=\u0016\"A4\n\u0007\u0005Mf-A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0016\u0011\u0018\u0002\u0004'\u0016\f(bAAZM\u0006\u00112/\u001a:wKJ\u001cF/\u0019:u\u0007>lW.\u00198e)\u0011\ty,!2\u0011\u000b\u0005\u0005\u00171\u00196\u000e\u0005\u0005U\u0015\u0002BA\\\u0003+Cq!a2.\u0001\u0004\ti!\u0001\u0003q_J$\u0018A\u0007+I%&3Ek\u0018\"J\u001d\u0006\u0013\u0016lX*F%ZK5)R0M\u0013Z+\u0015a\u0007+I%&3Ek\u0018\"J\u001d\u0006\u0013\u0016lX*F%ZK5)R0M\u0013Z+\u0005%\u0001\rU\u0011JKe\tV0I)R\u0003vlU#S-&\u001bUi\u0018'J-\u0016\u000b\u0011\u0004\u0016%S\u0013\u001a#v\f\u0013+U!~\u001bVI\u0015,J\u0007\u0016{F*\u0013,FA\u000512+\u0012*W\u000bJ{6\u000bV!S)V\u0003v\fV%N\u000b>+F+\u0006\u0002\u0002VB!\u0011q[Aq\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005}g-\u0001\u0006d_:\u001cWO\u001d:f]RLA!a9\u0002Z\nqa)\u001b8ji\u0016$UO]1uS>t\u0017aF*F%Z+%kX*U\u0003J#V\u000bU0U\u00136+u*\u0016+!\u0003E\u0019H/\u0019:u)\"\u0014\u0018N\u001a;TKJ4XM\u001d\u000b\u0007\u00033\tY/!<\t\u000f\u0005\u001dG\u00071\u0001\u0002\u000e!9\u0011q\u001e\u001bA\u0002\u00055\u0011aB1ui\u0016l\u0007\u000f^\u0001\u0011gR|\u0007\u000f\u00165sS\u001a$8+\u001a:wKJ$\"!!\u0007\u0002\u0011\u0011,X\u000e\u001d'pON\f\u0011BY3g_J,\u0017\t\u001c7\u0002\u0011\u00054G/\u001a:BY2\u0004")
public abstract class HiveThriftServer2Test
extends SparkFunSuite {
    private final String CLASS_NAME = new StringOps(Predef$.MODULE$.augmentString(HiveThriftServer2$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
    private final String org$apache$spark$sql$hive$thriftserver$HiveThriftServer2Test$$LOG_FILE_MARK = new StringBuilder(22).append("starting ").append(this.CLASS_NAME()).append(", logging to ").toString();
    private final String startScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../../sbin/start-thriftserver.sh".split("/"))).mkString(File.separator);
    private final String stopScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../../sbin/stop-thriftserver.sh".split("/"))).mkString(File.separator);
    private int listeningPort;
    private final String hiveConfList;
    private final String hiveVarList;
    private File warehousePath;
    private File metastorePath;
    private final File pidDir;
    private File logPath;
    private File operationLogPath;
    private File lScratchDir;
    private Process logTailingProcess;
    private ArrayBuffer<String> diagnosisBuffer;
    private final String THRIFT_BINARY_SERVICE_LIVE;
    private final String THRIFT_HTTP_SERVICE_LIVE;
    private final FiniteDuration SERVER_STARTUP_TIMEOUT;

    public abstract Enumeration.Value mode();

    private String CLASS_NAME() {
        return this.CLASS_NAME;
    }

    public String org$apache$spark$sql$hive$thriftserver$HiveThriftServer2Test$$LOG_FILE_MARK() {
        return this.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2Test$$LOG_FILE_MARK;
    }

    public String startScript() {
        return this.startScript;
    }

    public String stopScript() {
        return this.stopScript;
    }

    private int listeningPort() {
        return this.listeningPort;
    }

    private void listeningPort_$eq(int x$1) {
        this.listeningPort = x$1;
    }

    public int serverPort() {
        return this.listeningPort();
    }

    public String hiveConfList() {
        return this.hiveConfList;
    }

    public String hiveVarList() {
        return this.hiveVarList;
    }

    public String user() {
        return System.getProperty("user.name");
    }

    public File warehousePath() {
        return this.warehousePath;
    }

    public void warehousePath_$eq(File x$1) {
        this.warehousePath = x$1;
    }

    public File metastorePath() {
        return this.metastorePath;
    }

    public void metastorePath_$eq(File x$1) {
        this.metastorePath = x$1;
    }

    public String metastoreJdbcUri() {
        return new StringBuilder(37).append("jdbc:derby:;databaseName=").append(this.metastorePath()).append(";create=true").toString();
    }

    private File pidDir() {
        return this.pidDir;
    }

    public File logPath() {
        return this.logPath;
    }

    public void logPath_$eq(File x$1) {
        this.logPath = x$1;
    }

    public File operationLogPath() {
        return this.operationLogPath;
    }

    public void operationLogPath_$eq(File x$1) {
        this.operationLogPath = x$1;
    }

    public File lScratchDir() {
        return this.lScratchDir;
    }

    public void lScratchDir_$eq(File x$1) {
        this.lScratchDir = x$1;
    }

    private Process logTailingProcess() {
        return this.logTailingProcess;
    }

    private void logTailingProcess_$eq(Process x$1) {
        this.logTailingProcess = x$1;
    }

    private ArrayBuffer<String> diagnosisBuffer() {
        return this.diagnosisBuffer;
    }

    private void diagnosisBuffer_$eq(ArrayBuffer<String> x$1) {
        this.diagnosisBuffer = x$1;
    }

    public Seq<String> extraConf() {
        return Nil$.MODULE$;
    }

    public Seq<String> serverStartCommand(int port) {
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.binary();
        HiveConf.ConfVars portConf = !(value != null ? !value.equals(value2) : value2 != null) ? HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT : HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT;
        String tempLog4jConf = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalPath();
        Files.write((CharSequence)new StringOps(Predef$.MODULE$.augmentString("log4j.rootCategory=DEBUG, console\n          |log4j.appender.console=org.apache.log4j.ConsoleAppender\n          |log4j.appender.console.target=System.err\n          |log4j.appender.console.layout=org.apache.log4j.PatternLayout\n          |log4j.appender.console.layout.ConversionPattern=%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n\n        ")).stripMargin(), (File)new File(new StringBuilder(17).append(tempLog4jConf).append("/log4j.properties").toString()), (Charset)StandardCharsets.UTF_8);
        String driverClassPath = tempLog4jConf;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append(this.startScript()).append("\n       |  --master local\n       |  --hiveconf ").append(HiveConf.ConfVars.METASTORECONNECTURLKEY).append("=").append(this.metastoreJdbcUri()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.warehousePath()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST).append("=localhost\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE).append("=").append(this.mode()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION).append("=").append(this.operationLogPath()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.LOCALSCRATCHDIR).append("=").append(this.lScratchDir()).append("\n       |  --hiveconf ").append(portConf).append("=").append(port).append("\n       |  --driver-class-path ").append(driverClassPath).append("\n       |  --driver-java-options -Dlog4j.debug\n       |  --conf spark.ui.enabled=false\n       |  ").append(this.extraConf().mkString("\n")).append("\n     ").toString())).stripMargin().split("\\s+"))).toSeq();
    }

    public String THRIFT_BINARY_SERVICE_LIVE() {
        return this.THRIFT_BINARY_SERVICE_LIVE;
    }

    public String THRIFT_HTTP_SERVICE_LIVE() {
        return this.THRIFT_HTTP_SERVICE_LIVE;
    }

    public FiniteDuration SERVER_STARTUP_TIMEOUT() {
        return this.SERVER_STARTUP_TIMEOUT;
    }

    private void startThriftServer(int port, int attempt) {
        this.warehousePath_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.warehousePath().delete();
        this.metastorePath_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.metastorePath().delete();
        this.operationLogPath_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.operationLogPath().delete();
        this.lScratchDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.lScratchDir().delete();
        this.logPath_$eq(null);
        this.logTailingProcess_$eq(null);
        Seq<String> command = this.serverStartCommand(port);
        this.diagnosisBuffer().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(129).append("\n         |### Attempt ").append(attempt).append(" ###\n         |HiveThriftServer2 command line: ").append(command).append("\n         |Listening port: ").append(port).append("\n         |System user: ").append(this.user()).append("\n       ").toString())).stripMargin().split("\n"))));
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Trying to start HiveThriftServer2: port=").append(port).append(", mode=").append(this.mode()).append(", attempt=").append(attempt).toString());
        Seq<String> x$1 = command;
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_TESTING"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_SQL_TESTING"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_PID_DIR"), (Object)this.pidDir().getCanonicalPath())}));
        boolean x$3 = true;
        File x$4 = Utils$.MODULE$.executeAndGetOutput$default$2();
        String lines = Utils$.MODULE$.executeAndGetOutput(x$1, x$4, (Map)x$2, x$3);
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("COMMAND: ").append(command).toString());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("OUTPUT: ").append(lines).toString());
        this.logPath_$eq((File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines.split("\n"))).collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveThriftServer2Test $outer;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.contains(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2Test$$LOG_FILE_MARK()) ? new File((String)new StringOps(Predef$.MODULE$.augmentString(A1)).drop(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2Test$$LOG_FILE_MARK().length())) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = string.contains(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2Test$$LOG_FILE_MARK());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Failed to find HiveThriftServer2 log file.");
        }));
        Promise serverStarted = Promise$.MODULE$.apply();
        this.logPath().createNewFile();
        Seq successLines = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.THRIFT_BINARY_SERVICE_LIVE(), this.THRIFT_HTTP_SERVICE_LIVE()}));
        String[] command2 = new StringBuilder(27).append("/usr/bin/env tail -n +0 -f ").append(this.logPath().getCanonicalPath()).toString().split(" ");
        ProcessBuilder builder = new ProcessBuilder(command2);
        Function1 & Serializable & scala.Serializable captureOutput = (Function1 & Serializable & scala.Serializable)line -> {
            HiveThriftServer2Test.$anonfun$startThriftServer$6(this, successLines, serverStarted, line);
            return BoxedUnit.UNIT;
        };
        Process process = builder.start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getInputStream(), (Function1)captureOutput).start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getErrorStream(), (Function1)captureOutput).start();
        this.logTailingProcess_$eq(process);
        ThreadUtils$.MODULE$.awaitResult((Awaitable)serverStarted.future(), (Duration)this.SERVER_STARTUP_TIMEOUT());
    }

    private void stopThriftServer() {
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.stopScript()}));
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_PID_DIR"), (Object)this.pidDir().getCanonicalPath())}));
        File x$3 = Utils$.MODULE$.executeAndGetOutput$default$2();
        boolean x$4 = Utils$.MODULE$.executeAndGetOutput$default$4();
        Utils$.MODULE$.executeAndGetOutput(x$1, x$3, (Map)x$2, x$4);
        Thread.sleep(new package.DurationInt(package$.MODULE$.DurationInt(3)).seconds().toMillis());
        this.warehousePath().delete();
        this.warehousePath_$eq(null);
        this.metastorePath().delete();
        this.metastorePath_$eq(null);
        this.operationLogPath().delete();
        this.operationLogPath_$eq(null);
        this.lScratchDir().delete();
        this.lScratchDir_$eq(null);
        Option$.MODULE$.apply((Object)this.logPath()).foreach((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.delete()));
        this.logPath_$eq(null);
        Option$.MODULE$.apply((Object)this.logTailingProcess()).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.destroy();
            return BoxedUnit.UNIT;
        });
        this.logTailingProcess_$eq(null);
    }

    public void org$apache$spark$sql$hive$thriftserver$HiveThriftServer2Test$$dumpLogs() {
        this.logError((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("\n         |=====================================\n         |HiveThriftServer2Suite failure output\n         |=====================================\n         |").append(this.diagnosisBuffer().mkString("\n")).append("\n         |=========================================\n         |End HiveThriftServer2Suite failure output\n         |=========================================\n       ").toString())).stripMargin());
    }

    public void beforeAll() {
        super.beforeAll();
        this.listeningPort_$eq(10000 + Random$.MODULE$.nextInt(10000));
        this.diagnosisBuffer().clear();
        ((Try)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foldLeft((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.startThriftServer(this.listeningPort(), 0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> HiveThriftServer2Test.$anonfun$beforeAll$2(this, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)))).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveThriftServer2Test $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2Test$$dumpLogs();
                    throw A12;
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> "HiveThriftServer2 started successfully");
    }

    public void afterAll() {
        try {
            this.stopThriftServer();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "HiveThriftServer2 stopped");
        }
        finally {
            super.afterAll();
        }
    }

    public static final /* synthetic */ void $anonfun$startThriftServer$6(HiveThriftServer2Test $this, Seq successLines$1, Promise serverStarted$1, String line) {
        ArrayBuffer<String> arrayBuffer = $this.diagnosisBuffer();
        synchronized (arrayBuffer) {
            $this.diagnosisBuffer().$plus$eq((Object)line);
            successLines$1.foreach((Function1 & Serializable & scala.Serializable)r -> line.contains((CharSequence)r) ? BoxesRunTime.boxToBoolean((boolean)serverStarted$1.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ Try $anonfun$beforeAll$2(HiveThriftServer2Test $this, Try x0$1, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Try started = (Try)tuple2._1();
        int attempt = tuple2._2$mcI$sp();
        Try try_ = started.orElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.listeningPort_$eq($this.listeningPort() + 1);
            $this.stopThriftServer();
            return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.startThriftServer($this.listeningPort(), attempt));
        });
        return try_;
    }

    public HiveThriftServer2Test() {
        this.hiveConfList = "a=avalue;b=bvalue";
        this.hiveVarList = "c=cvalue;d=dvalue";
        String x$1 = "thriftserver-pid";
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        this.pidDir = Utils$.MODULE$.createTempDir(x$2, x$1);
        this.diagnosisBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.THRIFT_BINARY_SERVICE_LIVE = "Starting ThriftBinaryCLIService on port";
        this.THRIFT_HTTP_SERVICE_LIVE = "Started ThriftHttpCLIService in http";
        this.SERVER_STARTUP_TIMEOUT = new package.DurationInt(package$.MODULE$.DurationInt(3)).minutes();
    }
}

