/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.hive.jdbc.HiveDriver;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2Test;
import org.apache.spark.sql.hive.thriftserver.ServerMode$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r3Aa\u0003\u0007\u00013!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E!9Q\u0006\u0001b\u0001\n\u0003q\u0003BB\u001c\u0001A\u0003%q\u0006C\u00049\u0001\t\u0007I\u0011\u0001\u0018\t\re\u0002\u0001\u0015!\u00030\u0011\u001dQ\u0004A1A\u0005\u00029Baa\u000f\u0001!\u0002\u0013y\u0003\"\u0002\u001f\u0001\t#j\u0004\"\u0002\"\u0001\t#j$A\u0006&eE\u000e\u001cuN\u001c8fGRLwN\\+sSN+\u0018\u000e^3\u000b\u00055q\u0011\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\b\u0011\u0003\u0011A\u0017N^3\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001d\u001b\u0005a\u0011BA\u000f\r\u0005UA\u0015N^3UQJLg\r^*feZ,'O\r+fgR\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005m\u0001\u0011\u0001B7pI\u0016,\u0012a\t\t\u0003I\u001dr!aG\u0013\n\u0005\u0019b\u0011AC*feZ,'/T8eK&\u0011\u0001&\u000b\u0002\u0006-\u0006dW/Z\u0005\u0003U-\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]*\tA&A\u0003tG\u0006d\u0017-\u0001\nK\t\n\u001bu\fV#T)~#\u0015\tV!C\u0003N+U#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001\u00027b]\u001eT\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\t11\u000b\u001e:j]\u001e\f1C\u0013#C\u0007~#Vi\u0015+`\t\u0006#\u0016IQ!T\u000b\u0002\nA!V*F%\u0006)QkU#SA\u0005A\u0001+Q*T/>\u0013F)A\u0005Q\u0003N\u001bvk\u0014*EA\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002}A\u0011q\bQ\u0007\u0002W%\u0011\u0011i\u000b\u0002\u0005+:LG/\u0001\u0005bMR,'/\u00117m\u0001")
public class JdbcConnectionUriSuite
extends HiveThriftServer2Test {
    private final String JDBC_TEST_DATABASE;
    private final String USER;
    private final String PASSWORD;

    @Override
    public Enumeration.Value mode() {
        return ServerMode$.MODULE$.binary();
    }

    public String JDBC_TEST_DATABASE() {
        return this.JDBC_TEST_DATABASE;
    }

    public String USER() {
        return this.USER;
    }

    public String PASSWORD() {
        return this.PASSWORD;
    }

    @Override
    public void beforeAll() {
        super.beforeAll();
        String jdbcUri = new StringBuilder(24).append("jdbc:hive2://localhost:").append(this.serverPort()).append("/").toString();
        Connection connection = DriverManager.getConnection(jdbcUri, this.USER(), this.PASSWORD());
        Statement statement = connection.createStatement();
        statement.execute(new StringBuilder(16).append("CREATE DATABASE ").append(this.JDBC_TEST_DATABASE()).toString());
        connection.close();
    }

    @Override
    public void afterAll() {
        try {
            String jdbcUri = new StringBuilder(24).append("jdbc:hive2://localhost:").append(this.serverPort()).append("/").toString();
            Connection connection = DriverManager.getConnection(jdbcUri, this.USER(), this.PASSWORD());
            Statement statement = connection.createStatement();
            statement.execute(new StringBuilder(14).append("DROP DATABASE ").append(this.JDBC_TEST_DATABASE()).toString());
            connection.close();
        }
        finally {
            super.afterAll();
        }
    }

    public JdbcConnectionUriSuite() {
        Utils$.MODULE$.classForName(HiveDriver.class.getCanonicalName(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        this.JDBC_TEST_DATABASE = "jdbc_test_database";
        this.USER = System.getProperty("user.name");
        this.PASSWORD = "";
        this.test("SPARK-17819 Support default database in connection URIs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String jdbcUri = new StringBuilder(24).append("jdbc:hive2://localhost:").append(this.serverPort()).append("/").append(this.JDBC_TEST_DATABASE()).toString();
            Connection connection = DriverManager.getConnection(jdbcUri, this.USER(), this.PASSWORD());
            Statement statement = connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery("select current_database()");
                resultSet.next();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(resultSet.getString(1));
                String $org_scalatest_assert_macro_right = this.JDBC_TEST_DATABASE();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JdbcConnectionUriSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            }
            finally {
                statement.close();
                connection.close();
            }
            return assertion;
        }, new Position("JdbcConnectionUriSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }
}

