/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.hive.jdbc.HiveQueryResultSet;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.hive.service.rpc.thrift.TGetInfoReq;
import org.apache.hive.service.rpc.thrift.TGetTablesReq;
import org.apache.hive.service.rpc.thrift.TGetTablesResp;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.spark.package$;
import org.apache.spark.sql.catalyst.util.NumberConverter$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftJdbcTest;
import org.apache.spark.sql.hive.thriftserver.ServerMode$;
import org.apache.spark.sql.hive.thriftserver.ThriftserverShimUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00194AAB\u0004\u0001)!)\u0011\u0004\u0001C\u00015!)A\u0004\u0001C!;!)\u0001\u0006\u0001C\u0001S!)\u0001\u000b\u0001C\u0001#\")1\u000b\u0001C\u0001)\n13\u000b]1sWRC'/\u001b4u'\u0016\u0014h/\u001a:Qe>$xnY8m-\u0016\u00148/[8ogN+\u0018\u000e^3\u000b\u0005!I\u0011\u0001\u0004;ie&4Go]3sm\u0016\u0014(B\u0001\u0006\f\u0003\u0011A\u0017N^3\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u0018\u001b\u00059\u0011B\u0001\r\b\u0005IA\u0015N^3UQJLg\r\u001e&eE\u000e$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0003\u0011iw\u000eZ3\u0016\u0003y\u0001\"a\b\u0012\u000f\u0005Y\u0001\u0013BA\u0011\b\u0003)\u0019VM\u001d<fe6{G-Z\u0005\u0003G\u0011\u0012QAV1mk\u0016L!!\n\u0014\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0006\u0002O\u0005)1oY1mC\u00069C/Z:u\u000bb,7-\u001e;f'R\fG/Z7f]R<\u0016\u000e\u001e5Qe>$xnY8m-\u0016\u00148/[8o)\rQ3\b\u0012\u000b\u0003W=\u0002\"\u0001L\u0017\u000e\u0003\u0019J!A\f\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006a\r\u0001\r!M\u0001\u0002MB!AF\r\u001b,\u0013\t\u0019dEA\u0005Gk:\u001cG/[8ocA\u0011Q'O\u0007\u0002m)\u0011q\u0007O\u0001\u0005U\u0012\u00147M\u0003\u0002\u000b\u001f%\u0011!H\u000e\u0002\u0013\u0011&4X-U;fef\u0014Vm];miN+G\u000fC\u0003=\u0007\u0001\u0007Q(A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005y\neB\u0001\f@\u0013\t\u0001u!A\u000bUQJLg\r^:feZ,'o\u00155j[V#\u0018\u000e\\:\n\u0005\t\u001b%\u0001\u0005+Qe>$xnY8m-\u0016\u00148/[8o\u0015\t\u0001u\u0001C\u0003\r\u0007\u0001\u0007Q\t\u0005\u0002G\u001b:\u0011qi\u0013\t\u0003\u0011\u001aj\u0011!\u0013\u0006\u0003\u0015N\ta\u0001\u0010:p_Rt\u0014B\u0001''\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u000513\u0013A\b;fgR<U\r^%oM><\u0016\u000e\u001e5Qe>$xnY8m-\u0016\u00148/[8o)\tY#\u000bC\u0003=\t\u0001\u0007Q(\u0001\u0011uKN$x)\u001a;UC\ndWm],ji\"\u0004&o\u001c;pG>dg+\u001a:tS>tG#B+X1jcFCA\u0016W\u0011\u0015\u0001T\u00011\u00012\u0011\u0015aT\u00011\u0001>\u0011\u0015IV\u00011\u0001F\u0003\u0019\u00198\r[3nC\")1,\u0002a\u0001\u000b\u0006\u0001B/\u00192mK:\u000bW.\u001a)biR,'O\u001c\u0005\u0006;\u0016\u0001\rAX\u0001\u000bi\u0006\u0014G.\u001a+za\u0016\u001c\bcA0e\u000b6\t\u0001M\u0003\u0002bE\u0006!Q\u000f^5m\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a1\u0003\t1K7\u000f\u001e")
public class SparkThriftServerProtocolVersionsSuite
extends HiveThriftJdbcTest {
    @Override
    public Enumeration.Value mode() {
        return ServerMode$.MODULE$.binary();
    }

    public void testExecuteStatementWithProtocolVersion(TProtocolVersion version, String sql, Function1<HiveQueryResultSet, BoxedUnit> f) {
        TSocket rawTransport = new TSocket("localhost", this.serverPort());
        HiveConnection connection = new HiveConnection(new StringBuilder(23).append("jdbc:hive2://localhost:").append(this.serverPort()).toString(), new Properties());
        String user = System.getProperty("user.name");
        TTransport transport = PlainSaslHelper.getPlainTransport((String)user, (String)"anonymous", (TTransport)rawTransport);
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol(transport));
        transport.open();
        HiveQueryResultSet rs = null;
        try {
            TOpenSessionReq clientProtocol = new TOpenSessionReq(version);
            TOpenSessionResp openResp = client.OpenSession(clientProtocol);
            TSessionHandle sessHandle = openResp.getSessionHandle();
            TExecuteStatementReq execReq = new TExecuteStatementReq(sessHandle, sql);
            TExecuteStatementResp execResp = client.ExecuteStatement(execReq);
            TOperationHandle stmtHandle = execResp.getOperationHandle();
            Field protocol = connection.getClass().getDeclaredField("protocol");
            protocol.setAccessible(true);
            protocol.set(connection, version);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(connection.getProtocol());
            TProtocolVersion $org_scalatest_assert_macro_right = version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            rs = new HiveQueryResultSet.Builder((Connection)connection).setClient((TCLIService.Iface)client).setSessionHandle(sessHandle).setStmtHandle(stmtHandle).setMaxRows(Integer.MAX_VALUE).setFetchSize(Integer.MAX_VALUE).build();
            f.apply((Object)rs);
        }
        finally {
            rs.close();
            connection.close();
            transport.close();
            rawTransport.close();
        }
    }

    public void testGetInfoWithProtocolVersion(TProtocolVersion version) {
        TSocket rawTransport = new TSocket("localhost", this.serverPort());
        HiveConnection connection = new HiveConnection(new StringBuilder(23).append("jdbc:hive2://localhost:").append(this.serverPort()).toString(), new Properties());
        TTransport transport = PlainSaslHelper.getPlainTransport((String)this.user(), (String)"anonymous", (TTransport)rawTransport);
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol(transport));
        transport.open();
        try {
            TOpenSessionReq clientProtocol = new TOpenSessionReq(version);
            TOpenSessionResp openResp = client.OpenSession(clientProtocol);
            TSessionHandle sessHandle = openResp.getSessionHandle();
            TGetInfoReq dbVersionReq = new TGetInfoReq(sessHandle, GetInfoType.CLI_DBMS_VER.toTGetInfoType());
            String dbVersion = client.GetInfo(dbVersionReq).getInfoValue().getStringValue();
            TGetInfoReq dbNameReq = new TGetInfoReq(sessHandle, GetInfoType.CLI_DBMS_NAME.toTGetInfoType());
            String dbName = client.GetInfo(dbNameReq).getInfoValue().getStringValue();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dbVersion);
            String $org_scalatest_assert_macro_right = package$.MODULE$.SPARK_VERSION();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dbName);
            String $org_scalatest_assert_macro_right2 = "Spark SQL";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        }
        finally {
            connection.close();
            transport.close();
            rawTransport.close();
        }
    }

    public void testGetTablesWithProtocolVersion(TProtocolVersion version, String schema, String tableNamePattern, List<String> tableTypes, Function1<HiveQueryResultSet, BoxedUnit> f) {
        TSocket rawTransport = new TSocket("localhost", this.serverPort());
        HiveConnection connection = new HiveConnection(new StringBuilder(23).append("jdbc:hive2://localhost:").append(this.serverPort()).toString(), new Properties());
        TTransport transport = PlainSaslHelper.getPlainTransport((String)this.user(), (String)"anonymous", (TTransport)rawTransport);
        TCLIService.Client client = new TCLIService.Client((TProtocol)new TBinaryProtocol(transport));
        transport.open();
        HiveQueryResultSet rs = null;
        try {
            TOpenSessionReq clientProtocol = new TOpenSessionReq(version);
            TOpenSessionResp openResp = client.OpenSession(clientProtocol);
            TSessionHandle sessHandle = openResp.getSessionHandle();
            TGetTablesReq getTableReq = new TGetTablesReq(sessHandle);
            getTableReq.setSchemaName(schema);
            getTableReq.setTableName(tableNamePattern);
            getTableReq.setTableTypes(tableTypes);
            TGetTablesResp getTableResp = client.GetTables(getTableReq);
            Field protocol = connection.getClass().getDeclaredField("protocol");
            protocol.setAccessible(true);
            protocol.set(connection, version);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(connection.getProtocol());
            TProtocolVersion $org_scalatest_assert_macro_right = version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            rs = new HiveQueryResultSet.Builder((Connection)connection).setClient((TCLIService.Iface)client).setSessionHandle(sessHandle).setStmtHandle(getTableResp.getOperationHandle()).build();
            f.apply((Object)rs);
        }
        finally {
            rs.close();
            connection.close();
            transport.close();
            rawTransport.close();
        }
    }

    public static final /* synthetic */ void $anonfun$new$3(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToByte((byte)rs.getByte(1)));
        byte $org_scalatest_assert_macro_right = (byte)1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }

    public static final /* synthetic */ void $anonfun$new$5(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToShort((short)rs.getShort(1)));
        short $org_scalatest_assert_macro_right = (short)1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
    }

    public static final /* synthetic */ void $anonfun$new$7(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rs.getInt(1)));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
    }

    public static final /* synthetic */ void $anonfun$new$9(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)rs.getLong(1)));
        long $org_scalatest_assert_macro_right = 1L;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
    }

    public static final /* synthetic */ void $anonfun$new$11(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToFloat((float)rs.getFloat(1)));
        float $org_scalatest_assert_macro_right = 1.2f;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
    }

    public static final /* synthetic */ void $anonfun$new$13(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rs.getDouble(1)));
        double $org_scalatest_assert_macro_right = 1.2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
    }

    public static final /* synthetic */ void $anonfun$new$15(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getBigDecimal(1));
        BigDecimal $org_scalatest_assert_macro_right = new BigDecimal("1.00");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
    }

    public static final /* synthetic */ void $anonfun$new$16(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getBigDecimal(1));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
    }

    public static final /* synthetic */ void $anonfun$new$18(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "str";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
    }

    public static final /* synthetic */ void $anonfun$new$20(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "char-str";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
    }

    public static final /* synthetic */ void $anonfun$new$22(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "varchar-str";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
    }

    public static final /* synthetic */ void $anonfun$new$24(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "ABC";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
    }

    public static final /* synthetic */ void $anonfun$new$25(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = UTF8String.fromBytes((byte[])NumberConverter$.MODULE$.toBinary(49960)).toString();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
    }

    public static final /* synthetic */ void $anonfun$new$26(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
    }

    public static final /* synthetic */ void $anonfun$new$28(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)rs.getBoolean(1)));
        boolean $org_scalatest_assert_macro_right = true;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
    }

    public static final /* synthetic */ void $anonfun$new$30(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getDate(1));
        Date $org_scalatest_assert_macro_right = Date.valueOf("2019-07-22");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
    }

    public static final /* synthetic */ void $anonfun$new$32(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getTimestamp(1));
        Timestamp $org_scalatest_assert_macro_right = Timestamp.valueOf("2019-07-22 18:14:00");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }

    public static final /* synthetic */ void $anonfun$new$34(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
    }

    public static final /* synthetic */ void $anonfun$new$36(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "1 years 2 days";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
    }

    public static final /* synthetic */ void $anonfun$new$38(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "[1,2]";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
    }

    public static final /* synthetic */ void $anonfun$new$40(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "{1:2}";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
    }

    public static final /* synthetic */ void $anonfun$new$42(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs.getString(1));
        String $org_scalatest_assert_macro_right = "{\"A\":\"alpha\",\"B\":\"beta\"}";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
    }

    public static final /* synthetic */ Assertion $anonfun$new$45(SparkThriftServerProtocolVersionsSuite $this, HiveQueryResultSet rs$1, Seq tableNames$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rs$1.next(), "rs.next()", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(rs$1.getString("TABLE_NAME"));
        String $org_scalatest_assert_macro_right = (String)tableNames$1.apply(i);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
    }

    private final void checkResult$1(Seq tableNames, HiveQueryResultSet rs) {
        if (tableNames.nonEmpty()) {
            tableNames.indices().foreach((Function1 & Serializable & scala.Serializable)i -> SparkThriftServerProtocolVersionsSuite.$anonfun$new$45(this, rs, tableNames, BoxesRunTime.unboxToInt((Object)i)));
        } else {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rs.next(), "rs.next()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        }
    }

    public static final /* synthetic */ void $anonfun$new$46(SparkThriftServerProtocolVersionsSuite $this, TProtocolVersion version$1, Statement statement) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE table1(key INT, val STRING)", "CREATE TABLE table2(key INT, val STRING)"}))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)statement.execute(x$1)));
        $this.testGetTablesWithProtocolVersion(version$1, "%", "%", null, (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            $this.checkResult$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table1", "table2"})), rs);
            return BoxedUnit.UNIT;
        });
        $this.testGetTablesWithProtocolVersion(version$1, "%", "table1", null, (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            $this.checkResult$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table1"})), rs);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$1(SparkThriftServerProtocolVersionsSuite $this, TProtocolVersion version) {
        $this.test(new StringBuilder(14).append(version).append(" get byte type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(1 as byte)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$3($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        $this.test(new StringBuilder(15).append(version).append(" get short type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(1 as short)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$5($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        $this.test(new StringBuilder(13).append(version).append(" get int type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT 1", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$7($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        $this.test(new StringBuilder(16).append(version).append(" get bigint type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(1 as bigint)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$9($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        $this.test(new StringBuilder(15).append(version).append(" get float type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(1.2 as float)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$11($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        $this.test(new StringBuilder(16).append(version).append(" get double type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(1.2 as double)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$13($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        $this.test(new StringBuilder(17).append(version).append(" get decimal type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(1 as decimal(18, 2)) as c", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
                SparkThriftServerProtocolVersionsSuite.$anonfun$new$15($this, rs);
                return BoxedUnit.UNIT;
            });
            $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(null as decimal) ", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
                SparkThriftServerProtocolVersionsSuite.$anonfun$new$16($this, rs);
                return BoxedUnit.UNIT;
            });
        }, new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        $this.test(new StringBuilder(16).append(version).append(" get string type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT 'str'", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$18($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        $this.test(new StringBuilder(14).append(version).append(" get char type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast('char-str' as char(10))", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$20($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        $this.test(new StringBuilder(17).append(version).append(" get varchar type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast('varchar-str' as varchar(10))", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$22($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        $this.test(new StringBuilder(16).append(version).append(" get binary type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast('ABC' as binary)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
                SparkThriftServerProtocolVersionsSuite.$anonfun$new$24($this, rs);
                return BoxedUnit.UNIT;
            });
            $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(49960 as binary)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
                SparkThriftServerProtocolVersionsSuite.$anonfun$new$25($this, rs);
                return BoxedUnit.UNIT;
            });
            $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast(null as binary)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
                SparkThriftServerProtocolVersionsSuite.$anonfun$new$26($this, rs);
                return BoxedUnit.UNIT;
            });
        }, new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        $this.test(new StringBuilder(17).append(version).append(" get boolean type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT true", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$28($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        $this.test(new StringBuilder(14).append(version).append(" get date type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast('2019-07-22' as date)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$30($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        $this.test(new StringBuilder(19).append(version).append(" get timestamp type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT cast('2019-07-22 18:14:00' as timestamp)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$32($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        $this.test(new StringBuilder(9).append(version).append(" get void").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT null", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$34($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        $this.test(new StringBuilder(18).append(version).append(" get interval type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT interval '1' year '2' day", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$36($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        $this.test(new StringBuilder(15).append(version).append(" get array type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT array(1, 2)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$38($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        $this.test(new StringBuilder(13).append(version).append(" get map type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT map(1, 2)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$40($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        $this.test(new StringBuilder(16).append(version).append(" get struct type").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testExecuteStatementWithProtocolVersion(version, "SELECT struct('alpha' AS A, 'beta' AS B)", (Function1<HiveQueryResultSet, BoxedUnit>)(Function1 & Serializable & scala.Serializable)rs -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$42($this, rs);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        $this.test(new StringBuilder(9).append(version).append(" get info").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testGetInfoWithProtocolVersion(version), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        $this.test(new StringBuilder(11).append(version).append(" get tables").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withJdbcStatement((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table1", "table2"}), (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)statement -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$46($this, version, statement);
            return BoxedUnit.UNIT;
        }), new Position("SparkThriftServerProtocolVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
    }

    public SparkThriftServerProtocolVersionsSuite() {
        ThriftserverShimUtils$.MODULE$.testedProtocolVersions().foreach((Function1 & Serializable & scala.Serializable)version -> {
            SparkThriftServerProtocolVersionsSuite.$anonfun$new$1(this, version);
            return BoxedUnit.UNIT;
        });
    }
}

