/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.execution.HiveResult$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.hive.thriftserver.ThriftserverShimUtils$;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tmd!\u0002\u0017.\u0001=J\u0004\u0002C(\u0001\u0005\u000b\u0007I\u0011A)\t\u0011Y\u0003!\u0011!Q\u0001\nIC\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"AA\u000e\u0001B\u0001B\u0003%Q\u000e\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011\u0015Q\b\u0001\"\u0001|\u0011-\t)\u0001\u0001a\u0001\u0002\u0004%I!a\u0002\t\u0017\u0005\u001d\u0002\u00011AA\u0002\u0013%\u0011\u0011\u0006\u0005\f\u0003k\u0001\u0001\u0019!A!B\u0013\tI\u0001C\u0006\u00028\u0001\u0001\r\u00111A\u0005\n\u0005e\u0002bCA'\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fB1\"a\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002<!I\u0011Q\u000b\u0001A\u0002\u0013%\u0011q\u000b\u0005\n\u0003?\u0002\u0001\u0019!C\u0005\u0003CB\u0001\"!\u001a\u0001A\u0003&\u0011\u0011\f\u0005\n\u0003O\u0002\u0001\u0019!C\u0005\u0003/B\u0011\"!\u001b\u0001\u0001\u0004%I!a\u001b\t\u0011\u0005=\u0004\u0001)Q\u0005\u00033B1\"!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002t!Y\u0011Q\u0011\u0001A\u0002\u0003\u0007I\u0011BAD\u0011-\tY\t\u0001a\u0001\u0002\u0003\u0006K!!\u001e\t\u0017\u00055\u0005\u00011AA\u0002\u0013%\u0011q\u0012\u0005\f\u0003?\u0003\u0001\u0019!a\u0001\n\u0013\t\t\u000bC\u0006\u0002&\u0002\u0001\r\u0011!Q!\n\u0005E\u0005BCAT\u0001!\u0015\r\u0011\"\u0003\u0002*\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0003o\u0004A\u0011AA}\u0011\u001d\tY\u0010\u0001C!\u0003{Dq!a@\u0001\t\u0013\ti\u0010C\u0004\u0003\u0002\u0001!\t%!@\t\u000f\t\r\u0001\u0001\"\u0015\u0002~\"a!Q\u0001\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0003\b!a!\u0011\u0003\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0003\u0014!a!1\u0005\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0003&!a!q\u0006\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u00032!a!Q\u0007\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u00038\u001dA!qI\u0017\t\u0002=\u0012IEB\u0004-[!\u0005qFa\u0013\t\riDC\u0011\u0001B*\u0011\u001d\u0011)\u0006\u000bC\u0001\u0005/B\u0011Ba\u0019)#\u0003%\tA!\u001a\u0003=M\u0003\u0018M]6Fq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oi>\u0003XM]1uS>t'B\u0001\u00180\u00031!\bN]5giN,'O^3s\u0015\t\u0001\u0014'\u0001\u0003iSZ,'B\u0001\u001a4\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003iU\nQa\u001d9be.T!AN\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0014aA8sON!\u0001AO#J!\tY4)D\u0001=\u0015\tid(A\u0005pa\u0016\u0014\u0018\r^5p]*\u0011q\bQ\u0001\u0004G2L'BA!C\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001M\u001b\n\u0005\u0011c$!G#yK\u000e,H/Z*uCR,W.\u001a8u\u001fB,'/\u0019;j_:\u0004\"AR$\u000e\u00035J!\u0001S\u0017\u0003\u001dM\u0003\u0018M]6Pa\u0016\u0014\u0018\r^5p]B\u0011!*T\u0007\u0002\u0017*\u0011AjM\u0001\tS:$XM\u001d8bY&\u0011aj\u0013\u0002\b\u0019><w-\u001b8h\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u0002\u0001+\u0005\u0011\u0006CA*U\u001b\u0005\t\u0014BA+2\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010^\u0001\fgFd7i\u001c8uKb$\b%A\u0007qCJ,g\u000e^*fgNLwN\u001c\t\u00033rk\u0011A\u0017\u0006\u00037z\nqa]3tg&|g.\u0003\u0002^5\nY\u0001*\u001b<f'\u0016\u001c8/[8o\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0002aS:\u0011\u0011m\u001a\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IB\u000ba\u0001\u0010:p_Rt$\"\u00014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!,\u0017A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001[3\u0002\u0017\r|gNZ(wKJd\u0017-\u001f\t\u0005]N|v,D\u0001p\u0015\t\u0001\u0018/\u0001\u0003vi&d'\"\u0001:\u0002\t)\fg/Y\u0005\u0003i>\u00141!T1q\u0003=\u0011XO\\%o\u0005\u0006\u001c7n\u001a:pk:$\u0007CA<y\u001b\u0005)\u0017BA=f\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003\u0003?~}~\f\t!a\u0001\u0011\u0005\u0019\u0003\u0001\"B(\b\u0001\u0004\u0011\u0006\"B,\b\u0001\u0004A\u0006\"\u00020\b\u0001\u0004y\u0006\"\u00027\b\u0001\u0004i\u0007bB;\b!\u0003\u0005\rA^\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003CqA!!\u0004\u0002\u001e9!\u0011qBA\u000e\u001d\u0011\t\t\"!\u0007\u000f\t\u0005M\u0011q\u0003\b\u0004E\u0006U\u0011\"\u0001\u001d\n\u0005Y:\u0014B\u0001\u001b6\u0013\t\u00114'C\u0002\u0002 E\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0005\u0015\"!\u0003#bi\u00064%/Y7f\u0015\r\ty\"M\u0001\u000be\u0016\u001cX\u000f\u001c;`I\u0015\fH\u0003BA\u0016\u0003c\u00012a^A\u0017\u0013\r\ty#\u001a\u0002\u0005+:LG\u000fC\u0005\u00024%\t\t\u00111\u0001\u0002\n\u0005\u0019\u0001\u0010J\u0019\u0002\u000fI,7/\u001e7uA\u0005Q!/Z:vYRd\u0015n\u001d;\u0016\u0005\u0005m\u0002#B<\u0002>\u0005\u0005\u0013bAA K\n1q\n\u001d;j_:\u0004Ra^A\"\u0003\u000fJ1!!\u0012f\u0005\u0015\t%O]1z!\r\u0019\u0016\u0011J\u0005\u0004\u0003\u0017\n$a\u0001*po\u0006q!/Z:vYRd\u0015n\u001d;`I\u0015\fH\u0003BA\u0016\u0003#B\u0011\"a\r\r\u0003\u0003\u0005\r!a\u000f\u0002\u0017I,7/\u001e7u\u0019&\u001cH\u000fI\u0001\u0017aJ,g/[8vg\u001a+Go\u00195F]\u0012|eMZ:fiV\u0011\u0011\u0011\f\t\u0004o\u0006m\u0013bAA/K\n!Aj\u001c8h\u0003i\u0001(/\u001a<j_V\u001ch)\u001a;dQ\u0016sGm\u00144gg\u0016$x\fJ3r)\u0011\tY#a\u0019\t\u0013\u0005Mr\"!AA\u0002\u0005e\u0013a\u00069sKZLw.^:GKR\u001c\u0007.\u00128e\u001f\u001a47/\u001a;!\u0003a\u0001(/\u001a<j_V\u001ch)\u001a;dQN#\u0018M\u001d;PM\u001a\u001cX\r^\u0001\u001daJ,g/[8vg\u001a+Go\u00195Ti\u0006\u0014Ho\u00144gg\u0016$x\fJ3r)\u0011\tY#!\u001c\t\u0013\u0005M\"#!AA\u0002\u0005e\u0013!\u00079sKZLw.^:GKR\u001c\u0007n\u0015;beR|eMZ:fi\u0002\nA!\u001b;feV\u0011\u0011Q\u000f\t\u0007\u0003o\ny(a\u0012\u000f\t\u0005e\u0014Q\u0010\b\u0004E\u0006m\u0014\"\u00014\n\u0007\u0005}Q-\u0003\u0003\u0002\u0002\u0006\r%\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005}Q-\u0001\u0005ji\u0016\u0014x\fJ3r)\u0011\tY#!#\t\u0013\u0005MR#!AA\u0002\u0005U\u0014!B5uKJ\u0004\u0013!\u00033bi\u0006$\u0016\u0010]3t+\t\t\t\nE\u0003x\u0003\u0007\n\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI*M\u0001\u0006if\u0004Xm]\u0005\u0005\u0003;\u000b9J\u0001\u0005ECR\fG+\u001f9f\u00035!\u0017\r^1UsB,7o\u0018\u0013fcR!\u00111FAR\u0011%\t\u0019\u0004GA\u0001\u0002\u0004\t\t*\u0001\u0006eCR\fG+\u001f9fg\u0002\nAB]3tk2$8k\u00195f[\u0006,\"!a+\u0011\t\u00055\u0016qV\u0007\u0002}%\u0019\u0011\u0011\u0017 \u0003\u0017Q\u000b'\r\\3TG\",W.Y\u0001\u0016C\u0012$gj\u001c8Ok2d7i\u001c7v[:4\u0016\r\\;f)!\tY#a.\u0002<\u0006U\u0007bBA]7\u0001\u0007\u0011qI\u0001\u0005MJ|W\u000eC\u0004\u0002>n\u0001\r!a0\u0002\u0005Q|\u0007CBAa\u0003\u0017\fy-\u0004\u0002\u0002D*!\u0011QYAd\u0003\u001diW\u000f^1cY\u0016T1!!3f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\f\u0019MA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA<\u0002R&\u0019\u00111[3\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002Xn\u0001\r!!7\u0002\u000f=\u0014H-\u001b8bYB\u0019q/a7\n\u0007\u0005uWMA\u0002J]R\fQbZ3u\u001d\u0016DHOU8x'\u0016$HCBAr\u0003S\f\u0019\u0010\u0005\u0003\u0002.\u0006\u0015\u0018bAAt}\t1!k\\<TKRDq!a;\u001d\u0001\u0004\ti/A\u0003pe\u0012,'\u000f\u0005\u0003\u0002.\u0006=\u0018bAAy}\t\u0001b)\u001a;dQ>\u0013\u0018.\u001a8uCRLwN\u001c\u0005\b\u0003kd\u0002\u0019AA-\u0003!i\u0017\r\u001f*poNd\u0015AE4fiJ+7/\u001e7u'\u0016$8k\u00195f[\u0006$\"!a+\u0002\u0017I,h.\u00138uKJt\u0017\r\u001c\u000b\u0003\u0003W\tq!\u001a=fGV$X-\u0001\u0004dC:\u001cW\r\\\u0001\bG2,\u0017M\\;q\u0003%\u0002(o\u001c;fGR,G\r\n<bY&$\u0017\r^3EK\u001a\fW\u000f\u001c;GKR\u001c\u0007n\u0014:jK:$\u0018\r^5p]R!!\u0011\u0002B\b)\u0011\tYCa\u0003\t\u000f\t5!\u00051\u0001\u0002n\u0006YqN]5f]R\fG/[8o\u0011!\t\u0019DIA\u0001\u0002\u0004a\u0018!\u00069s_R,7\r^3eI\u0005\u001c8/\u001a:u'R\fG/\u001a\u000b\u0005\u0005+\u0011\t\u0003\u0006\u0003\u0002,\t]\u0001b\u0002B\rG\u0001\u0007!1D\u0001\u0006gR\fG/\u001a\t\u0005\u0003[\u0013i\"C\u0002\u0003 y\u0012ab\u00149fe\u0006$\u0018n\u001c8Ti\u0006$X\r\u0003\u0005\u00024\r\n\t\u00111\u0001}\u0003e\u0001(o\u001c;fGR,G\rJ:fi\"\u000b7OU3tk2$8+\u001a;\u0015\t\t\u001d\"Q\u0006\u000b\u0005\u0003W\u0011I\u0003\u0003\u0004\u0003,\u0011\u0002\rA^\u0001\rQ\u0006\u001c(+Z:vYR\u001cV\r\u001e\u0005\t\u0003g!\u0013\u0011!a\u0001y\u0006)\u0003O]8uK\u000e$X\r\u001a\u0013sK\u001eL7\u000f^3s\u0007V\u0014(/\u001a8u\u001fB,'/\u0019;j_:dun\u001a\u000b\u0005\u0003{\u0014\u0019\u0004\u0003\u0005\u00024\u0015\n\t\u00111\u0001}\u0003}\u0001(o\u001c;fGR,G\rJ:fi>\u0003XM]1uS>tW\t_2faRLwN\u001c\u000b\u0005\u0005s\u0011)\u0005\u0006\u0003\u0002,\tm\u0002b\u0002B\u001fM\u0001\u0007!qH\u0001\u0013_B,'/\u0019;j_:,\u0005pY3qi&|g\u000e\u0005\u0003\u0002.\n\u0005\u0013b\u0001B\"}\t\u0001\u0002*\u001b<f'FcU\t_2faRLwN\u001c\u0005\t\u0003g1\u0013\u0011!a\u0001y\u0006q2\u000b]1sW\u0016CXmY;uKN#\u0018\r^3nK:$x\n]3sCRLwN\u001c\t\u0003\r\"\u001a2\u0001\u000bB'!\r9(qJ\u0005\u0004\u0005#*'AB!osJ+g\r\u0006\u0002\u0003J\u0005qq-\u001a;UC\ndWmU2iK6\fG\u0003BAV\u00053BqAa\u0017+\u0001\u0004\u0011i&\u0001\u0006tiJ,8\r\u001e+za\u0016\u0004B!!&\u0003`%!!\u0011MAL\u0005)\u0019FO];diRK\b/Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\u001d$f\u0001<\u0003j-\u0012!1\u000e\t\u0005\u0005[\u00129(\u0004\u0002\u0003p)!!\u0011\u000fB:\u0003%)hn\u00195fG.,GMC\u0002\u0003v\u0015\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IHa\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class SparkExecuteStatementOperation
extends ExecuteStatementOperation
implements SparkOperation {
    private TableSchema resultSchema;
    private final SQLContext sqlContext;
    private final HiveSession parentSession;
    private final String statement;
    private final boolean runInBackground;
    private Dataset<Row> result;
    private Option<Row[]> resultList;
    private long previousFetchEndOffset;
    private long previousFetchStartOffset;
    private Iterator<Row> iter;
    private DataType[] dataTypes;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return SparkExecuteStatementOperation$.MODULE$.$lessinit$greater$default$5();
    }

    public static TableSchema getTableSchema(StructType structType) {
        return SparkExecuteStatementOperation$.MODULE$.getTableSchema(structType);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ void protected$validateDefaultFetchOrientation(SparkExecuteStatementOperation x$1, FetchOrientation orientation) {
        x$1.validateDefaultFetchOrientation(orientation);
    }

    public /* synthetic */ void protected$assertState(SparkExecuteStatementOperation x$1, OperationState state) {
        x$1.assertState(state);
    }

    public /* synthetic */ void protected$setHasResultSet(SparkExecuteStatementOperation x$1, boolean hasResultSet) {
        x$1.setHasResultSet(hasResultSet);
    }

    public /* synthetic */ void protected$registerCurrentOperationLog(SparkExecuteStatementOperation x$1) {
        x$1.registerCurrentOperationLog();
    }

    public /* synthetic */ void protected$setOperationException(SparkExecuteStatementOperation x$1, HiveSQLException operationException) {
        x$1.setOperationException(operationException);
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private Dataset<Row> result() {
        return this.result;
    }

    private void result_$eq(Dataset<Row> x$1) {
        this.result = x$1;
    }

    private Option<Row[]> resultList() {
        return this.resultList;
    }

    private void resultList_$eq(Option<Row[]> x$1) {
        this.resultList = x$1;
    }

    private long previousFetchEndOffset() {
        return this.previousFetchEndOffset;
    }

    private void previousFetchEndOffset_$eq(long x$1) {
        this.previousFetchEndOffset = x$1;
    }

    private long previousFetchStartOffset() {
        return this.previousFetchStartOffset;
    }

    private void previousFetchStartOffset_$eq(long x$1) {
        this.previousFetchStartOffset = x$1;
    }

    private Iterator<Row> iter() {
        return this.iter;
    }

    private void iter_$eq(Iterator<Row> x$1) {
        this.iter = x$1;
    }

    private DataType[] dataTypes() {
        return this.dataTypes;
    }

    private void dataTypes_$eq(DataType[] x$1) {
        this.dataTypes = x$1;
    }

    private TableSchema resultSchema$lzycompute() {
        SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
        synchronized (sparkExecuteStatementOperation) {
            if (!this.bitmap$0) {
                TableSchema tableSchema;
                if (this.result() == null || this.result().schema().isEmpty()) {
                    tableSchema = new TableSchema(Arrays.asList((Object[])new FieldSchema[]{new FieldSchema("Result", "string", "")}));
                } else {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Result Schema: ").append(this.result().schema()).toString());
                    tableSchema = SparkExecuteStatementOperation$.MODULE$.getTableSchema(this.result().schema());
                }
                this.resultSchema = tableSchema;
                this.bitmap$0 = true;
            }
        }
        return this.resultSchema;
    }

    private TableSchema resultSchema() {
        return !this.bitmap$0 ? this.resultSchema$lzycompute() : this.resultSchema;
    }

    public void addNonNullColumnValue(Row from, ArrayBuffer<Object> to, int ordinal) {
        DataType dataType = this.dataTypes()[ordinal];
        if (StringType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)from.getString(ordinal));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToInteger((int)from.getInt(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)from.getBoolean(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToDouble((double)from.getDouble(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToFloat((float)from.getFloat(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DecimalType$.MODULE$.unapply(dataType)) {
            to.$plus$eq((Object)from.getDecimal(ordinal));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LongType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToLong((long)from.getLong(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToByte((byte)from.getByte(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToShort((short)from.getShort(ordinal)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            to.$plus$eq(from.getAs(ordinal));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = dataType instanceof DateType ? true : dataType instanceof TimestampType;
            if (bl) {
                String hiveString = HiveResult$.MODULE$.toHiveString(new Tuple2(from.get(ordinal), (Object)this.dataTypes()[ordinal]), HiveResult$.MODULE$.toHiveString$default$2());
                to.$plus$eq((Object)hiveString);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                to.$plus$eq((Object)HiveResult$.MODULE$.toHiveString(new Tuple2(from.getAs(ordinal), (Object)CalendarIntervalType$.MODULE$), HiveResult$.MODULE$.toHiveString$default$2()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = dataType instanceof ArrayType ? true : (dataType instanceof StructType ? true : (dataType instanceof MapType ? true : dataType instanceof UserDefinedType));
                if (bl2) {
                    String hiveString = HiveResult$.MODULE$.toHiveString(new Tuple2(from.get(ordinal), (Object)this.dataTypes()[ordinal]), HiveResult$.MODULE$.toHiveString$default$2());
                    to.$plus$eq((Object)hiveString);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation order, long maxRowsL) {
        return (RowSet)this.withLocalProperties((Function0 & Serializable & scala.Serializable)() -> {
            RowSet rowSet;
            long l;
            this.log().info(new StringBuilder(57).append("Received getNextRowSet request order=").append((Object)order).append(" and maxRowsL=").append(maxRowsL).append(" ").append("with ").append(this.statementId()).toString());
            this.protected$validateDefaultFetchOrientation(this, order);
            this.protected$assertState(this, OperationState.FINISHED);
            this.protected$setHasResultSet(this, true);
            RowSet resultRowSet = ThriftserverShimUtils$.MODULE$.resultRowSet(this.getResultSetSchema(), this.getProtocolVersion());
            if ((order.equals((Object)FetchOrientation.FETCH_FIRST) || order.equals((Object)FetchOrientation.FETCH_PRIOR)) && this.previousFetchEndOffset() != 0L) {
                Iterator iterator;
                if (new StringOps(Predef$.MODULE$.augmentString(this.sqlContext().getConf(SQLConf$.MODULE$.THRIFTSERVER_INCREMENTAL_COLLECT().key()))).toBoolean()) {
                    this.resultList_$eq((Option<Row[]>)None$.MODULE$);
                    iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.result().toLocalIterator()).asScala();
                } else {
                    if (this.resultList().isEmpty()) {
                        this.resultList_$eq((Option<Row[]>)new Some(this.result().collect()));
                    }
                    iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.resultList().get())).iterator();
                }
                this.iter_$eq((Iterator<Row>)iterator);
            }
            if (order.equals((Object)FetchOrientation.FETCH_FIRST)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("FETCH_FIRST request with ").append(this.statementId()).append(". Resetting to resultOffset=0").toString());
                l = 0;
            } else if (order.equals((Object)FetchOrientation.FETCH_PRIOR)) {
                long targetOffset = package$.MODULE$.max(this.previousFetchStartOffset() - maxRowsL, 0L);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("FETCH_PRIOR request with ").append(this.statementId()).append(". Resetting to resultOffset=").append(targetOffset).toString());
                int off = 0;
                while ((long)off < targetOffset && this.iter().hasNext()) {
                    this.iter().next();
                    ++off;
                }
                l = off;
            } else {
                l = this.previousFetchEndOffset();
            }
            long resultOffset = l;
            resultRowSet.setStartOffset(resultOffset);
            this.previousFetchStartOffset_$eq(resultOffset);
            if (!this.iter().hasNext()) {
                rowSet = resultRowSet;
            } else {
                int maxRows = (int)maxRowsL;
                int curRow = 0;
                while (curRow < maxRows && this.iter().hasNext()) {
                    Row sparkRow = (Row)this.iter().next();
                    ArrayBuffer row = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    for (int curCol = 0; curCol < sparkRow.length(); ++curCol) {
                        ArrayBuffer arrayBuffer;
                        if (sparkRow.isNullAt(curCol)) {
                            arrayBuffer = row.$plus$eq(null);
                            continue;
                        }
                        this.addNonNullColumnValue(sparkRow, (ArrayBuffer<Object>)row, curCol);
                        arrayBuffer = BoxedUnit.UNIT;
                    }
                    resultRowSet.addRow((Object[])row.toArray(ClassTag$.MODULE$.Any()));
                    ++curRow;
                    ++resultOffset;
                }
                this.previousFetchEndOffset_$eq(resultOffset);
                this.log().info(new StringBuilder(55).append("Returning result set with ").append(curRow).append(" rows from offsets ").append("[").append(this.previousFetchStartOffset()).append(", ").append(this.previousFetchEndOffset()).append(") with ").append(this.statementId()).toString());
                rowSet = resultRowSet;
            }
            return rowSet;
        });
    }

    @Override
    public TableSchema getResultSetSchema() {
        return this.resultSchema();
    }

    @Override
    public void runInternal() {
        this.setState(OperationState.PENDING);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Submitting query '").append($this.statement).append("' with ").append(this.statementId()).toString());
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), this.statement, this.statementId(), this.parentSession.getUsername());
        this.setHasResultSet(true);
        if (!this.runInBackground) {
            this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute();
        } else {
            UserGroupInformation sparkServiceUGI = Utils.getUGI();
            Runnable backgroundOperation = new Runnable(this, sparkServiceUGI){
                private final /* synthetic */ SparkExecuteStatementOperation $outer;
                private final UserGroupInformation sparkServiceUGI$1;

                public void run() {
                    PrivilegedExceptionAction<BoxedUnit> doAsAction = new PrivilegedExceptionAction<BoxedUnit>(this){
                        private final /* synthetic */ $anon$1 $outer;

                        public void run() {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().protected$registerCurrentOperationLog(this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer());
                            try {
                                this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().withLocalProperties((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute());
                            }
                            catch (HiveSQLException e) {
                                this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().protected$setOperationException(this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer(), e);
                                this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().log().error("Error running hive query: ", (Throwable)e);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$$anon$1$$anon$2 )}, serializedLambda);
                        }
                    };
                    try {
                        this.sparkServiceUGI$1.doAs((PrivilegedExceptionAction)doAsAction);
                    }
                    catch (Exception e) {
                        this.$outer.protected$setOperationException(this.$outer, new HiveSQLException(e));
                        this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error running hive query as user : ").append($this.sparkServiceUGI$1.getShortUserName()).toString(), e);
                    }
                }

                public /* synthetic */ SparkExecuteStatementOperation org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sparkServiceUGI$1 = sparkServiceUGI$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$$anon$1 )}, serializedLambda);
                }
            };
            try {
                Future<?> backgroundHandle = this.parentSession.getSessionManager().submitBackgroundOperation(backgroundOperation);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof RejectedExecutionException) {
                    RejectedExecutionException rejectedExecutionException = (RejectedExecutionException)throwable2;
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error submitting query in background, query rejected", rejectedExecutionException);
                    this.setState(OperationState.ERROR);
                    HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), rejectedExecutionException.getMessage(), Utils$.MODULE$.exceptionString((Throwable)rejectedExecutionException));
                    throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejectedExecutionException);
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error executing query in background", e);
                    this.setState(OperationState.ERROR);
                    HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), e.getMessage(), Utils$.MODULE$.exceptionString(e));
                    throw new HiveSQLException(e);
                }
                throw throwable;
            }
        }
    }

    public void org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute() {
        block29: {
            block28: {
                try {
                    try {
                        Iterator iterator;
                        block27: {
                            SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
                            synchronized (sparkExecuteStatementOperation) {
                                block26: {
                                    if (this.getStatus().getState().isTerminal()) {
                                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Query with ").append(this.statementId()).append(" in terminal state before it started running").toString());
                                        break block26;
                                    }
                                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running query with ").append(this.statementId()).toString());
                                    this.setState(OperationState.RUNNING);
                                    break block27;
                                }
                                break block28;
                            }
                        }
                        NonClosableMutableURLClassLoader executionHiveClassLoader = this.sqlContext().sharedState().jarClassLoader();
                        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
                        if (!this.runInBackground) {
                            this.parentSession.getSessionState().getConf().setClassLoader((ClassLoader)executionHiveClassLoader);
                        }
                        SparkContext qual$1 = this.sqlContext().sparkContext();
                        String x$12 = this.statementId();
                        String x$2 = this.statement;
                        boolean x$3 = qual$1.setJobGroup$default$3();
                        qual$1.setJobGroup(x$12, x$2, x$3);
                        this.result_$eq((Dataset<Row>)this.sqlContext().sql(this.statement));
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.result().queryExecution().toString());
                        HiveThriftServer2$.MODULE$.eventManager().onStatementParsed(this.statementId(), this.result().queryExecution().toString());
                        if (new StringOps(Predef$.MODULE$.augmentString(this.sqlContext().getConf(SQLConf$.MODULE$.THRIFTSERVER_INCREMENTAL_COLLECT().key()))).toBoolean()) {
                            this.resultList_$eq((Option<Row[]>)None$.MODULE$);
                            iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.result().toLocalIterator()).asScala();
                        } else {
                            this.resultList_$eq((Option<Row[]>)new Some(this.result().collect()));
                            iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.resultList().get())).iterator();
                        }
                        this.iter_$eq((Iterator<Row>)iterator);
                        this.dataTypes_$eq((DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.result().schema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))));
                        break block29;
                    }
                    catch (Throwable e) {
                        OperationState currentState;
                        if (this.statementId() != null) {
                            this.sqlContext().sparkContext().cancelJobGroup(this.statementId());
                        }
                        if ((currentState = this.getStatus().getState()).isTerminal()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Ignore exception in terminal state with ").append(this.statementId()).append(": ").append(e).toString());
                            break block29;
                        }
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error executing query with ").append(this.statementId()).append(", currentState ").append((Object)currentState).append(", ").toString(), e);
                        this.setState(OperationState.ERROR);
                        Throwable throwable = e;
                        if (throwable instanceof HiveSQLException) {
                            HiveSQLException hiveSQLException = (HiveSQLException)throwable;
                            HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), hiveSQLException.getMessage(), Utils$.MODULE$.exceptionString((Throwable)hiveSQLException));
                            throw hiveSQLException;
                        }
                        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
                        HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), root.getMessage(), Utils$.MODULE$.exceptionString(root));
                        throw new HiveSQLException(new StringBuilder(21).append("Error running query: ").append(root.toString()).toString(), root);
                    }
                }
                catch (Throwable throwable) {
                    SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
                    synchronized (sparkExecuteStatementOperation) {
                        if (!this.getStatus().getState().isTerminal()) {
                            this.setState(OperationState.FINISHED);
                            HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
                        }
                    }
                    this.sqlContext().sparkContext().clearJobGroup();
                    throw throwable;
                }
            }
            SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
            synchronized (sparkExecuteStatementOperation) {
                if (!this.getStatus().getState().isTerminal()) {
                    this.setState(OperationState.FINISHED);
                    HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
                }
            }
            this.sqlContext().sparkContext().clearJobGroup();
            return;
        }
        SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
        synchronized (sparkExecuteStatementOperation) {
            if (!this.getStatus().getState().isTerminal()) {
                this.setState(OperationState.FINISHED);
                HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
            }
        }
        this.sqlContext().sparkContext().clearJobGroup();
    }

    @Override
    public synchronized void cancel() {
        block0: {
            if (this.getStatus().getState().isTerminal()) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Cancel query with ").append(this.statementId()).toString());
            this.setState(OperationState.CANCELED);
            this.cleanup();
            HiveThriftServer2$.MODULE$.eventManager().onStatementCanceled(this.statementId());
        }
    }

    @Override
    public void cleanup() {
        block0: {
            Future<?> backgroundHandle;
            Object object = this.runInBackground ? ((backgroundHandle = this.getBackgroundHandle()) != null ? BoxesRunTime.boxToBoolean((boolean)backgroundHandle.cancel(true)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            if (this.statementId() == null) break block0;
            this.sqlContext().sparkContext().cancelJobGroup(this.statementId());
        }
    }

    public SparkExecuteStatementOperation(SQLContext sqlContext, HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground) {
        this.sqlContext = sqlContext;
        this.parentSession = parentSession;
        this.statement = statement;
        this.runInBackground = runInBackground;
        super(parentSession, statement, confOverlay, runInBackground);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
        this.previousFetchEndOffset = 0L;
        this.previousFetchStartOffset = 0L;
    }
}

