/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.sql.hive.thriftserver.ThriftserverShimUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@ScalaSignature(bytes="\u0006\u0001\u00055uA\u0002\u0010 \u0011\u0003\t3F\u0002\u0004.?!\u0005\u0011E\f\u0005\u0006w\u0005!\t!\u0010\u0005\b}\u0005\u0011\r\u0011\"\u0003@\u0011\u0019A\u0015\u0001)A\u0005\u0001\"9\u0011*\u0001b\u0001\n\u0013Q\u0005BB+\u0002A\u0003%1\nC\u0005W\u0003\u0001\u0007\t\u0019!C\u0005/\"Iq,\u0001a\u0001\u0002\u0004%I\u0001\u0019\u0005\nM\u0006\u0001\r\u0011!Q!\naCqaZ\u0001C\u0002\u00135\u0001\u000e\u0003\u0004m\u0003\u0001\u0006i!\u001b\u0005\u0006[\u0006!\tA\u001c\u0005\u0006_\u0006!\t\u0001\u001d\u0005\u0006m\u0006!\ta\u001e\u0004\u0007[}\u0001\u0011%!\u0004\t\rmzA\u0011AA\u000b\u0011%\tIb\u0004b\u0001\n\u0013\tY\u0002C\u0004\u0002\u001e=\u0001\u000b\u0011B?\t\u0013\u0005}qB1A\u0005\n\u0005\u0005\u0002\u0002CA\u001e\u001f\u0001\u0006I!a\t\t\u0011Y|!\u0019!C\u0005\u0003{Aq!a\u0010\u0010A\u0003%\u0001\u0010C\u0005\u0002B=\u0011\r\u0011\"\u0003\u0002D!A\u0011qJ\b!\u0002\u0013\t)\u0005C\u0004\u0002R=!\t%a\u0015\t\r\u0005\u0015t\u0002\"\u0001o\u0011\u001d\t9g\u0004C!\u0003SBq!!\u001e\u0010\t\u0003\n9\bC\u0004\u0002\u0002>!I!a!\u0002#M\u0003\u0018M]6T#2\u001bE*\u0013#sSZ,'O\u0003\u0002!C\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011!eI\u0001\u0005Q&4XM\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u0004\"\u0001L\u0001\u000e\u0003}\u0011\u0011c\u00159be.\u001c\u0016\u000bT\"M\u0013\u0012\u0013\u0018N^3s'\r\tq&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YJT\"A\u001c\u000b\u0005a*\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005i:$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t1&\u0001\u0004qe>l\u0007\u000f^\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0005Y\u0006twMC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%AB*ue&tw-A\u0004qe>l\u0007\u000f\u001e\u0011\u0002\u001f\r|g\u000e^5ok\u0016$\u0007K]8naR,\u0012a\u0013\t\u0003\u0019Ns!!T)\u0011\u00059\u000bT\"A(\u000b\u0005Ac\u0014A\u0002\u001fs_>$h(\u0003\u0002Sc\u00051\u0001K]3eK\u001aL!a\u0012+\u000b\u0005I\u000b\u0014\u0001E2p]RLg.^3e!J|W\u000e\u001d;!\u0003%!(/\u00198ta>\u0014H/F\u0001Y!\tIV,D\u0001[\u0015\t16L\u0003\u0002]O\u00051A\u000f\u001b:jMRL!A\u0018.\u0003\u000fQ\u001bvnY6fi\u0006iAO]1ogB|'\u000f^0%KF$\"!\u00193\u0011\u0005A\u0012\u0017BA22\u0005\u0011)f.\u001b;\t\u000f\u0015D\u0011\u0011!a\u00011\u0006\u0019\u0001\u0010J\u0019\u0002\u0015Q\u0014\u0018M\\:q_J$\b%\u0001\rT!\u0006\u00136j\u0018%B\t>{\u0005k\u0018)S\u001fB{\u0006KU#G\u0013b+\u0012![\b\u0002U\u0006\n1.A\u0007ta\u0006\u00148N\f5bI>|\u0007OL\u0001\u001a'B\u000b%kS0I\u0003\u0012{u\nU0Q%>\u0003v\f\u0015*F\r&C\u0006%\u0001\u000bj]N$\u0018\r\u001c7TS\u001et\u0017\r\u001c%b]\u0012dWM\u001d\u000b\u0002C\u0006!Q.Y5o)\t\t\u0017\u000fC\u0003s\u001b\u0001\u00071/\u0001\u0003be\u001e\u001c\bc\u0001\u0019u\u0017&\u0011Q/\r\u0002\u0006\u0003J\u0014\u0018-_\u0001\rSN\u0014V-\\8uK6{G-\u001a\u000b\u0003qn\u0004\"\u0001M=\n\u0005i\f$a\u0002\"p_2,\u0017M\u001c\u0005\u0006y:\u0001\r!`\u0001\u0006gR\fG/\u001a\t\u0004}\u0006%Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0004G2L'b\u0001\u0012\u0002\u0006)\u0019\u0011qA\u0014\u0002\r!\fGm\\8q\u0013\r\tYa \u0002\u0010\u00072L7+Z:tS>t7\u000b^1uKN!q\"a\u00046!\rq\u0018\u0011C\u0005\u0004\u0003'y(!C\"mS\u0012\u0013\u0018N^3s)\t\t9\u0002\u0005\u0002-\u001f\u0005a1/Z:tS>t7\u000b^1uKV\tQ0A\u0007tKN\u001c\u0018n\u001c8Ti\u0006$X\rI\u0001\bG>t7o\u001c7f+\t\t\u0019\u0003\u0005\u0003\u0002&\u0005Ub\u0002BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\bg\u0016\u001c8/[8o\u0015\u0011\ty#a\u0001\u0002\u0005Ed\u0017\u0002BA\u001a\u0003S\tAbU3tg&|gn\u0015;bi\u0016LA!a\u000e\u0002:\tIAj\\4IK2\u0004XM\u001d\u0006\u0005\u0003g\tI#\u0001\u0005d_:\u001cx\u000e\\3!+\u0005A\u0018!D5t%\u0016lw\u000e^3N_\u0012,\u0007%\u0001\u0003d_:4WCAA#!\u0011\t9%a\u0013\u000e\u0005\u0005%#\u0002BA!\u0003\u000bIA!!\u0014\u0002J\ti1i\u001c8gS\u001e,(/\u0019;j_:\fQaY8oM\u0002\n\u0001c]3u\u0011&4XMV1sS\u0006\u0014G.Z:\u0015\u0007\u0005\f)\u0006C\u0004\u0002Xe\u0001\r!!\u0017\u0002\u001b!Lg/\u001a,be&\f'\r\\3t!\u0019\tY&!\u0019L\u00176\u0011\u0011Q\f\u0006\u0004\u0003?\"\u0015\u0001B;uS2LA!a\u0019\u0002^\t\u0019Q*\u00199\u0002'A\u0014\u0018N\u001c;NCN$XM]!oI\u0006\u0003\b/\u00133\u0002\u0015A\u0014xnY3tg\u000ekG\r\u0006\u0003\u0002l\u0005E\u0004c\u0001\u0019\u0002n%\u0019\u0011qN\u0019\u0003\u0007%sG\u000f\u0003\u0004\u0002tm\u0001\raS\u0001\u0004G6$\u0017a\u00039s_\u000e,7o\u001d'j]\u0016$b!a\u001b\u0002z\u0005u\u0004BBA>9\u0001\u00071*\u0001\u0003mS:,\u0007BBA@9\u0001\u0007\u00010A\tbY2|w/\u00138uKJ\u0014X\u000f\u001d;j]\u001e\fab\u001d9mSR\u001cV-\\5D_2|g\u000e\u0006\u0003\u0002\u0006\u0006-\u0005#BA.\u0003\u000f[\u0015\u0002BAE\u0003;\u0012A\u0001T5ti\"1\u00111P\u000fA\u0002-\u0003")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    public SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            SparkSQLCLIDriver.$anonfun$setHiveVariables$1(kv);
            return BoxedUnit.UNIT;
        });
    }

    public void printMasterAndAppId() {
        String master = SparkSQLEnv$.MODULE$.sparkContext().master();
        String appId = SparkSQLEnv$.MODULE$.sparkContext().applicationId();
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(32).append("Spark master: ").append(master).append(", Application Id: ").append(appId).toString());
    }

    public int processCmd(String cmd) {
        int n;
        String cmd_trimmed = cmd.trim();
        String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
            this.sessionState().close();
            System.exit(0);
        }
        if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
            long startTimeNs = System.nanoTime();
            super.processCmd(cmd);
            long endTimeNs = System.nanoTime();
            double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
            this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString());
            n = 0;
        } else {
            int ret = 0;
            HiveConf hconf = (HiveConf)this.conf();
            CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
            if (proc != null) {
                if (proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof ResetProcessor) {
                    SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                    driver.init();
                    PrintStream out = this.sessionState().out;
                    PrintStream err = this.sessionState().err;
                    long startTimeNs = System.nanoTime();
                    if (this.sessionState().getIsVerbose()) {
                        out.println(cmd);
                    }
                    CommandProcessorResponse rc = driver.run(cmd);
                    long endTimeNs = System.nanoTime();
                    double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                    ret = rc.getResponseCode();
                    if (ret != 0) {
                        Throwable throwable = rc.getException();
                        if (throwable instanceof AnalysisException) {
                            AnalysisException analysisException = (AnalysisException)throwable;
                            Option option = analysisException.cause();
                            if (option instanceof Some && !this.sessionState().getIsSilent()) {
                                err.println(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Error in query: ").append(analysisException.getMessage()).append("\n                       |").append(StringUtils.stringifyException((Throwable)analysisException)).append("\n                     ").toString())).stripMargin());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                err.println(new StringBuilder(16).append("Error in query: ").append(analysisException.getMessage()).toString());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            err.println(rc.getErrorMessage());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        driver.close();
                        return ret;
                    }
                    ArrayList res = new ArrayList();
                    if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER)) {
                        Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1 & Serializable & scala.Serializable)fields -> {
                            out.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                            return BoxedUnit.UNIT;
                        });
                    }
                    IntRef counter = IntRef.create((int)0);
                    try {
                        while (!out.checkError() && driver.getResults(res)) {
                            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1 & Serializable & scala.Serializable)l -> {
                                SparkSQLCLIDriver.$anonfun$processCmd$3(counter, out, l);
                                return BoxedUnit.UNIT;
                            });
                            res.clear();
                        }
                    }
                    catch (IOException e) {
                        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Failed with exception ").append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n                   |").append(StringUtils.stringifyException((Throwable)e)).append("\n                 ").toString())).stripMargin());
                        ret = 1;
                    }
                    int cret = driver.close();
                    if (ret == 0) {
                        ret = cret;
                    }
                    String responseMsg = new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString();
                    if (counter.elem != 0) {
                        responseMsg = new StringBuilder(17).append(responseMsg).append(", Fetched ").append(counter.elem).append(" row(s)").toString();
                    }
                    this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(responseMsg, null);
                    driver.destroy();
                } else {
                    if (this.sessionState().getIsVerbose()) {
                        this.sessionState().out.println(new StringBuilder(1).append(tokens[0]).append(" ").append(cmd_1).toString());
                    }
                    ret = proc.run(cmd_1).getResponseCode();
                }
            }
            n = ret;
        }
        return n;
    }

    public int processLine(String line, boolean allowInterrupting) {
        int n;
        block4: {
            SignalHandler oldSignal = null;
            Signal interruptSignal = null;
            if (allowInterrupting) {
                interruptSignal = new Signal("INT");
                oldSignal = Signal.handle(interruptSignal, new SignalHandler(this){
                    private boolean interruptRequested;
                    private final /* synthetic */ SparkSQLCLIDriver $outer;

                    private boolean interruptRequested() {
                        return this.interruptRequested;
                    }

                    private void interruptRequested_$eq(boolean x$1) {
                        this.interruptRequested = x$1;
                    }

                    public void handle(Signal signal) {
                        boolean initialRequest = !this.interruptRequested();
                        this.interruptRequested_$eq(true);
                        if (!initialRequest) {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Exiting the JVM");
                            System.exit(127);
                        }
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Interrupting... Be patient, this might take some time.");
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Press Ctrl+C again to kill JVM");
                        HiveInterruptUtils.interrupt();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.interruptRequested = false;
                    }
                });
            }
            try {
                IntRef lastRet = IntRef.create((int)0);
                Buffer commands = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.splitSemiColon(line)).asScala();
                ObjectRef command = ObjectRef.create((Object)"");
                commands.foreach((Function1 & Serializable & scala.Serializable)oneCmd -> {
                    Object object;
                    if (org.apache.commons.lang3.StringUtils.endsWith((CharSequence)oneCmd, (CharSequence)"\\")) {
                        command$1.elem = new StringBuilder(1).append((String)command$1.elem).append(org.apache.commons.lang3.StringUtils.chop((String)oneCmd)).append(";").toString();
                        object = BoxedUnit.UNIT;
                    } else {
                        command$1.elem = new StringBuilder(0).append((String)command$1.elem).append((String)oneCmd).toString();
                        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)command$1.elem))) {
                            int ret = this.processCmd((String)command$1.elem);
                            command$1.elem = "";
                            lastRet$1.elem = ret;
                            boolean ignoreErrors = HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
                            if (ret != 0 && !ignoreErrors) {
                                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf()));
                                object = BoxesRunTime.boxToInteger((int)ret);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    }
                    return object;
                });
                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf()));
                n = lastRet.elem;
            }
            catch (Throwable throwable) {
                if (oldSignal != null && interruptSignal != null) {
                    Signal.handle(interruptSignal, oldSignal);
                }
                throw throwable;
            }
            if (oldSignal == null || interruptSignal == null) break block4;
            Signal.handle(interruptSignal, oldSignal);
        }
        return n;
    }

    private List<String> splitSemiColon(String line) {
        BooleanRef insideSingleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideDoubleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideComment = BooleanRef.create((boolean)false);
        BooleanRef escape = BooleanRef.create((boolean)false);
        IntRef beginIndex = IntRef.create((int)0);
        ArrayList<String> ret = new ArrayList<String>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), line.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            block14: {
                block13: {
                    if (line.charAt(index) == '\'' && !insideComment$1.elem) {
                        if (!escape$1.elem && !insideDoubleQuote$1.elem) {
                            insideSingleQuote$1.elem = !insideSingleQuote$1.elem;
                        }
                    } else if (line.charAt(index) == '\"' && !insideComment$1.elem) {
                        if (!escape$1.elem && !insideSingleQuote$1.elem) {
                            insideDoubleQuote$1.elem = !insideDoubleQuote$1.elem;
                        }
                    } else if (line.charAt(index) == '-') {
                        boolean hasNext;
                        boolean bl = hasNext = index + 1 < line.length();
                        if (!insideDoubleQuote$1.elem && !insideSingleQuote$1.elem && !insideComment$1.elem && hasNext && line.charAt(index + 1) == '-') {
                            insideComment$1.elem = true;
                        }
                    } else if (line.charAt(index) == ';') {
                        if (!(insideSingleQuote$1.elem || insideDoubleQuote$1.elem || insideComment$1.elem)) {
                            ret.add(line.substring(beginIndex$1.elem, index));
                            beginIndex$1.elem = index + 1;
                        }
                    } else if (line.charAt(index) == '\n' && !escape$1.elem) {
                        insideComment$1.elem = false;
                    }
                    if (!escape$1.elem) break block13;
                    escape$1.elem = false;
                    break block14;
                }
                if (line.charAt(index) != '\\') break block14;
                escape$1.elem = true;
            }
        });
        ret.add(line.substring(beginIndex.elem));
        return ret;
    }

    public static final /* synthetic */ void $anonfun$setHiveVariables$1(Tuple2 kv) {
        SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
    }

    public static final /* synthetic */ void $anonfun$processCmd$3(IntRef counter$1, PrintStream out$1, String l) {
        ++counter$1.elem;
        out$1.println(l);
    }

    public SparkSQLCLIDriver() {
        Logging.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console = ThriftserverShimUtils$.MODULE$.getConsole();
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() != null ? this.sessionState().getConf() : new Configuration();
        if (!this.isRemoteMode()) {
            SparkSQLEnv$.MODULE$.init();
            if (this.sessionState().getIsSilent()) {
                SparkSQLEnv$.MODULE$.sparkContext().setLogLevel(Level.WARN.toString());
            }
        } else {
            throw new RuntimeException("Remote operations not supported");
        }
    }
}

