/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001u4QAE\n\u0001/uA\u0011\u0002\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0018\t\u0011=\u0002!Q1A\u0005\u0002AB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t\u007f\u0001\u0011)\u0019!C\u0001a!A\u0001\t\u0001B\u0001B\u0003%\u0011\u0007\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001C\u0011!)\u0006A!A!\u0002\u0013\u0019\u0005\"\u0002,\u0001\t\u00039\u0006bB/\u0001\u0005\u0004%\t\u0005\r\u0005\u0007=\u0002\u0001\u000b\u0011B\u0019\t\u000b}\u0003A\u0011\t1\t\u000b\u0011\u0004A\u0011\t1\t\u000b\u0015\u0004A\u0011\t1\t\u000b\u0019\u0004A\u0011\t1\t\u000b\u001d\u0004A\u0011\t1\t\u000b!\u0004A\u0011I5\t\u000bY\u0004A\u0011B<\u0003--+(-\u001a:oKR,7/\u0012=fGV$xN]\"p]\u001aT!\u0001F\u000b\u0002\u0007-D4O\u0003\u0002\u0017/\u00051A-\u001a9m_fT!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\n\u0004\u0001y\u0011\u0003CA\u0010!\u001b\u0005\u0019\u0012BA\u0011\u0014\u00059YUOY3s]\u0016$Xm]\"p]\u001a\u0004\"a\t\u0014\u000e\u0003\u0011R!!J\f\u0002\u0011%tG/\u001a:oC2L!a\n\u0013\u0003\u000f1{wmZ5oO\u0006I1\u000f]1sW\u000e{gNZ\u0002\u0001!\tYC&D\u0001\u0018\u0013\tisCA\u0005Ta\u0006\u00148nQ8oM&\u0011\u0001\u0006I\u0001\u0006CB\u0004\u0018\nZ\u000b\u0002cA\u0011!g\u000f\b\u0003ge\u0002\"\u0001N\u001c\u000e\u0003UR!AN\u0015\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i:\u0014AB1qa&#\u0007%\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\f1\"\u001a=fGV$xN]%eA\u0005IAM]5wKJ\u0004v\u000eZ\u000b\u0002\u0007B\u0019A)R$\u000e\u0003]J!AR\u001c\u0003\r=\u0003H/[8o!\tA5+D\u0001J\u0015\tQ5*A\u0003n_\u0012,GN\u0003\u0002M\u001b\u0006\u0019\u0011\r]5\u000b\u00059{\u0015AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0001+U\u0001\bM\u0006\u0014'/[29\u0015\u0005\u0011\u0016AA5p\u0013\t!\u0016JA\u0002Q_\u0012\f!\u0002\u001a:jm\u0016\u0014\bk\u001c3!\u0003\u0019a\u0014N\\5u}Q)\u0001,\u0017.\\9B\u0011q\u0004\u0001\u0005\u0006Q!\u0001\rA\u000b\u0005\u0006_!\u0001\r!\r\u0005\u0006\u007f!\u0001\r!\r\u0005\u0006\u0003\"\u0001\raQ\u0001\u0013e\u0016\u001cx.\u001e:dK:\u000bW.\u001a)sK\u001aL\u00070A\nsKN|WO]2f\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u0004mC\n,Gn]\u000b\u0002CB!!GY\u00192\u0013\t\u0019WHA\u0002NCB\f1\"\u001a8wSJ|g.\\3oi\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0003]\u0019Xm\u0019:fi:\u000bW.Z:U_6{WO\u001c;QCRD7/A\ftK\u000e\u0014X\r^#om:\u000bW.Z:U_.+\u0017PU3gg\u00069ao\u001c7v[\u0016\u001cX#\u00016\u0011\u0007-\u00048O\u0004\u0002m]:\u0011A'\\\u0005\u0002q%\u0011qnN\u0001\ba\u0006\u001c7.Y4f\u0013\t\t(OA\u0002TKFT!a\\\u001c\u0011\u0005}!\u0018BA;\u0014\u0005QYUOY3s]\u0016$Xm\u001d,pYVlWm\u00159fG\u0006\u00192\r[3dW\u0016CXmY;u_J,eN^&fsR\u0011\u0001p\u001f\t\u0003\tfL!A_\u001c\u0003\u000f\t{w\u000e\\3b]\")A0\u0005a\u0001c\u0005\u00191.Z=")
public class KubernetesExecutorConf
extends KubernetesConf
implements Logging {
    private final String appId;
    private final String executorId;
    private final Option<Pod> driverPod;
    private final String resourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String appId() {
        return this.appId;
    }

    public String executorId() {
        return this.executorId;
    }

    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    @Override
    public String resourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    @Override
    public Map<String, String> labels() {
        Map presetLabels = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Object)this.executorId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}));
        Map<String, String> executorCustomLabels = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX());
        presetLabels.keys().foreach((Function1 & Serializable & scala.Serializable)key -> {
            Predef$.MODULE$.require(!executorCustomLabels.contains((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Custom executor labels cannot contain ").append(key).append(" as it is reserved for Spark.").toString());
            return BoxedUnit.UNIT;
        });
        return executorCustomLabels.$plus$plus((GenTraversableOnce)presetLabels);
    }

    @Override
    public Map<String, String> environment() {
        return ((TraversableOnce)super.sparkConf().getExecutorEnv().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.checkExecutorEnvKey((String)p._1())))).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Map<String, String> annotations() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX());
    }

    @Override
    public Map<String, String> secretNamesToMountPaths() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX());
    }

    @Override
    public Map<String, String> secretEnvNamesToKeyRefs() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX());
    }

    @Override
    public Seq<KubernetesVolumeSpec> volumes() {
        return KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX());
    }

    private boolean checkExecutorEnvKey(String key) {
        boolean bl;
        Regex executorEnvRegex = new StringOps(Predef$.MODULE$.augmentString("[-._a-zA-Z][-._a-zA-Z0-9]*")).r();
        if (executorEnvRegex.pattern().matcher(key).matches()) {
            bl = true;
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(178).append("Invalid key: ").append(key).append(": ").append("a valid environment variable name must consist of alphabetic characters, ").append("digits, '_', '-', or '.', and must not start with a digit.").append("Regex used for validation is '").append(executorEnvRegex).append("')").toString());
            bl = false;
        }
        return bl;
    }

    public KubernetesExecutorConf(SparkConf sparkConf, String appId, String executorId, Option<Pod> driverPod) {
        this.appId = appId;
        this.executorId = executorId;
        this.driverPod = driverPod;
        super(sparkConf);
        Logging.$init$((Logging)this);
        this.resourceNamePrefix = (String)((Option)this.get(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX())).getOrElse((Function0 & Serializable & scala.Serializable)() -> KubernetesConf$.MODULE$.getResourceNamePrefix(this.appName()));
    }
}

