/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ConfigFluentImpl;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$ClientType$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.guava.base.Charsets;
import org.sparkproject.guava.io.Files;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class SparkKubernetesClientFactory$
implements Logging {
    public static SparkKubernetesClientFactory$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkKubernetesClientFactory$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KubernetesClient createKubernetesClient(String master, Option<String> namespace, String kubernetesAuthConfPrefix, Enumeration.Value clientType, SparkConf sparkConf, Option<File> defaultServiceAccountToken, Option<File> defaultServiceAccountCaCert) {
        String oauthTokenFileConf = new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()).toString();
        String oauthTokenConf = new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()).toString();
        Option oauthTokenFile = sparkConf.getOption(oauthTokenFileConf).map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1)).orElse((Function0 & Serializable & scala.Serializable)() -> defaultServiceAccountToken);
        Option oauthTokenValue = sparkConf.getOption(oauthTokenConf);
        KubernetesUtils$.MODULE$.requireNandDefined(oauthTokenFile, oauthTokenValue, new StringBuilder(61).append("Cannot specify OAuth token through both a file ").append(oauthTokenFileConf).append(" and a ").append("value ").append(oauthTokenConf).append(".").toString());
        Option caCertFile = sparkConf.getOption(new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString()).orElse((Function0 & Serializable & scala.Serializable)() -> defaultServiceAccountCaCert.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAbsolutePath()));
        Option clientKeyFile = sparkConf.getOption(new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString());
        Option clientCertFile = sparkConf.getOption(new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString());
        Dispatcher dispatcher = new Dispatcher((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("kubernetes-dispatcher"));
        Option kubeContext = ((Option)sparkConf.get(Config$.MODULE$.KUBERNETES_CONTEXT())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkKubernetesClientFactory$.$anonfun$createKubernetesClient$5(x$3)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Auto-configuring K8S client using ").append(kubeContext.map((Function1 & Serializable & scala.Serializable)x$4 -> new StringBuilder(8).append("context ").append((String)x$4).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "current context")).append(" from users K8S config file").toString());
        Config config = SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder((ConfigBuilder)((ConfigFluentImpl)((ConfigFluentImpl)((ConfigFluentImpl)((ConfigFluentImpl)new ConfigBuilder(Config.autoConfigure((String)((String)kubeContext.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)))).withApiVersion("v1")).withMasterUrl(master)).withWebsocketPingInterval(0L)).withRequestTimeout(SparkKubernetesClientFactory$ClientType$.MODULE$.convert(clientType).requestTimeout(sparkConf))).withConnectionTimeout(SparkKubernetesClientFactory$ClientType$.MODULE$.convert(clientType).connectionTimeout(sparkConf))), oauthTokenValue, (Function2 & Serializable & scala.Serializable)(token, configBuilder) -> (ConfigBuilder)configBuilder.withOauthToken(token))), oauthTokenFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withOauthToken(Files.toString((File)file, (Charset)Charsets.UTF_8)))), caCertFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withCaCertFile(file))), clientKeyFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withClientKeyFile(file))), clientCertFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withClientCertFile(file))), namespace, (Function2 & Serializable & scala.Serializable)(ns, configBuilder) -> (ConfigBuilder)configBuilder.withNamespace(ns)).build();
        OkHttpClient baseHttpClient = HttpClientUtils.createHttpClient((Config)config);
        OkHttpClient httpClientWithCustomDispatcher = baseHttpClient.newBuilder().dispatcher(dispatcher).build();
        return new DefaultKubernetesClient(httpClientWithCustomDispatcher, config);
    }

    private ConfigBuilder OptionConfigurableConfigBuilder(ConfigBuilder configBuilder) {
        return configBuilder;
    }

    public static final /* synthetic */ boolean $anonfun$createKubernetesClient$5(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    private SparkKubernetesClientFactory$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

