/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Properties;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0003\u0006\u0001!YA\u0001b\t\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015Y\u0005\u0001\"\u0003M\u0011\u0015A\u0007\u0001\"\u0003j\u0005\u0019\u0019E.[3oi*\u00111\u0002D\u0001\u0007gV\u0014W.\u001b;\u000b\u00055q\u0011aA69g*\u0011q\u0002E\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c2\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011a$I\u0007\u0002?)\u0011\u0001\u0005E\u0001\tS:$XM\u001d8bY&\u0011!e\b\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011aeJ\u0007\u0002\u0019%\u0011\u0001\u0006\u0004\u0002\u0015\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u001cuN\u001c4\u0002\u000f\t,\u0018\u000e\u001c3feB\u00111\u0006L\u0007\u0002\u0015%\u0011QF\u0003\u0002\u0018\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u0014U/\u001b7eKJ\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005AJT\"A\u0019\u000b\u0005I\u001a\u0014AB2mS\u0016tGO\u0003\u00025k\u0005Q1.\u001e2fe:,G/Z:\u000b\u0005Y:\u0014a\u00024bEJL7\r\u000f\u0006\u0002q\u0005\u0011\u0011n\\\u0005\u0003uE\u0012\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u000f]\fGo\u00195feB\u00111&P\u0005\u0003})\u0011q\u0003T8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:\u0002\rqJg.\u001b;?)\u0015\t%i\u0011#F!\tY\u0003\u0001C\u0003$\u000b\u0001\u0007Q\u0005C\u0003*\u000b\u0001\u0007!\u0006C\u0003/\u000b\u0001\u0007q\u0006C\u0003<\u000b\u0001\u0007A(A\u0002sk:$\u0012\u0001\u0013\t\u00031%K!AS\r\u0003\tUs\u0017\u000e^\u0001\u0018C\u0012$GI]5wKJ|uO\\3s%\u00164WM]3oG\u0016$2\u0001S'X\u0011\u0015qu\u00011\u0001P\u0003%!'/\u001b<feB{G\r\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006)Qn\u001c3fY*\u0011AkM\u0001\u0004CBL\u0017B\u0001,R\u0005\r\u0001v\u000e\u001a\u0005\u00061\u001e\u0001\r!W\u0001\ne\u0016\u001cx.\u001e:dKN\u00042A\u00172f\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_I\u00051AH]8pizJ\u0011AG\u0005\u0003Cf\tq\u0001]1dW\u0006<W-\u0003\u0002dI\n\u00191+Z9\u000b\u0005\u0005L\u0002C\u0001)g\u0013\t9\u0017KA\u0006ICNlU\r^1eCR\f\u0017A\u00042vS2$7i\u001c8gS\u001el\u0015\r\u001d\u000b\u0004U6<\bC\u0001)l\u0013\ta\u0017KA\u0005D_:4\u0017nZ'ba\")a\u000e\u0003a\u0001_\u0006i1m\u001c8gS\u001el\u0015\r\u001d(b[\u0016\u0004\"\u0001\u001d;\u000f\u0005E\u0014\bC\u0001/\u001a\u0013\t\u0019\u0018$\u0001\u0004Qe\u0016$WMZ\u0005\u0003kZ\u0014aa\u0015;sS:<'BA:\u001a\u0011\u0015\u0019\u0003\u00021\u0001y!\u0011\u0001\u0018p\\8\n\u0005i4(aA'ba\u0002")
public class Client
implements Logging {
    private final KubernetesDriverConf conf;
    private final KubernetesDriverBuilder builder;
    private final KubernetesClient kubernetesClient;
    private final LoggingPodStatusWatcher watcher;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void run() {
        KubernetesDriverSpec resolvedDriverSpec = this.builder.buildFromFeatures(this.conf, this.kubernetesClient);
        String configMapName = new StringBuilder(16).append(this.conf.resourceNamePrefix()).append("-driver-conf-map").toString();
        ConfigMap configMap = this.buildConfigMap(configMapName, resolvedDriverSpec.systemProperties());
        Container resolvedDriverContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(resolvedDriverSpec.pod().container()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        Pod resolvedDriverPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(resolvedDriverSpec.pod().pod()).editSpec().addToContainers(new Container[]{resolvedDriverContainer}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withNewConfigMap().withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        String driverPodName = resolvedDriverPod.getMetadata().getName();
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (Watch)((Watchable)$this.kubernetesClient.pods().withName(driverPodName)).watch((Object)$this.watcher), (Function1 & Serializable & scala.Serializable)x$1 -> {
            Client.$anonfun$run$2(this, resolvedDriverPod, resolvedDriverSpec, configMap, driverPodName, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void addDriverOwnerReference(Pod driverPod, Seq<HasMetadata> resources) {
        OwnerReference driverPodOwnerReference = ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withName(driverPod.getMetadata().getName())).withApiVersion(driverPod.getApiVersion())).withUid(driverPod.getMetadata().getUid())).withKind(driverPod.getKind())).withController(Predef$.MODULE$.boolean2Boolean(true))).build();
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            Client.$anonfun$addDriverOwnerReference$1(driverPodOwnerReference, resource);
            return BoxedUnit.UNIT;
        });
    }

    private ConfigMap buildConfigMap(String configMapName, Map<String, String> conf) {
        Properties properties = new Properties();
        conf.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = properties.setProperty(k, v);
            return object;
        });
        StringWriter propertiesWriter = new StringWriter();
        properties.store(propertiesWriter, new StringBuilder(60).append("Java properties built from Kubernetes config map with name: ").append(configMapName).toString());
        return ((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(Constants$.MODULE$.SPARK_CONF_FILE_NAME(), propertiesWriter.toString())).build();
    }

    public static final /* synthetic */ void $anonfun$run$2(Client $this, Pod resolvedDriverPod$1, KubernetesDriverSpec resolvedDriverSpec$1, ConfigMap configMap$1, String driverPodName$1, Watch x$1) {
        Pod createdDriverPod = (Pod)$this.kubernetesClient.pods().create((Object)resolvedDriverPod$1);
        try {
            Seq otherKubernetesResources = (Seq)resolvedDriverSpec$1.driverKubernetesResources().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigMap[]{configMap$1})), Seq$.MODULE$.canBuildFrom());
            $this.addDriverOwnerReference(createdDriverPod, (Seq<HasMetadata>)otherKubernetesResources);
            $this.kubernetesClient.resourceList((HasMetadata[])otherKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).createOrReplace();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.kubernetesClient.pods().delete((Object[])new Pod[]{createdDriverPod});
                throw e;
            }
            throw throwable;
        }
        String sId = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.conf.namespace(), driverPodName$1}))).mkString(":");
        $this.watcher.watchOrStop(sId);
    }

    public static final /* synthetic */ void $anonfun$addDriverOwnerReference$1(OwnerReference driverPodOwnerReference$1, HasMetadata resource) {
        ObjectMeta originalMetadata = resource.getMetadata();
        originalMetadata.setOwnerReferences(Collections.singletonList(driverPodOwnerReference$1));
    }

    public Client(KubernetesDriverConf conf, KubernetesDriverBuilder builder, KubernetesClient kubernetesClient, LoggingPodStatusWatcher watcher) {
        this.conf = conf;
        this.builder = builder;
        this.kubernetesClient = kubernetesClient;
        this.watcher = watcher;
        Logging.$init$((Logging)this);
    }
}

