/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.GBTClassifier;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GBTClassifierSuite$
extends SparkFunSuite {
    public static GBTClassifierSuite$ MODULE$;

    static {
        new GBTClassifierSuite$();
    }

    public void compareAPIs(RDD<org.apache.spark.ml.feature.LabeledPoint> data, Option<RDD<org.apache.spark.ml.feature.LabeledPoint>> validationData, GBTClassifier gbt, Map<Object, Object> categoricalFeatures) {
        int numFeatures = ((org.apache.spark.ml.feature.LabeledPoint)data.first()).features().size();
        BoostingStrategy oldBoostingStrategy = gbt.getOldBoostingStrategy(categoricalFeatures, Algo$.MODULE$.Classification());
        GradientBoostedTrees oldGBT = new GradientBoostedTrees(oldBoostingStrategy, (int)gbt.getSeed());
        GradientBoostedTreesModel oldModel = oldGBT.run(data.map((Function1 & Serializable & scala.Serializable)point -> LabeledPoint$.MODULE$.fromML(point), ClassTag$.MODULE$.apply(LabeledPoint.class)));
        Dataset<Row> newData = TreeTests$.MODULE$.setMetadata(data, categoricalFeatures, 2);
        GBTClassificationModel newModel = (GBTClassificationModel)gbt.fit(newData);
        GBTClassificationModel oldModelAsNew = GBTClassificationModel$.MODULE$.fromOld(oldModel, (GBTClassifier)newModel.parent(), categoricalFeatures, numFeatures, 2);
        TreeTests$.MODULE$.checkEqual(oldModelAsNew, newModel);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.numFeatures()));
        int $org_scalatest_assert_macro_right = numFeatures;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GBTClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)oldModelAsNew.numFeatures()));
        int $org_scalatest_assert_macro_right2 = numFeatures;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GBTClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GBTClassifierSuite$() {
        MODULE$ = this;
    }
}

