/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionSuite;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.Assert;
import org.junit.Test;

public class JavaLogisticRegressionSuite
extends SharedSparkSession {
    private transient Dataset<Row> dataset;
    private transient JavaRDD<LabeledPoint> datasetRDD;
    private double eps = 1.0E-5;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        List<LabeledPoint> points = LogisticRegressionSuite.generateLogisticInputAsList(1.0, 1.0, 100, 42);
        this.datasetRDD = this.jsc.parallelize(points, 2);
        this.dataset = this.spark.createDataFrame(this.datasetRDD, LabeledPoint.class);
        this.dataset.createOrReplaceTempView("dataset");
    }

    @Test
    public void logisticRegressionDefaultParams() {
        LogisticRegression lr = new LogisticRegression();
        Assert.assertEquals((Object)"label", (Object)lr.getLabelCol());
        LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.dataset);
        model.transform(this.dataset).createOrReplaceTempView("prediction");
        Dataset predictions = this.spark.sql("SELECT label, probability, prediction FROM prediction");
        predictions.collectAsList();
        Assert.assertEquals((double)0.5, (double)model.getThreshold(), (double)this.eps);
        Assert.assertEquals((Object)"features", (Object)model.getFeaturesCol());
        Assert.assertEquals((Object)"prediction", (Object)model.getPredictionCol());
        Assert.assertEquals((Object)"probability", (Object)model.getProbabilityCol());
    }

    @Test
    public void logisticRegressionWithSetters() {
        LogisticRegression lr = (LogisticRegression)new LogisticRegression().setMaxIter(10).setRegParam(1.0).setThreshold(0.6).setProbabilityCol("myProbability");
        LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.dataset);
        LogisticRegression parent = (LogisticRegression)model.parent();
        Assert.assertEquals((long)10L, (long)parent.getMaxIter());
        Assert.assertEquals((double)1.0, (double)parent.getRegParam(), (double)this.eps);
        Assert.assertEquals((double)0.4, (double)parent.getThresholds()[0], (double)this.eps);
        Assert.assertEquals((double)0.6, (double)parent.getThresholds()[1], (double)this.eps);
        Assert.assertEquals((double)0.6, (double)parent.getThreshold(), (double)this.eps);
        Assert.assertEquals((double)0.6, (double)model.getThreshold(), (double)this.eps);
        model.setThreshold(1.0);
        model.transform(this.dataset).createOrReplaceTempView("predAllZero");
        Dataset predAllZero = this.spark.sql("SELECT prediction, myProbability FROM predAllZero");
        for (Row r : predAllZero.collectAsList()) {
            Assert.assertEquals((double)0.0, (double)r.getDouble(0), (double)this.eps);
        }
        model.transform(this.dataset, model.threshold().w(0.0), new ParamPair[]{model.probabilityCol().w((Object)"myProb")}).createOrReplaceTempView("predNotAllZero");
        Dataset predNotAllZero = this.spark.sql("SELECT prediction, myProb FROM predNotAllZero");
        boolean foundNonZero = false;
        for (Row r : predNotAllZero.collectAsList()) {
            if (r.getDouble(0) == 0.0) continue;
            foundNonZero = true;
        }
        Assert.assertTrue((boolean)foundNonZero);
        LogisticRegressionModel model2 = (LogisticRegressionModel)lr.fit(this.dataset, lr.maxIter().w(5), new ParamPair[]{lr.regParam().w(0.1), lr.threshold().w(0.4), lr.probabilityCol().w((Object)"theProb")});
        LogisticRegression parent2 = (LogisticRegression)model2.parent();
        Assert.assertEquals((long)5L, (long)parent2.getMaxIter());
        Assert.assertEquals((double)0.1, (double)parent2.getRegParam(), (double)this.eps);
        Assert.assertEquals((double)0.4, (double)parent2.getThreshold(), (double)this.eps);
        Assert.assertEquals((double)0.4, (double)model2.getThreshold(), (double)this.eps);
        Assert.assertEquals((Object)"theProb", (Object)model2.getProbabilityCol());
    }

    @Test
    public void logisticRegressionPredictorClassifierMethods() {
        LogisticRegression lr = new LogisticRegression();
        LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.dataset);
        Assert.assertEquals((long)2L, (long)model.numClasses());
        model.transform(this.dataset).createOrReplaceTempView("transformed");
        Dataset trans1 = this.spark.sql("SELECT rawPrediction, probability FROM transformed");
        for (Row row : trans1.collectAsList()) {
            Vector raw = (Vector)row.get(0);
            Vector prob = (Vector)row.get(1);
            Assert.assertEquals((long)2L, (long)raw.size());
            Assert.assertEquals((long)2L, (long)prob.size());
            double probFromRaw1 = 1.0 / (1.0 + Math.exp(-raw.apply(1)));
            Assert.assertEquals((double)0.0, (double)Math.abs(prob.apply(1) - probFromRaw1), (double)this.eps);
            Assert.assertEquals((double)0.0, (double)Math.abs(prob.apply(0) - (1.0 - probFromRaw1)), (double)this.eps);
        }
        Dataset trans2 = this.spark.sql("SELECT prediction, probability FROM transformed");
        for (Row row : trans2.collectAsList()) {
            double pred = row.getDouble(0);
            Vector prob = (Vector)row.get(1);
            double probOfPred = prob.apply((int)pred);
            for (int i = 0; i < prob.size(); ++i) {
                Assert.assertTrue((probOfPred >= prob.apply(i) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void logisticRegressionTrainingSummary() {
        LogisticRegression lr = new LogisticRegression();
        LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.dataset);
        LogisticRegressionTrainingSummary summary = model.summary();
        Assert.assertEquals((long)summary.totalIterations(), (long)summary.objectiveHistory().length);
    }
}

